# 機能設計書 39-フォーム一覧

## 概要

本ドキュメントは、QuickerSite CMSにおけるフォーム管理の一覧表示機能の設計を記述する。

### 本機能の処理概要

フォーム一覧機能は、サイト内で作成されたすべてのWebフォーム（問い合わせフォーム、アンケートなど）を一覧表示し、各フォームに対する操作（編集、フィールド設定、プレビュー、データエクスポート、コピー）へのアクセスを提供する機能である。

**業務上の目的・背景**：
Webサイトでは問い合わせフォームやアンケートなど、様々なフォームを運用する必要がある。本機能により、すべてのフォームを一覧で確認し、必要な操作に素早くアクセスできる。

**機能の利用シーン**：
- 既存フォームの設定を変更したい場合
- 新規フォームを作成したい場合
- フォームに送信されたデータを確認・エクスポートしたい場合
- 既存フォームをコピーして新規フォームを作成したい場合

**主要な処理内容**：
1. カスタマーに紐づくフォーム一覧の取得
2. 各フォームへの操作アイコンの表示
3. フォームのコピー処理
4. 新規フォーム作成画面へのリンク

**関連システム・外部連携**：
- tblFormテーブル（フォームマスタ）
- tblFormFieldテーブル（フォームフィールド）
- tblFormSubmissionテーブル（フォーム送信データ）

**権限による制御**：
- 管理者権限が必要
- セカンドアドミンのbForms権限が必要
- データエクスポートにはbFormExport権限が必要

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 132 | フォーム一覧 | 主画面 | フォームの一覧表示と操作 |
| 133 | フォーム編集 | 遷移先 | フォーム設定の編集 |
| 134 | フォームフィールド設定 | 遷移先 | フォームのフィールド定義 |
| 135 | フォームプレビュー | 遷移先 | フォームのプレビュー表示 |
| 136 | フォームデータエクスポート | 遷移先 | 送信データの表示 |

## 機能種別

フォーム管理 / 一覧表示・参照

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| iFormID | String | No | コピー対象フォームID | encrypt暗号化、decrypt復号 |
| QS_secCode | String | No | CSRFトークン | checkCSRF検証 |

### 入力データソース

- URLパラメータ（コピー時）
- customer.forms（フォーム一覧）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| フォーム一覧 | HTML | フォーム名と操作アイコンのテーブル |

### 出力先

- 画面（フォーム一覧テーブル）

## 処理フロー

### 処理シーケンス

```
1. ページ読み込み
   └─ セキュリティチェック（bForms権限）
2. コピー処理判定
   └─ iFormIDがある場合、copyform.copy()実行
3. フォーム一覧取得
   └─ customer.formsでフォームコレクション取得
4. 一覧表示
   └─ 各フォームに対して操作アイコンを生成
   └─ 編集、フィールド設定、プレビュー、データ、Excel、コピー
5. 権限チェック
   └─ bFormExportでデータエクスポートアイコン表示制御
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[セキュリティチェック]
    B --> C{iFormID?}
    C -->|Yes| D[フォームコピー処理]
    C -->|No| E[フォーム一覧取得]
    D --> E
    E --> F{フォーム存在?}
    F -->|No| G[「フォームなし」表示]
    F -->|Yes| H[フォームループ開始]
    H --> I[フォーム名リンク生成]
    I --> J[フィールド設定アイコン]
    J --> K[プレビューアイコン]
    K --> L{bFormExport?}
    L -->|Yes| M[データ/Excelアイコン]
    L -->|No| N[コピーアイコン]
    M --> N
    N --> O{次のフォーム?}
    O -->|Yes| H
    O -->|No| P[終了]
    G --> P
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-039-1 | ID暗号化 | フォームIDはencrypt関数で暗号化してURLに渡す | 全リンク |
| BR-039-2 | コピー確認 | フォームコピー前に確認ダイアログを表示 | コピーアイコンクリック時 |
| BR-039-3 | エクスポート権限 | bFormExport権限がある場合のみデータエクスポート可能 | データ/Excelアイコン表示時 |
| BR-039-4 | CSRFチェック | コピー操作時にCSRFトークン検証 | コピー実行時 |

### 計算ロジック

特になし

## データベース操作仕様

### 読み取り

| テーブル名 | 操作 | 条件 | 取得項目 |
|-----------|------|------|----------|
| tblForm | SELECT | iCustomerID = cId | iId, sName等 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 権限エラー | bForms権限なし | アクセス拒否 |
| - | CSRFエラー | トークン不正 | 処理中断 |

### リトライ仕様

特になし

## トランザクション仕様

フォームコピー時はcopy関数内でフォームとフィールドを一括コピー。

## パフォーマンス要件

- フォーム一覧表示: 1秒以内（通常のフォーム数）

## セキュリティ考慮事項

- bs_security.aspによる管理者認証
- セカンドアドミンのbForms権限チェック
- フォームIDはencrypt関数で暗号化
- コピー操作時のCSRFトークン検証
- データエクスポートはbFormExport権限で制御

## 備考

- フォームIDはiID列に表示（開発者向け情報）
- プレビューはポップアップ表示（QSPP）
- データ表示はフルウィンドウポップアップ
- Excel出力は別ウィンドウで開く

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | form.asp | `asp/includes/form.asp` | cls_formクラスのプロパティ定義（2-5行目） |

**読解のコツ**: iId, sName, bSendEmail, bAutoResponder等のプロパティがフォームの構成要素となる。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_formList.asp | `asp/bs_formList.asp` | フォーム一覧のメイン処理（4-9行目） |

**主要処理フロー**:
1. **4行目**: セキュリティチェック（secondAdmin.bForms）
2. **5-6行目**: コピー処理（cls_form.copy()）
3. **7-8行目**: フォーム一覧取得（customer.forms）
4. **8-9行目**: 一覧表示ループ

#### Step 3: 関連操作を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | form.asp | `asp/includes/form.asp` | copy関数（839-851行目） |
| 3-2 | form.asp | `asp/includes/form.asp` | fields関数（233-249行目） |

### プログラム呼び出し階層図

```
bs_formList.asp
    │
    ├─ bs_security.asp（認証チェック）
    │      └─ logon.hasaccess secondAdmin.bForms
    │
    ├─ cls_form.copy()
    │      ├─ fields（フォームフィールド取得）
    │      ├─ save()（新規フォーム保存）
    │      └─ cFields(fKey).copy(iId)（フィールドコピー）
    │
    └─ customer.forms
           └─ フォーム一覧Dictionary
```

### データフロー図

```
[入力]               [処理]                    [出力]

tblForm ─────────▶ customer.forms ──────▶ フォーム一覧表示
                       │
                       ▼
iFormID ─────────▶ copyform.copy() ──────▶ 新規フォーム作成
                       │
                       └─▶ tblFormへINSERT
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_formList.asp | `asp/bs_formList.asp` | ソース | フォーム一覧画面 |
| bs_formEdit.asp | `asp/bs_formEdit.asp` | ソース | フォーム編集画面 |
| bs_formFields.asp | `asp/bs_formFields.asp` | ソース | フォームフィールド設定 |
| bs_formPreview.asp | `asp/bs_formPreview.asp` | ソース | フォームプレビュー |
| bs_formExport.asp | `asp/bs_formExport.asp` | ソース | データエクスポート |
| bs_formExcel.asp | `asp/bs_formExcel.asp` | ソース | Excelエクスポート |
| form.asp | `asp/includes/form.asp` | ソース | cls_formクラス定義 |
