# 機能設計書 4-パスワード変更

## 概要

本ドキュメントは、QuickerSite CMSの管理者パスワード変更機能について記述する。

### 本機能の処理概要

本機能は、メイン管理者のバックサイトパスワードの変更、およびサイト全体へのパスワード保護設定を行うための機能を提供する。管理者はセキュリティ維持のために定期的なパスワード変更が可能であり、また公開サイト全体にパスワード保護を適用することもできる。

**業務上の目的・背景**：セキュリティ維持のため、管理者パスワードの定期的な変更が推奨される。また、サイトの公開前やメンテナンス中に、サイト全体をパスワード保護する必要がある場合にも本機能を使用する。

**機能の利用シーン**：
- セキュリティポリシーに基づく定期的なパスワード変更
- パスワード漏洩が疑われる場合の緊急変更
- 初期セットアップ後のデフォルトパスワードからの変更
- サイト全体へのパスワード保護設定・解除

**主要な処理内容**：
1. メイン管理者パスワードの変更
2. サイト全体パスワード（sTotalPW）の設定・削除
3. パスワード確認の一致チェック
4. SHA-256によるパスワードハッシュ化

**関連システム・外部連携**：なし

**権限による制御**：
- メイン管理者パスワード変更: メイン管理者のみ
- サイト全体パスワード管理: secondAdmin.bPagesPW権限が必要

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 18 | 全体パスワード適用 | 主画面 | サイト全体へのパスワード保護・変更 |
| 116 | セカンド管理者PW | 参照画面 | セカンド管理者のパスワード設定 |

## 機能種別

セキュリティ管理 / パスワード変更

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| adminPassword | String | Yes | 新しい管理者パスワード | 最大30文字 |
| adminPasswordConfirm | String | Yes | パスワード確認 | adminPasswordと一致 |
| sTotalPW | String | No | サイト全体パスワード | 3文字以上15文字以内 |
| btnaction | String | Yes | 実行アクション | save_pw_total / delete_pw_total / cSaveAdminPW |

### 入力データソース

- 画面入力（パスワード変更フォーム）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| customer.adminPassword | String | SHA-256ハッシュ化された管理者パスワード |
| customer.sTotalPW | String | サイト全体パスワード（平文） |
| tblPage.sPw | String | 全ページにパスワードを適用 |

### 出力先

- データベース（tblCustomer.adminPassword）
- データベース（tblCustomer.sTotalPW）
- データベース（tblPage.sPw - 全ページ）

## 処理フロー

### 処理シーケンス

```
1. パスワード変更画面アクセス
   └─ secondAdmin.bPagesPW権限チェック

2. サイト全体パスワード設定（btnaction="save_pw_total"）
   └─ CSRF検証
   └─ applyTotalPW()呼び出し
      └─ 3文字以上チェック
      └─ tblCustomer.sTotalPW更新
      └─ 全ページのsPwを更新

3. サイト全体パスワード削除（btnaction="delete_pw_total"）
   └─ CSRF検証
   └─ removeTotalPW()呼び出し
      └─ tblCustomer.sTotalPW空文字に
      └─ 全ページのsPwを空文字に

4. 管理者パスワード変更（btnaction=cSaveAdminPW）
   └─ CSRF検証
   └─ パスワード確認一致チェック
   └─ saveAdminPW()呼び出し
      └─ デフォルトパスワードチェック
      └─ SHA-256ハッシュ化
      └─ tblCustomer.adminPassword更新
      └─ 自動ログオン
```

### フローチャート

```mermaid
flowchart TD
    A[パスワード変更画面] --> B{権限チェック}
    B -->|権限なし| C[bs_default.aspへリダイレクト]
    B -->|権限あり| D[フォーム表示]
    D --> E{アクション}
    E -->|save_pw_total| F[CSRF検証]
    F --> G{3文字以上?}
    G -->|No| H[エラー: err_pw]
    G -->|Yes| I[sTotalPW更新]
    I --> J[全ページsPw更新]
    E -->|delete_pw_total| K[CSRF検証]
    K --> L[sTotalPW削除]
    L --> M[全ページsPw削除]
    E -->|cSaveAdminPW| N[CSRF検証]
    N --> O{パスワード一致?}
    O -->|No| P[エラー: pwnomatch]
    O -->|Yes| Q{デフォルトPW?}
    Q -->|Yes| R[エラー: err_backsitepw]
    Q -->|No| S[SHA-256ハッシュ化]
    S --> T[adminPassword更新]
    T --> U[自動ログオン]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | パスワード確認必須 | パスワードと確認用パスワードの一致が必要 | 管理者パスワード変更時 |
| BR-02 | デフォルトパスワード禁止 | "admin"などのデフォルトパスワードは使用不可 | 管理者パスワード変更時 |
| BR-03 | 最小文字数 | サイト全体パスワードは3文字以上 | サイト全体パスワード設定時 |
| BR-04 | 全ページ一括適用 | サイト全体パスワード設定時は全ページに適用 | サイト全体パスワード設定時 |
| BR-05 | SHA-256ハッシュ化 | 管理者パスワードはSHA-256でハッシュ化 | 管理者パスワード変更時 |

### 計算ロジック

- 管理者パスワードハッシュ: `sha256(入力パスワード)`
- サイト全体パスワード: `lcase(入力値)` （小文字化して保存）

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 管理者PW変更 | tblCustomer | UPDATE | adminPassword更新 |
| 全体PW設定 | tblCustomer | UPDATE | sTotalPW更新 |
| 全体PW設定 | tblPage | UPDATE | 全ページのsPw更新 |
| 全体PW削除 | tblCustomer | UPDATE | sTotalPW空文字 |
| 全体PW削除 | tblPage | UPDATE | 全ページのsPw空文字 |

### テーブル別操作詳細

#### tblCustomer

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | adminPassword | sha256(入力値) | ハッシュ化して保存 |
| UPDATE | sTotalPW | 入力値 or 空文字 | 平文で保存 |

#### tblPage

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | sPw | sTotalPW値 or 空文字 | 全ページ対象（bIntranet=false） |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| err_mandatory | 入力エラー | パスワードが空 | 再入力を促す |
| pwnomatch | 入力エラー | パスワード確認が不一致 | 再入力を促す |
| err_backsitepw | 入力エラー | デフォルトパスワード使用 | 異なるパスワードを設定 |
| err_pw | 入力エラー | サイト全体パスワードが3文字未満 | 3文字以上のパスワードを設定 |

### リトライ仕様

- エラー時は同一画面で再入力可能

## トランザクション仕様

- 全体パスワード適用時: tblCustomer更新後にtblPage一括更新（ロールバックなし）

## パフォーマンス要件

- パスワード変更: 即座に完了
- 全体パスワード適用: ページ数に応じて処理時間が変動

## セキュリティ考慮事項

- 管理者パスワードはSHA-256でハッシュ化して保存
- デフォルトパスワードの使用を禁止
- CSRF対策トークン検証
- パスワード変更後は自動的に新パスワードでログオン

## 備考

- セカンドアドミンはこの画面で自身のパスワードを変更することはできない（別画面: bs_secondAdminPW.asp）
- サイト全体パスワードはイントラネットページには適用されない

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

パスワード関連のデータ構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | customer.asp | `asp/includes/customer.asp` | adminPassword、sTotalPWプロパティの定義（6-7行目付近） |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_applyTotalPW.asp | `asp/bs_applyTotalPW.asp` | パスワード変更画面のメインファイル（5行） |

**主要処理フロー**:
1. **4行目**: secondAdmin.bPagesPW権限チェック
2. フォーム表示（sTotalPW、adminPassword、adminPasswordConfirm）

#### Step 3: 処理ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_process.asp | `asp/bs_process.asp` | btnaction処理分岐 |

**主要処理フロー**:
- **157-161行目**: delete_pw_total処理（removeTotalPW）
- **162-166行目**: save_pw_total処理（applyTotalPW）
- **176-184行目**: cSaveAdminPW処理（saveAdminPW）

#### Step 4: パスワード管理関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | customer.asp | `asp/includes/customer.asp` | パスワード管理関数 |

**主要処理フロー**:
- **706-718行目**: applyTotalPW関数
- **719-726行目**: removeTotalPW関数
- **1200-1214行目**: saveAdminPW関数

### プログラム呼び出し階層図

```
bs_applyTotalPW.asp
    │
    ├─ begin.asp（インクルード）
    │      └─ includes/customer.asp（cls_customerクラス）
    │
    ├─ bs_security.asp（認証・権限チェック）
    │
    ├─ bs_process.asp（処理分岐）
    │      │
    │      ├─ btnaction = "save_pw_total"
    │      │      └─ customer.applyTotalPW()
    │      │             ├─ sTotalPW更新
    │      │             └─ tblPage一括UPDATE
    │      │
    │      ├─ btnaction = "delete_pw_total"
    │      │      └─ customer.removeTotalPW()
    │      │             ├─ sTotalPW削除
    │      │             └─ tblPage一括UPDATE
    │      │
    │      └─ btnaction = cSaveAdminPW
    │             └─ customer.saveAdminPW()
    │                    ├─ sha256()
    │                    └─ adminPassword更新
    │
    └─ フォーム表示
```

### データフロー図

```
[入力]               [処理]                    [出力]

sTotalPW ──────────▶ applyTotalPW()
                         │
                    ┌────┴────┐
                    ▼         ▼
            tblCustomer    tblPage
            (sTotalPW)     (sPw全ページ)


adminPassword ─────▶ saveAdminPW()
                         │
                         ▼
                    sha256()
                         │
                         ▼
                    tblCustomer
                    (adminPassword)
                         │
                         ▼
                    logon.logon()
                    (自動ログオン)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_applyTotalPW.asp | `asp/bs_applyTotalPW.asp` | ソース | パスワード変更画面（メイン管理者用） |
| bs_applyTotalPWSA.asp | `asp/bs_applyTotalPWSA.asp` | ソース | パスワード変更画面（セカンドアドミン用） |
| bs_process.asp | `asp/bs_process.asp` | ソース | 処理分岐ロジック |
| customer.asp | `asp/includes/customer.asp` | ソース | パスワード管理関数定義 |
| sha256.asp | `asp/includes/sha256.asp` | ソース | SHA-256ハッシュ関数 |
| bs_security.asp | `asp/bs_security.asp` | ソース | 認証・権限チェック |
