# 機能設計書 40-フォーム作成・編集

## 概要

本ドキュメントは、QuickerSite CMSにおけるWebフォームの作成・編集機能の設計を記述する。

### 本機能の処理概要

フォーム作成・編集機能は、問い合わせフォームやアンケートフォームなどのWebフォームを新規作成または既存フォームを編集する機能である。自動返信、管理者へのメール通知、リダイレクト、CAPTCHA認証など、フォームの動作に関する詳細設定を行うことができる。

**業務上の目的・背景**：
Webサイトには問い合わせフォーム、資料請求フォーム、アンケートなど様々なフォームが必要となる。本機能により、コーディング不要でフォームの作成・設定が可能であり、自動返信や管理者通知などの業務フローも設定できる。

**機能の利用シーン**：
- 新規の問い合わせフォームを作成したい場合
- 既存フォームの設定（送信先メール、自動返信等）を変更したい場合
- フォーム送信後のリダイレクト先を設定したい場合
- CAPTCHA認証を有効にしたい場合

**主要な処理内容**：
1. フォーム基本情報の設定（名前、イントロ、ボタンラベル）
2. 質問/回答のレイアウト設定
3. 自動返信（オートレスポンダー）の設定
4. 管理者へのメール通知設定
5. フィードバック表示またはリダイレクトの設定
6. CAPTCHA認証の有効/無効設定
7. フォームの保存/削除

**関連システム・外部連携**：
- tblFormテーブル（フォームマスタ）
- cls_mail_message（メール送信）
- CAPTCHA認証

**権限による制御**：
- 管理者権限が必要
- セカンドアドミンのbForms権限が必要

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 132 | フォーム一覧 | 遷移元 | 一覧からの編集選択 |
| 133 | フォーム編集 | 主画面 | フォーム設定の編集 |
| 134 | フォームフィールド設定 | 遷移先 | 新規作成後の遷移 |

## 機能種別

フォーム管理 / CRUD操作

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| iFormID | String | No | フォームID | encrypt暗号化 |
| sName | String | Yes | フォーム名 | 最大255文字 |
| sIntro | String | No | イントロ文 | テキストエリア |
| sButton | String | Yes | 送信ボタンラベル | 最大255文字 |
| sReset | String | No | リセットボタンラベル | 空欄で非表示 |
| sQAalign | String | Yes | 質問/回答配置 | QS_QleftAright/QS_QtopAbottom/QS_QrightAleft |
| bCookie | Boolean | No | Cookie保存 | チェックボックス |
| bCaptcha | Boolean | No | CAPTCHA認証 | チェックボックス |
| sFeedback | String | No | フィードバックメッセージ | リダイレクトと排他 |
| sRedirectPrefix | String | No | リダイレクトプレフィックス | http/https/内部URL |
| sRedirect | String | No | リダイレクトURL | フィードバックと排他 |
| bAutoResponder | Boolean | No | 自動返信有効化 | チェックボックス |
| sAutoResponseSubject | String | Cond | 自動返信件名 | bAutoResponder時必須 |
| sAutoResponseFromName | String | Cond | 自動返信差出人名 | bAutoResponder時必須 |
| sAutoResponseFromEmail | String | Cond | 自動返信差出人メール | bAutoResponder時必須、メール形式 |
| sAutoResponse | String | Cond | 自動返信本文 | bAutoResponder時必須 |
| bSendEmail | Boolean | No | 管理者メール通知有効化 | チェックボックス |
| sSubject | String | Cond | 通知メール件名 | bSendEmail時必須 |
| sAutoResponseWebmaster | String | No | 通知メール本文追加 | テキストエリア |
| sTo | String | Cond | 通知先メールアドレス | bSendEmail時必須、改行区切り |
| bAttachFiles | Boolean | No | 添付ファイル含める | bSendEmail時のみ |
| sScriptUponSubmission | String | No | 送信時スクリプト | bApplication時のみ |

### 入力データソース

- 画面入力（フォーム）
- Request.Form

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| フォーム設定画面 | HTML | 設定フォーム表示 |
| フォームデータ | DB | tblFormテーブル |

### 出力先

- 画面（設定フォーム）
- データベース（tblForm）

## 処理フロー

### 処理シーケンス

```
1. ページ読み込み
   └─ セキュリティチェック（bForms権限）
2. フォーム初期化
   └─ cls_formオブジェクト生成
   └─ iFormIDがあれば既存データ取得
3. ポストバック判定
   └─ postBack=trueなら入力値取得
4. ボタンアクション判定
   ├─ 保存ボタン
   │   └─ checkCSRF()
   │   └─ form.getRequestValues()
   │   └─ form.save()
   │   └─ 新規なら bs_formfields.aspへリダイレクト
   │   └─ 編集なら bs_formList.aspへリダイレクト
   └─ 削除ボタン
       └─ checkCSRF()
       └─ form.remove()
       └─ bs_formList.aspへリダイレクト
5. フォーム表示
   └─ 各設定項目を表示
   └─ bAutoResponder/bSendEmailで条件付き項目表示
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[セキュリティチェック]
    B --> C[cls_form初期化]
    C --> D{iFormID?}
    D -->|Yes| E[既存データ取得]
    D -->|No| F[新規フォーム]
    E --> G{postBack?}
    F --> G
    G -->|Yes| H[入力値取得]
    G -->|No| I[フォーム表示]
    H --> J{btnaction?}
    J -->|save| K[checkCSRF]
    J -->|delete| L[checkCSRF]
    J -->|なし| I
    K --> M[form.save()]
    L --> N[form.remove()]
    M --> O{新規?}
    O -->|Yes| P[bs_formfields.aspへ]
    O -->|No| Q[bs_formList.aspへ]
    N --> Q
    I --> R[終了]
    P --> R
    Q --> R
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-040-1 | 必須項目 | sName, sButtonは必須 | 保存時 |
| BR-040-2 | フィードバック排他 | sFeedbackとsRedirectは排他（どちらか一方のみ） | 保存時check() |
| BR-040-3 | 自動返信必須 | bAutoResponder時は関連項目すべて必須 | 保存時check() |
| BR-040-4 | メール通知必須 | bSendEmail時はsTo, sSubject必須 | 保存時check() |
| BR-040-5 | メール形式検証 | sTo, sAutoResponseFromEmailはメール形式 | 保存時check() |
| BR-040-6 | 新規作成遷移 | 新規保存後はフィールド設定画面へ遷移 | 新規フォーム保存時 |
| BR-040-7 | コピー変数 | [QS_COPYSUBMISSION]で送信内容を自動返信に含める | 自動返信本文 |

### 計算ロジック

- リダイレクトURLからhttp://、https://を自動削除（check関数内）

## データベース操作仕様

### 読み取り

| テーブル名 | 操作 | 条件 | 取得項目 |
|-----------|------|------|----------|
| tblForm | SELECT | iId = formId | 全カラム |

### 書き込み

| テーブル名 | 操作 | 条件 | 更新項目 |
|-----------|------|------|----------|
| tblForm | INSERT | 新規作成時 | 全カラム |
| tblForm | UPDATE | iId = formId | 全カラム |
| tblForm | DELETE | 削除時 | iId = formId |
| tblPage | UPDATE | 削除時 | iFormID = null |
| tblCatalog | UPDATE | 削除時 | iFormID = null |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| err_mandatory | 必須エラー | 必須項目が空 | エラーメッセージ表示 |
| err_email | メール形式エラー | メールアドレス形式不正 | エラーメッセージ表示 |
| err_reg_or_fb | 排他エラー | sFeedbackとsRedirectの両方が空または両方に値 | エラーメッセージ表示 |

### リトライ仕様

エラー発生時は画面に戻り、入力値を保持して再入力可能。

## トランザクション仕様

削除時はtblFormSubmission、tblFormField、tblFormFieldValue、関連ページ/カタログの参照を順次処理。

## パフォーマンス要件

- フォーム保存: 1秒以内

## セキュリティ考慮事項

- bs_security.aspによる管理者認証
- セカンドアドミンのbForms権限チェック
- 保存/削除時のCSRFトークン検証
- sanitize関数による入力値サニタイズ
- quotRep関数による出力エスケープ
- 他カスタマーのフォーム編集防止（iCustomerID検証）

## 備考

- bAutoResponderをチェックすると画面がリロードされ自動返信設定項目が表示される
- bSendEmailをチェックすると画面がリロードされメール通知設定項目が表示される
- sScriptUponSubmission（送信時スクリプト）はbApplication=true時のみ表示
- [QS_COPYSUBMISSION]変数で送信内容を自動返信に含めることが可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | form.asp | `asp/includes/form.asp` | cls_formクラスのプロパティ定義（2-5行目） |
| 1-2 | form.asp | `asp/includes/form.asp` | 初期化処理（7-26行目） |

**読解のコツ**: iId, sName, bSendEmail, bAutoResponderなど多数のプロパティが存在。pick関数で既存データを取得する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_formEdit.asp | `asp/bs_formEdit.asp` | フォーム編集のメイン処理 |

**主要処理フロー**:
1. **4行目**: セキュリティチェック（secondAdmin.bForms）
2. **5-10行目**: cls_form初期化、postBack判定
3. **11-13行目**: カスタマーID検証（セキュリティ）
4. **14-31行目**: ボタンアクションによる処理分岐
5. **32-45行目**: フォーム設定項目の表示

#### Step 3: バリデーション・保存処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | form.asp | `asp/includes/form.asp` | check関数（64-130行目） |
| 3-2 | form.asp | `asp/includes/form.asp` | save関数（131-184行目） |
| 3-3 | form.asp | `asp/includes/form.asp` | remove関数（210-232行目） |

### プログラム呼び出し階層図

```
bs_formEdit.asp
    │
    ├─ bs_security.asp（認証チェック）
    │      └─ logon.hasaccess secondAdmin.bForms
    │
    ├─ cls_form
    │      │
    │      ├─ pick()（既存データ取得）
    │      │      └─ SELECT tblForm
    │      │
    │      ├─ getRequestValues()（入力値取得）
    │      │
    │      ├─ check()（バリデーション）
    │      │      ├─ 必須チェック
    │      │      ├─ メール形式チェック
    │      │      └─ フィードバック/リダイレクト排他チェック
    │      │
    │      ├─ save()（保存処理）
    │      │      └─ INSERT/UPDATE tblForm
    │      │
    │      └─ remove()（削除処理）
    │             ├─ submissions().remove()
    │             ├─ fields().remove()
    │             ├─ UPDATE tblPage SET iFormID=null
    │             ├─ UPDATE tblCatalog SET iFormID=null
    │             └─ DELETE tblForm
    │
    └─ cls_urlTypeShortList（URLプレフィックス選択）
```

### データフロー図

```
[入力]               [処理]                    [出力]

Request.Form ──────▶ getRequestValues() ──▶ フォームプロパティ
                           │
                           ▼
                       check()
                           │
                           ▼
                       save()
                           │
                           ▼
                       tblForm
                           │
                           ▼
               新規: bs_formfields.asp
               編集: bs_formList.asp
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_formEdit.asp | `asp/bs_formEdit.asp` | ソース | フォーム編集画面 |
| bs_formList.asp | `asp/bs_formList.asp` | ソース | フォーム一覧（遷移元/遷移先） |
| bs_formFields.asp | `asp/bs_formFields.asp` | ソース | フォームフィールド設定（遷移先） |
| form.asp | `asp/includes/form.asp` | ソース | cls_formクラス定義 |
| bs_backForm.asp | `asp/bs_backForm.asp` | ソース | エラーメッセージ表示 |
