# 機能設計書 41-フォームフィールド管理

## 概要

本ドキュメントは、QuickerSite CMSにおけるフォームフィールド管理機能の設計仕様を定義する。この機能は、お問い合わせフォーム等の入力項目の追加・編集・並び替えを行う管理画面機能である。

### 本機能の処理概要

**業務上の目的・背景**：
Webサイトのお問い合わせフォームや各種申込フォームでは、サイトの要件に応じて様々な入力項目（テキスト、選択肢、ファイルアップロード等）が必要となる。本機能は、管理者がプログラミング知識なしに、フォームの入力項目を自由にカスタマイズできるようにすることで、柔軟なフォーム構築を実現する。

**機能の利用シーン**：
- 新規フォーム作成時に入力項目を定義する場面
- 既存フォームに項目を追加・修正する場面
- フォーム項目の表示順序を変更する場面
- 不要になった項目を削除する場面

**主要な処理内容**：
1. フォームに紐づくフィールド一覧を取得し表示する
2. フィールドの新規作成画面への遷移を提供する
3. フィールドの上下移動（並び替え）を実行する
4. フィールドの編集・削除画面への遷移を提供する
5. フィールドタイプ（テキスト、テキストエリア、チェックボックス等）の選択・設定を行う

**関連システム・外部連携**：
- フォームプレビュー機能との連携（作成したフィールドの確認）
- フォーム送信データ表示機能との連携（フィールド構造に基づくデータ表示）

**権限による制御**：
- `secondAdmin.bForms`権限を持つ管理者のみがアクセス可能
- セカンドアドミン設定により、フォーム管理機能へのアクセス可否を制御

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 25 | フォームフィールド一覧 | 主画面 | フォーム入力項目の一覧表示・並び替え |
| 26 | フォームフィールド編集 | 遷移先画面 | フォームフィールドの詳細設定 |
| 27 | フォームプレビュー | 参照画面 | フォームの表示プレビュー |

## 機能種別

CRUD操作（フォームフィールドの作成・読取・更新・削除）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| iFormID | String(暗号化) | Yes | 対象フォームのID | 復号化後に数値であること |
| iFormFieldID | String(暗号化) | No | 対象フィールドのID（編集時） | 復号化後に数値であること |
| btnaction | String | No | 実行アクション（MoveUP/MoveDOWN） | 固定値のみ許可 |
| sName | String | Yes | フィールド名 | 空文字不可、255文字以内 |
| sType | String | Yes | フィールドタイプ | 定義済みタイプコードのみ |
| sValues | String | No | 選択肢の値（ドロップダウン・ラジオ用） | 改行区切り |
| bMandatory | Boolean | No | 必須フラグ | true/false |
| iRang | Integer | No | 表示順序 | 1以上の整数 |

### 入力データソース

- 画面フォームからのPOSTリクエスト
- URLパラメータ（暗号化されたID）
- データベース（tblFormField、tblForm）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| フィールド一覧 | HTML | フォームに属するフィールドの表形式一覧 |
| フィールド名 | String | 各フィールドの表示名 |
| フィールドタイプ | String | タイプの日本語表示（テキスト、チェックボックス等） |
| 必須フラグ | String | 必須かどうかの表示（Yes/No） |
| 表示順 | Integer | フィールドの表示順序 |

### 出力先

- 管理画面（HTML形式でブラウザに表示）
- データベース（tblFormFieldテーブル）

## 処理フロー

### 処理シーケンス

```
1. 認証・権限チェック
   └─ secondAdmin.bForms権限の確認

2. リクエストパラメータ取得
   └─ iFormID、iFormFieldID、btnactionの取得・復号化

3. アクション判定
   └─ MoveUP: フィールドの表示順を上に移動
   └─ MoveDOWN: フィールドの表示順を下に移動

4. CSRF検証（アクション実行時）
   └─ checkCSRF()関数による検証

5. フォーム情報取得
   └─ cls_formオブジェクトの生成・データ取得

6. フィールド一覧取得
   └─ form.fieldsプロパティによる取得

7. 画面レンダリング
   └─ フィールド一覧のHTML生成・出力
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{認証・権限チェック}
    B -->|権限なし| C[アクセス拒否]
    B -->|権限あり| D[パラメータ取得]
    D --> E{アクションあり?}
    E -->|MoveUP| F[CSRF検証]
    E -->|MoveDOWN| F
    E -->|なし| G[フォーム情報取得]
    F --> H{検証OK?}
    H -->|NG| I[エラー]
    H -->|OK| J[並び替え処理実行]
    J --> G
    G --> K[フィールド一覧取得]
    K --> L[画面表示]
    L --> M[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-41-01 | フィールド名必須 | フィールド名は必ず入力が必要 | フィールド保存時 |
| BR-41-02 | タイプ必須 | フィールドタイプは必ず選択が必要 | フィールド保存時 |
| BR-41-03 | 選択肢必須条件 | ドロップダウン・ラジオタイプ選択時は選択肢値が必須 | sType=50,55時 |
| BR-41-04 | 表示順自動採番 | 新規作成時は既存フィールド数+1を自動設定 | 新規作成時 |
| BR-41-05 | 移動制限 | 最上位のフィールドはこれ以上上に移動できない | MoveUP実行時かつiRang=1 |

### 計算ロジック

表示順の更新ロジック：
- MoveUP: 対象フィールドのiRangを-1、入れ替わるフィールドのiRangを+1
- MoveDOWN: 対象フィールドのiRangを+1、入れ替わるフィールドのiRangを-1

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| フィールド一覧取得 | tblFormField | SELECT | フォームIDでフィルタして取得 |
| MoveUP | tblFormField | UPDATE | iRangの更新（2レコード） |
| MoveDOWN | tblFormField | UPDATE | iRangの更新（2レコード） |
| フィールド保存 | tblFormField | INSERT/UPDATE | フィールド情報の登録・更新 |
| フィールド削除 | tblFormField | DELETE | フィールドレコードの削除 |
| フィールド削除 | tblFormFieldValue | DELETE | 関連する値データの削除 |

### テーブル別操作詳細

#### tblFormField

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | iFormID=指定値、ORDER BY iRang | フィールド一覧取得 |
| UPDATE | iRang | iRang-1（MoveUP）またはiRang+1（MoveDOWN） | 対象フィールド |
| UPDATE | iRang | iRang+1（MoveUP）またはiRang-1（MoveDOWN） | 入れ替え先フィールド |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| err_mandatory | バリデーションエラー | 必須項目未入力 | エラーメッセージ表示 |
| CSRF_ERROR | セキュリティエラー | CSRFトークン不一致 | 処理中止 |
| ACCESS_DENIED | 権限エラー | bForms権限なし | アクセス拒否画面へ遷移 |

### リトライ仕様

特になし（ユーザー操作による再実行）

## トランザクション仕様

MoveUP/MoveDOWN処理時は、2つのUPDATE文が連続実行されるが、明示的なトランザクション制御は行われていない。

## パフォーマンス要件

- フィールド一覧表示：1秒以内
- 並び替え処理：1秒以内

## セキュリティ考慮事項

- CSRF対策：checkCSRF()関数によるトークン検証
- 認証・認可：logon.hasaccess による権限チェック
- ID暗号化：encrypt/decrypt関数によるID値の保護
- XSS対策：sanitize関数による出力エスケープ

## 備考

フィールドタイプ一覧（sb_ff_定数）：
- 10: テキスト（255文字以内）
- 20: テキストエリア（255文字以上）
- 25: リッチテキスト
- 30: 日付
- 40: チェックボックス
- 50: ドロップダウン
- 55: ラジオボタン
- 60: URL
- 70: メールアドレス
- 80: ファイル
- 90: 画像
- 100: コメント
- 110: 隠しフィールド

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

フォームフィールドのデータモデルを最初に理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | formFieldTypeList.asp | `asp/includes/formFieldTypeList.asp` | フィールドタイプの定数定義（sb_ff_text等）を理解する |
| 1-2 | FormField.asp | `asp/includes/FormField.asp` | cls_FormFieldクラスのプロパティ・メソッドを理解する |

**読解のコツ**:
- 2-14行目でフィールドタイプの定数が定義されている（sb_ff_text="10"等）
- cls_formFieldTypeListクラスはフィールドタイプ選択のドロップダウン生成に使用される

#### Step 2: エントリーポイントを理解する

一覧画面の処理起点を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_formFields.asp | `asp/bs_formFields.asp` | フィールド一覧画面のメイン処理 |

**主要処理フロー**:
1. **4行目**: 権限チェック（secondAdmin.bForms）
2. **5-6行目**: cls_FormFieldオブジェクトの生成
3. **6-13行目**: MoveUP/MoveDOWN処理の分岐
4. **14-16行目**: フォーム情報とフィールド一覧の取得
5. **18-19行目**: フィールド一覧のHTMLテーブル生成

#### Step 3: フィールド編集処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_FormFieldEdit.asp | `asp/bs_FormFieldEdit.asp` | フィールド編集画面の処理 |
| 3-2 | FormField.asp | `asp/includes/FormField.asp` | save/remove/moveUp/moveDownメソッドの実装 |

**主要処理フロー**:
- **9-18行目（bs_FormFieldEdit.asp）**: ボタンアクション（save/delete）による分岐処理
- **56-103行目（FormField.asp）**: save関数でのバリデーションとDB保存処理
- **208-227行目（FormField.asp）**: moveUp/moveDown関数の実装

### プログラム呼び出し階層図

```
bs_formFields.asp (一覧画面)
    │
    ├─ cls_FormField.moveUp() / moveDown()
    │      └─ db.execute() - iRang更新SQL実行
    │
    ├─ cls_form.fields
    │      └─ cls_FormField.pick() - フィールド情報取得
    │
    └─ 遷移 → bs_FormFieldEdit.asp (編集画面)
               │
               ├─ cls_FormField.getRequestValues()
               │      └─ Request.Formからの値取得
               │
               ├─ cls_FormField.save()
               │      ├─ check() - バリデーション
               │      └─ db.GetDynamicRS - INSERT/UPDATE
               │
               └─ cls_FormField.remove()
                      └─ db.execute() - DELETE処理
```

### データフロー図

```
[入力]                    [処理]                         [出力]

URLパラメータ ──────▶ bs_formFields.asp ───────▶ フィールド一覧HTML
(iFormID)              │
                       ├─ cls_form.pick()
                       │
                       └─ cls_form.fields ──────▶ tblFormField
                                                   (SELECT)

POSTデータ ────────▶ bs_FormFieldEdit.asp ───▶ tblFormField
(フィールド設定)        │                           (INSERT/UPDATE)
                       ├─ cls_FormField.save()
                       │
                       └─ Response.Redirect ───▶ bs_formFields.asp
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_formFields.asp | `asp/bs_formFields.asp` | ソース | フィールド一覧画面 |
| bs_FormFieldEdit.asp | `asp/bs_FormFieldEdit.asp` | ソース | フィールド編集画面 |
| FormField.asp | `asp/includes/FormField.asp` | ソース | フィールドクラス定義 |
| formFieldTypeList.asp | `asp/includes/formFieldTypeList.asp` | ソース | フィールドタイプ定義 |
| form.asp | `asp/includes/form.asp` | ソース | フォームクラス定義 |
| bs_backFormField.asp | `asp/bs_backFormField.asp` | テンプレート | 戻るリンク表示 |
| bs_security.asp | `asp/bs_security.asp` | ソース | 認証・権限チェック |
