# 機能設計書 42-フォーム送信データ表示

## 概要

本ドキュメントは、QuickerSite CMSにおけるフォーム送信データ表示機能の設計仕様を定義する。この機能は、お問い合わせフォーム等から送信されたデータを管理画面で一覧表示・編集・削除する機能である。

### 本機能の処理概要

**業務上の目的・背景**：
Webサイトのお問い合わせフォームから送信されたデータを、管理者が確認・管理する必要がある。本機能により、顧客からの問い合わせ内容、申込情報、アンケート回答等を一元的に閲覧・管理でき、迅速な顧客対応を実現する。

**機能の利用シーン**：
- お問い合わせ内容の確認・対応
- 申込データの確認
- 送信データの編集（誤入力の修正）
- 古いデータの削除
- データのExcelエクスポート（機能43と連携）

**主要な処理内容**：
1. 指定フォームの送信データ一覧を取得・表示する
2. 各送信データの詳細を表形式で表示する
3. 個別の送信データを削除する
4. 全ての送信データを一括削除する
5. カタログアイテムと関連付けられた送信データの表示
6. Excelエクスポート機能への遷移リンクを提供する

**関連システム・外部連携**：
- フォームデータExcel出力機能（機能43）との連携
- カタログ機能との連携（カタログアイテムに紐づく問い合わせの場合）

**権限による制御**：
- `secondAdmin.bFormExport`権限を持つ管理者のみがアクセス可能

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 28 | フォームデータエクスポート | 主画面 | フォーム送信データの閲覧 |
| 29 | フォームExcel出力 | 遷移先画面 | Excel形式エクスポート |
| 30 | フォーム送信編集 | 遷移先画面 | 送信済みフォームデータの編集・修正 |

## 機能種別

CRUD操作（送信データの読取・更新・削除）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| iFormID | String(暗号化) | Yes | 対象フォームのID | 復号化後に数値であること |
| iSubmissionID | String(暗号化) | No | 削除対象の送信データID | 復号化後に数値であること |
| pageAction | String | No | ページアクション（removeAll） | 固定値のみ許可 |

### 入力データソース

- URLパラメータ（暗号化されたID）
- データベース（tblFormSubmission、tblFormFieldValue）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 送信件数 | Integer | 総送信データ数 |
| 送信日時 | DateTime | 各データの送信日時 |
| カタログ名 | String | 関連カタログ名（存在する場合） |
| アイテム名 | String | 関連カタログアイテム名（存在する場合） |
| フィールド値 | String | 各フィールドの送信値 |

### 出力先

- 管理画面（HTML形式でブラウザに表示）

## 処理フロー

### 処理シーケンス

```
1. 認証・権限チェック
   └─ secondAdmin.bFormExport権限の確認

2. リクエストパラメータ取得
   └─ iFormID、iSubmissionID、pageActionの取得・復号化

3. 削除アクション判定
   ├─ iSubmissionID指定あり: 個別削除実行
   └─ pageAction=removeAll: 全削除実行

4. CSRF検証（削除アクション時）
   └─ checkCSRF()関数による検証

5. フォーム情報取得
   └─ cls_formオブジェクトの生成・データ取得

6. フィールド定義取得
   └─ form.fieldsによるフィールド構造取得

7. 送信データ一覧取得
   └─ form.submissionsによる送信データ取得

8. カタログ関連チェック
   └─ 送信データにiItemIDがあるかチェック

9. 画面レンダリング
   └─ 送信データ一覧のHTML生成・出力
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{認証・権限チェック}
    B -->|権限なし| C[アクセス拒否]
    B -->|権限あり| D[パラメータ取得]
    D --> E{削除アクションあり?}
    E -->|個別削除| F[CSRF検証]
    E -->|全削除| F
    E -->|なし| G[フォーム情報取得]
    F --> H{検証OK?}
    H -->|NG| I[エラー]
    H -->|OK| J[削除処理実行]
    J --> G
    G --> K[フィールド定義取得]
    K --> L[送信データ一覧取得]
    L --> M{カタログ関連あり?}
    M -->|あり| N[カタログ列追加]
    M -->|なし| O[画面表示]
    N --> O
    O --> P[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-42-01 | 降順表示 | 送信データは新しい順（降順）で表示 | 一覧表示時 |
| BR-42-02 | コメントタイプ除外 | コメントタイプのフィールドは表示対象外 | 一覧表示時 |
| BR-42-03 | カタログ列動的表示 | カタログ関連データがある場合のみカタログ列を表示 | 一覧表示時 |
| BR-42-04 | チェックボックス変換 | チェックボックス値はYes/Noに変換して表示 | 値表示時 |
| BR-42-05 | ファイルリンク化 | ファイル・画像タイプはリンクとして表示 | 値表示時 |
| BR-42-06 | 削除確認必須 | 削除実行前にJavaScript確認ダイアログを表示 | 削除時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 送信データ一覧取得 | tblFormSubmission | SELECT | フォームIDでフィルタして取得 |
| フィールド値取得 | tblFormFieldValue | SELECT | 送信IDでフィルタして取得 |
| 個別削除 | tblFormSubmission | DELETE | 指定送信データの削除 |
| 個別削除 | tblFormFieldValue | DELETE | 関連するフィールド値の削除 |
| 全削除 | tblFormSubmission | DELETE | フォームの全送信データ削除 |
| 全削除 | tblFormFieldValue | DELETE | 関連する全フィールド値の削除 |

### テーブル別操作詳細

#### tblFormSubmission

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | iFormID=指定値、ORDER BY dCreatedTS DESC | 送信データ一覧取得 |
| DELETE | - | iId=指定値 | 個別削除 |
| DELETE | - | iFormID=指定値 | 全削除 |

#### tblFormFieldValue

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | sValue | iSubmissionID=指定値 | フィールド値取得 |
| DELETE | - | iSubmissionID=指定値 | 個別削除時 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| CSRF_ERROR | セキュリティエラー | CSRFトークン不一致 | 処理中止 |
| ACCESS_DENIED | 権限エラー | bFormExport権限なし | アクセス拒否画面へ遷移 |
| NO_DATA | データなし | 送信データが存在しない | 「データなし」メッセージ表示 |

### リトライ仕様

特になし（ユーザー操作による再実行）

## トランザクション仕様

削除処理時、tblFormSubmissionとtblFormFieldValueの削除が連続実行されるが、明示的なトランザクション制御は行われていない。

## パフォーマンス要件

- 送信データ一覧表示：3秒以内（1000件以下の場合）
- 個別削除処理：1秒以内
- 全削除処理：件数に応じて変動

## セキュリティ考慮事項

- CSRF対策：checkCSRF()関数によるトークン検証
- 認証・認可：logon.hasaccess による権限チェック
- ID暗号化：encrypt/decrypt関数によるID値の保護
- XSS対策：sanitize関数による出力エスケープ
- 削除確認：JavaScript confirm()による誤削除防止

## 備考

ファイル・画像タイプのフィールド値は、ファイル保存先の設定（sFileLocation）に応じて異なるパスで表示される。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

送信データの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | form.asp | `asp/includes/form.asp` | submissionsプロパティの実装を理解する |

**読解のコツ**:
- 824-838行目でsubmissions関数が定義されている
- tblFormSubmissionテーブルからデータを取得し、cls_submissionオブジェクトとして返す

#### Step 2: エントリーポイントを理解する

送信データ表示画面の処理起点を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_formExport.asp | `asp/bs_formExport.asp` | 送信データ一覧画面のメイン処理 |

**主要処理フロー**:
1. **4行目**: 権限チェック（secondAdmin.bFormExport）
2. **6-7行目**: フォームとフィールド情報の取得
3. **8-12行目**: 個別削除処理（submission.remove）
4. **13-16行目**: 全削除処理（form.removeAllSubmissions）
5. **17-18行目**: 送信データ一覧の取得
6. **19-24行目**: カタログ関連チェック
7. **24-49行目**: HTMLテーブル生成とデータ表示

#### Step 3: 削除処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | form.asp | `asp/includes/form.asp` | removeAllSubmissions関数の実装 |

**主要処理フロー**:
- **875-886行目**: removeAllSubmissions関数
- 全送信データをループして個別に削除処理を実行

### プログラム呼び出し階層図

```
bs_formExport.asp (送信データ一覧画面)
    │
    ├─ cls_form.pick()
    │      └─ tblForm SELECT
    │
    ├─ cls_form.fields
    │      └─ tblFormField SELECT
    │
    ├─ cls_submission.remove(fields)
    │      ├─ ファイル削除処理
    │      └─ tblFormFieldValue DELETE
    │      └─ tblFormSubmission DELETE
    │
    ├─ cls_form.removeAllSubmissions()
    │      └─ 全submissionをループしてremove()
    │
    └─ cls_form.submissions
           └─ cls_submission.values(fields)
                  └─ tblFormFieldValue SELECT
```

### データフロー図

```
[入力]                    [処理]                         [出力]

URLパラメータ ──────▶ bs_formExport.asp ────────▶ 送信データ一覧HTML
(iFormID)              │
                       ├─ cls_form.submissions
                       │      └─ tblFormSubmission SELECT
                       │
                       └─ cls_submission.values
                              └─ tblFormFieldValue SELECT

削除リクエスト ─────▶ submission.remove() ─────▶ DELETE処理
(iSubmissionID)        │
                       ├─ ファイル削除
                       └─ DB削除
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_formExport.asp | `asp/bs_formExport.asp` | ソース | 送信データ一覧画面 |
| form.asp | `asp/includes/form.asp` | ソース | Formクラス定義 |
| FormField.asp | `asp/includes/FormField.asp` | ソース | FormFieldクラス定義 |
| bs_formSubmissionEdit.asp | `asp/bs_formSubmissionEdit.asp` | ソース | 送信データ編集画面 |
| bs_formExcel.asp | `asp/bs_formExcel.asp` | ソース | Excel出力処理 |
| bs_security.asp | `asp/bs_security.asp` | ソース | 認証・権限チェック |
