# 機能設計書 43-フォームデータExcel出力

## 概要

本ドキュメントは、QuickerSite CMSにおけるフォームデータExcel出力機能の設計仕様を定義する。この機能は、お問い合わせフォーム等から送信されたデータをExcel形式でエクスポートする機能である。

### 本機能の処理概要

**業務上の目的・背景**：
フォームから収集したデータを、Excel形式でダウンロードすることにより、外部ツールでの集計・分析、他システムへのインポート、バックアップ、帳票作成などの二次利用を可能にする。管理画面上での閲覧だけでなく、オフラインでのデータ活用ニーズに対応する。

**機能の利用シーン**：
- アンケート結果の集計・分析
- 問い合わせデータのバックアップ
- 他システムへのデータ移行
- 報告書・帳票作成のための元データ取得
- 定期的なデータエクスポート業務

**主要な処理内容**：
1. 指定フォームの全送信データを取得する
2. フィールド定義に基づきHTMLテーブルを生成する
3. HTMLテーブルをExcelファイル形式に変換する
4. ブラウザにExcelファイルをダウンロードさせる

**関連システム・外部連携**：
- フォーム送信データ表示機能（機能42）からの呼び出し
- cls_excelfileクラスによるExcelファイル生成

**権限による制御**：
- `secondAdmin.bFormExport`権限を持つ管理者のみがアクセス可能

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 29 | フォームExcel出力 | 主画面 | フォームデータのExcel形式エクスポート |
| 28 | フォームデータエクスポート | 参照元画面 | フォーム送信データの閲覧 |

## 機能種別

帳票出力（Excelファイル生成・ダウンロード）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| iFormID | String(暗号化) | Yes | 対象フォームのID | 復号化後に数値であること |

### 入力データソース

- URLパラメータ（暗号化されたID）
- データベース（tblForm、tblFormField、tblFormSubmission、tblFormFieldValue）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| ID | Integer | 送信データのID |
| 日時 | DateTime | 送信日時 |
| カタログ | String | 関連カタログ名（存在する場合） |
| アイテム | String | 関連アイテム名（存在する場合） |
| フィールド値（複数） | String | 各フィールドの送信値 |

### 出力先

- ブラウザ（Excelファイルとしてダウンロード）

## 処理フロー

### 処理シーケンス

```
1. 認証・権限チェック
   └─ secondAdmin.bFormExport権限の確認

2. リクエストパラメータ取得
   └─ iFormIDの取得・復号化

3. フォーム情報取得
   └─ cls_formオブジェクトの生成・データ取得

4. フィールド定義取得
   └─ form.fieldsによるフィールド構造取得

5. 送信データ一覧取得
   └─ form.submissionsによる送信データ取得

6. カタログ関連チェック
   └─ 送信データにiItemIDがあるかチェック

7. HTMLテーブル生成
   ├─ ヘッダー行の生成
   └─ データ行の生成（全送信データをループ）

8. Excelファイル変換・出力
   ├─ cls_excelfileオブジェクト生成
   ├─ export()メソッドでHTML→Excel変換
   └─ redirectLink()でダウンロードリダイレクト
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{認証・権限チェック}
    B -->|権限なし| C[アクセス拒否]
    B -->|権限あり| D[パラメータ取得]
    D --> E[フォーム情報取得]
    E --> F[フィールド定義取得]
    F --> G[送信データ一覧取得]
    G --> H{カタログ関連あり?}
    H -->|あり| I[カタログ列追加]
    H -->|なし| J[HTMLテーブル生成]
    I --> J
    J --> K[ヘッダー行生成]
    K --> L[データ行生成ループ]
    L --> M[cls_excelfile.export]
    M --> N[redirectLink]
    N --> O[Excelダウンロード]
    O --> P[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-43-01 | コメントタイプ除外 | コメントタイプのフィールドはExcelに含めない | テーブル生成時 |
| BR-43-02 | チェックボックス変換 | チェックボックス値はYes/Noに変換して出力 | 値出力時 |
| BR-43-03 | ファイルURL出力 | ファイル・画像タイプはURLとして出力 | 値出力時 |
| BR-43-04 | カタログ列動的出力 | カタログ関連データがある場合のみカタログ列を出力 | テーブル生成時 |
| BR-43-05 | ヘッダー背景色 | ヘッダー行はGainsboro色で背景を設定 | ヘッダー生成時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| フォーム情報取得 | tblForm | SELECT | 指定IDのフォーム情報 |
| フィールド定義取得 | tblFormField | SELECT | フォームIDでフィルタ |
| 送信データ取得 | tblFormSubmission | SELECT | フォームIDでフィルタ |
| フィールド値取得 | tblFormFieldValue | SELECT | 送信IDでフィルタ |

### テーブル別操作詳細

#### tblFormSubmission

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | iFormID=指定値 | 送信データ一覧取得 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ACCESS_DENIED | 権限エラー | bFormExport権限なし | アクセス拒否画面へ遷移 |

### リトライ仕様

特になし（ユーザー操作による再実行）

## トランザクション仕様

参照のみのためトランザクション制御不要

## パフォーマンス要件

- Excel生成処理：データ件数に応じて変動
- 大量データ時はタイムアウト注意

## セキュリティ考慮事項

- 認証・認可：logon.hasaccess による権限チェック
- ID暗号化：decrypt関数によるID値の保護
- XSS対策：sanitize関数による値エスケープ

## 備考

Excelファイル生成はHTMLテーブルをExcelが解釈可能な形式で出力する方式を採用している。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

Excel出力画面の処理起点を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | bs_formExcel.asp | `asp/bs_formExcel.asp` | Excel出力のメイン処理 |

**主要処理フロー**:
1. **4行目**: 権限チェック（secondAdmin.bFormExport）
2. **6-8行目**: フォーム、フィールド、送信データの取得
3. **9-14行目**: カタログ関連チェック
4. **15-26行目**: HTMLテーブルのヘッダー行生成
5. **27-57行目**: データ行生成ループ
6. **62-65行目**: cls_excelfileによるExcel出力

#### Step 2: データ取得処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | form.asp | `asp/includes/form.asp` | submissions, fieldsプロパティの実装 |

**読解のコツ**:
- 233-249行目: fieldsプロパティでフィールド一覧を取得
- 824-838行目: submissionsプロパティで送信データ一覧を取得

#### Step 3: Excel出力クラスを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | excelfile.asp | `asp/includes/excelfile.asp` | cls_excelfileクラスの実装（推定） |

### プログラム呼び出し階層図

```
bs_formExcel.asp (Excel出力)
    │
    ├─ cls_form.pick()
    │      └─ tblForm SELECT
    │
    ├─ cls_form.fields
    │      └─ tblFormField SELECT
    │
    ├─ cls_form.submissions
    │      └─ tblFormSubmission SELECT
    │
    ├─ cls_submission.values(fields)
    │      └─ tblFormFieldValue SELECT
    │
    └─ cls_excelfile
           ├─ export(table) - HTML→Excel変換
           └─ redirectLink() - ダウンロードリダイレクト
```

### データフロー図

```
[入力]                    [処理]                         [出力]

URLパラメータ ──────▶ bs_formExcel.asp ─────────▶ Excelファイル
(iFormID)              │                              (ダウンロード)
                       ├─ cls_form.fields
                       │      └─ tblFormField SELECT
                       │
                       ├─ cls_form.submissions
                       │      └─ tblFormSubmission SELECT
                       │
                       ├─ HTMLテーブル生成
                       │
                       └─ cls_excelfile.export()
                              └─ Excel形式変換
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_formExcel.asp | `asp/bs_formExcel.asp` | ソース | Excel出力メイン処理 |
| form.asp | `asp/includes/form.asp` | ソース | Formクラス定義 |
| FormField.asp | `asp/includes/FormField.asp` | ソース | FormFieldクラス定義 |
| excelfile.asp | `asp/includes/excelfile.asp` | ソース | Excelファイル生成クラス |
| bs_formExport.asp | `asp/bs_formExport.asp` | ソース | 送信データ一覧画面（呼び出し元） |
