# 機能設計書 44-フォームプレビュー

## 概要

本ドキュメントは、QuickerSite CMSにおけるフォームプレビュー機能の設計仕様を定義する。この機能は、作成したフォームの実際の表示を確認するためのプレビュー機能である。

### 本機能の処理概要

**業務上の目的・背景**：
フォーム作成時に、実際にユーザーがどのような画面を見るのかを確認できる必要がある。本機能により、フォームを公開する前にレイアウト、入力項目、バリデーション等の動作確認を行い、意図した通りのフォームが作成できているかを検証できる。

**機能の利用シーン**：
- フォーム新規作成後の確認
- フォームフィールド追加・変更後の確認
- フォームレイアウト・スタイルの確認
- バリデーション動作の確認
- 公開前の最終チェック

**主要な処理内容**：
1. 指定フォームの情報を取得する
2. フォームのbuildメソッドを呼び出してHTMLを生成する
3. 生成されたフォームHTMLをプレビュー画面に表示する

**関連システム・外部連携**：
- フォームフィールド管理機能（機能41）からの呼び出し
- フォーム編集機能（機能40）からの呼び出し

**権限による制御**：
- `secondAdmin.bForms`権限を持つ管理者のみがアクセス可能

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 27 | フォームプレビュー | 主画面 | フォームの表示プレビュー |
| 25 | フォームフィールド一覧 | 参照元画面 | フォーム入力項目の一覧表示・並び替え |
| 24 | フォーム編集 | 参照元画面 | フォームの作成・設定・自動応答設定 |

## 機能種別

表示処理（フォームHTMLの生成・プレビュー表示）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| iFormID | String(暗号化) | Yes | 対象フォームのID | 復号化後に数値であること |

### 入力データソース

- URLパラメータ（暗号化されたID）
- データベース（tblForm、tblFormField）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| フォームHTML | HTML | 生成されたフォームのHTML |
| イントロ文 | String | フォーム上部に表示される説明文 |
| 各フィールド | HTML | 各入力フィールドのHTML |
| 送信ボタン | HTML | 送信ボタンのHTML |
| リセットボタン | HTML | リセットボタンのHTML（設定時） |

### 出力先

- ブラウザ（HTML形式でプレビュー表示）

## 処理フロー

### 処理シーケンス

```
1. 認証・権限チェック
   └─ secondAdmin.bForms権限の確認

2. リクエストパラメータ取得
   └─ iFormIDの取得・復号化

3. フォーム情報取得
   └─ cls_formオブジェクトの生成・データ取得

4. フォームHTML生成
   └─ form.build()メソッドの呼び出し

5. HTML出力
   └─ Response.writeでブラウザに出力
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{認証・権限チェック}
    B -->|権限なし| C[アクセス拒否]
    B -->|権限あり| D[パラメータ取得]
    D --> E[フォーム情報取得]
    E --> F[form.build呼び出し]
    F --> G[フォームHTML生成]
    G --> H[プレビュー表示]
    H --> I[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-44-01 | プレビューモード | 実際の送信は行わず、表示のみ確認 | プレビュー時 |
| BR-44-02 | 全フィールド表示 | 定義された全てのフィールドを表示 | プレビュー時 |
| BR-44-03 | スタイル適用 | サイトのCSSスタイルを適用して表示 | プレビュー時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| フォーム情報取得 | tblForm | SELECT | 指定IDのフォーム情報 |
| フィールド定義取得 | tblFormField | SELECT | フォームIDでフィルタ |

### テーブル別操作詳細

#### tblForm

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | iId=指定値 | フォーム情報取得 |

#### tblFormField

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | iFormID=指定値、ORDER BY iRang | フィールド一覧取得 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ACCESS_DENIED | 権限エラー | bForms権限なし | アクセス拒否画面へ遷移 |
| FORM_NOT_FOUND | データなし | フォームが存在しない | エラーページ表示 |

### リトライ仕様

特になし

## トランザクション仕様

参照のみのためトランザクション制御不要

## パフォーマンス要件

- プレビュー表示：1秒以内

## セキュリティ考慮事項

- 認証・認可：logon.hasaccess による権限チェック
- ID暗号化：decrypt関数によるID値の保護

## 備考

プレビュー画面はポップアップウィンドウで表示される設計となっている。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

プレビュー画面の処理起点を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | bs_formPreview.asp | `asp/bs_formPreview.asp` | プレビュー画面のメイン処理 |

**主要処理フロー**:
1. **4行目**: 権限チェック（secondAdmin.bForms）
2. **4-5行目**: フォームオブジェクトの生成
3. **6行目**: form.build()メソッドの呼び出し

#### Step 2: フォームHTML生成処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | form.asp | `asp/includes/form.asp` | build関数の実装 |

**主要処理フロー**:
- **250-805行目**: build関数の実装
- **565行目**: アンカータグの生成
- **579行目**: formタグの開始
- **586行目**: イントロ文の表示
- **588-744行目**: 各フィールドタイプに応じたHTML生成
- **745-756行目**: CAPTCHA表示（設定時）
- **775-778行目**: 送信・リセットボタンの生成

**読解のコツ**:
- build関数は非常に長い関数で、フィールドタイプごとに分岐処理がある
- 624-737行目でselect caseによりフィールドタイプ別のHTML生成を行う

### プログラム呼び出し階層図

```
bs_formPreview.asp (プレビュー画面)
    │
    └─ cls_form.build()
           │
           ├─ cls_form.pick()
           │      └─ tblForm SELECT
           │
           ├─ cls_form.fields
           │      └─ tblFormField SELECT
           │
           └─ フィールドタイプ別HTML生成
                  ├─ sb_ff_text → input type="text"
                  ├─ sb_ff_textarea → textarea
                  ├─ sb_ff_checkbox → input type="checkbox"
                  ├─ sb_ff_select → select
                  ├─ sb_ff_radio → input type="radio"
                  ├─ sb_ff_date → input + DatePicker
                  └─ sb_ff_file → input type="file"
```

### データフロー図

```
[入力]                    [処理]                         [出力]

URLパラメータ ──────▶ bs_formPreview.asp ────────▶ フォームHTML
(iFormID)              │                              (プレビュー表示)
                       └─ cls_form.build()
                              │
                              ├─ tblForm SELECT
                              │
                              ├─ tblFormField SELECT
                              │
                              └─ HTML生成
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_formPreview.asp | `asp/bs_formPreview.asp` | ソース | プレビュー画面 |
| form.asp | `asp/includes/form.asp` | ソース | Formクラス定義（build関数） |
| FormField.asp | `asp/includes/FormField.asp` | ソース | FormFieldクラス定義 |
| bs_formFields.asp | `asp/bs_formFields.asp` | ソース | フィールド一覧画面（呼び出し元） |
