# 機能設計書 45-カタログ一覧

## 概要

本ドキュメントは、QuickerSite CMSにおけるカタログ一覧機能の設計仕様を定義する。この機能は、商品カタログの一覧を表示し、各カタログの管理画面へのナビゲーションを提供する機能である。

### 本機能の処理概要

**業務上の目的・背景**：
ECサイトや商品紹介サイトでは、複数の商品カタログを管理する必要がある。本機能により、管理者はサイト内の全カタログを一元的に把握し、各カタログの設定・フィールド・ファイルタイプ・アイテムの管理画面へ素早くアクセスできる。

**機能の利用シーン**：
- カタログの全体像を把握する場面
- 新規カタログを作成する場面
- 既存カタログの設定を変更する場面
- カタログフィールドの並び替えを行う場面
- カタログアイテム一覧へ遷移する場面

**主要な処理内容**：
1. 顧客（サイト）に属する全カタログを取得・表示する
2. 各カタログのフィールド一覧を表示する
3. 各カタログのファイルタイプ一覧を表示する
4. フィールドの上下移動（並び替え）を実行する
5. 新規カタログ作成、カタログ編集、フィールド編集、アイテム一覧への遷移リンクを提供する

**関連システム・外部連携**：
- カタログ作成・編集機能（機能46）への遷移
- カタログフィールド管理機能（機能47）への遷移
- カタログアイテム検索機能（機能49）への遷移
- カタログファイルタイプ管理機能（機能50）への遷移

**権限による制御**：
- `secondAdmin.bCatalog`権限を持つ管理者のみがアクセス可能

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 34 | カタログ一覧 | 主画面 | 登録済みカタログの一覧表示 |
| 35 | カタログ編集 | 遷移先画面 | カタログの基本設定 |
| 36 | カタログフィールド編集 | 遷移先画面 | カタログ項目のカスタムフィールド定義 |
| 37 | カタログファイルタイプ編集 | 遷移先画面 | カタログに添付可能なファイルタイプの定義 |
| 39 | カタログアイテム検索 | 遷移先画面 | カタログ内アイテムの検索・絞り込み |

## 機能種別

CRUD操作（カタログ・フィールドの読取・並び替え）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| iFieldID | String(暗号化) | No | 並び替え対象フィールドのID | 復号化後に数値であること |
| btnaction | String | No | 実行アクション（MoveUP/MoveDOWN） | 固定値のみ許可 |

### 入力データソース

- URLパラメータ（暗号化されたID）
- データベース（tblCatalog、tblCatalogField、tblCatalogFileType）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| カタログ一覧 | HTML | 登録済みカタログの表形式一覧 |
| カタログ名 | String | 各カタログの名称 |
| カタログID | Integer | 各カタログのID |
| フィールド一覧 | HTML | 各カタログに属するフィールドのリスト |
| ファイルタイプ一覧 | HTML | 各カタログに属するファイルタイプのリスト |

### 出力先

- 管理画面（HTML形式でブラウザに表示）

## 処理フロー

### 処理シーケンス

```
1. 認証・権限チェック
   └─ secondAdmin.bCatalog権限の確認

2. リクエストパラメータ取得
   └─ iFieldID、btnactionの取得・復号化

3. アクション判定
   └─ MoveUP: フィールドの表示順を上に移動
   └─ MoveDOWN: フィールドの表示順を下に移動

4. CSRF検証（アクション実行時）
   └─ checkCSRF()関数による検証

5. カタログ一覧取得
   └─ customer.catalogsによる取得

6. 各カタログのフィールド・ファイルタイプ取得
   └─ catalogs(key).fields、catalogs(key).fileTypesによる取得

7. 画面レンダリング
   └─ カタログ一覧のHTML生成・出力
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{認証・権限チェック}
    B -->|権限なし| C[アクセス拒否]
    B -->|権限あり| D[パラメータ取得]
    D --> E{アクションあり?}
    E -->|MoveUP| F[CSRF検証]
    E -->|MoveDOWN| F
    E -->|なし| G[カタログ一覧取得]
    F --> H{検証OK?}
    H -->|NG| I[エラー]
    H -->|OK| J[並び替え処理実行]
    J --> G
    G --> K{カタログあり?}
    K -->|あり| L[各カタログのフィールド・ファイルタイプ取得]
    K -->|なし| M[「カタログなし」メッセージ表示]
    L --> N[画面表示]
    M --> N
    N --> O[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-45-01 | カタログ名順表示 | カタログは名前順で表示 | 一覧表示時 |
| BR-45-02 | フィールドiRang順表示 | フィールドはiRang（表示順）の昇順で表示 | フィールド一覧表示時 |
| BR-45-03 | アイテム追加条件 | フィールドが1件以上ある場合のみアイテム追加リンクを表示 | 一覧表示時 |
| BR-45-04 | 移動制限 | 最上位のフィールドはこれ以上上に移動できない | MoveUP実行時かつiRang=1 |

### 計算ロジック

表示順の更新ロジック：
- MoveUP: 対象フィールドのiRangを-1、入れ替わるフィールドのiRangを+1
- MoveDOWN: 対象フィールドのiRangを+1、入れ替わるフィールドのiRangを-1

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| カタログ一覧取得 | tblCatalog | SELECT | 顧客IDでフィルタして取得 |
| フィールド一覧取得 | tblCatalogField | SELECT | カタログIDでフィルタして取得 |
| ファイルタイプ一覧取得 | tblCatalogFileType | SELECT | カタログIDでフィルタして取得 |
| MoveUP | tblCatalogField | UPDATE | iRangの更新（2レコード） |
| MoveDOWN | tblCatalogField | UPDATE | iRangの更新（2レコード） |

### テーブル別操作詳細

#### tblCatalog

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | iCustomerID=顧客ID、ORDER BY sName | カタログ一覧取得 |

#### tblCatalogField

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | iCatalogID=指定値、ORDER BY iRang | フィールド一覧取得 |
| UPDATE | iRang | iRang-1（MoveUP）またはiRang+1（MoveDOWN） | 対象フィールド |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| CSRF_ERROR | セキュリティエラー | CSRFトークン不一致 | 処理中止 |
| ACCESS_DENIED | 権限エラー | bCatalog権限なし | アクセス拒否画面へ遷移 |

### リトライ仕様

特になし（ユーザー操作による再実行）

## トランザクション仕様

MoveUP/MoveDOWN処理時は、2つのUPDATE文が連続実行されるが、明示的なトランザクション制御は行われていない。

## パフォーマンス要件

- カタログ一覧表示：1秒以内
- 並び替え処理：1秒以内

## セキュリティ考慮事項

- CSRF対策：checkCSRF()関数によるトークン検証
- 認証・認可：logon.hasaccess による権限チェック
- ID暗号化：encrypt/decrypt関数によるID値の保護

## 備考

カタログはECサイト機能の中核を担う機能で、商品情報のカスタマイズ性が高い設計となっている。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

カタログのデータモデルを最初に理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | catalog.asp | `asp/includes/catalog.asp` | cls_catalogクラスのプロパティ・メソッドを理解する |
| 1-2 | catalogField.asp | `asp/includes/catalogField.asp` | cls_catalogFieldクラスを理解する |
| 1-3 | catalogFileType.asp | `asp/includes/catalogFileType.asp` | cls_catalogFileTypeクラスを理解する |

**読解のコツ**:
- 2-5行目（catalog.asp）: カタログのプロパティ一覧
- 244-266行目（catalog.asp）: fieldsメソッドでフィールド一覧を取得
- 228-243行目（catalog.asp）: fileTypesメソッドでファイルタイプ一覧を取得

#### Step 2: エントリーポイントを理解する

一覧画面の処理起点を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_catalogList.asp | `asp/bs_catalogList.asp` | カタログ一覧画面のメイン処理 |

**主要処理フロー**:
1. **4行目**: 権限チェック（secondAdmin.bCatalog）
2. **5-6行目**: cls_catalogFieldオブジェクトの生成
3. **6-13行目**: MoveUP/MoveDOWN処理の分岐
4. **14-15行目**: カタログ一覧の取得（customer.catalogs）
5. **17-22行目**: 各カタログのループ処理とHTML生成

#### Step 3: フィールド並び替え処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | catalogField.asp | `asp/includes/catalogField.asp` | moveUp/moveDownメソッドの実装 |

**主要処理フロー**:
- **138-157行目**: moveUp/moveDown関数の実装

### プログラム呼び出し階層図

```
bs_catalogList.asp (カタログ一覧画面)
    │
    ├─ cls_catalogField.moveUp() / moveDown()
    │      └─ db.execute() - iRang更新SQL実行
    │
    ├─ customer.catalogs
    │      └─ cls_catalog.pick() - カタログ情報取得
    │
    ├─ catalogs(key).fields("")
    │      └─ cls_catalogField.pick() - フィールド情報取得
    │
    └─ catalogs(key).fileTypes
           └─ cls_catalogFileType.pick() - ファイルタイプ情報取得
```

### データフロー図

```
[入力]                    [処理]                         [出力]

URLパラメータ ──────▶ bs_catalogList.asp ────────▶ カタログ一覧HTML
(iFieldID, btnaction)    │
                         ├─ customer.catalogs
                         │      └─ tblCatalog SELECT
                         │
                         ├─ catalog.fields
                         │      └─ tblCatalogField SELECT
                         │
                         └─ catalog.fileTypes
                                └─ tblCatalogFileType SELECT
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_catalogList.asp | `asp/bs_catalogList.asp` | ソース | カタログ一覧画面 |
| catalog.asp | `asp/includes/catalog.asp` | ソース | Catalogクラス定義 |
| catalogField.asp | `asp/includes/catalogField.asp` | ソース | CatalogFieldクラス定義 |
| catalogFileType.asp | `asp/includes/catalogFileType.asp` | ソース | CatalogFileTypeクラス定義 |
| bs_catalogEdit.asp | `asp/bs_catalogEdit.asp` | ソース | カタログ編集画面 |
| bs_catalogFieldEdit.asp | `asp/bs_catalogFieldEdit.asp` | ソース | フィールド編集画面 |
| bs_catalogFileTypeEdit.asp | `asp/bs_catalogFileTypeEdit.asp` | ソース | ファイルタイプ編集画面 |
| bs_catalogItemSearch.asp | `asp/bs_catalogItemSearch.asp` | ソース | アイテム検索画面 |
