# 機能設計書 46-カタログ作成・編集

## 概要

本ドキュメントは、QuickerSite CMSにおけるカタログ作成・編集機能の設計仕様を定義する。この機能は、商品カタログの新規作成および既存カタログの基本設定を編集する機能である。

### 本機能の処理概要

**業務上の目的・背景**：
ECサイトや商品紹介サイトでは、商品カテゴリごとにカタログを作成し、それぞれに固有の設定を行う必要がある。本機能により、管理者はカタログの名称、表示設定、ソート順、サムネイル設定、フォーム連携、RSSビュー設定など、カタログの基本動作を定義できる。

**機能の利用シーン**：
- 新規商品カタログを作成する場面
- カタログの基本設定を変更する場面
- カタログの表示・非表示を切り替える場面
- カタログとお問い合わせフォームを連携させる場面
- RSSフィードの表示テンプレートを設定する場面

**主要な処理内容**：
1. カタログの新規作成（INSERT）
2. カタログの基本情報の編集（UPDATE）
3. カタログの削除（DELETE）
4. フォーム連携の設定
5. サムネイル自動生成の設定
6. RSSビューテンプレートの設定

**関連システム・外部連携**：
- カタログ一覧機能（機能45）への遷移
- フォーム機能との連携（カタログアイテムへのお問い合わせ）
- RSSフィード出力機能との連携

**権限による制御**：
- `secondAdmin.bCatalog`権限を持つ管理者のみがアクセス可能

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 35 | カタログ編集 | 主画面 | カタログの基本設定 |
| 34 | カタログ一覧 | 参照元画面 | 登録済みカタログの一覧表示 |
| 38 | カタログアイテム編集 | 遷移先画面 | カタログ内の個別アイテム追加・編集 |
| 39 | カタログアイテム検索 | 遷移先画面 | カタログ内アイテムの検索・絞り込み |

## 機能種別

CRUD操作（カタログの作成・読取・更新・削除）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| iCatalogID | String(暗号化) | No | 対象カタログのID（編集時） | 復号化後に数値であること |
| sName | String | Yes | カタログ名 | 空文字不可、255文字以内 |
| sItemName | String | Yes | アイテム名称ラベル | 空文字不可、50文字以内 |
| bOnline | Boolean | No | オンライン状態 | true/false |
| bPushRSS | Boolean | No | RSS配信フラグ | true/false |
| bSearchable | Boolean | No | 検索可能フラグ | true/false |
| bAutoThumb | Boolean | No | サムネイル自動生成フラグ | true/false |
| iMaxThumbSize | Integer | No | サムネイルの最大サイズ | 10-1000px |
| sResizePicTo | Integer | No | 画像リサイズサイズ | 480-2800px |
| bUseShadow | Boolean | No | 影効果使用フラグ | true/false |
| sOrderItemsBy | String | No | アイテムのソート順 | 定義済み値のみ |
| iPageSize | Integer | No | ページあたりの表示件数 | 1-100 |
| iFormID | String(暗号化) | No | 連携フォームのID | 復号化後に数値であること |
| sFormTitle | String | No | フォームリンクのテキスト | フォーム連携時は必須 |
| sFilePath | String | No | 添付ファイル保存パス | フォルダパス |
| sRSSView1/2/3 | String | No | RSSビューテンプレート | HTMLテンプレート |
| sItemView | String | No | アイテム表示テンプレート | HTMLテンプレート |
| btnaction | String | No | 実行アクション | 保存/削除 |

### 入力データソース

- 画面フォームからのPOSTリクエスト
- URLパラメータ（暗号化されたID）
- データベース（tblCatalog）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| カタログ編集フォーム | HTML | カタログ設定の入力フォーム |
| フィールドプレースホルダー | HTML | テンプレートで使用可能なプレースホルダー一覧 |

### 出力先

- 管理画面（HTML形式でブラウザに表示）
- データベース（tblCatalogテーブル）

## 処理フロー

### 処理シーケンス

```
1. 認証・権限チェック
   └─ secondAdmin.bCatalog権限の確認

2. リクエストパラメータ取得
   └─ iCatalogIDの取得・復号化

3. POSTバック判定
   └─ postBack=trueの場合、フォーム値を取得

4. アクション判定
   └─ save: カタログの保存処理
   └─ delete: カタログの削除処理

5. CSRF検証（アクション実行時）
   └─ checkCSRF()関数による検証

6. バリデーション
   └─ catalog.check()関数による入力検証

7. 保存/削除処理
   ├─ 保存: catalog.save()
   └─ 削除: catalog.remove()

8. リダイレクト/画面表示
   └─ 成功時: リダイレクト、失敗時: エラー表示
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{認証・権限チェック}
    B -->|権限なし| C[アクセス拒否]
    B -->|権限あり| D[パラメータ取得]
    D --> E{POSTバック?}
    E -->|Yes| F[フォーム値取得]
    E -->|No| G[既存データ取得]
    F --> H{アクション判定}
    G --> I[編集フォーム表示]
    H -->|save| J[CSRF検証]
    H -->|delete| J
    J --> K{バリデーション}
    K -->|OK| L{保存 or 削除?}
    K -->|NG| I
    L -->|保存| M[catalog.save]
    L -->|削除| N[catalog.remove]
    M --> O[リダイレクト]
    N --> P[カタログ一覧へ]
    I --> Q[終了]
    O --> Q
    P --> Q
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-46-01 | カタログ名必須 | カタログ名は必ず入力が必要 | 保存時 |
| BR-46-02 | アイテム名必須 | アイテム名称ラベルは必ず入力が必要 | 保存時 |
| BR-46-03 | フォームリンク文必須 | フォーム連携時はリンクテキストが必須 | iFormIDが設定されている場合 |
| BR-46-04 | 削除時の関連データ削除 | カタログ削除時は関連するアイテム・フィールド・ファイルタイプも削除 | 削除時 |
| BR-46-05 | RSSキャッシュクリア | 保存時にRSSキャッシュをクリア | 保存時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| カタログ取得 | tblCatalog | SELECT | 指定IDのカタログ情報 |
| カタログ新規作成 | tblCatalog | INSERT | 新規レコード追加 |
| カタログ更新 | tblCatalog | UPDATE | 既存レコード更新 |
| カタログ削除 | tblCatalog | DELETE | レコード削除 |
| 関連アイテム削除 | tblCatalogItem | DELETE | カタログ削除時 |
| 関連フィールド削除 | tblCatalogField | DELETE | カタログ削除時 |
| 関連ファイルタイプ削除 | tblCatalogFileType | DELETE | カタログ削除時 |
| ページ参照解除 | tblPage | UPDATE | iCatalogID=null |

### テーブル別操作詳細

#### tblCatalog

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | iId=指定値 | カタログ情報取得 |
| INSERT | sName, sItemName, bOnline, etc. | フォーム入力値 | 新規作成、dCreatedTS=now() |
| UPDATE | sName, sItemName, bOnline, etc. | フォーム入力値 | 更新、dUpdatedTS=now() |
| DELETE | - | iId=指定値 | カタログ削除 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| err_mandatory | バリデーションエラー | 必須項目未入力 | エラーメッセージ表示 |
| CSRF_ERROR | セキュリティエラー | CSRFトークン不一致 | 処理中止 |
| ACCESS_DENIED | 権限エラー | bCatalog権限なし | アクセス拒否画面へ遷移 |

### リトライ仕様

特になし（ユーザー操作による再実行）

## トランザクション仕様

カタログ削除時は関連テーブルの削除が連続実行されるが、明示的なトランザクション制御は行われていない。

## パフォーマンス要件

- カタログ編集画面表示：1秒以内
- 保存処理：1秒以内

## セキュリティ考慮事項

- CSRF対策：checkCSRF()関数、QS_secCodeHiddenによるトークン検証
- 認証・認可：logon.hasaccess による権限チェック
- ID暗号化：encrypt/decrypt関数によるID値の保護
- XSS対策：quotRep、sanitize関数による出力エスケープ

## 備考

RSSビューテンプレートでは、{ITEMTITLE}、{ITEMDATE}、{ITEMPICTURE}、{ITEMENCID}、{フィールド名}などのプレースホルダーが使用可能。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

カタログのデータモデルを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | catalog.asp | `asp/includes/catalog.asp` | cls_catalogクラスのプロパティ・メソッドを理解する |

**主要プロパティ（2-7行目）**:
- iId, sName, sItemName, sOrderItemsBy, iCustomerID, bOnline
- iPageSize, bAutoThumb, iMaxThumbSize, sResizePicTo, bUseShadow
- sRSSView1, sRSSView2, sRSSView3, sItemView
- iFormID, sFormTitle, sFilePath

#### Step 2: エントリーポイントを理解する

編集画面の処理起点を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_catalogEdit.asp | `asp/bs_catalogEdit.asp` | カタログ編集画面のメイン処理 |

**主要処理フロー**:
1. **4行目**: 権限チェック（secondAdmin.bCatalog）
2. **5行目**: cls_catalogオブジェクトの生成
3. **6-10行目**: POSTバック処理
4. **11-20行目**: ボタンアクション（save/delete）による分岐処理
5. **28行目以降**: 編集フォームのHTML生成

#### Step 3: 保存・削除処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | catalog.asp | `asp/includes/catalog.asp` | save、check、remove関数の実装 |

**主要処理フロー**:
- **84-99行目**: check関数でのバリデーション
- **101-149行目**: save関数でのDB保存処理
- **201-227行目**: remove関数での削除処理（関連データも削除）

### プログラム呼び出し階層図

```
bs_catalogEdit.asp (カタログ編集画面)
    │
    ├─ cls_catalog.pick()
    │      └─ tblCatalog SELECT
    │
    ├─ cls_catalog.getRequestValues()
    │      └─ Request.Formからの値取得
    │
    ├─ cls_catalog.save()
    │      ├─ check() - バリデーション
    │      ├─ db.GetDynamicRS - INSERT/UPDATE
    │      └─ clearRSSCache() - キャッシュクリア
    │
    └─ cls_catalog.remove()
           ├─ items削除ループ
           ├─ fields削除ループ
           ├─ fileTypes削除ループ
           └─ db.execute() - DELETE処理
```

### データフロー図

```
[入力]                    [処理]                         [出力]

URLパラメータ ──────▶ bs_catalogEdit.asp ───────▶ 編集フォームHTML
(iCatalogID)             │
                         └─ cls_catalog.pick()
                                └─ tblCatalog SELECT

POSTデータ ────────▶ bs_catalogEdit.asp ───────▶ tblCatalog
(カタログ設定)           │                              (INSERT/UPDATE)
                         ├─ cls_catalog.save()
                         │      └─ clearRSSCache()
                         │
                         └─ Response.Redirect
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_catalogEdit.asp | `asp/bs_catalogEdit.asp` | ソース | カタログ編集画面 |
| catalog.asp | `asp/includes/catalog.asp` | ソース | Catalogクラス定義 |
| bs_catalogList.asp | `asp/bs_catalogList.asp` | ソース | カタログ一覧画面 |
| bs_backCatalog.asp | `asp/bs_backCatalog.asp` | テンプレート | 戻るリンク表示 |
| catalogOrderBYList.asp | `asp/includes/catalogOrderBYList.asp` | ソース | ソート順選択リスト |
