# 機能設計書 47-カタログフィールド管理

## 概要

本ドキュメントは、QuickerSite CMSにおけるカタログフィールド管理機能の設計仕様を定義する。この機能は、カタログ項目のカスタムフィールドを定義・編集・削除する機能である。

### 本機能の処理概要

**業務上の目的・背景**：
商品カタログでは、商品ごとに異なる属性（価格、サイズ、色、仕様等）を柔軟に定義する必要がある。本機能により、管理者はカタログごとに独自のフィールド（入力項目）を定義し、商品情報のカスタマイズ性を実現できる。

**機能の利用シーン**：
- カタログに新しい入力項目を追加する場面
- 既存フィールドの設定を変更する場面
- フィールドの公開/非公開を切り替える場面
- 不要になったフィールドを削除する場面
- フィールドを検索対象に含めるか設定する場面

**主要な処理内容**：
1. カタログフィールドの新規作成（INSERT）
2. カタログフィールドの編集（UPDATE）
3. カタログフィールドの削除（DELETE）
4. フィールドタイプの選択（テキスト、選択肢、日付、チェックボックス等）
5. フィールドの必須/任意設定
6. フィールドの公開/非公開設定
7. フィールドの検索対象設定

**関連システム・外部連携**：
- カタログ一覧機能（機能45）への遷移
- カタログアイテム管理機能（機能48）との連携（フィールド値の入力）

**権限による制御**：
- `secondAdmin.bCatalog`権限を持つ管理者のみがアクセス可能

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 36 | カタログフィールド編集 | 主画面 | カタログ項目のカスタムフィールド定義 |
| 34 | カタログ一覧 | 参照元/遷移先画面 | 登録済みカタログの一覧表示 |

## 機能種別

CRUD操作（カタログフィールドの作成・読取・更新・削除）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| iFieldID | String(暗号化) | No | 対象フィールドのID（編集時） | 復号化後に数値であること |
| iCatalogID | String(暗号化) | Yes | 対象カタログのID | 復号化後に数値であること |
| sName | String | Yes | フィールド名 | 空文字不可 |
| sType | String | Yes | フィールドタイプ | 定義済みタイプのみ |
| sValues | String | No | 選択肢の値（セレクト用） | 改行区切り、セレクトタイプ時必須 |
| bMandatory | Boolean | No | 必須フラグ | true/false |
| bPublic | Boolean | No | 公開フラグ | true/false |
| bSearchField | Boolean | No | 検索対象フラグ | true/false |
| btnaction | String | No | 実行アクション | 保存/削除 |

### 入力データソース

- 画面フォームからのPOSTリクエスト
- URLパラメータ（暗号化されたID）
- データベース（tblCatalogField）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| フィールド編集フォーム | HTML | フィールド設定の入力フォーム |
| カタログ名 | String | 対象カタログの名称 |
| フィールドタイプ選択 | HTML | タイプ選択ドロップダウン |

### 出力先

- 管理画面（HTML形式でブラウザに表示）
- データベース（tblCatalogFieldテーブル）

## 処理フロー

### 処理シーケンス

```
1. 認証・権限チェック
   └─ secondAdmin.bCatalog権限の確認

2. リクエストパラメータ取得
   └─ iFieldID、iCatalogIDの取得・復号化

3. POSTバック判定
   └─ postBack=trueの場合、フォーム値を取得

4. アクション判定
   └─ save: フィールドの保存処理
   └─ delete: フィールドの削除処理

5. CSRF検証（アクション実行時）
   └─ checkCSRF()関数による検証

6. バリデーション
   └─ catalogField.check()関数による入力検証

7. 保存/削除処理
   ├─ 保存: catalogField.save()
   └─ 削除: catalogField.remove()

8. リダイレクト/画面表示
   └─ 成功時: カタログ一覧へリダイレクト
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{認証・権限チェック}
    B -->|権限なし| C[アクセス拒否]
    B -->|権限あり| D[パラメータ取得]
    D --> E{POSTバック?}
    E -->|Yes| F[フォーム値取得]
    E -->|No| G[既存データ取得]
    F --> H{アクション判定}
    G --> I[編集フォーム表示]
    H -->|save| J[CSRF検証]
    H -->|delete| J
    J --> K{バリデーション}
    K -->|OK| L{保存 or 削除?}
    K -->|NG| I
    L -->|保存| M[catalogField.save]
    L -->|削除| N[catalogField.remove]
    M --> O[カタログ一覧へリダイレクト]
    N --> O
    I --> P[終了]
    O --> P
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-47-01 | フィールド名必須 | フィールド名は必ず入力が必要 | 保存時 |
| BR-47-02 | タイプ必須 | フィールドタイプは必ず選択が必要 | 保存時 |
| BR-47-03 | 選択肢必須条件 | セレクトタイプ選択時は選択肢値が必須 | sType=sb_select時 |
| BR-47-04 | 表示順自動採番 | 新規作成時は既存フィールド数+1を自動設定 | 新規作成時 |
| BR-47-05 | 削除時の関連データ削除 | フィールド削除時は関連するアイテムフィールド値も削除 | 削除時 |
| BR-47-06 | 表示順再計算 | フィールド削除時は残りのフィールドの表示順を再計算 | 削除時 |
| BR-47-07 | 最後のフィールド削除不可 | カタログに1件以上のフィールドが必要 | 削除時 |

### 計算ロジック

表示順の自動採番ロジック：
- 新規作成時: `SELECT COUNT(*) FROM tblCatalogField WHERE iCatalogID=指定値` + 1

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| フィールド取得 | tblCatalogField | SELECT | 指定IDのフィールド情報 |
| フィールド新規作成 | tblCatalogField | INSERT | 新規レコード追加 |
| フィールド更新 | tblCatalogField | UPDATE | 既存レコード更新 |
| フィールド削除 | tblCatalogField | DELETE | レコード削除 |
| アイテムフィールド値削除 | tbCatalogItemFields | DELETE | フィールド削除時 |
| 表示順再計算 | tblCatalogField | UPDATE | フィールド削除時 |
| 新規アイテムフィールド追加 | tbCatalogItemFields | INSERT | 新規フィールド作成時 |

### テーブル別操作詳細

#### tblCatalogField

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | iId=指定値 | フィールド情報取得 |
| INSERT | sName, sType, sValues, iRang, bMandatory, bSearchField, bPublic | フォーム入力値 | 新規作成 |
| UPDATE | sName, sType, sValues, bMandatory, bSearchField, bPublic | フォーム入力値 | 更新 |
| DELETE | - | iId=指定値 | フィールド削除 |

#### tbCatalogItemFields

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | - | iFieldId=指定値 | フィールド削除時 |
| INSERT | iItemID, iFieldID, sValue | 新規フィールド用 | 新規フィールド作成時 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| err_mandatory | バリデーションエラー | 必須項目未入力 | エラーメッセージ表示 |
| CSRF_ERROR | セキュリティエラー | CSRFトークン不一致 | 処理中止 |
| ACCESS_DENIED | 権限エラー | bCatalog権限なし | アクセス拒否画面へ遷移 |

### リトライ仕様

特になし（ユーザー操作による再実行）

## トランザクション仕様

フィールド削除時は関連テーブルの削除・更新が連続実行されるが、明示的なトランザクション制御は行われていない。

## パフォーマンス要件

- フィールド編集画面表示：1秒以内
- 保存処理：1秒以内

## セキュリティ考慮事項

- CSRF対策：checkCSRF()関数、QS_secCodeHiddenによるトークン検証
- 認証・認可：logon.hasaccess による権限チェック
- ID暗号化：encrypt/decrypt関数によるID値の保護
- XSS対策：quotRep関数による出力エスケープ

## 備考

フィールドタイプ一覧（sb_定数）：
- sb_text: テキスト
- sb_textarea: テキストエリア
- sb_date: 日付
- sb_checkbox: チェックボックス
- sb_select: ドロップダウン
- sb_url: URL
- sb_email: メールアドレス
- sb_richtext: リッチテキスト

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

カタログフィールドのデータモデルを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | catalogField.asp | `asp/includes/catalogField.asp` | cls_catalogFieldクラスのプロパティ・メソッドを理解する |

**主要プロパティ（2-10行目）**:
- iId, iCatalogID, sName, sType, sValues, iRang
- bMandatory, bSearchField, bPublic

**読解のコツ**:
- 12-21行目: Class_Initialize（初期化処理）
- 41-55行目: check関数（バリデーション）
- 56-103行目: save関数（保存処理）
- 158-168行目: remove関数（削除処理）

#### Step 2: エントリーポイントを理解する

編集画面の処理起点を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_catalogFieldEdit.asp | `asp/bs_catalogFieldEdit.asp` | フィールド編集画面のメイン処理 |

**主要処理フロー**:
1. **4行目**: 権限チェック（secondAdmin.bCatalog）
2. **5行目**: cls_catalogFieldオブジェクトの生成
3. **6-10行目**: POSTバック処理
4. **11-19行目**: ボタンアクション（save/delete）による分岐処理
5. **21行目以降**: 編集フォームのHTML生成

### プログラム呼び出し階層図

```
bs_catalogFieldEdit.asp (フィールド編集画面)
    │
    ├─ cls_catalogField.pick()
    │      └─ tblCatalogField SELECT
    │
    ├─ cls_catalogField.getRequestValues()
    │      └─ Request.Formからの値取得
    │
    ├─ cls_catalogField.save()
    │      ├─ check() - バリデーション
    │      ├─ db.GetDynamicRS - INSERT/UPDATE
    │      └─ 新規アイテムフィールド追加
    │
    └─ cls_catalogField.remove()
           ├─ iRang再計算 UPDATE
           ├─ tbCatalogItemFields DELETE
           └─ tblCatalogField DELETE
```

### データフロー図

```
[入力]                    [処理]                         [出力]

URLパラメータ ──────▶ bs_catalogFieldEdit.asp ──▶ 編集フォームHTML
(iFieldID, iCatalogID)   │
                         └─ cls_catalogField.pick()
                                └─ tblCatalogField SELECT

POSTデータ ────────▶ bs_catalogFieldEdit.asp ──▶ tblCatalogField
(フィールド設定)         │                              (INSERT/UPDATE)
                         ├─ cls_catalogField.save()
                         │
                         └─ Response.Redirect
                                └─ bs_catalogList.asp
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_catalogFieldEdit.asp | `asp/bs_catalogFieldEdit.asp` | ソース | フィールド編集画面 |
| catalogField.asp | `asp/includes/catalogField.asp` | ソース | CatalogFieldクラス定義 |
| bs_catalogList.asp | `asp/bs_catalogList.asp` | ソース | カタログ一覧画面 |
| fixedFieldTypeList.asp | `asp/includes/fixedFieldTypeList.asp` | ソース | フィールドタイプ選択リスト |
| bs_backCatalog.asp | `asp/bs_backCatalog.asp` | テンプレート | 戻るリンク表示 |
