# 機能設計書 48-カタログアイテム管理

## 概要

本ドキュメントは、QuickerSite CMSにおけるカタログアイテム管理機能の設計仕様を定義する。この機能は、カタログ内の個別商品・アイテムの追加・編集・削除を行う機能である。

### 本機能の処理概要

**業務上の目的・背景**：
商品カタログの各商品（アイテム）情報を登録・管理する必要がある。本機能により、管理者はカタログに定義されたフィールドに従って商品情報を入力し、画像やファイルを添付して、商品ページの元データを作成・管理できる。

**機能の利用シーン**：
- 新規商品を登録する場面
- 既存商品の情報を更新する場面
- 商品画像をアップロード・削除する場面
- 商品にファイルを添付する場面
- 商品の公開期間を設定する場面
- 不要になった商品を削除する場面

**主要な処理内容**：
1. カタログアイテムの新規作成（INSERT）
2. カタログアイテムの編集（UPDATE）
3. カタログアイテムの削除（DELETE）
4. アイテム画像のアップロード・削除
5. アイテムファイルの添付・削除
6. 公開期間（オンライン開始日・終了日）の設定
7. フォーム連携の有効/無効設定

**関連システム・外部連携**：
- カタログアイテム検索機能（機能49）への遷移
- カタログアイテム画像アップロード機能（機能51）との連携
- カタログアイテムファイルアップロード機能（機能52）との連携
- フォーム機能との連携（アイテムへのお問い合わせ）

**権限による制御**：
- `secondAdmin.bCatalog`権限を持つ管理者のみがアクセス可能

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 38 | カタログアイテム編集 | 主画面 | カタログ内の個別アイテム追加・編集 |
| 39 | カタログアイテム検索 | 参照元/遷移先画面 | カタログ内アイテムの検索・絞り込み |
| 41 | カタログアイテム画像 | 遷移先画面 | カタログアイテムへの画像管理 |
| 40 | カタログアイテムファイル | 遷移先画面 | カタログアイテムへのファイル添付管理 |

## 機能種別

CRUD操作（カタログアイテムの作成・読取・更新・削除）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| iItemID | String(暗号化) | No | 対象アイテムのID（編集時） | 復号化後に数値であること |
| iCatalogID | String(暗号化) | Yes | 対象カタログのID | 復号化後に数値であること |
| sTitle | String | Yes | アイテムタイトル | 空文字不可、250文字以内 |
| dDate | Date | No | アイテム日付 | 日付形式 |
| dOnlineFrom | Date | No | 公開開始日 | 日付形式 |
| dOnlineUntill | Date | No | 公開終了日 | 日付形式 |
| bForm | Boolean | No | フォーム使用フラグ | true/false |
| フィールド値（動的） | 各種 | 各フィールドの定義による | カタログフィールドの値 | 各フィールドの設定による |
| btnaction | String | No | 実行アクション | 保存/削除/画像アップロード/添付アップロード/画像削除 |
| iFileID | String(暗号化) | No | 削除対象ファイルのID | 復号化後に数値であること |

### 入力データソース

- 画面フォームからのPOSTリクエスト
- URLパラメータ（暗号化されたID）
- データベース（tblCatalogItem、tbCatalogItemFields）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| アイテム編集フォーム | HTML | アイテム情報の入力フォーム |
| カタログ名 | String | 対象カタログの名称 |
| 動的フィールド | HTML | カタログに定義されたフィールドの入力欄 |
| 添付ファイル一覧 | HTML | アイテムに添付されたファイルのリスト |
| 画像プレビュー | HTML | アイテム画像のプレビュー |

### 出力先

- 管理画面（HTML形式でブラウザに表示）
- データベース（tblCatalogItem、tbCatalogItemFieldsテーブル）

## 処理フロー

### 処理シーケンス

```
1. 認証・権限チェック
   └─ secondAdmin.bCatalog権限の確認

2. リクエストパラメータ取得
   └─ iItemID、iCatalogID、iFileIDの取得・復号化

3. ファイル削除チェック
   └─ iFileIDがある場合はファイル削除処理

4. POSTバック判定
   └─ postBack=trueの場合、フォーム値を取得

5. アクション判定
   ├─ save: アイテムの保存処理
   ├─ delete: アイテムの削除処理
   ├─ uploadattachment: ファイルアップロード画面へ
   ├─ uploadpic: 画像アップロード画面へ
   └─ deletepic: 画像削除処理

6. CSRF検証（アクション実行時）
   └─ checkCSRF()関数による検証

7. バリデーション
   └─ catalogItem.check()関数による入力検証

8. 保存/削除処理
   ├─ 保存: catalogItem.save()
   └─ 削除: catalogItem.remove()

9. リダイレクト/画面表示
   └─ 成功時: リダイレクト、失敗時: エラー表示
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{認証・権限チェック}
    B -->|権限なし| C[アクセス拒否]
    B -->|権限あり| D[パラメータ取得]
    D --> E{ファイル削除?}
    E -->|Yes| F[ファイル削除処理]
    E -->|No| G{POSTバック?}
    F --> G
    G -->|Yes| H[フォーム値取得]
    G -->|No| I[既存データ取得]
    H --> J{アクション判定}
    I --> K[編集フォーム表示]
    J -->|save| L[CSRF検証・バリデーション]
    J -->|delete| L
    J -->|uploadattachment| M[ファイルアップロード画面へ]
    J -->|uploadpic| N[画像アップロード画面へ]
    J -->|deletepic| O[画像削除処理]
    L --> P{検証OK?}
    P -->|OK| Q[保存/削除実行]
    P -->|NG| K
    Q --> R[リダイレクト]
    O --> K
    K --> S[終了]
    R --> S
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-48-01 | タイトル必須 | アイテムタイトルは必ず入力が必要 | 保存時 |
| BR-48-02 | 必須フィールド検証 | カタログフィールドで必須設定されたフィールドは入力必須 | 保存時 |
| BR-48-03 | 削除時の関連データ削除 | アイテム削除時は画像・ファイル・フィールド値・送信データも削除 | 削除時 |
| BR-48-04 | RSSキャッシュクリア | 保存・削除時にRSSキャッシュをクリア | 保存・削除時 |
| BR-48-05 | タイトル文字数制限 | タイトルは255文字以内 | 保存時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| アイテム取得 | tblCatalogItem | SELECT | 指定IDのアイテム情報 |
| フィールド値取得 | tbCatalogItemFields | SELECT | アイテムIDでフィルタ |
| アイテム新規作成 | tblCatalogItem | INSERT | 新規レコード追加 |
| アイテム更新 | tblCatalogItem | UPDATE | 既存レコード更新 |
| フィールド値保存 | tbCatalogItemFields | DELETE/INSERT | 全削除後に再挿入 |
| アイテム削除 | tblCatalogItem | DELETE | レコード削除 |
| フィールド値削除 | tbCatalogItemFields | DELETE | アイテム削除時 |
| 添付ファイル削除 | tblCatalogItemFiles | DELETE | アイテム削除時 |

### テーブル別操作詳細

#### tblCatalogItem

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | iId=指定値 | アイテム情報取得 |
| INSERT | sTitle, iCatalogID, dDate, dOnlineFrom, dOnlineUntill, bForm, sPicExt | フォーム入力値 | 新規作成、dCreatedTS=now() |
| UPDATE | sTitle, dDate, dOnlineFrom, dOnlineUntill, bForm, sPicExt | フォーム入力値 | 更新、dUpdatedTS=now() |
| DELETE | - | iId=指定値 | アイテム削除 |

#### tbCatalogItemFields

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | iFieldId, sValue | iItemID=指定値 | フィールド値取得 |
| DELETE | - | iItemID=指定値 | 保存前に全削除 |
| INSERT | iItemID, iFieldID, sValue | 各フィールドの値 | 保存時に再挿入 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| err_mandatory | バリデーションエラー | 必須項目未入力 | エラーメッセージ表示 |
| CSRF_ERROR | セキュリティエラー | CSRFトークン不一致 | 処理中止 |
| ACCESS_DENIED | 権限エラー | bCatalog権限なし | アクセス拒否画面へ遷移 |

### リトライ仕様

特になし（ユーザー操作による再実行）

## トランザクション仕様

アイテム保存時はフィールド値の全削除→再挿入が連続実行されるが、明示的なトランザクション制御は行われていない。

## パフォーマンス要件

- アイテム編集画面表示：1秒以内
- 保存処理：1秒以内

## セキュリティ考慮事項

- CSRF対策：checkCSRF()関数、QS_secCodeHiddenによるトークン検証
- 認証・認可：logon.hasaccess による権限チェック
- ID暗号化：encrypt/decrypt関数によるID値の保護
- XSS対策：quotRep、sanitize関数による出力エスケープ

## 備考

フィールド値の保存は「全削除→再挿入」方式を採用している。これにより、フィールドの追加・削除に対応できるが、大量データ時のパフォーマンスに注意が必要。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

カタログアイテムのデータモデルを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | catalogItem.asp | `asp/includes/catalogItem.asp` | cls_catalogItemクラスのプロパティ・メソッドを理解する |

**主要プロパティ（3行目）**:
- iId, sTitle, dUpdatedTS, dCreatedTS, fields, iCatalogID
- dOnlineUntill, dOnlineFrom, dDate, sPicExt, bForm

**読解のコツ**:
- 50-79行目: pick関数（データ取得）
- 80-99行目: check関数（バリデーション）
- 100-148行目: save関数（保存処理）
- 175-194行目: remove関数（削除処理）

#### Step 2: エントリーポイントを理解する

編集画面の処理起点を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_catalogItemEdit.asp | `asp/bs_catalogItemEdit.asp` | アイテム編集画面のメイン処理 |

**主要処理フロー**:
1. **4行目**: 権限チェック（secondAdmin.bCatalog）
2. **5行目**: cls_catalogItemオブジェクトの生成
3. **11-14行目**: ファイル削除処理
4. **15-43行目**: ボタンアクションによる分岐処理
5. **44-50行目**: カタログフィールドとファイルタイプの取得
6. **51行目以降**: 編集フォームのHTML生成

### プログラム呼び出し階層図

```
bs_catalogItemEdit.asp (アイテム編集画面)
    │
    ├─ cls_catalogItem.pick()
    │      ├─ tblCatalogItem SELECT
    │      └─ tbCatalogItemFields SELECT
    │
    ├─ cls_catalogItem.getRequestValues()
    │      └─ Request.Formからの値取得
    │
    ├─ cls_catalogItem.save()
    │      ├─ check() - バリデーション
    │      ├─ tblCatalogItem INSERT/UPDATE
    │      ├─ tbCatalogItemFields DELETE
    │      ├─ tbCatalogItemFields INSERT
    │      └─ catalog.clearRSSCache()
    │
    ├─ cls_catalogItem.remove()
    │      ├─ removePic() - 画像削除
    │      ├─ files削除ループ
    │      ├─ submissions削除ループ
    │      ├─ tbCatalogItemFields DELETE
    │      └─ tblCatalogItem DELETE
    │
    └─ cls_catalogItem.removeFile()
           └─ cls_catalogItemFile.remove()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

URLパラメータ ──────▶ bs_catalogItemEdit.asp ──▶ 編集フォームHTML
(iItemID, iCatalogID)    │
                         ├─ cls_catalogItem.pick()
                         │      ├─ tblCatalogItem
                         │      └─ tbCatalogItemFields
                         │
                         └─ catalog.fields
                                └─ tblCatalogField

POSTデータ ────────▶ bs_catalogItemEdit.asp ──▶ tblCatalogItem
(アイテム情報)           │                              tbCatalogItemFields
                         ├─ cls_catalogItem.save()     (DELETE/INSERT)
                         │
                         └─ Response.Redirect
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_catalogItemEdit.asp | `asp/bs_catalogItemEdit.asp` | ソース | アイテム編集画面 |
| catalogItem.asp | `asp/includes/catalogItem.asp` | ソース | CatalogItemクラス定義 |
| catalog.asp | `asp/includes/catalog.asp` | ソース | Catalogクラス定義 |
| catalogField.asp | `asp/includes/catalogField.asp` | ソース | CatalogFieldクラス定義 |
| bs_catalogItemSearch.asp | `asp/bs_catalogItemSearch.asp` | ソース | アイテム検索画面 |
| bs_catalogItemPic.asp | `asp/bs_catalogItemPic.asp` | ソース | 画像アップロード画面 |
| bs_catalogItemFile.asp | `asp/bs_catalogItemFile.asp` | ソース | ファイルアップロード画面 |
