# 機能設計書 5-サイト基本設定

## 概要

本ドキュメントは、QuickerSite CMSのサイト基本設定機能について記述する。

### 本機能の処理概要

本機能は、サイトの基本的な情報（サイト名、URL、タイトル、言語、日付フォーマット等）を設定・管理するための機能を提供する。これらの設定はサイト全体に影響を与え、SEO対策やブランディングの基盤となる。

**業務上の目的・背景**：Webサイトの運営において、サイト名やURLなどの基本情報は、検索エンジン最適化（SEO）、ブランド認知、ユーザー体験に直接影響する重要な要素である。本機能により、これらの設定を一元管理できる。

**機能の利用シーン**：
- サイト新規構築時の初期設定
- リブランディングに伴うサイト名変更
- ドメイン変更に伴うURL設定変更
- 多言語サイト構築時の言語設定
- 日付表示形式の地域対応

**主要な処理内容**：
1. サイト名・スローガンの設定
2. サイトURLおよび代替ドメインの設定
3. サイトタイトル・コピーライトの設定
4. META keywords・description の設定
5. サイトヘッダー追加情報の設定
6. RSS URLの設定
7. 言語・日付フォーマットの設定
8. ウェブマスター情報の設定

**関連システム・外部連携**：なし（Google Analytics設定は別機能 No.7）

**権限による制御**：secondAdmin.bSetupGeneral 権限が必要

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 86 | 変数設定 | 主画面 | サイト変数・パラメータの設定 |
| 136 | 顧客詳細 | 参照画面 | クライアント詳細情報の表示 |
| 137 | 顧客編集 | 参照画面 | サイト顧客の編集 |
| 147 | IIS管理 | 参照画面 | IISサーバー設定の管理 |
| 148 | バインディング編集 | 参照画面 | ドメインバインディングの編集 |
| 187 | 初期セットアップ | 参照画面 | サイトの初期セットアップ |

## 機能種別

設定管理 / CRUD操作

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| siteName | String | Yes | サイト名（組織名） | 最大254文字 |
| sSiteSlogan | String | No | サイトスローガン | 最大250文字 |
| sUrl | String | Yes | サイトURL | 7文字以上、http/https/ftpで始まる |
| sAlternateDomains | String | No | 代替ドメイン（改行区切り） | - |
| siteTitle | String | No | サイトタイトル | 最大254文字 |
| copyRight | String | No | コピーライト（META copyright） | 最大254文字 |
| keywords | String | No | キーワード（META keywords） | 最大2048文字 |
| sDescription | String | No | 説明（META description） | - |
| sHeader | String | No | ヘッダー追加情報 | - |
| sDefaultRSSLink | String | No | デフォルトRSS URL | 最大250文字 |
| googleAnalytics | String | No | Google Analytics コード | - |
| sDatumFormat | String | No | 日付フォーマット | リスト選択 |
| language | Integer | No | サイト言語 | リスト選択 |
| webmaster | String | No | ウェブマスター名（META author） | 最大255文字 |
| webmasterEmail | String | No | ウェブマスターメールアドレス | 最大254文字 |

### 入力データソース

- 画面入力（設定フォーム）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| customer.siteName | String | サイト名 |
| customer.siteTitle | String | サイトタイトル |
| customer.sUrl | String | サイトURL |
| customer.language | Integer | 言語コード |
| 他の設定項目 | 各種 | 入力パラメータに対応 |

### 出力先

- データベース（tblCustomer）
- アプリケーションキャッシュ（メニューキャッシュクリア）

## 処理フロー

### 処理シーケンス

```
1. 基本設定画面アクセス
   └─ secondAdmin.bSetupGeneral権限チェック

2. 現在の設定値読み込み
   └─ customer オブジェクトから各値を取得
   └─ 言語リスト、日付フォーマットリストの取得

3. フォーム表示
   └─ 各設定項目をフォームに表示
   └─ メイン管理者のみURL編集可能

4. 保存処理（btnaction="saveAdmin"）
   └─ CSRF検証
   └─ 各フォーム値の取得
   └─ URL整形（http:// 付加、末尾スラッシュ除去）
   └─ customer.save()
   └─ メニューキャッシュクリア
```

### フローチャート

```mermaid
flowchart TD
    A[基本設定画面] --> B{権限チェック}
    B -->|権限なし| C[bs_default.aspへリダイレクト]
    B -->|権限あり| D[現在の設定値読み込み]
    D --> E[フォーム表示]
    E --> F{保存ボタン押下}
    F -->|No| E
    F -->|Yes| G[CSRF検証]
    G --> H[フォーム値取得]
    H --> I[URL整形]
    I --> J{メイン管理者?}
    J -->|Yes| K[URL・代替ドメイン更新]
    J -->|No| L[URL関連スキップ]
    K --> M[customer.save]
    L --> M
    M --> N[メニューキャッシュクリア]
    N --> O[成功メッセージ表示]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | URL形式 | URLは http:// または https:// または ftp:// で始まる必要あり | 常時 |
| BR-02 | URL末尾 | URLの末尾スラッシュは自動的に除去される | 常時 |
| BR-03 | URL小文字化 | URLは小文字に変換される | 常時 |
| BR-04 | URL編集権限 | URLと代替ドメインはメイン管理者のみ編集可能 | セカンドアドミン時 |
| BR-05 | 代替ドメイン自動設定 | 新規作成時、www有無の代替ドメインを自動設定 | 新規作成時 |

### 計算ロジック

- URL整形: `trim(lcase(sURL))` + 末尾スラッシュ除去

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 設定読み込み | tblCustomer | SELECT | 現在の設定値取得 |
| 設定保存 | tblCustomer | UPDATE | 設定値更新 |

### テーブル別操作詳細

#### tblCustomer

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | iId = cId | 全カラム取得 |
| UPDATE | siteName | 入力値 | サイト名 |
| UPDATE | siteTitle | 入力値 | サイトタイトル |
| UPDATE | sUrl | 整形後の入力値 | URL |
| UPDATE | language | 選択値 | 言語コード |
| UPDATE | sDatumFormat | 選択値 | 日付フォーマット |
| UPDATE | 他多数 | 各入力値 | 各設定項目 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| err_mandatory | 入力エラー | 必須項目（siteName）が空 | 再入力を促す |
| err_url | 入力エラー | URLが7文字以下 | 正しいURLを入力 |

### リトライ仕様

- エラー時は同一画面で再入力可能

## トランザクション仕様

- 保存処理: 単一UPDATEで完結

## パフォーマンス要件

- 設定保存: 即座に完了
- メニューキャッシュクリア: 即座に完了

## セキュリティ考慮事項

- CSRF対策トークン検証
- secondAdmin.bSetupGeneral 権限チェック
- URL編集はメイン管理者のみに制限

## 備考

- Google Analytics設定は同一画面に含まれるが、機能としては別機能（No.7）として扱う
- SEO関連設定（META keywords、description）は同一画面だが、機能としては別機能（No.6）として扱う

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

サイト設定のデータ構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | customer.asp | `asp/includes/customer.asp` | cls_customerクラスのプロパティ定義（2-19行目） |

**読解のコツ**: cls_customerクラスは多くのプロパティを持つ。siteName、siteTitle、sUrl、language などが基本設定に関連する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_admin.asp | `asp/bs_admin.asp` | 基本設定画面のメインファイル（11行） |

**主要処理フロー**:
1. **4行目**: secondAdmin.bSetupGeneral 権限チェック
2. **4-7行目**: 言語リスト、日付フォーマットリストの取得
3. **10行目**: フォーム表示（各設定項目）

#### Step 3: 処理ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_process.asp | `asp/bs_process.asp` | saveAdmin処理 |

**主要処理フロー**:
- **103-126行目**: saveAdmin処理
- **105-108行目**: メイン管理者のみURL関連を更新
- **109-121行目**: 各設定値の取得
- **122-126行目**: save()とキャッシュクリア

### プログラム呼び出し階層図

```
bs_admin.asp
    │
    ├─ begin.asp（インクルード）
    │      └─ includes/customer.asp（cls_customerクラス）
    │
    ├─ bs_security.asp（認証・権限チェック）
    │
    ├─ bs_process.asp（処理分岐）
    │      │
    │      └─ btnaction = "saveAdmin"
    │             ├─ 各フォーム値取得
    │             ├─ customer.save()
    │             └─ clearMenuCache()
    │
    ├─ cls_languageListNew（言語リスト）
    │
    ├─ cls_dateFormatList（日付フォーマットリスト）
    │
    └─ フォーム表示
```

### データフロー図

```
[入力]               [処理]                    [出力]

フォーム入力 ────▶ Request.Form取得
                         │
                         ▼
                    URL整形処理
                    (小文字化・スラッシュ除去)
                         │
                         ▼
                    customer.save()
                         │
                    ┌────┴────┐
                    ▼         ▼
            tblCustomer   clearMenuCache()
            (UPDATE)      (キャッシュクリア)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_admin.asp | `asp/bs_admin.asp` | ソース | 基本設定画面メインファイル |
| bs_process.asp | `asp/bs_process.asp` | ソース | 処理分岐ロジック（saveAdmin） |
| customer.asp | `asp/includes/customer.asp` | ソース | cls_customerクラス定義 |
| languageList.asp | `asp/includes/languageList.asp` | ソース | 言語リスト定義 |
| dateFormatList.asp | `asp/includes/dateFormatList.asp` | ソース | 日付フォーマットリスト定義 |
| bs_security.asp | `asp/bs_security.asp` | ソース | 認証・権限チェック |
