# 機能設計書 50-カタログファイルタイプ管理

## 概要

本ドキュメントは、QuickerSite CMSにおけるカタログファイルタイプ管理機能の設計仕様を定義する。この機能は、カタログアイテムに添付可能なファイルのカテゴリ（タイプ）を定義・編集・削除する機能である。

### 本機能の処理概要

**業務上の目的・背景**：
商品カタログでは、商品ごとに複数の関連ファイル（仕様書、マニュアル、カタログPDF等）を添付することがある。本機能により、管理者はカタログごとにファイルの種類（カテゴリ）を定義し、アイテムへのファイル添付を体系的に管理できる。

**機能の利用シーン**：
- カタログに新しいファイルカテゴリを追加する場面
- 既存ファイルタイプの名称を変更する場面
- 不要になったファイルタイプを削除する場面

**主要な処理内容**：
1. カタログファイルタイプの新規作成（INSERT）
2. カタログファイルタイプの編集（UPDATE）
3. カタログファイルタイプの削除（DELETE）
4. 関連ファイルの連動削除

**関連システム・外部連携**：
- カタログ一覧機能（機能45）への遷移
- カタログアイテム管理機能（機能48）との連携（ファイル添付時のタイプ選択）

**権限による制御**：
- `secondAdmin.bCatalog`権限を持つ管理者のみがアクセス可能

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 37 | カタログファイルタイプ編集 | 主画面 | ファイルタイプの作成・編集・削除 |
| 34 | カタログ一覧 | 参照元/遷移先画面 | 登録済みカタログの一覧表示 |

## 機能種別

CRUD操作（カタログファイルタイプの作成・読取・更新・削除）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| iFileTypeID | String(暗号化) | No | 対象ファイルタイプのID（編集時） | 復号化後に数値であること |
| iCatalogID | String(暗号化) | Yes | 対象カタログのID | 復号化後に数値であること |
| sName | String | Yes | ファイルタイプ名 | 空文字不可 |
| btnaction | String | No | 実行アクション | 保存/削除 |

### 入力データソース

- 画面フォームからのPOSTリクエスト
- URLパラメータ（暗号化されたID）
- データベース（tblCatalogFileType）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| ファイルタイプ編集フォーム | HTML | タイプ名入力フォーム |
| カタログ名 | String | 対象カタログの名称 |

### 出力先

- 管理画面（HTML形式でブラウザに表示）
- データベース（tblCatalogFileTypeテーブル）

## 処理フロー

### 処理シーケンス

```
1. 認証・権限チェック
   └─ secondAdmin.bCatalog権限の確認

2. cls_catalogFileTypeオブジェクト生成
   └─ iFileTypeID、iCatalogIDの取得・復号化
   └─ 既存データがあればpick()で読み込み

3. アクション判定
   └─ save: ファイルタイプの保存処理
   └─ delete: ファイルタイプの削除処理

4. CSRF検証（アクション実行時）
   └─ checkCSRF()関数による検証

5. バリデーション
   └─ catalogFileType.check()関数による入力検証

6. 保存/削除処理
   ├─ 保存: catalogFileType.save()
   └─ 削除: catalogFileType.remove()

7. リダイレクト/画面表示
   └─ 成功時: カタログ一覧へリダイレクト
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{認証・権限チェック}
    B -->|権限なし| C[アクセス拒否]
    B -->|権限あり| D[cls_catalogFileType生成]
    D --> E{アクション判定}
    E -->|save| F[CSRF検証]
    E -->|delete| F
    E -->|なし| G[編集フォーム表示]
    F --> H[getRequestValues]
    H --> I{バリデーション}
    I -->|OK| J{保存 or 削除?}
    I -->|NG| G
    J -->|保存| K[catalogFileType.save]
    J -->|削除| L[catalogFileType.remove]
    K --> M[カタログ一覧へリダイレクト]
    L --> M
    G --> N[終了]
    M --> N
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-50-01 | タイプ名必須 | ファイルタイプ名は必ず入力が必要 | 保存時 |
| BR-50-02 | 関連ファイル削除 | タイプ削除時は関連アイテムファイルも削除 | 削除時 |
| BR-50-03 | カタログ紐付け | ファイルタイプは特定のカタログに紐付く | 作成時 |

### 計算ロジック

特になし（単純なマスタ管理）

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| タイプ取得 | tblCatalogFileType | SELECT | 指定IDのタイプ情報 |
| タイプ新規作成 | tblCatalogFileType | INSERT | 新規レコード追加 |
| タイプ更新 | tblCatalogFileType | UPDATE | 既存レコード更新 |
| タイプ削除 | tblCatalogFileType | DELETE | レコード削除 |
| 関連ファイル削除 | tblCatalogItemFiles | DELETE | タイプ削除時 |

### テーブル別操作詳細

#### tblCatalogFileType

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | iId=指定値 | タイプ情報取得 |
| INSERT | iCatalogID, sName | フォーム入力値 | 新規作成 |
| UPDATE | sName | フォーム入力値 | 更新 |
| DELETE | - | iId=指定値 | タイプ削除 |

#### tblCatalogItemFiles

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | - | iFileTypeID=指定値 | タイプ削除時の連動削除 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| err_mandatory | バリデーションエラー | タイプ名未入力 | エラーメッセージ表示 |
| CSRF_ERROR | セキュリティエラー | CSRFトークン不一致 | 処理中止 |
| ACCESS_DENIED | 権限エラー | bCatalog権限なし | アクセス拒否画面へ遷移 |

### リトライ仕様

特になし（ユーザー操作による再実行）

## トランザクション仕様

ファイルタイプ削除時は関連ファイルの削除が先に実行されるが、明示的なトランザクション制御は行われていない。

## パフォーマンス要件

- 編集画面表示：1秒以内
- 保存処理：1秒以内

## セキュリティ考慮事項

- CSRF対策：checkCSRF()関数、QS_secCodeHiddenによるトークン検証
- 認証・認可：logon.hasaccess による権限チェック
- ID暗号化：encrypt/decrypt関数によるID値の保護
- XSS対策：quotRep関数による出力エスケープ
- 削除確認：JavaScript confirm()による誤削除防止

## 備考

ファイルタイプの用途例：
- 「仕様書」: 商品の技術仕様書PDF
- 「マニュアル」: 取扱説明書PDF
- 「カタログ」: 商品カタログPDF
- 「画像」: 追加の商品画像
- 「動画」: 商品紹介動画

カタログコピー時の挙動：
- catalogFileType.copy(catID)メソッドにより、カタログコピー時にファイルタイプ定義も複製される

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

カタログファイルタイプのデータモデルを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | catalogFileType.asp | `asp/includes/catalogFileType.asp` | cls_CatalogFileTypeクラスのプロパティ・メソッドを理解する |

**主要プロパティ（3-5行目）**:
- iId: ファイルタイプID
- sName: ファイルタイプ名
- iCatalogID: 所属カタログID

**読解のコツ**:
- 6-12行目: Class_Initialize（初期化処理、iCatalogID復号化、pick呼び出し）
- 13-25行目: Pick関数（既存データ読み込み）
- 26-32行目: Check関数（バリデーション、sName必須）
- 33-54行目: Save関数（INSERT/UPDATE処理）
- 59-67行目: Remove関数（関連ファイル削除→本体削除）
- 72-78行目: Copy関数（カタログコピー時の複製）

#### Step 2: エントリーポイントを理解する

編集画面の処理起点を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_catalogFileTypeEdit.asp | `asp/bs_catalogFileTypeEdit.asp` | ファイルタイプ編集画面のメイン処理 |

**主要処理フロー**:
1. **4行目**: 権限チェック（secondAdmin.bCatalog）
2. **5行目**: cls_catalogFileTypeオブジェクトの生成
3. **6-14行目**: ボタンアクション（save/delete）による分岐処理
4. **7-10行目**: save処理（CSRF検証→getRequestValues→save→リダイレクト）
5. **11-14行目**: delete処理（CSRF検証→remove→リダイレクト）
6. **15行目以降**: 編集フォームのHTML生成

### プログラム呼び出し階層図

```
bs_catalogFileTypeEdit.asp (ファイルタイプ編集画面)
    │
    ├─ cls_CatalogFileType.new()
    │      ├─ iCatalogID=decrypt(request)
    │      └─ pick(iFileTypeID)
    │             └─ tblCatalogFileType SELECT
    │
    ├─ [save処理]
    │      ├─ checkCSRF()
    │      ├─ cls_CatalogFileType.getRequestValues()
    │      │      └─ sName, iCatalogID取得
    │      └─ cls_CatalogFileType.save()
    │             ├─ check() - バリデーション
    │             └─ db.GetDynamicRS - INSERT/UPDATE
    │
    └─ [delete処理]
           ├─ checkCSRF()
           └─ cls_CatalogFileType.remove()
                  ├─ tblCatalogItemFiles DELETE (関連ファイル)
                  └─ tblCatalogFileType DELETE (本体)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

URLパラメータ ──────▶ bs_catalogFileTypeEdit.asp ──▶ 編集フォームHTML
(iFileTypeID, iCatalogID)   │
                            └─ cls_CatalogFileType.pick()
                                   └─ tblCatalogFileType SELECT

POSTデータ ────────▶ bs_catalogFileTypeEdit.asp ──▶ tblCatalogFileType
(sName)                     │                              (INSERT/UPDATE)
                            ├─ cls_CatalogFileType.save()
                            │
                            └─ Response.Redirect
                                   └─ bs_catalogList.asp

削除リクエスト ────▶ bs_catalogFileTypeEdit.asp ──▶ tblCatalogItemFiles DELETE
                            │                              tblCatalogFileType DELETE
                            └─ cls_CatalogFileType.remove()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_catalogFileTypeEdit.asp | `asp/bs_catalogFileTypeEdit.asp` | ソース | ファイルタイプ編集画面 |
| catalogFileType.asp | `asp/includes/catalogFileType.asp` | ソース | cls_CatalogFileTypeクラス定義 |
| bs_catalogList.asp | `asp/bs_catalogList.asp` | ソース | カタログ一覧画面（遷移先） |
| catalog.asp | `asp/includes/catalog.asp` | ソース | cls_catalogクラス（fileTypes取得） |
| bs_backCatalog.asp | `asp/bs_backCatalog.asp` | テンプレート | 戻るリンク表示 |
