# 機能設計書 51-カタログアイテム画像アップロード

## 概要

本ドキュメントは、QuickerSite CMSにおけるカタログアイテム画像アップロード機能の設計を記載する。カタログ内の個別商品・アイテムに対して画像ファイルを添付するための機能である。

### 本機能の処理概要

カタログアイテム画像アップロード機能は、管理者がカタログに登録された商品やアイテムに対して画像を添付できる機能である。

**業務上の目的・背景**：ECサイトや商品カタログにおいて、商品の視覚的な情報は購買決定に大きな影響を与える。本機能により、管理者は商品画像を簡単にアップロードし、カタログアイテムと関連付けることができる。これにより、商品の魅力を視覚的に伝え、ユーザーエクスペリエンスを向上させることが可能となる。

**機能の利用シーン**：
- 新規商品をカタログに追加した際に、商品画像を設定する場面
- 既存商品の画像を更新・差し替えする場面
- 商品の複数バリエーション（色違い等）の画像を管理する場面

**主要な処理内容**：
1. アップロードされた画像ファイルの受信とサーバーへの保存
2. ファイルタイプ（拡張子）のバリデーション（サムネイル生成可能な画像形式のみ許可）
3. ファイルサイズのバリデーション（5.5MB以下に制限）
4. CSRF対策トークンの検証によるセキュリティ確保
5. カタログアイテムレコードへの画像ファイル名の関連付け更新

**関連システム・外部連携**：特になし（内部処理のみ）

**権限による制御**：セカンドアドミンのカタログ権限（secondAdmin.bCatalog）を持つユーザーのみがアクセス可能

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 41 | カタログアイテム画像 | 主画面 | カタログアイテムへの画像管理 |
| 38 | カタログアイテム編集 | 遷移先画面 | アップロード成功時のリダイレクト先 |

## 機能種別

ファイルアップロード / データ更新（UPDATE操作）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| iItemID | String（暗号化） | Yes | カタログアイテムID | 復号化後に数値チェック |
| QSSEC | String | Yes | CSRFトークン | checkCSRF_Uploadで検証 |
| uploadFile | Binary | Yes | アップロードする画像ファイル | 拡張子・サイズチェック |

### 入力データソース

- 画面入力（multipart/form-data形式のファイルアップロード）
- FreeASPUploadコンポーネントによるファイル受信

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| sPicExt | String | 保存されたファイル名（暗号化ID_パスワード.拡張子形式） |

### 出力先

- ファイルシステム：ユーザーファイルディレクトリ（Application("QS_CMS_userfiles")）
- データベース：tblCatalogItemテーブルのsPicExtカラム

## 処理フロー

### 処理シーケンス

```
1. セキュリティチェック
   └─ セカンドアドミンのカタログ権限を確認

2. ファイルアップロード処理
   └─ FreeASPUploadコンポーネントでファイルを受信
   └─ 一時ディレクトリへ保存

3. CSRFトークン検証
   └─ checkCSRF_Upload関数でトークンを検証

4. カタログアイテム取得
   └─ 暗号化されたiItemIDを復号化
   └─ cls_catalogItemクラスでアイテム情報を取得

5. ファイルバリデーション
   └─ 拡張子チェック（allowedFileTypesforThumbingに含まれるか）
   └─ サイズチェック（5,550,000バイト以下か）

6. ファイル保存処理
   ├─ カタログにファイルパス設定がない場合
   │   └─ 暗号化ID_ランダムパスワード.拡張子形式でリネーム保存
   └─ カタログにファイルパス設定がある場合
       └─ 元のファイル名で指定パスへ移動

7. データベース更新
   └─ カタログアイテムのsPicExtを更新してsave()

8. リダイレクト処理
   ├─ 成功時：bs_catalogItemEdit.aspへリダイレクト
   └─ エラー時：bs_catalogItemPic.aspへエラーメッセージ付きでリダイレクト
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[セキュリティチェック]
    B --> C[ファイルアップロード受信]
    C --> D[CSRFトークン検証]
    D --> E[カタログアイテム取得]
    E --> F{ファイルが存在?}
    F -->|No| G[err_newFile エラー]
    F -->|Yes| H{拡張子チェック}
    H -->|NG| I[err_fileType エラー]
    H -->|OK| J{サイズチェック}
    J -->|NG| K[err_fileSize エラー]
    J -->|OK| L{カタログにパス設定あり?}
    L -->|No| M[暗号化名でリネーム保存]
    L -->|Yes| N[元の名前で移動]
    M --> O[DB更新]
    N --> O
    O --> P[カタログアイテム編集画面へリダイレクト]
    G --> Q[画像画面へエラー付きリダイレクト]
    I --> Q
    K --> Q
    P --> R[終了]
    Q --> R
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-51-001 | ファイルタイプ制限 | サムネイル生成可能な画像形式（jpg, jpeg, png, gif等）のみアップロード可能 | 全アップロード時 |
| BR-51-002 | ファイルサイズ制限 | 5.55MB（5,550,000バイト）以下のファイルのみアップロード可能 | 全アップロード時 |
| BR-51-003 | ファイル名生成 | ファイルパス設定がない場合、暗号化ID_ランダム文字列.拡張子形式で保存 | カタログのsFilePathが空の場合 |

### 計算ロジック

- ファイル名生成：`encrypt(catalogItem.iId) & "_" & GeneratePassWord() & "." & GetFileExtension(FileName)`

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 画像アップロード | tblCatalogItem | UPDATE | sPicExtカラムを更新 |

### テーブル別操作詳細

#### tblCatalogItem

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | sPicExt | アップロードされたファイル名（リネーム後） | 画像ファイルの参照名を保存 |
| UPDATE | dUpdatedTS | now() | 更新日時を記録 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| err_fileType | バリデーションエラー | 許可されていない拡張子のファイルをアップロード | 対応形式（jpg, png, gif等）のファイルを選択 |
| err_fileSize | バリデーションエラー | 5.55MBを超えるファイルをアップロード | ファイルサイズを縮小して再アップロード |
| err_newFile | 入力エラー | ファイルが選択されていない | ファイルを選択してから送信 |

### リトライ仕様

- リトライ機能なし（エラー時はエラーメッセージを表示して再入力を促す）

## トランザクション仕様

- 明示的なトランザクション管理は行われていない
- ファイル保存とDB更新が分離されているため、DB更新失敗時にファイルが残る可能性あり

## パフォーマンス要件

- ファイルサイズ上限：5.55MB
- 大きな画像の場合、アップロード時間はネットワーク帯域に依存

## セキュリティ考慮事項

- CSRFトークン検証（checkCSRF_Upload関数）
- セカンドアドミンのカタログ権限チェック
- ファイルタイプのホワイトリスト方式バリデーション
- ファイル名にランダム文字列を付与して推測困難化

## 備考

- FreeASPUploadコンポーネントを使用してファイルアップロードを処理
- allowedFileTypesforThumbingディクショナリで許可拡張子を管理

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

カタログアイテムのデータ構造と画像管理の仕組みを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | catalogItem.asp | `asp/includes/catalogItem.asp` | cls_catalogItemクラスの構造、sPicExtプロパティの役割 |
| 1-2 | catalog.asp | `asp/includes/catalog.asp` | カタログのsFilePath設定とcorreFPプロパティ |

**読解のコツ**: ASP Classic（VBScript）のクラス定義は`Class cls_クラス名`で始まり、`End Class`で終わる。Publicプロパティがフィールドに相当する。

#### Step 2: エントリーポイントを理解する

アップロード処理の起点となるファイルを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_catalogItemPicUpload.asp | `asp/bs_catalogItemPicUpload.asp` | ファイルアップロード処理の全体フロー |

**主要処理フロー**:
1. **4行目**: セキュリティチェック（logon.hasaccess secondAdmin.bCatalog）
2. **5-8行目**: FreeASPUploadでファイル受信
3. **9行目**: CSRFトークン検証
4. **10-12行目**: カタログアイテム取得
5. **15-44行目**: ファイルバリデーションと保存処理
6. **45-49行目**: リダイレクト処理

#### Step 3: ファイルアップロードライブラリを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | begin.asp | `asp/begin.asp` | FreeASPUploadクラスのインクルード元 |

**主要処理フロー**:
- FreeASPUploadは外部ライブラリで、multipart/form-dataの解析とファイル保存を担当

#### Step 4: カタログアイテムクラスの詳細を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | catalogItem.asp | `asp/includes/catalogItem.asp` | pick関数（50-79行目）でデータ取得、save関数（100-148行目）でデータ保存 |

**主要処理フロー**:
- **15-17行目**: picURL関数で画像URLを生成
- **41-49行目**: removePic関数で画像削除
- **100-148行目**: save関数でDB更新

### プログラム呼び出し階層図

```
bs_catalogItemPicUpload.asp
    │
    ├─ begin.asp (include)
    │      └─ FreeASPUpload クラス
    │
    ├─ bs_security.asp (include)
    │      └─ logon.hasaccess メソッド
    │
    ├─ checkCSRF_Upload() 関数
    │
    ├─ cls_catalogItem クラス
    │      ├─ pick() メソッド
    │      ├─ save() メソッド
    │      └─ catalog プロパティ
    │             └─ cls_catalog クラス
    │                    └─ correFP プロパティ
    │
    └─ FreeASPUpload クラス
           ├─ Save() メソッド
           ├─ UploadedFiles コレクション
           │      ├─ FileName プロパティ
           │      ├─ Length プロパティ
           │      ├─ rename() メソッド
           │      ├─ move() メソッド
           │      └─ delete() メソッド
           └─ form() メソッド
```

### データフロー図

```
[入力]                    [処理]                         [出力]

画像ファイル ──────────▶ FreeASPUpload ─────────────────▶ サーバーファイル
(multipart/form-data)     │                              (ユーザーファイルDir)
                          │
                          ▼
iItemID ──────────────▶ decrypt() ──────────────────────▶ catalogItem.iId
(暗号化パラメータ)         │
                          │
                          ▼
                    cls_catalogItem.save() ──────────────▶ tblCatalogItem.sPicExt
                          │                               (DB更新)
                          │
                          ▼
                    Response.Redirect ──────────────────▶ 編集画面/エラー画面
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_catalogItemPicUpload.asp | `asp/bs_catalogItemPicUpload.asp` | ソース | 画像アップロード処理のメインファイル |
| bs_catalogItemPic.asp | `asp/bs_catalogItemPic.asp` | ソース | 画像アップロードフォーム画面 |
| bs_catalogItemEdit.asp | `asp/bs_catalogItemEdit.asp` | ソース | カタログアイテム編集画面（リダイレクト先） |
| catalogItem.asp | `asp/includes/catalogItem.asp` | ソース | カタログアイテムクラス定義 |
| catalog.asp | `asp/includes/catalog.asp` | ソース | カタログクラス定義 |
| begin.asp | `asp/begin.asp` | ソース | 共通インクルード・初期化処理 |
| bs_security.asp | `asp/bs_security.asp` | ソース | セキュリティチェック処理 |
