# 機能設計書 52-カタログアイテムファイルアップロード

## 概要

本ドキュメントは、QuickerSite CMSにおけるカタログアイテムファイルアップロード機能の設計を記載する。カタログ内の個別商品・アイテムに対してPDF、ドキュメント等のファイルを添付するための機能である。

### 本機能の処理概要

カタログアイテムファイルアップロード機能は、管理者がカタログに登録された商品やアイテムに対して各種ファイル（PDF、ドキュメント等）を添付できる機能である。画像アップロード機能とは異なり、ファイルタイプ（カテゴリ）を指定して複数ファイルを管理できる。

**業務上の目的・背景**：商品カタログにおいて、商品のスペックシート、取扱説明書、カタログPDF等の補足資料を提供することで、顧客に詳細な情報を提供できる。本機能により、商品に関連する各種ドキュメントを体系的に管理し、ダウンロード可能にすることができる。

**機能の利用シーン**：
- 商品の仕様書PDFを添付する場面
- 商品の取扱説明書をアップロードする場面
- 商品のカタログパンフレットを登録する場面
- 複数のファイルタイプに分類してファイルを管理する場面

**主要な処理内容**：
1. アップロードされたファイルの受信とサーバーへの保存
2. ファイルタイプ（拡張子）のバリデーション（許可されたファイル形式のみ）
3. ファイルサイズのバリデーション（6MB以下に制限）
4. CSRF対策トークンの検証によるセキュリティ確保
5. カタログアイテムファイルレコード（tblCatalogItemFiles）の新規作成

**関連システム・外部連携**：特になし（内部処理のみ）

**権限による制御**：セカンドアドミンのカタログ権限（secondAdmin.bCatalog）を持つユーザーのみがアクセス可能

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 40 | カタログアイテムファイル | 主画面 | カタログアイテムへのファイル添付管理 |
| 38 | カタログアイテム編集 | 遷移先画面 | アップロード成功時のリダイレクト先 |

## 機能種別

ファイルアップロード / データ作成（INSERT操作）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| iItemID | String（暗号化） | Yes | カタログアイテムID | 復号化後に数値チェック |
| iFileTypeId | String（暗号化） | Yes | ファイルタイプID | カタログに定義されたファイルタイプ |
| sTitle | String | No | ファイルのタイトル | 任意入力 |
| QSSEC | String | Yes | CSRFトークン | checkCSRF_Uploadで検証 |
| uploadFile | Binary | Yes | アップロードするファイル | 拡張子・サイズチェック |

### 入力データソース

- 画面入力（multipart/form-data形式のファイルアップロード）
- FreeASPUploadコンポーネントによるファイル受信

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| iId | Integer | 生成されたファイルレコードのID |
| sName | String | 保存されたファイル名 |
| iFileTypeID | Integer | ファイルタイプID |
| iItemID | Integer | 関連するカタログアイテムID |

### 出力先

- ファイルシステム：ユーザーファイルディレクトリ（Application("QS_CMS_userfiles")）
- データベース：tblCatalogItemFilesテーブル

## 処理フロー

### 処理シーケンス

```
1. セキュリティチェック
   └─ セカンドアドミンのカタログ権限を確認

2. ファイルアップロード処理
   └─ FreeASPUploadコンポーネントでファイルを受信
   └─ 一時ディレクトリへ保存

3. CSRFトークン検証
   └─ checkCSRF_Upload関数でトークンを検証

4. カタログアイテム取得
   └─ 暗号化されたiItemIDを復号化
   └─ cls_catalogItemクラスでアイテム情報を取得

5. ファイルバリデーション
   └─ 拡張子チェック（allowedFileTypesに含まれるか）
   └─ サイズチェック（6,000,000バイト以下か）

6. ファイルレコード作成
   └─ cls_catalogItemFileインスタンスを生成
   └─ iItemID、iFileTypeIdを設定

7. ファイル保存処理
   ├─ カタログにファイルパス設定がない場合
   │   └─ 暗号化ID_ランダムパスワード.拡張子形式でリネーム保存
   └─ カタログにファイルパス設定がある場合
       └─ 元のファイル名で指定パスへ移動

8. データベース保存
   └─ catalogItemFile.save()でtblCatalogItemFilesに挿入

9. リダイレクト処理
   ├─ 成功時：bs_catalogItemEdit.aspへリダイレクト
   └─ エラー時：bs_catalogItemFile.aspへエラーメッセージ付きでリダイレクト
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[セキュリティチェック]
    B --> C[ファイルアップロード受信]
    C --> D[CSRFトークン検証]
    D --> E[カタログアイテム取得]
    E --> F{ファイルが存在?}
    F -->|No| G[err_newFile エラー]
    F -->|Yes| H{拡張子チェック}
    H -->|NG| I[err_fileType エラー]
    H -->|OK| J{サイズチェック}
    J -->|NG| K[err_fileSize エラー]
    J -->|OK| L[cls_catalogItemFile生成]
    L --> M{カタログにパス設定あり?}
    M -->|No| N[暗号化名でリネーム保存]
    M -->|Yes| O[元の名前で移動]
    N --> P[DB保存 catalogItemFile.save]
    O --> P
    P --> Q[カタログアイテム編集画面へリダイレクト]
    G --> R[ファイル画面へエラー付きリダイレクト]
    I --> R
    K --> R
    Q --> S[終了]
    R --> S
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-52-001 | ファイルタイプ制限 | allowedFileTypesに登録された拡張子のみアップロード可能 | 全アップロード時 |
| BR-52-002 | ファイルサイズ制限 | 6MB（6,000,000バイト）以下のファイルのみアップロード可能 | 全アップロード時 |
| BR-52-003 | ファイル名生成 | ファイルパス設定がない場合、暗号化ID_ランダム文字列.拡張子形式で保存 | カタログのsFilePathが空の場合 |
| BR-52-004 | ファイルタイプ必須 | ファイルにはカタログで定義されたファイルタイプを関連付ける | 全アップロード時 |

### 計算ロジック

- ファイル名生成：`encrypt(catalogItem.iId) & "_" & GeneratePassWord() & "." & GetFileExtension(FileName)`

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ファイルアップロード | tblCatalogItemFiles | INSERT | 新規ファイルレコードを作成 |

### テーブル別操作詳細

#### tblCatalogItemFiles

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | iItemID | カタログアイテムのID | 親アイテムへの外部キー |
| INSERT | iFileTypeID | 選択されたファイルタイプID | ファイルカテゴリ分類 |
| INSERT | sName | アップロードされたファイル名（リネーム後） | ファイルの参照名 |
| INSERT | sTitle | 入力されたタイトル | 表示用タイトル |
| INSERT | dCreatedTS | now() | 作成日時 |
| INSERT | dUpdatedTS | now() | 更新日時 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| err_fileType | バリデーションエラー | 許可されていない拡張子のファイルをアップロード | 対応形式のファイルを選択 |
| err_fileSize | バリデーションエラー | 6MBを超えるファイルをアップロード | ファイルサイズを縮小して再アップロード |
| err_newFile | 入力エラー | ファイルが選択されていない | ファイルを選択してから送信 |

### リトライ仕様

- リトライ機能なし（エラー時はエラーメッセージを表示して再入力を促す）

## トランザクション仕様

- 明示的なトランザクション管理は行われていない
- ファイル保存とDB挿入が分離されているため、DB挿入失敗時にファイルが残る可能性あり

## パフォーマンス要件

- ファイルサイズ上限：6MB
- 大きなファイルの場合、アップロード時間はネットワーク帯域に依存

## セキュリティ考慮事項

- CSRFトークン検証（checkCSRF_Upload関数）
- セカンドアドミンのカタログ権限チェック
- ファイルタイプのホワイトリスト方式バリデーション
- ファイル名にランダム文字列を付与して推測困難化

## 備考

- 画像アップロード（No.51）との違い：
  - ファイルタイプ（カテゴリ）の指定が可能
  - 許可拡張子リストが異なる（allowedFileTypes vs allowedFileTypesforThumbing）
  - サイズ上限が異なる（6MB vs 5.55MB）
  - 別テーブル（tblCatalogItemFiles）に保存
- 1つのカタログアイテムに複数のファイルを添付可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

カタログアイテムファイルのデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | catalogItemFile.asp | `asp/includes/catalogItemFile.asp` | cls_catalogItemFileクラスの構造、プロパティ定義 |
| 1-2 | catalogItem.asp | `asp/includes/catalogItem.asp` | filesプロパティで関連ファイルを取得する仕組み |

**読解のコツ**: cls_catalogItemFileはiItemIDでカタログアイテムに紐づく。1:Nの関係性を持つ。

#### Step 2: エントリーポイントを理解する

アップロード処理の起点となるファイルを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_catalogItemFileUpload.asp | `asp/bs_catalogItemFileUpload.asp` | ファイルアップロード処理の全体フロー |

**主要処理フロー**:
1. **4行目**: セキュリティチェック（logon.hasaccess secondAdmin.bCatalog）
2. **5-8行目**: FreeASPUploadでファイル受信
3. **9行目**: CSRFトークン検証
4. **10-12行目**: カタログアイテム取得
5. **15-43行目**: ファイルバリデーション、cls_catalogItemFile生成、保存処理
6. **47-50行目**: リダイレクト処理

#### Step 3: カタログアイテムファイルクラスの詳細を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | catalogItemFile.asp | `asp/includes/catalogItemFile.asp` | pick関数（26-42行目）、save関数（56-75行目）、remove関数（76-86行目） |

**主要処理フロー**:
- **26-42行目**: pick関数でtblCatalogItemFilesからデータ取得
- **56-75行目**: save関数でDB挿入/更新
- **43-54行目**: urlプロパティでダウンロードリンク生成

### プログラム呼び出し階層図

```
bs_catalogItemFileUpload.asp
    │
    ├─ begin.asp (include)
    │      └─ FreeASPUpload クラス
    │
    ├─ bs_security.asp (include)
    │      └─ logon.hasaccess メソッド
    │
    ├─ checkCSRF_Upload() 関数
    │
    ├─ cls_catalogItem クラス
    │      ├─ pick() メソッド
    │      └─ catalog プロパティ
    │             └─ cls_catalog クラス
    │                    ├─ sFilePath プロパティ
    │                    └─ correFP プロパティ
    │
    ├─ cls_catalogItemFile クラス
    │      └─ save() メソッド
    │
    └─ FreeASPUpload クラス
           ├─ Save() メソッド
           ├─ UploadedFiles コレクション
           │      ├─ FileName プロパティ
           │      ├─ Length プロパティ
           │      ├─ rename() メソッド
           │      └─ move() メソッド
           └─ form() メソッド
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ファイル ─────────────▶ FreeASPUpload ─────────────────▶ サーバーファイル
(multipart/form-data)     │                              (ユーザーファイルDir)
                          │
                          ▼
iItemID ──────────────▶ decrypt() ──────────────────────▶ catalogItem.iId
(暗号化パラメータ)         │
                          │
iFileTypeId ──────────▶ decrypt() ──────────────────────▶ catalogItemFile.iFileTypeID
(暗号化パラメータ)         │
                          │
                          ▼
                    cls_catalogItemFile.save() ─────────▶ tblCatalogItemFiles
                          │                               (DB INSERT)
                          │
                          ▼
                    Response.Redirect ──────────────────▶ 編集画面/エラー画面
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_catalogItemFileUpload.asp | `asp/bs_catalogItemFileUpload.asp` | ソース | ファイルアップロード処理のメインファイル |
| bs_catalogItemFile.asp | `asp/bs_catalogItemFile.asp` | ソース | ファイルアップロードフォーム画面 |
| bs_catalogItemEdit.asp | `asp/bs_catalogItemEdit.asp` | ソース | カタログアイテム編集画面（リダイレクト先） |
| catalogItemFile.asp | `asp/includes/catalogItemFile.asp` | ソース | カタログアイテムファイルクラス定義 |
| catalogItem.asp | `asp/includes/catalogItem.asp` | ソース | カタログアイテムクラス定義 |
| catalog.asp | `asp/includes/catalog.asp` | ソース | カタログクラス定義 |
| begin.asp | `asp/begin.asp` | ソース | 共通インクルード・初期化処理 |
| bs_security.asp | `asp/bs_security.asp` | ソース | セキュリティチェック処理 |
