# 機能設計書 53-フィード一覧

## 概要

本ドキュメントは、QuickerSite CMSにおけるフィード一覧機能の設計を記載する。登録済みのRSSフィード設定の一覧表示と管理を行う機能である。

### 本機能の処理概要

フィード一覧機能は、管理者が設定した外部RSSフィードの一覧を表示し、各フィードへのアクセス・管理機能を提供する。フィードの編集、プレビュー、コピー、埋め込みコードの取得が可能である。

**業務上の目的・背景**：ウェブサイトに外部のニュースや更新情報を取り込むことで、コンテンツを充実させ、サイトの情報価値を高めることができる。本機能は、複数のRSSフィードを一元管理し、効率的にサイトへの埋め込みを行うための管理インターフェースを提供する。

**機能の利用シーン**：
- 設定済みフィードの一覧を確認する場面
- 新規フィードを追加するために作成画面へ遷移する場面
- 既存フィードの設定を編集する場面
- フィードの表示状態をプレビューで確認する場面
- フィードを複製して類似設定を作成する場面
- テンプレートへの埋め込みコードを取得する場面

**主要な処理内容**：
1. 顧客に紐づくフィード一覧の取得と表示
2. 新規フィード作成画面へのリンク提供
3. 各フィードの編集画面へのリンク提供
4. フィードプレビュー機能へのリンク提供
5. フィードのコピー機能（CSRF対策付き）
6. 埋め込みコード（[QS_FEED:コード]形式）の表示

**関連システム・外部連携**：特になし（内部処理のみ）

**権限による制御**：セカンドアドミンのフィード権限（secondAdmin.bFeed）を持つユーザーのみがアクセス可能

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 68 | フィード一覧 | 主画面 | 登録済みRSSフィードの一覧表示 |
| 69 | フィード編集 | 遷移先機能 | 新規フィード作成画面への遷移 |
| 70 | フィードプレビュー | 遷移先機能 | フィードプレビュー画面への遷移 |

## 機能種別

データ一覧表示 / コピー操作（INSERT）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| iFeedID | String（暗号化） | No | コピー対象フィードID | コピー操作時のみ必須 |
| QSSEC | String | コピー時 | CSRFトークン | コピー操作時に検証 |

### 入力データソース

- クエリパラメータ（コピー操作時のiFeedID）
- セッション（顧客ID: cId）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| sName | String | フィード名 |
| sCode | String | 埋め込み用コード |
| iID | Integer | フィードID |
| プレビューリンク | URL | プレビュー画面へのリンク |
| 編集リンク | URL | 編集画面へのリンク |
| コピーリンク | URL | コピー操作用リンク |

### 出力先

- 画面表示（HTML）

## 処理フロー

### 処理シーケンス

```
1. セキュリティチェック
   └─ セカンドアドミンのフィード権限を確認

2. コピー処理（iFeedIDパラメータがある場合）
   └─ cls_feedインスタンス生成
   └─ copy()メソッドでフィードを複製
   └─ 成功時は新しいフィードの編集画面へリダイレクト

3. フィード一覧取得
   └─ customer.feedsで顧客のフィード一覧を取得

4. 画面レンダリング
   └─ 新規作成リンクの表示
   └─ フィードがある場合はテーブル形式で一覧表示
   └─ 各フィードに対して以下を表示：
       ├─ フィード名（編集画面へのリンク）
       ├─ プレビューアイコン
       ├─ コピーアイコン（確認ダイアログ付き）
       ├─ 埋め込みコード入力欄
       └─ 内部ID表示
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[セキュリティチェック]
    B --> C{コピーパラメータあり?}
    C -->|Yes| D[cls_feed生成]
    D --> E[copy メソッド実行]
    E --> F{コピー成功?}
    F -->|Yes| G[新フィード編集画面へリダイレクト]
    F -->|No| H[一覧表示へ]
    C -->|No| H
    H --> I[customer.feedsで一覧取得]
    I --> J{フィードあり?}
    J -->|Yes| K[テーブル形式で一覧表示]
    J -->|No| L[「フィードなし」メッセージ表示]
    K --> M[終了]
    L --> M
    G --> M
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-53-001 | 顧客別フィード管理 | 各顧客は自分のフィードのみ参照・操作可能 | 全操作時 |
| BR-53-002 | コピー時コード初期化 | フィードをコピーする際、sCodeは空にリセットされる | コピー操作時 |
| BR-53-003 | コピー時名前変更 | コピーされたフィードの名前は「コピー - 元の名前」形式になる | コピー操作時 |
| BR-53-004 | CSRF対策 | コピー操作時はCSRFトークン検証が必要 | コピー操作時 |

### 計算ロジック

- 特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 一覧表示 | tblFeed | SELECT | 顧客IDに紐づくフィード一覧を取得 |
| コピー | tblFeed | INSERT | 新規フィードレコードを作成 |

### テーブル別操作詳細

#### tblFeed（コピー操作時）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | sName | "コピー - " + 元のsName | 名前を変更 |
| INSERT | sCode | 空文字 | コードはリセット |
| INSERT | その他項目 | 元のフィードと同じ値 | URL設定等を複製 |
| INSERT | iCustomerID | cId | 顧客IDを設定 |
| INSERT | dCreatedTS | now() | 作成日時 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 権限エラー | フィード権限がないユーザーがアクセス | ログイン画面へリダイレクト |

### リトライ仕様

- 特になし

## トランザクション仕様

- コピー操作は単一のINSERT処理のため、暗黙的トランザクション

## パフォーマンス要件

- 一覧表示はページング無し（全件表示）
- フィード数が多い場合はレスポンス時間に影響

## セキュリティ考慮事項

- セカンドアドミンのフィード権限チェック
- コピー操作時のCSRFトークン検証（QS_secCodeURL）
- 埋め込みコードはsanitize関数でエスケープ
- confirmダイアログでコピー操作の誤操作防止

## 備考

- 埋め込みコード形式：`[QS_FEED:コード]`
- この埋め込みコードをテンプレートに記述することでフィードがページに表示される

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

フィードのデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | feed.asp | `asp/includes/feed.asp` | cls_feedクラスの構造、プロパティ定義（2-6行目） |
| 1-2 | customer.asp | `asp/includes/customer.asp` | feedsプロパティでフィード一覧を取得する仕組み |

**読解のコツ**: cls_feedはiCustomerIDで顧客に紐づく。customer.feedsでDictionaryオブジェクトとして取得される。

#### Step 2: エントリーポイントを理解する

一覧画面の処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_feedList.asp | `asp/bs_feedList.asp` | フィード一覧画面の全体フロー |

**主要処理フロー**:
1. **4行目**: セキュリティチェック（logon.hasaccess secondAdmin.bFeed）
2. **5-7行目**: コピー処理（copyFeed.copy()）
3. **8-9行目**: フィード一覧取得（customer.feeds）
4. **9行目以降**: テーブル形式での一覧表示

#### Step 3: フィードクラスの詳細を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | feed.asp | `asp/includes/feed.asp` | pick関数（31-64行目）、save関数（96-147行目）、copy関数（193-200行目） |

**主要処理フロー**:
- **31-64行目**: pick関数でtblFeedからデータ取得
- **193-200行目**: copy関数でフィード複製（sCodeを空にリセット）

### プログラム呼び出し階層図

```
bs_feedList.asp
    │
    ├─ begin.asp (include)
    │
    ├─ bs_security.asp (include)
    │      └─ logon.hasaccess メソッド
    │
    ├─ cls_feed クラス
    │      ├─ copy() メソッド
    │      │      └─ save() メソッド
    │      └─ pick() メソッド
    │
    ├─ customer オブジェクト
    │      └─ feeds プロパティ
    │             └─ Dictionary<iId, cls_feed>
    │
    └─ 各種ヘルパー関数
           ├─ getArtLink() - リンク生成
           ├─ getIcon() - アイコンリンク生成
           ├─ encrypt() - ID暗号化
           └─ sanitize() - XSS対策
```

### データフロー図

```
[入力]                    [処理]                         [出力]

セッション(cId) ─────▶ customer.feeds ─────────────────▶ フィード一覧
                          │                              (HTML テーブル)
                          ▼
                    for each feedKey ──────────────────▶ 各フィード行
                          │                              - 名前リンク
                          │                              - プレビューアイコン
                          │                              - コピーアイコン
                          │                              - 埋め込みコード
                          ▼
iFeedID ──────────▶ cls_feed.copy() ────────────────▶ 新フィード作成
(コピー時)              │                              → 編集画面へリダイレクト
                        ▼
                    tblFeed INSERT
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_feedList.asp | `asp/bs_feedList.asp` | ソース | フィード一覧画面のメインファイル |
| bs_feedEdit.asp | `asp/bs_feedEdit.asp` | ソース | フィード編集画面（遷移先） |
| bs_feedPreview.asp | `asp/bs_feedPreview.asp` | ソース | フィードプレビュー画面（遷移先） |
| feed.asp | `asp/includes/feed.asp` | ソース | フィードクラス定義 |
| customer.asp | `asp/includes/customer.asp` | ソース | 顧客クラス（feedsプロパティ） |
| begin.asp | `asp/begin.asp` | ソース | 共通インクルード・初期化処理 |
| bs_security.asp | `asp/bs_security.asp` | ソース | セキュリティチェック処理 |
| bs_header.asp | `asp/bs_header.asp` | ソース | バックサイトヘッダー |
| bs_feedBack.asp | `asp/bs_feedBack.asp` | ソース | フィード管理用の戻るリンク |
