# 機能設計書 54-フィード作成・編集

## 概要

本ドキュメントは、QuickerSite CMSにおけるフィード作成・編集機能の設計を記載する。外部RSSフィードの取り込み設定を新規作成または編集する機能である。

### 本機能の処理概要

フィード作成・編集機能は、外部RSSフィードをサイトに取り込むための設定を行う機能である。RSS/ATOMフィードのURL設定、表示オプション、キャッシュ設定、カスタムテンプレート等を管理できる。

**業務上の目的・背景**：外部のニュースフィードや更新情報をサイトに取り込むことで、コンテンツを動的に充実させることができる。本機能により、フィードの取得元URL、表示件数、表示形式、キャッシュ時間等を詳細に設定し、サイトに最適化された形式でフィードを表示することが可能となる。

**機能の利用シーン**：
- 新規にRSS/ATOMフィードを登録する場面
- 既存フィードのURL変更や表示設定を変更する場面
- フィードの表示テンプレートをカスタマイズする場面
- フィードのキャッシュ時間を調整する場面
- フィードを削除する場面

**主要な処理内容**：
1. フィード基本情報（名前、コード、URL）の設定
2. 表示オプション（タイトル表示、リンク、日付、著者、カテゴリ等）の設定
3. キャッシュ設定（0〜14400秒）
4. カスタムHTMLテンプレートの設定（オプション）
5. フィードが使用されているページの検索・表示
6. フィードの保存・削除

**関連システム・外部連携**：
- 外部RSSフィードサーバー（build関数で取得時）

**権限による制御**：セカンドアドミンのフィード権限（secondAdmin.bFeed）を持つユーザーのみがアクセス可能

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 69 | フィード編集 | 主画面 | 外部RSSフィードの取り込み設定 |
| 68 | フィード一覧 | 遷移先機能 | 保存・削除後のリダイレクト先 |

## 機能種別

データ作成（INSERT）/ データ更新（UPDATE）/ データ削除（DELETE）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| ifeedId | String（暗号化） | 編集時 | フィードID | 編集時は必須 |
| sName | String | Yes | フィード名 | 最大50文字 |
| sCode | String | No | 埋め込み用コード | 最大45文字、重複不可 |
| sPrefixUrl | String | Yes | URLプレフィックス（http://またはhttps://） | 選択式 |
| sUrl | String | Yes（複数URL設定時以外） | フィードURL | 最大255文字 |
| sUrls | String | No | 複数フィードURL（改行区切り） | 複数フィード結合用 |
| iMaxItems | Integer | Yes | 最大表示件数 | 1〜100 |
| bRandom | Boolean | No | ランダム表示 | チェックボックス |
| bEnableJS | Boolean | No | JavaScript有効化 | チェックボックス |
| iCache | Integer | Yes | キャッシュ時間（秒） | 0〜14400 |
| bTemplate | Boolean | No | カスタムテンプレート使用 | チェックボックス |
| bShowTitle | Boolean | No | タイトル表示 | チェックボックス |
| bLinkOnTitle | Boolean | No | タイトルにリンク | チェックボックス |
| bOpenLinkInNW | Boolean | No | 新しいウィンドウで開く | チェックボックス |
| bShowDate | Boolean | No | 日付表示 | チェックボックス |
| bShowAuthor | Boolean | No | 著者情報表示 | チェックボックス |
| bShowCategory | Boolean | No | カテゴリ表示 | チェックボックス |
| sTemplate | String | No | カスタムHTMLテンプレート | テンプレート使用時 |
| sHTMLBefore | String | No | テンプレート前HTML | 最大254文字 |
| sHTMLAfter | String | No | テンプレート後HTML | 最大254文字 |
| iTitleLimitTo | Integer | No | タイトル文字数制限 | 0〜100（0は無制限） |
| iLimitTo | Integer | No | 説明文字数制限 | 0〜2500（0は無制限） |
| btnaction | String | Yes | 操作ボタン | save/delete |

### 入力データソース

- 画面入力（フォームPOST）
- データベース（編集時の既存データ）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| iId | Integer | フィードID |
| 全入力項目 | 各種 | 入力された設定値 |

### 出力先

- データベース：tblFeedテーブル
- アプリケーションキャッシュ：customer.cacheFeeds()で更新

## 処理フロー

### 処理シーケンス

```
1. セキュリティチェック
   └─ セカンドアドミンのフィード権限を確認

2. フィードオブジェクト初期化
   └─ cls_feedインスタンス生成
   └─ 既存IDがある場合はpick()でデータ取得

3. PostBack処理（フォーム送信時）
   └─ getRequestValues()で入力値を取得

4. ボタンアクション分岐
   ├─ 保存ボタン押下時
   │   └─ CSRFトークン検証
   │   └─ getRequestValues()で値取得
   │   └─ save()でデータ保存
   │   └─ 成功時は一覧画面へリダイレクト
   │
   └─ 削除ボタン押下時
       └─ CSRFトークン検証
       └─ remove()でデータ削除
       └─ 一覧画面へリダイレクト

5. 入力フォーム表示
   └─ 各設定項目の入力欄を表示
   └─ カスタムテンプレート使用時はテンプレート編集欄を表示

6. 使用箇所検索（既存フィードの場合）
   └─ cls_fullSearchでフィードコードの使用箇所を検索
   └─ 結果を表示
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[セキュリティチェック]
    B --> C[cls_feed生成]
    C --> D{既存ID?}
    D -->|Yes| E[pick でデータ取得]
    D -->|No| F[新規データ]
    E --> G{PostBack?}
    F --> G
    G -->|Yes| H[getRequestValues]
    G -->|No| I[フォーム表示]
    H --> J{ボタンアクション}
    J -->|save| K[CSRFチェック]
    K --> L[save 処理]
    L --> M{保存成功?}
    M -->|Yes| N[一覧へリダイレクト]
    M -->|No| I
    J -->|delete| O[CSRFチェック]
    O --> P[remove 処理]
    P --> N
    I --> Q{既存フィード?}
    Q -->|Yes| R[使用箇所検索]
    R --> S[終了]
    Q -->|No| S
    N --> S
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-54-001 | 必須項目 | sNameとsUrl（またはsUrls）は必須 | 保存時 |
| BR-54-002 | コード重複不可 | sCodeは同一顧客内で重複不可 | 保存時（sCodeが設定されている場合） |
| BR-54-003 | 内部フィード禁止 | sUrlにdefault.asp?iId=やdefault.asp?sCode=を含めることは禁止 | 保存時 |
| BR-54-004 | URL正規化 | sUrlからhttp://やhttps://プレフィックスを自動除去 | 保存時 |
| BR-54-005 | キャッシュクリア | 保存時にフィードキャッシュをクリア | 保存時 |

### 計算ロジック

- 埋め込みコード形式：`[QS_FEED:sCode]`
- テンプレート変数：
  - `{AUTHOR}` - 著者
  - `{CATEGORY}` - カテゴリ
  - `{COUNTER}` - カウンター
  - `{DATE}` - 日付
  - `{DESCRIPTION}` - 説明
  - `{IMAGE}` - 画像
  - `{ENCLOSURE}` - エンクロージャ
  - `{LINK}` - リンク
  - `{TITLE}` - タイトル

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 新規作成 | tblFeed | INSERT | 新規フィードレコードを作成 |
| 編集保存 | tblFeed | UPDATE | 既存フィードレコードを更新 |
| 削除 | tblFeed | DELETE | フィードレコードを削除 |
| 削除 | tblPage | UPDATE | 関連するページのiFeedIDをnullに設定 |

### テーブル別操作詳細

#### tblFeed

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT/UPDATE | sName | 入力値（最大50文字） | フィード名 |
| INSERT/UPDATE | sUrl | 入力値 | フィードURL |
| INSERT/UPDATE | sPrefixUrl | http://またはhttps:// | URLプレフィックス |
| INSERT/UPDATE | iMaxItems | 1〜100 | 最大表示件数 |
| INSERT/UPDATE | sCode | 入力値（大文字） | 埋め込みコード |
| INSERT/UPDATE | iCache | 0〜14400 | キャッシュ秒数 |
| INSERT/UPDATE | bShowTitle | true/false | タイトル表示 |
| INSERT/UPDATE | sTemplate | テンプレートHTML | カスタムテンプレート |
| INSERT/UPDATE | iCustomerID | cId | 顧客ID |
| INSERT/UPDATE | dUpdatedTS | now() | 更新日時 |
| INSERT | dCreatedTS | now() | 作成日時 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| err_mandatory | 必須エラー | sNameまたはsUrlが空 | 必須項目を入力 |
| err_doublefeed | 重複エラー | sCodeが既に使用されている | 別のコードを使用 |

### リトライ仕様

- 特になし（エラー時はフォーム画面に戻り、エラーメッセージを表示）

## トランザクション仕様

- 保存・削除は単一のINSERT/UPDATE/DELETE処理のため、暗黙的トランザクション
- 削除時はtblPageの更新とtblFeedの削除が連続実行される

## パフォーマンス要件

- 使用箇所検索（cls_fullSearch）は正規表現によるファイル検索のため、ファイル数が多い場合は時間がかかる可能性あり

## セキュリティ考慮事項

- セカンドアドミンのフィード権限チェック
- CSRF対策（保存・削除時にcheckCSRF()で検証）
- 入力値のサニタイズ（quotRep関数でエスケープ）
- 外部RSSフィードのJavaScript無効化オプション（bEnableJS）

## 備考

- カスタムテンプレート使用時は、テンプレート変数を使用して表示形式を自由にカスタマイズ可能
- 複数フィードを結合する場合はsUrlsに改行区切りでURLを記述
- フィードキャッシュはアプリケーション変数に保存され、指定秒数後に自動更新

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

フィードのデータ構造とプロパティを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | feed.asp | `asp/includes/feed.asp` | cls_feedクラスのプロパティ定義（2-5行目）、Class_Initialize（6-27行目） |

**読解のコツ**: Class_Initializeでデフォルト値が設定される。bShowTitle等のフラグはデフォルトtrueに設定されている。

#### Step 2: エントリーポイントを理解する

編集画面の処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_feedEdit.asp | `asp/bs_feedEdit.asp` | フィード編集画面の全体フロー |

**主要処理フロー**:
1. **4行目**: セキュリティチェック
2. **5-8行目**: フィードオブジェクト生成、PostBack処理
3. **9-20行目**: ボタンアクション分岐（save/delete）
4. **21-25行目**: フォーム表示
5. **26-36行目**: 使用箇所検索

#### Step 3: フィードクラスの詳細を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | feed.asp | `asp/includes/feed.asp` | check関数（65-95行目）、save関数（96-147行目）、getRequestValues（148-181行目）、remove関数（182-192行目）、build関数（201-497行目） |

**主要処理フロー**:
- **65-95行目**: check関数でバリデーション（必須チェック、重複チェック）
- **96-147行目**: save関数でDB保存とキャッシュ更新
- **148-181行目**: getRequestValues関数でフォーム値取得
- **182-192行目**: remove関数で削除（tblPageの更新含む）
- **201-497行目**: build関数でRSS/ATOMフィードを解析してHTML生成

#### Step 4: フィード解析処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | feed.asp | `asp/includes/feed.asp` | build関数（201-497行目）のMSXML2.DOMDocumentによるXML解析 |

**主要処理フロー**:
- **258-277行目**: XMLDOMオブジェクトでフィードを読み込み
- **285-300行目**: RSS/ATOM形式の判定
- **304-435行目**: フィードアイテムのループ処理
- **450-456行目**: キャッシュへの保存

### プログラム呼び出し階層図

```
bs_feedEdit.asp
    │
    ├─ begin.asp (include)
    │
    ├─ bs_security.asp (include)
    │      └─ logon.hasaccess メソッド
    │
    ├─ checkCSRF() 関数
    │
    ├─ cls_feed クラス
    │      ├─ pick() メソッド
    │      ├─ getRequestValues() メソッド
    │      ├─ check() メソッド
    │      │      └─ message.AddError()
    │      ├─ save() メソッド
    │      │      └─ customer.cacheFeeds()
    │      └─ remove() メソッド
    │             └─ db.execute() - tblPage UPDATE
    │
    ├─ cls_urlTypeShortList クラス
    │      └─ showSelected() - URLプレフィックス選択
    │
    └─ cls_fullSearch クラス
           └─ search() - フィードコード使用箇所検索
```

### データフロー図

```
[入力]                    [処理]                         [出力]

フォーム入力 ──────────▶ getRequestValues() ─────────▶ フィードプロパティ
                          │
                          ▼
                    check() バリデーション ──────────▶ エラーメッセージ
                          │                          (err_mandatory等)
                          ▼
                    save() / remove() ───────────▶ tblFeed
                          │                          (INSERT/UPDATE/DELETE)
                          │
                          ▼
                    customer.cacheFeeds() ─────────▶ アプリケーションキャッシュ
                          │
                          ▼
                    Response.Redirect ─────────────▶ 一覧画面

既存フィード ─────────▶ cls_fullSearch.search() ───▶ 使用箇所一覧
(編集時)                   │                          (HTML表示)
                          ▼
                    パターン検索 [QS_FEED:code]
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_feedEdit.asp | `asp/bs_feedEdit.asp` | ソース | フィード編集画面のメインファイル |
| bs_feedList.asp | `asp/bs_feedList.asp` | ソース | フィード一覧画面（リダイレクト先） |
| bs_feedPreview.asp | `asp/bs_feedPreview.asp` | ソース | フィードプレビュー画面 |
| feed.asp | `asp/includes/feed.asp` | ソース | フィードクラス定義 |
| customer.asp | `asp/includes/customer.asp` | ソース | 顧客クラス（cacheFeedsメソッド） |
| fullsearch.asp | `asp/includes/fullsearch.asp` | ソース | 全文検索クラス |
| begin.asp | `asp/begin.asp` | ソース | 共通インクルード・初期化処理 |
| bs_security.asp | `asp/bs_security.asp` | ソース | セキュリティチェック処理 |
| bs_feedBack.asp | `asp/bs_feedBack.asp` | ソース | フィード管理用の戻るリンク |
