# 機能設計書 55-フィードプレビュー

## 概要

本ドキュメントは、QuickerSite CMSにおけるフィードプレビュー機能の設計を記載する。設定済みRSSフィードの表示プレビューを行う機能である。

### 本機能の処理概要

フィードプレビュー機能は、設定したRSSフィードが実際にどのように表示されるかを管理画面上でプレビュー確認できる機能である。外部RSSフィードを取得・解析し、設定済みの表示オプションに基づいてレンダリング結果を表示する。

**業務上の目的・背景**：フィードの設定変更後、実際のページに反映する前に表示結果を確認することで、設定ミスによる表示崩れを防止できる。本機能により、管理者はフィード設定の妥当性を事前に検証し、公開前の品質を担保することが可能となる。

**機能の利用シーン**：
- 新規フィード設定後に表示結果を確認する場面
- フィードの表示オプションやテンプレートを変更した後に確認する場面
- フィード取得元のRSSが正常に読み込めるか確認する場面
- テンプレート変数の置換結果を確認する場面

**主要な処理内容**：
1. 指定されたフィードIDに基づくフィードオブジェクトの取得
2. build()メソッドによる外部RSSフィードの取得・解析
3. 設定に基づいたHTML生成
4. プレビュー画面への表示

**関連システム・外部連携**：
- 外部RSSフィードサーバー（build関数でHTTP取得）

**権限による制御**：セカンドアドミンのフィード権限（secondAdmin.bFeed）を持つユーザーのみがアクセス可能

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 70 | フィードプレビュー | 主画面 | フィード表示のプレビュー |
| 68 | フィード一覧 | 遷移元画面 | 一覧画面からプレビューへ遷移 |

## 機能種別

データ表示 / 外部データ取得

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| iFeedID | String（暗号化） | Yes | プレビュー対象フィードID | 復号化後に数値チェック |

### 入力データソース

- クエリパラメータ（iFeedID）
- データベース（tblFeedからフィード設定を取得）
- 外部RSSフィードサーバー（フィードデータ）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| HTML | String | フィードの表示HTML |
| 戻るリンク | URL | 一覧画面へのリンク |

### 出力先

- 画面表示（HTML）

## 処理フロー

### 処理シーケンス

```
1. セキュリティチェック
   └─ セカンドアドミンのフィード権限を確認

2. フィードオブジェクト生成
   └─ cls_feedインスタンス生成
   └─ iFeedIDパラメータから自動的にpick()実行

3. フィードビルド処理
   └─ feed.build()メソッド実行
   ├─ 外部RSSフィードをHTTP取得
   ├─ RSS/ATOM形式を判定
   ├─ XMLを解析してアイテムを抽出
   ├─ テンプレートに基づいてHTML生成
   └─ キャッシュに保存

4. 画面レンダリング
   └─ 戻るリンクの表示
   └─ フィードHTMLの表示
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[セキュリティチェック]
    B --> C[cls_feed生成]
    C --> D[iFeedIDから自動pick]
    D --> E[feed.build 実行]
    E --> F{キャッシュ有効?}
    F -->|Yes| G[キャッシュからHTML取得]
    F -->|No| H[外部RSSフィード取得]
    H --> I{取得成功?}
    I -->|Yes| J[XML解析]
    I -->|No| K[エラー表示]
    J --> L[テンプレート処理]
    L --> M[HTML生成]
    M --> N[キャッシュ保存]
    G --> O[画面表示]
    N --> O
    K --> O
    O --> P[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-55-001 | キャッシュ利用 | 設定されたキャッシュ時間内はキャッシュからHTML取得 | キャッシュが有効な場合 |
| BR-55-002 | ランダム表示 | bRandom=trueの場合はアイテムをランダム順に表示 | ランダム設定時 |
| BR-55-003 | 最大件数制限 | iMaxItemsで指定された件数まで表示 | 全表示時 |

### 計算ロジック

- キャッシュ有効判定：`cdate(now()) > cdate(application(QS_CMS_cacheFEED & iId & "TS"))`
- テンプレート変数置換：
  - `{LINK}` → feedlink
  - `{TITLE}` → feedtitle
  - `{AUTHOR}` → feedAuthor
  - `{DATE}` → feedDate
  - `{CATEGORY}` → feedCategory
  - `{IMAGE}` → feedimage
  - `{ENCLOSURE}` → feedenclosure
  - `{COUNTER}` → アイテム番号
  - `{DESCRIPTION}` → feedDescription

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| プレビュー | tblFeed | SELECT | フィード設定を取得 |

### テーブル別操作詳細

#### tblFeed

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | WHERE iId = 指定ID AND iCustomerID = cId | フィード設定を全カラム取得 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 権限エラー | フィード権限がないユーザーがアクセス | ログイン画面へリダイレクト |
| - | フィード取得エラー | 外部RSSフィードが取得できない | 空のHTMLを返す（エラーメッセージなし） |

### リトライ仕様

- 外部フィード取得失敗時のリトライは行われない
- キャッシュが古い場合のみ再取得を試行

## トランザクション仕様

- SELECT処理のみのため、トランザクション管理不要

## パフォーマンス要件

- 外部RSSフィード取得は非同期ではないため、レスポンス時間は外部サーバーに依存
- キャッシュ利用時は高速レスポンス

## セキュリティ考慮事項

- セカンドアドミンのフィード権限チェック
- bEnableJS=falseの場合はフィード内のJavaScriptを除去（removeJS関数）
- 外部フィードのHTML内容は設定に応じてサニタイズ

## 備考

- プレビュー画面は管理画面のヘッダー・フッターを含む
- フィード取得にはMSXML2.DOMDocumentを使用
- RSS 2.0とATOM形式の両方に対応

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

フィードのデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | feed.asp | `asp/includes/feed.asp` | cls_feedクラスのプロパティとbuild関数の構造 |

**読解のコツ**: build関数（201-497行目）がフィード取得・解析・HTML生成の中心処理。

#### Step 2: エントリーポイントを理解する

プレビュー画面の処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_feedPreview.asp | `asp/bs_feedPreview.asp` | フィードプレビュー画面の全体フロー |

**主要処理フロー**:
1. **4行目**: セキュリティチェック（logon.hasaccess secondAdmin.bFeed）
2. **5行目**: cls_feedインスタンス生成（iFeedIDから自動pick）
3. **6行目**: feed.build()でHTML生成
4. **6行目**: Response.writeでHTML出力

#### Step 3: フィードビルド処理の詳細を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | feed.asp | `asp/includes/feed.asp` | build関数（201-497行目）の詳細 |

**主要処理フロー**:
- **203-204行目**: キャッシュ有効性チェック
- **258-277行目**: MSXML2.DOMDocumentでフィード取得
- **285-300行目**: RSS/ATOM形式判定
- **304-435行目**: フィードアイテム解析とHTML生成
- **450-456行目**: キャッシュ保存
- **457-480行目**: ランダム表示処理

### プログラム呼び出し階層図

```
bs_feedPreview.asp
    │
    ├─ begin.asp (include)
    │
    ├─ bs_security.asp (include)
    │      └─ logon.hasaccess メソッド
    │
    └─ cls_feed クラス
           ├─ pick() メソッド（コンストラクタから自動呼び出し）
           │
           └─ build() メソッド
                  │
                  ├─ キャッシュチェック
                  │      └─ application(QS_CMS_cacheFEED & iId)
                  │
                  ├─ MSXML2.DOMDocument
                  │      ├─ Load() - フィード取得
                  │      ├─ getElementsByTagName() - 要素取得
                  │      └─ childNodes - 子要素アクセス
                  │
                  ├─ テンプレート処理
                  │      └─ Replace() - 変数置換
                  │
                  ├─ treatConstants() - 定数処理
                  │
                  └─ removeJS() - JavaScript除去（bEnableJS=false時）
```

### データフロー図

```
[入力]                    [処理]                         [出力]

iFeedID ──────────────▶ cls_feed.pick() ────────────▶ フィード設定
(暗号化パラメータ)         │
                          ▼
                    キャッシュチェック
                          │
                          ▼
                    ┌─────┴─────┐
                    │           │
                キャッシュ有効  キャッシュ無効
                    │           │
                    │           ▼
                    │     外部フィード取得
                    │     (MSXML2.DOMDocument.Load)
                    │           │
                    │           ▼
                    │     XML解析
                    │     (RSS/ATOM判定)
                    │           │
                    │           ▼
                    │     テンプレート処理
                    │     (変数置換)
                    │           │
                    │           ▼
                    │     キャッシュ保存
                    │           │
                    └─────┬─────┘
                          │
                          ▼
                    Response.write ────────────────▶ 画面表示
                                                    (フィードHTML)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_feedPreview.asp | `asp/bs_feedPreview.asp` | ソース | フィードプレビュー画面のメインファイル |
| bs_feedList.asp | `asp/bs_feedList.asp` | ソース | フィード一覧画面（遷移元） |
| feed.asp | `asp/includes/feed.asp` | ソース | フィードクラス定義（build関数） |
| begin.asp | `asp/begin.asp` | ソース | 共通インクルード・初期化処理 |
| bs_security.asp | `asp/bs_security.asp` | ソース | セキュリティチェック処理 |
| bs_feedBack.asp | `asp/bs_feedBack.asp` | ソース | フィード管理用の戻るリンク |
