# 機能設計書 56-ギャラリー一覧

## 概要

本ドキュメントは、QuickerSite CMSにおけるギャラリー一覧機能の設計を記載する。登録済みの画像ギャラリーの一覧表示と管理を行う機能である。

### 本機能の処理概要

ギャラリー一覧機能は、管理者が設定した画像ギャラリーの一覧を表示し、各ギャラリーへのアクセス・管理機能を提供する。ギャラリーの編集、プレビュー、コピー、埋め込みコードの取得が可能である。

**業務上の目的・背景**：画像ギャラリーはウェブサイトにおいて製品紹介、ポートフォリオ、イベント写真等を効果的に表示するために重要な機能である。本機能は、複数のギャラリーを一元管理し、効率的にサイトへの埋め込みを行うための管理インターフェースを提供する。

**機能の利用シーン**：
- 設定済みギャラリーの一覧を確認する場面
- 新規ギャラリーを追加するために作成画面へ遷移する場面
- 既存ギャラリーの設定を編集する場面
- ギャラリーの表示状態をプレビューで確認する場面
- ギャラリーを複製して類似設定を作成する場面
- テンプレートへの埋め込みコードを取得する場面

**主要な処理内容**：
1. 顧客に紐づくギャラリー一覧の取得と表示
2. 新規ギャラリー作成画面へのリンク提供
3. 各ギャラリーの編集画面へのリンク提供
4. ギャラリープレビュー機能へのリンク提供
5. ギャラリーのコピー機能（CSRF対策付き）
6. 埋め込みコード（[QS_GALLERY:コード]形式）の表示

**関連システム・外部連携**：特になし（内部処理のみ）

**権限による制御**：セカンドアドミンのギャラリー権限（secondAdmin.bGallery）を持つユーザーのみがアクセス可能

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 31 | ギャラリー一覧 | 主画面 | 登録済みギャラリーの一覧表示 |
| 32 | ギャラリー編集 | 遷移先機能 | 新規ギャラリー作成画面への遷移 |
| 33 | ギャラリープレビュー | 遷移先機能 | ギャラリープレビュー画面への遷移 |

## 機能種別

データ一覧表示 / コピー操作（INSERT）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| iGalleryID | String（暗号化） | No | コピー対象ギャラリーID | コピー操作時のみ必須 |
| QSSEC | String | コピー時 | CSRFトークン | コピー操作時に検証 |

### 入力データソース

- クエリパラメータ（コピー操作時のiGalleryID）
- セッション（顧客ID: cId）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| sName | String | ギャラリー名 |
| sCode | String | 埋め込み用コード |
| iID | Integer | ギャラリーID |
| プレビューリンク | URL | プレビュー画面へのリンク |
| 編集リンク | URL | 編集画面へのリンク |
| コピーリンク | URL | コピー操作用リンク |

### 出力先

- 画面表示（HTML）

## 処理フロー

### 処理シーケンス

```
1. セキュリティチェック
   └─ セカンドアドミンのギャラリー権限を確認

2. コピー処理（iGalleryIDパラメータがある場合）
   └─ cls_galleryインスタンス生成
   └─ copy()メソッドでギャラリーを複製
   └─ 成功時は新しいギャラリーの編集画面へリダイレクト

3. ギャラリー一覧取得
   └─ customer.galleriesで顧客のギャラリー一覧を取得

4. 画面レンダリング
   └─ 新規作成リンクの表示
   └─ ギャラリーがある場合はテーブル形式で一覧表示
   └─ 各ギャラリーに対して以下を表示：
       ├─ ギャラリー名（編集画面へのリンク）
       ├─ プレビューアイコン
       ├─ コピーアイコン（確認ダイアログ付き）
       ├─ 埋め込みコード入力欄
       └─ 内部ID表示
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[セキュリティチェック]
    B --> C{コピーパラメータあり?}
    C -->|Yes| D[cls_gallery生成]
    D --> E[copy メソッド実行]
    E --> F{コピー成功?}
    F -->|Yes| G[新ギャラリー編集画面へリダイレクト]
    F -->|No| H[一覧表示へ]
    C -->|No| H
    H --> I[customer.galleriesで一覧取得]
    I --> J{ギャラリーあり?}
    J -->|Yes| K[テーブル形式で一覧表示]
    J -->|No| L[「ギャラリーなし」メッセージ表示]
    K --> M[終了]
    L --> M
    G --> M
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-56-001 | 顧客別ギャラリー管理 | 各顧客は自分のギャラリーのみ参照・操作可能 | 全操作時 |
| BR-56-002 | コピー時コード初期化 | ギャラリーをコピーする際、sCodeはランダム生成される | コピー操作時 |
| BR-56-003 | コピー時名前変更 | コピーされたギャラリーの名前は「コピー - 元の名前」形式になる | コピー操作時 |
| BR-56-004 | CSRF対策 | コピー操作時はCSRFトークン検証が必要 | コピー操作時 |

### 計算ロジック

- 特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 一覧表示 | tblGallery | SELECT | 顧客IDに紐づくギャラリー一覧を取得 |
| コピー | tblGallery | INSERT | 新規ギャラリーレコードを作成 |

### テーブル別操作詳細

#### tblGallery（コピー操作時）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | sName | "コピー - " + 元のsName | 名前を変更 |
| INSERT | sCode | GeneratePassWord() | ランダムコード生成 |
| INSERT | その他項目 | 元のギャラリーと同じ値 | 画像パス設定等を複製 |
| INSERT | iCustomerID | cId | 顧客IDを設定 |
| INSERT | dCreatedTS | now() | 作成日時 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 権限エラー | ギャラリー権限がないユーザーがアクセス | ログイン画面へリダイレクト |

### リトライ仕様

- 特になし

## トランザクション仕様

- コピー操作は単一のINSERT処理のため、暗黙的トランザクション

## パフォーマンス要件

- 一覧表示はページング無し（全件表示）
- ギャラリー数が多い場合はレスポンス時間に影響

## セキュリティ考慮事項

- セカンドアドミンのギャラリー権限チェック
- コピー操作時のCSRFトークン検証（QS_secCodeURL）
- 埋め込みコードはsanitize関数でエスケープ
- confirmダイアログでコピー操作の誤操作防止

## 備考

- 埋め込みコード形式：`[QS_GALLERY:コード]`
- この埋め込みコードをテンプレートに記述することでギャラリーがページに表示される

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ギャラリーのデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | gallery.asp | `asp/includes/gallery.asp` | cls_galleryクラスの構造、プロパティ定義（2-6行目） |
| 1-2 | customer.asp | `asp/includes/customer.asp` | galleriesプロパティでギャラリー一覧を取得する仕組み |

**読解のコツ**: cls_galleryはiCustomerIDで顧客に紐づく。customer.galleriesでDictionaryオブジェクトとして取得される。

#### Step 2: エントリーポイントを理解する

一覧画面の処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_galleryList.asp | `asp/bs_galleryList.asp` | ギャラリー一覧画面の全体フロー |

**主要処理フロー**:
1. **4行目**: セキュリティチェック（logon.hasaccess secondAdmin.bGallery）
2. **5-7行目**: コピー処理（copyGallery.copy()）
3. **8-9行目**: ギャラリー一覧取得（customer.galleries）
4. **9行目以降**: テーブル形式での一覧表示

#### Step 3: ギャラリークラスの詳細を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | gallery.asp | `asp/includes/gallery.asp` | pick関数（62-108行目）、save関数（133-193行目）、copy関数（687-694行目） |

**主要処理フロー**:
- **62-108行目**: pick関数でtblGalleryからデータ取得
- **687-694行目**: copy関数でギャラリー複製（sCodeをランダム生成）

### プログラム呼び出し階層図

```
bs_galleryList.asp
    │
    ├─ begin.asp (include)
    │
    ├─ bs_security.asp (include)
    │      └─ logon.hasaccess メソッド
    │
    ├─ cls_gallery クラス
    │      ├─ copy() メソッド
    │      │      └─ save() メソッド
    │      └─ pick() メソッド
    │
    ├─ customer オブジェクト
    │      └─ galleries プロパティ
    │             └─ Dictionary<iId, cls_gallery>
    │
    └─ 各種ヘルパー関数
           ├─ getArtLink() - リンク生成
           ├─ getIcon() - アイコンリンク生成
           ├─ encrypt() - ID暗号化
           └─ sanitize() - XSS対策
```

### データフロー図

```
[入力]                    [処理]                         [出力]

セッション(cId) ─────▶ customer.galleries ─────────────▶ ギャラリー一覧
                          │                              (HTML テーブル)
                          ▼
                    for each galleryKey ───────────────▶ 各ギャラリー行
                          │                              - 名前リンク
                          │                              - プレビューアイコン
                          │                              - コピーアイコン
                          │                              - 埋め込みコード
                          ▼
iGalleryID ───────▶ cls_gallery.copy() ────────────▶ 新ギャラリー作成
(コピー時)              │                              → 編集画面へリダイレクト
                        ▼
                    tblGallery INSERT
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_galleryList.asp | `asp/bs_galleryList.asp` | ソース | ギャラリー一覧画面のメインファイル |
| bs_galleryEdit.asp | `asp/bs_galleryEdit.asp` | ソース | ギャラリー編集画面（遷移先） |
| bs_galleryPreview.asp | `asp/bs_galleryPreview.asp` | ソース | ギャラリープレビュー画面（遷移先） |
| gallery.asp | `asp/includes/gallery.asp` | ソース | ギャラリークラス定義 |
| customer.asp | `asp/includes/customer.asp` | ソース | 顧客クラス（galleriesプロパティ） |
| begin.asp | `asp/begin.asp` | ソース | 共通インクルード・初期化処理 |
| bs_security.asp | `asp/bs_security.asp` | ソース | セキュリティチェック処理 |
