# 機能設計書 57-ギャラリー作成・編集

## 概要

本ドキュメントは、QuickerSite CMSにおけるギャラリー作成・編集機能の設計を記載する。画像ギャラリーの新規作成およびアップロード・設定を行う機能である。

### 本機能の処理概要

ギャラリー作成・編集機能は、画像ギャラリーを作成・管理するための機能である。画像フォルダの選択、ギャラリータイプ（サムネイル一覧、スライドショー、Nivo Slider等）の設定、表示オプションの設定等が可能である。

**業務上の目的・背景**：画像ギャラリーはウェブサイトにおける視覚的なコンテンツ表現の中核機能である。本機能により、管理者は様々な形式のギャラリー（サムネイル一覧、Cycleスライドショー、Nivo Slider等）を作成し、サイトのデザインに合わせた画像表示を実現できる。

**機能の利用シーン**：
- 新規画像ギャラリーを作成する場面
- 既存ギャラリーの画像フォルダを変更する場面
- ギャラリーの表示タイプ（スライドショー、サムネイル等）を変更する場面
- サムネイルサイズやエフェクトを設定する場面
- Nivo Slider使用時のキャプションやリンクを設定する場面
- ギャラリーを削除する場面

**主要な処理内容**：
1. ギャラリー基本情報（名前、コード、画像パス）の設定
2. ギャラリータイプの選択（サムネイル一覧、Simple Slideshow、Simple Cycle、Nivo Slider）
3. 表示オプション（サムネイルサイズ、行数、エフェクト等）の設定
4. Nivo Slider使用時のキャプション・URL設定
5. ギャラリーが使用されているページの検索・表示
6. ギャラリーの保存・削除

**関連システム・外部連携**：
- ファイルシステム（画像フォルダへのアクセス）
- アセットマネージャー（画像管理へのリンク）

**権限による制御**：セカンドアドミンのギャラリー権限（secondAdmin.bGallery）を持つユーザーのみがアクセス可能

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 32 | ギャラリー編集 | 主画面 | ギャラリーの作成・画像アップロード・設定 |
| 31 | ギャラリー一覧 | 遷移先機能 | 保存・削除後のリダイレクト先 |
| 33 | ギャラリープレビュー | 遷移先機能 | プレビューボタンからの遷移 |

## 機能種別

データ作成（INSERT）/ データ更新（UPDATE）/ データ削除（DELETE）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| iGalleryId | String（暗号化） | 編集時 | ギャラリーID | 編集時は必須 |
| sName | String | Yes | ギャラリー名 | 最大50文字 |
| sCode | String | Yes | 埋め込み用コード | 最大45文字、重複不可 |
| sPath | String | Yes | 画像フォルダパス | フォルダが存在すること |
| sType | String | No | ギャラリータイプ | SS/SC/NS等 |
| iThumbSize | Integer | No | サムネイルサイズ | 10〜800/1920 |
| iPicsInRow | Integer | No | 行あたり画像数 | 1〜25 |
| iBrowseBy | Integer | No | ページあたり件数 | 1〜500 |
| iFullImageSize | Integer | No | フルサイズ画像サイズ | 320〜1920 |
| bFSR | Boolean | No | 固定サイズリサイズ | チェックボックス |
| bShowFileName | Boolean | No | ファイル名表示 | チェックボックス |
| iSlideShowTimerQS | Integer | No | スライドショータイマー | 1〜60秒 |
| sCycleEffect | String | No | Cycleエフェクト | fade等 |
| sWidth/sHeight | String | No | 幅/高さ | スライドショータイプ時 |
| sBorder/sBorderColor | String | No | 枠線設定 | Simple Slideshow時 |
| iSpecialEffect | Integer | No | 特殊エフェクト | BW/GS/SE等 |
| sNSCss | String | No | Nivo Sliderスタイル | default等 |
| bNSControlNav/bNSdirectionNav | Boolean | No | Nivoナビゲーション設定 | チェックボックス |
| btnaction | String | Yes | 操作ボタン | save/delete/preview |

### 入力データソース

- 画面入力（フォームPOST）
- データベース（編集時の既存データ）
- ファイルシステム（画像フォルダ一覧）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| iId | Integer | ギャラリーID |
| 全入力項目 | 各種 | 入力された設定値 |

### 出力先

- データベース：tblGalleryテーブル
- アプリケーションキャッシュ：customer.cacheGalleries()で更新

## 処理フロー

### 処理シーケンス

```
1. セキュリティチェック
   └─ セカンドアドミンのギャラリー権限を確認

2. ギャラリーオブジェクト初期化
   └─ cls_galleryインスタンス生成
   └─ 既存IDがある場合はpick()でデータ取得

3. PostBack処理（フォーム送信時）
   └─ getRequestValues()で入力値を取得

4. ボタンアクション分岐
   ├─ 保存ボタン押下時
   │   └─ CSRFトークン検証
   │   └─ getRequestValues()で値取得
   │   └─ save()でデータ保存
   │   └─ 成功時は一覧画面へリダイレクト
   │
   ├─ プレビューボタン押下時
   │   └─ CSRFトークン検証
   │   └─ save()でデータ保存
   │   └─ プレビュー画面へリダイレクト
   │
   └─ 削除ボタン押下時
       └─ CSRFトークン検証
       └─ remove()でデータ削除
       └─ 一覧画面へリダイレクト

5. 入力フォーム表示
   └─ ギャラリータイプに応じた設定項目を表示
   └─ Nivo Slider選択時は画像ごとのキャプション・URL設定を表示

6. 使用箇所検索（既存ギャラリーの場合）
   └─ cls_fullSearchでギャラリーコードの使用箇所を検索
   └─ 結果を表示
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[セキュリティチェック]
    B --> C[cls_gallery生成]
    C --> D{既存ID?}
    D -->|Yes| E[pick でデータ取得]
    D -->|No| F[新規データ]
    E --> G{PostBack?}
    F --> G
    G -->|Yes| H[getRequestValues]
    G -->|No| I[フォーム表示]
    H --> J{ボタンアクション}
    J -->|save| K[CSRFチェック]
    K --> L[save 処理]
    L --> M{保存成功?}
    M -->|Yes| N[一覧へリダイレクト]
    M -->|No| I
    J -->|preview| O[CSRFチェック]
    O --> P[save 処理]
    P --> Q[プレビュー画面へリダイレクト]
    J -->|delete| R[CSRFチェック]
    R --> S[remove 処理]
    S --> N
    I --> T{Nivo Slider?}
    T -->|Yes| U[画像ごとのキャプション・URL入力]
    T -->|No| V[標準設定項目]
    U --> W{既存ギャラリー?}
    V --> W
    W -->|Yes| X[使用箇所検索]
    X --> Y[終了]
    W -->|No| Y
    N --> Y
    Q --> Y
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-57-001 | 必須項目 | sName、sCode、sPathは必須 | 保存時 |
| BR-57-002 | コード重複不可 | sCodeは同一顧客内で重複不可 | 保存時 |
| BR-57-003 | パス必須 | sPath（画像フォルダ）の選択は必須 | 保存時 |
| BR-57-004 | キャッシュクリア | 保存時にギャラリーキャッシュをクリア | 保存時 |
| BR-57-005 | Nivo Slider設定保存 | Nivo Slider選択時はキャプション・URLをsNSImgLinksに保存 | sType=NS時 |

### 計算ロジック

- 埋め込みコード形式：`[QS_GALLERY:sCode]`
- キャプション・URL保存形式（Nivo Slider）：`ファイル名(ドットなし)[TAB]キャプション[TAB]URL[TAB]新窓フラグ[改行]`

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 新規作成 | tblGallery | INSERT | 新規ギャラリーレコードを作成 |
| 編集保存 | tblGallery | UPDATE | 既存ギャラリーレコードを更新 |
| 削除 | tblGallery | DELETE | ギャラリーレコードを削除 |

### テーブル別操作詳細

#### tblGallery

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT/UPDATE | sName | 入力値（最大50文字） | ギャラリー名 |
| INSERT/UPDATE | sCode | 入力値（大文字） | 埋め込みコード |
| INSERT/UPDATE | sPath | 選択されたフォルダパス | 画像フォルダ |
| INSERT/UPDATE | sType | SS/SC/NS等 | ギャラリータイプ |
| INSERT/UPDATE | iThumbSize | サムネイルサイズ | ピクセル |
| INSERT/UPDATE | sNSImgLinks | キャプション・URL設定 | Nivo Slider用 |
| INSERT/UPDATE | iCustomerID | cId | 顧客ID |
| INSERT | dCreatedTS | now() | 作成日時 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| err_mandatory | 必須エラー | sName、sCode、sPathのいずれかが空 | 必須項目を入力 |
| err_doublefeed | 重複エラー | sCodeが既に使用されている | 別のコードを使用 |

### リトライ仕様

- 特になし（エラー時はフォーム画面に戻り、エラーメッセージを表示）

## トランザクション仕様

- 保存・削除は単一のINSERT/UPDATE/DELETE処理のため、暗黙的トランザクション

## パフォーマンス要件

- Nivo Slider使用時、画像フォルダ内の画像ファイル数が多いと、キャプション入力フォームの生成に時間がかかる可能性あり

## セキュリティ考慮事項

- セカンドアドミンのギャラリー権限チェック
- CSRF対策（保存・削除時にcheckCSRF()で検証）
- 入力値のサニタイズ（quotRep関数でエスケープ）
- ファイルパスはユーザーファイルディレクトリ内に限定

## 備考

- ギャラリータイプ：
  - 標準（サムネイル一覧 + Lightbox）
  - QS_gallery_SS（Simple Slideshow）
  - QS_gallery_SC（Simple Cycle）
  - QS_gallery_NS（Nivo Slider）
- 特殊エフェクト：白黒、グレースケール、セピア
- アセットマネージャーへのリンクで画像管理が可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ギャラリーのデータ構造とプロパティを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | gallery.asp | `asp/includes/gallery.asp` | cls_galleryクラスのプロパティ定義（2-6行目）、Class_Initialize（7-41行目） |

**読解のコツ**: Class_Initializeでデフォルト値が設定される。ギャラリータイプ（sType）によって表示・設定項目が変わる。

#### Step 2: エントリーポイントを理解する

編集画面の処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_galleryEdit.asp | `asp/bs_galleryEdit.asp` | ギャラリー編集画面の全体フロー |

**主要処理フロー**:
1. **4行目**: セキュリティチェック
2. **6-12行目**: ギャラリーオブジェクト生成、PostBack処理
3. **15-30行目**: ボタンアクション分岐（save/preview/delete）
4. **40-108行目**: フォーム表示（ギャラリータイプ別）
5. **109-176行目**: Nivo Slider用キャプション・URL入力
6. **183-194行目**: 使用箇所検索

#### Step 3: ギャラリークラスの詳細を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | gallery.asp | `asp/includes/gallery.asp` | check関数（109-132行目）、save関数（133-193行目）、getRequestValues関数（194-268行目）、build関数（289-677行目） |

**主要処理フロー**:
- **109-132行目**: check関数でバリデーション（必須チェック、重複チェック）
- **133-193行目**: save関数でDB保存とキャッシュ更新
- **194-268行目**: getRequestValues関数でフォーム値取得（Nivo Sliderのキャプション処理含む）

### プログラム呼び出し階層図

```
bs_galleryEdit.asp
    │
    ├─ begin.asp (include)
    │
    ├─ bs_security.asp (include)
    │      └─ logon.hasaccess メソッド
    │
    ├─ checkCSRF() 関数
    │
    ├─ cls_gallery クラス
    │      ├─ pick() メソッド
    │      ├─ getRequestValues() メソッド
    │      ├─ check() メソッド
    │      ├─ save() メソッド
    │      │      └─ customer.cacheGalleries()
    │      └─ remove() メソッド
    │
    ├─ cls_fileexplorer クラス
    │      └─ SelectBoxFolders() - フォルダ選択
    │
    ├─ cls_galleryTypeList クラス
    │      └─ showSelected() - タイプ選択
    │
    ├─ cls_galleryCycleList クラス
    │      └─ showSelected() - Cycleエフェクト選択
    │
    └─ cls_fullSearch クラス
           └─ search() - ギャラリーコード使用箇所検索
```

### データフロー図

```
[入力]                    [処理]                         [出力]

フォーム入力 ──────────▶ getRequestValues() ─────────▶ ギャラリープロパティ
                          │
                          ▼
                    check() バリデーション ──────────▶ エラーメッセージ
                          │
                          ▼
                    save() / remove() ───────────▶ tblGallery
                          │                          (INSERT/UPDATE/DELETE)
                          │
                          ▼
                    customer.cacheGalleries() ─────▶ アプリケーションキャッシュ
                          │
                          ▼
                    Response.Redirect ─────────────▶ 一覧/プレビュー画面

画像フォルダ ─────────▶ FileSystemObject ─────────▶ Nivo Slider
(sPath)                   │                          キャプション入力欄
                          ▼
                    画像ファイル列挙
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_galleryEdit.asp | `asp/bs_galleryEdit.asp` | ソース | ギャラリー編集画面のメインファイル |
| bs_galleryList.asp | `asp/bs_galleryList.asp` | ソース | ギャラリー一覧画面（リダイレクト先） |
| bs_galleryPreview.asp | `asp/bs_galleryPreview.asp` | ソース | ギャラリープレビュー画面 |
| gallery.asp | `asp/includes/gallery.asp` | ソース | ギャラリークラス定義 |
| galleryTypeList.asp | `asp/includes/galleryTypeList.asp` | ソース | ギャラリータイプリスト |
| galleryCycleList.asp | `asp/includes/galleryCycleList.asp` | ソース | Cycleエフェクトリスト |
| gallerySEList.asp | `asp/includes/gallerySEList.asp` | ソース | 特殊エフェクトリスト |
| fullsearch.asp | `asp/includes/fullsearch.asp` | ソース | 全文検索クラス |
| bs_galleryBack.asp | `asp/bs_galleryBack.asp` | ソース | ギャラリー管理用の戻るリンク |
