# 機能設計書 58-ギャラリープレビュー

## 概要

本ドキュメントは、QuickerSite CMSにおけるギャラリープレビュー機能の設計を記載する。設定済み画像ギャラリーの表示プレビューを行う機能である。

### 本機能の処理概要

ギャラリープレビュー機能は、設定した画像ギャラリーが実際にどのように表示されるかを管理画面上でプレビュー確認できる機能である。画像フォルダ内の画像を取得し、設定済みの表示オプションに基づいてレンダリング結果を表示する。

**業務上の目的・背景**：ギャラリーの設定変更後、実際のページに反映する前に表示結果を確認することで、設定ミスによる表示崩れを防止できる。本機能により、管理者はギャラリー設定の妥当性を事前に検証し、公開前の品質を担保することが可能となる。

**機能の利用シーン**：
- 新規ギャラリー設定後に表示結果を確認する場面
- ギャラリーの表示タイプやサイズ設定を変更した後に確認する場面
- スライドショーのエフェクトやタイマー設定を確認する場面
- Nivo Sliderのキャプションやナビゲーション表示を確認する場面

**主要な処理内容**：
1. 指定されたギャラリーIDに基づくギャラリーオブジェクトの取得
2. backsitePVフラグをtrueに設定（バックサイドプレビューモード）
3. build()メソッドによる画像ギャラリーのHTML生成
4. プレビュー画面への表示

**関連システム・外部連携**：
- ファイルシステム（画像フォルダへのアクセス）

**権限による制御**：セカンドアドミンのギャラリー権限（secondAdmin.bGallery）を持つユーザーのみがアクセス可能

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 33 | ギャラリープレビュー | 主画面 | ギャラリー表示のプレビュー |
| 31 | ギャラリー一覧 | 遷移元画面 | 一覧画面からプレビューへ遷移 |
| 32 | ギャラリー編集 | 遷移元/遷移先画面 | 編集画面からの遷移、修正ボタンで編集へ遷移 |

## 機能種別

データ表示 / ファイルシステムアクセス

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| iGalleryID | String（暗号化） | Yes | プレビュー対象ギャラリーID | 復号化後に数値チェック |

### 入力データソース

- クエリパラメータ（iGalleryID）
- データベース（tblGalleryからギャラリー設定を取得）
- ファイルシステム（画像フォルダ内の画像ファイル）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| HTML | String | ギャラリーの表示HTML |
| 戻るリンク | URL | 一覧画面へのリンク |
| 修正ボタン | URL | 編集画面へのリンク |

### 出力先

- 画面表示（HTML）

## 処理フロー

### 処理シーケンス

```
1. セキュリティチェック
   └─ セカンドアドミンのギャラリー権限を確認

2. ギャラリーオブジェクト生成
   └─ cls_galleryインスタンス生成
   └─ iGalleryIDパラメータから自動的にpick()実行
   └─ backsitePV = true に設定

3. ギャラリービルド処理
   └─ gallery.build()メソッド実行
   ├─ ファイルシステムから画像ファイル一覧を取得
   ├─ ギャラリータイプに応じたHTML生成
   │   ├─ 標準：サムネイル一覧 + Lightbox
   │   ├─ Simple Slideshow：スライドショー
   │   ├─ Simple Cycle：Cycleプラグイン
   │   └─ Nivo Slider：Nivoスライダー
   └─ treatConstants()で定数処理

4. 画面レンダリング
   └─ 戻るリンクの表示
   └─ ギャラリーHTMLの表示
   └─ 修正ボタンの表示
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[セキュリティチェック]
    B --> C[cls_gallery生成]
    C --> D[iGalleryIDから自動pick]
    D --> E[backsitePV = true]
    E --> F[gallery.build 実行]
    F --> G{フォルダ存在?}
    G -->|Yes| H[画像ファイル一覧取得]
    G -->|No| I[エラーメッセージ表示]
    H --> J{ギャラリータイプ}
    J -->|標準| K[サムネイル一覧生成]
    J -->|SS| L[Simple Slideshow生成]
    J -->|SC| M[Simple Cycle生成]
    J -->|NS| N[Nivo Slider生成]
    K --> O[treatConstants処理]
    L --> O
    M --> O
    N --> O
    O --> P[画面表示]
    I --> P
    P --> Q[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-58-001 | バックサイドプレビューモード | backsitePV=trueにより、ナビゲーションリンクを非表示にする | 全プレビュー時 |
| BR-58-002 | 画像ソート | iSortImagesByの設定に従って画像をソート | 全表示時 |
| BR-58-003 | サムネイル生成 | showThumb.aspxでサムネイルを動的生成 | 画像表示時 |

### 計算ロジック

- 画像ソート順：
  - 0: ファイル名順
  - 1: 更新日時（新しい順）
  - 2: 更新日時（古い順）
  - 3: ランダム
  - 4: 作成日時（新しい順）
  - 5: 作成日時（古い順）

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| プレビュー | tblGallery | SELECT | ギャラリー設定を取得 |

### テーブル別操作詳細

#### tblGallery

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | WHERE iId = 指定ID AND iCustomerID = cId | ギャラリー設定を全カラム取得 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 権限エラー | ギャラリー権限がないユーザーがアクセス | ログイン画面へリダイレクト |
| - | フォルダ不存在 | 画像フォルダが存在しない | エラーメッセージ「does not exist」表示 |

### リトライ仕様

- 特になし

## トランザクション仕様

- SELECT処理のみのため、トランザクション管理不要

## パフォーマンス要件

- 画像フォルダ内のファイル数が多い場合、一覧表示に時間がかかる可能性あり
- サムネイル生成はshowThumb.aspxで動的に行われる

## セキュリティ考慮事項

- セカンドアドミンのギャラリー権限チェック
- 画像パスはユーザーファイルディレクトリ内に限定
- Lightbox用のrel属性はサニタイズ

## 備考

- includeNS=trueを設定してNivo Sliderのリソースを読み込み
- backsitePV=trueにより、ナビゲーションリンク（次へ/前へ）が非表示になる
- 修正ボタンで編集画面へ直接遷移可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ギャラリーのデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | gallery.asp | `asp/includes/gallery.asp` | cls_galleryクラスのプロパティとbuild関数の構造 |

**読解のコツ**: build関数（289-677行目）がギャラリー生成の中心処理。sTypeによって処理が大きく分岐する。

#### Step 2: エントリーポイントを理解する

プレビュー画面の処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_galleryPreview.asp | `asp/bs_galleryPreview.asp` | ギャラリープレビュー画面の全体フロー |

**主要処理フロー**:
1. **2行目**: includeNS=true設定（Nivo Slider用）
2. **4行目**: セキュリティチェック
3. **5行目**: cls_galleryインスタンス生成
4. **6行目**: backsitePV=true設定
5. **7行目**: gallery.build()でHTML生成、treatConstants()で定数処理
6. **7行目**: gDumpにHTML格納、画面出力

#### Step 3: ギャラリービルド処理の詳細を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | gallery.asp | `asp/includes/gallery.asp` | build関数（289-677行目）の詳細 |

**主要処理フロー**:
- **304-312行目**: FileSystemObjectでフォルダ・ファイル取得
- **319-341行目**: 画像ファイルソート処理
- **349-430行目**: 標準ギャラリー（サムネイル一覧）のHTML生成
- **581-608行目**: Nivo Slider（QS_gallery_NS）のHTML生成
- **609-633行目**: Simple Cycle（QS_gallery_SC）のHTML生成
- **635-651行目**: Simple Slideshow（QS_gallery_SS）のHTML生成

### プログラム呼び出し階層図

```
bs_galleryPreview.asp
    │
    ├─ begin.asp (include)
    │
    ├─ bs_security.asp (include)
    │      └─ logon.hasaccess メソッド
    │
    └─ cls_gallery クラス
           ├─ pick() メソッド（コンストラクタから自動呼び出し）
           │
           ├─ backsitePV プロパティ = true
           │
           └─ build() メソッド
                  │
                  ├─ FileSystemObject
                  │      ├─ GetFolder() - フォルダ取得
                  │      └─ files - ファイルコレクション
                  │
                  ├─ SortDictionary2() - ソート処理
                  │
                  ├─ ギャラリータイプ別HTML生成
                  │      ├─ 標準：サムネイル + Lightbox
                  │      ├─ QS_gallery_SS：Simple Slideshow
                  │      ├─ QS_gallery_SC：Simple Cycle
                  │      └─ QS_gallery_NS：Nivo Slider
                  │
                  └─ treatConstants() - 定数処理
```

### データフロー図

```
[入力]                    [処理]                         [出力]

iGalleryID ───────────▶ cls_gallery.pick() ─────────▶ ギャラリー設定
(暗号化パラメータ)         │
                          ▼
                    backsitePV = true
                          │
                          ▼
sPath ────────────────▶ FileSystemObject ──────────▶ 画像ファイル一覧
(画像フォルダ)              │
                          ▼
                    iSortImagesBy ソート
                          │
                          ▼
                    ギャラリータイプ判定
                          │
                    ┌─────┼─────┬─────┐
                    │     │     │     │
                 標準   SS    SC    NS
                    │     │     │     │
                    └─────┴─────┴─────┘
                          │
                          ▼
                    treatConstants() ────────────────▶ 画面表示
                                                       (ギャラリーHTML)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_galleryPreview.asp | `asp/bs_galleryPreview.asp` | ソース | ギャラリープレビュー画面のメインファイル |
| bs_galleryList.asp | `asp/bs_galleryList.asp` | ソース | ギャラリー一覧画面（遷移元） |
| bs_galleryEdit.asp | `asp/bs_galleryEdit.asp` | ソース | ギャラリー編集画面（修正ボタン遷移先） |
| gallery.asp | `asp/includes/gallery.asp` | ソース | ギャラリークラス定義（build関数） |
| showThumb.aspx | `asp/showThumb.aspx` | ソース | サムネイル動的生成 |
| begin.asp | `asp/begin.asp` | ソース | 共通インクルード・初期化処理 |
| bs_security.asp | `asp/bs_security.asp` | ソース | セキュリティチェック処理 |
