# 機能設計書 59-投票（Poll）一覧

## 概要

本ドキュメントは、QuickerSite CMSにおける投票（Poll）一覧機能の設計を記載する。登録済みのアンケート・投票機能の一覧表示と管理を行う機能である。

### 本機能の処理概要

投票（Poll）一覧機能は、管理者が設定した投票・アンケートの一覧を表示し、各投票へのアクセス・管理機能を提供する。投票の編集、コピー、埋め込みコードの取得が可能である。

**業務上の目的・背景**：ウェブサイト上でユーザーの意見を収集するための投票・アンケート機能は、サイト運営において重要なフィードバック収集手段である。本機能は、複数の投票を一元管理し、効率的にサイトへの埋め込みを行うための管理インターフェースを提供する。

**機能の利用シーン**：
- 設定済み投票の一覧を確認する場面
- 新規投票を追加するために作成画面へ遷移する場面
- 既存投票の設定を編集する場面
- 投票を複製して類似設定を作成する場面
- テンプレートへの埋め込みコードを取得する場面

**主要な処理内容**：
1. 顧客に紐づく投票一覧の取得と表示
2. 新規投票作成画面へのリンク提供
3. 各投票の編集画面へのリンク提供
4. 投票のコピー機能（CSRF対策付き）
5. 埋め込みコード（[QS_POLL:コード]形式）の表示

**関連システム・外部連携**：特になし（内部処理のみ）

**権限による制御**：セカンドアドミンの投票権限（secondAdmin.bPoll）を持つユーザーのみがアクセス可能

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 63 | 投票一覧 | 主画面 | 登録済み投票の一覧表示 |
| 64 | 投票編集 | 遷移先機能 | 新規投票作成画面への遷移 |

## 機能種別

データ一覧表示 / コピー操作（INSERT）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| iPollID | String（暗号化） | No | コピー対象投票ID | コピー操作時のみ必須 |
| QSSEC | String | コピー時 | CSRFトークン | コピー操作時に検証 |

### 入力データソース

- クエリパラメータ（コピー操作時のiPollID）
- セッション（顧客ID: cId）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| sQuestion | String | 投票質問文 |
| sCode | String | 埋め込み用コード |
| iID | Integer | 投票ID |
| 編集リンク | URL | 編集画面へのリンク |
| コピーリンク | URL | コピー操作用リンク |

### 出力先

- 画面表示（HTML）

## 処理フロー

### 処理シーケンス

```
1. セキュリティチェック
   └─ セカンドアドミンの投票権限を確認

2. コピー処理（iPollIDパラメータがある場合）
   └─ cls_pollインスタンス生成
   └─ copy()メソッドで投票を複製
   └─ 成功時は新しい投票の編集画面へリダイレクト

3. 投票一覧取得
   └─ customer.pollsで顧客の投票一覧を取得

4. 画面レンダリング
   └─ 新規作成リンクの表示
   └─ 投票がある場合はテーブル形式で一覧表示
   └─ 各投票に対して以下を表示：
       ├─ 投票質問文（編集画面へのリンク）
       ├─ コピーアイコン（確認ダイアログ付き）
       ├─ 埋め込みコード入力欄
       └─ 内部ID表示
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[セキュリティチェック]
    B --> C{コピーパラメータあり?}
    C -->|Yes| D[cls_poll生成]
    D --> E[copy メソッド実行]
    E --> F{コピー成功?}
    F -->|Yes| G[新投票編集画面へリダイレクト]
    F -->|No| H[一覧表示へ]
    C -->|No| H
    H --> I[customer.pollsで一覧取得]
    I --> J{投票あり?}
    J -->|Yes| K[テーブル形式で一覧表示]
    J -->|No| L[「投票なし」メッセージ表示]
    K --> M[終了]
    L --> M
    G --> M
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-59-001 | 顧客別投票管理 | 各顧客は自分の投票のみ参照・操作可能 | 全操作時 |
| BR-59-002 | コピー時コード初期化 | 投票をコピーする際、sCodeはランダム生成される | コピー操作時 |
| BR-59-003 | CSRF対策 | コピー操作時はCSRFトークン検証が必要 | コピー操作時 |

### 計算ロジック

- 特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 一覧表示 | tblPoll | SELECT | 顧客IDに紐づく投票一覧を取得 |
| コピー | tblPoll | INSERT | 新規投票レコードを作成 |

### テーブル別操作詳細

#### tblPoll（コピー操作時）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | sCode | GeneratePassword | ランダムコード生成 |
| INSERT | その他項目 | 元の投票と同じ値 | 質問・選択肢等を複製 |
| INSERT | iCustomerID | cId | 顧客IDを設定 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 権限エラー | 投票権限がないユーザーがアクセス | ログイン画面へリダイレクト |

### リトライ仕様

- 特になし

## トランザクション仕様

- コピー操作は単一のINSERT処理のため、暗黙的トランザクション

## パフォーマンス要件

- 一覧表示はページング無し（全件表示）
- 投票数が多い場合はレスポンス時間に影響

## セキュリティ考慮事項

- セカンドアドミンの投票権限チェック
- コピー操作時のCSRFトークン検証（QS_secCodeURL）
- 埋め込みコードはsanitize関数でエスケープ
- confirmダイアログでコピー操作の誤操作防止

## 備考

- 埋め込みコード形式：`[QS_POLL:コード]`
- この埋め込みコードをテンプレートに記述することで投票がページに表示される
- フィード一覧やギャラリー一覧とは異なり、プレビュー機能は一覧画面からは提供されない

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

投票のデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | poll.asp | `asp/includes/poll.asp` | cls_pollクラスの構造、プロパティ定義（2-17行目） |
| 1-2 | customer.asp | `asp/includes/customer.asp` | pollsプロパティで投票一覧を取得する仕組み |

**読解のコツ**: cls_pollはiCustomerIDで顧客に紐づく。Questionsディクショナリで選択肢を管理（最大12個）。

#### Step 2: エントリーポイントを理解する

一覧画面の処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_pollList.asp | `asp/bs_pollList.asp` | 投票一覧画面の全体フロー |

**主要処理フロー**:
1. **4行目**: セキュリティチェック（logon.hasaccess secondAdmin.bPoll）
2. **5-7行目**: コピー処理（copyPoll.copy()）
3. **8-9行目**: 投票一覧取得（customer.polls）
4. **9行目以降**: テーブル形式での一覧表示

#### Step 3: 投票クラスの詳細を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | poll.asp | `asp/includes/poll.asp` | pick関数（95-125行目）、save関数（147-186行目）、copy関数（381-387行目） |

**主要処理フロー**:
- **95-125行目**: pick関数でtblPollからデータ取得
- **381-387行目**: copy関数で投票複製（sCodeをランダム生成）

### プログラム呼び出し階層図

```
bs_pollList.asp
    │
    ├─ begin.asp (include)
    │
    ├─ bs_security.asp (include)
    │      └─ logon.hasaccess メソッド
    │
    ├─ cls_poll クラス
    │      ├─ copy() メソッド
    │      │      └─ save() メソッド
    │      └─ pick() メソッド
    │
    ├─ customer オブジェクト
    │      └─ polls プロパティ
    │             └─ Dictionary<iId, cls_poll>
    │
    └─ 各種ヘルパー関数
           ├─ getArtLink() - リンク生成
           ├─ getIcon() - アイコンリンク生成
           ├─ encrypt() - ID暗号化
           └─ sanitize() - XSS対策
```

### データフロー図

```
[入力]                    [処理]                         [出力]

セッション(cId) ─────▶ customer.polls ─────────────────▶ 投票一覧
                          │                              (HTML テーブル)
                          ▼
                    for each pollKey ──────────────────▶ 各投票行
                          │                              - 質問リンク
                          │                              - コピーアイコン
                          │                              - 埋め込みコード
                          ▼
iPollID ──────────▶ cls_poll.copy() ────────────────▶ 新投票作成
(コピー時)              │                              → 編集画面へリダイレクト
                        ▼
                    tblPoll INSERT
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_pollList.asp | `asp/bs_pollList.asp` | ソース | 投票一覧画面のメインファイル |
| bs_pollEdit.asp | `asp/bs_pollEdit.asp` | ソース | 投票編集画面（遷移先） |
| poll.asp | `asp/includes/poll.asp` | ソース | 投票クラス定義 |
| customer.asp | `asp/includes/customer.asp` | ソース | 顧客クラス（pollsプロパティ） |
| begin.asp | `asp/begin.asp` | ソース | 共通インクルード・初期化処理 |
| bs_security.asp | `asp/bs_security.asp` | ソース | セキュリティチェック処理 |
