# 機能設計書 6-SEO設定

## 概要

本ドキュメントは、QuickerSite CMSのSEO設定機能について記述する。

### 本機能の処理概要

本機能は、サイトのSEO（検索エンジン最適化）に関連するMETAタグ情報（keywords、description、copyright、author）を設定・管理するための機能を提供する。これらの設定は各ページに共通して適用され、検索エンジンによるサイトのインデックス化と表示に影響を与える。

**業務上の目的・背景**：検索エンジンからの流入はWebサイトのアクセス数に大きく影響する。METAタグの適切な設定は、検索結果での表示品質向上やクリック率改善に寄与する。本機能により、サイト全体のSEO設定を一元管理できる。

**機能の利用シーン**：
- サイト新規構築時のSEO初期設定
- SEO対策の見直しに伴うキーワード・説明文の更新
- 検索エンジン対応のためのMETAタグ最適化
- ブランディングに基づくコピーライト・著作者情報の設定

**主要な処理内容**：
1. META keywords の設定（サイト全体のキーワード）
2. META description の設定（サイトの説明文）
3. META copyright の設定（著作権情報）
4. META author の設定（ウェブマスター名）
5. ヘッダー追加情報の設定

**関連システム・外部連携**：なし

**権限による制御**：secondAdmin.bSetupGeneral 権限が必要

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 86 | 変数設定 | 主画面 | SEO関連METAタグの設定 |
| 136 | 顧客詳細 | 参照画面 | クライアント詳細情報の表示 |
| 137 | 顧客編集 | 参照画面 | サイト顧客の編集 |

## 機能種別

設定管理 / SEO設定

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| keywords | String | No | META keywords（検索キーワード） | 最大2048文字 |
| sDescription | String | No | META description（サイト説明） | 制限なし |
| copyRight | String | No | META copyright（著作権表示） | 最大254文字 |
| webmaster | String | No | META author（ウェブマスター名） | 最大255文字 |
| webmasterEmail | String | No | ウェブマスターメールアドレス | 最大254文字 |
| sHeader | String | No | ヘッダー追加情報（HTMLタグ直接記述可） | 制限なし |

### 入力データソース

- 画面入力（設定フォーム bs_admin.asp）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| customer.keywords | String | META keywords |
| customer.sDescription | String | META description |
| customer.copyRight | String | META copyright |
| customer.webmaster | String | META author |
| customer.webmasterEmail | String | ウェブマスターメールアドレス |
| customer.sHeader | String | ヘッダー追加情報 |

### 出力先

- データベース（tblCustomer）
- フロントサイトHTMLヘッダー（METAタグとして出力）

## 処理フロー

### 処理シーケンス

```
1. 基本設定画面アクセス
   └─ secondAdmin.bSetupGeneral権限チェック

2. 現在の設定値読み込み
   └─ customer オブジェクトから各SEO設定値を取得

3. フォーム表示
   └─ keywords、sDescription、copyRight、webmaster等をフォームに表示

4. 保存処理（btnaction="saveAdmin"）
   └─ CSRF検証
   └─ 各SEOフォーム値の取得
   └─ customer.save()
   └─ メニューキャッシュクリア
```

### フローチャート

```mermaid
flowchart TD
    A[基本設定画面] --> B{権限チェック}
    B -->|権限なし| C[bs_default.aspへリダイレクト]
    B -->|権限あり| D[現在のSEO設定値読み込み]
    D --> E[フォーム表示]
    E --> F{保存ボタン押下}
    F -->|No| E
    F -->|Yes| G[CSRF検証]
    G --> H[SEO設定値取得]
    H --> I[keywords取得]
    I --> J[sDescription取得]
    J --> K[copyRight取得]
    K --> L[webmaster取得]
    L --> M[sHeader取得]
    M --> N[customer.save]
    N --> O[メニューキャッシュクリア]
    O --> P[成功メッセージ表示]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | キーワード任意 | META keywordsは任意入力 | 常時 |
| BR-02 | 説明文任意 | META descriptionは任意入力 | 常時 |
| BR-03 | ヘッダー直接記述 | sHeaderはHTMLタグを直接記述可能 | 常時 |
| BR-04 | 全ページ適用 | SEO設定はサイト全体に適用される | 常時 |

### 計算ロジック

- 特になし（入力値をそのまま保存）

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| SEO設定読み込み | tblCustomer | SELECT | 現在のSEO設定値取得 |
| SEO設定保存 | tblCustomer | UPDATE | SEO設定値更新 |

### テーブル別操作詳細

#### tblCustomer

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | keywords | iId = cId | キーワード取得 |
| SELECT | sDescription | iId = cId | 説明文取得 |
| SELECT | copyRight | iId = cId | コピーライト取得 |
| SELECT | webmaster | iId = cId | ウェブマスター名取得 |
| SELECT | webmasterEmail | iId = cId | メールアドレス取得 |
| SELECT | sHeader | iId = cId | ヘッダー情報取得 |
| UPDATE | keywords | 入力値 | キーワード更新 |
| UPDATE | sDescription | 入力値 | 説明文更新 |
| UPDATE | copyRight | 入力値 | コピーライト更新 |
| UPDATE | webmaster | 入力値 | ウェブマスター名更新 |
| UPDATE | webmasterEmail | 入力値 | メールアドレス更新 |
| UPDATE | sHeader | 入力値 | ヘッダー情報更新 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| （なし） | - | SEO設定項目は全て任意のためバリデーションエラーは発生しない | - |

### リトライ仕様

- エラー時は同一画面で再入力可能

## トランザクション仕様

- 保存処理: 単一UPDATEで完結

## パフォーマンス要件

- 設定保存: 即座に完了
- メニューキャッシュクリア: 即座に完了

## セキュリティ考慮事項

- CSRF対策トークン検証
- secondAdmin.bSetupGeneral 権限チェック
- sHeaderは直接HTMLを記述可能なため、信頼できる管理者のみがアクセス可能

## 備考

- SEO設定はサイト基本設定画面（No.5）と同一画面で管理される
- 各ページ個別のSEO設定（sKeywords、sDescription）はページ編集機能（No.9）で行う
- Google Analytics設定は同一画面に含まれるが、機能としては別機能（No.7）として扱う

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

SEO設定のデータ構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | customer.asp | `asp/includes/customer.asp` | cls_customerクラスのSEO関連プロパティ（6-8行目） |

**読解のコツ**: cls_customerクラスで以下のプロパティがSEO設定に関連する。
- `keywords`: META keywords
- `sDescription`: META description
- `copyRight`: META copyright
- `webmaster`: META author
- `webmasterEmail`: ウェブマスターメール
- `sHeader`: ヘッダー追加情報

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_admin.asp | `asp/bs_admin.asp` | 基本設定画面のメインファイル（11行） |

**主要処理フロー**:
1. **4行目**: secondAdmin.bSetupGeneral 権限チェック
2. **10行目**: フォーム表示（keywords、sDescription、copyRight等のinputタグ）

**SEO関連フォーム要素**:
- `<input name="keywords" ... maxlength=2048 />` - キーワード入力
- `<textarea name="sDescription" ...>` - 説明文入力
- `<input name="copyRight" ... maxlength=254 />` - コピーライト入力
- `<input name="webmaster" ... maxlength=255 />` - ウェブマスター名入力
- `<textarea name="sHeader" ...>` - ヘッダー追加情報入力

#### Step 3: 処理ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_process.asp | `asp/bs_process.asp` | saveAdmin処理 |

**主要処理フロー**:
- **103-126行目**: saveAdmin処理
- **109行目**: `customer.sDescription = Request.Form("sDescription")`
- **113行目**: `customer.copyRight = Request.Form("copyRight")`
- **114行目**: `customer.keywords = Request.Form("keywords")`
- **116行目**: `customer.sHeader = Request.Form("sHeader")`
- **119行目**: `customer.webmaster = Request.Form("webmaster")`
- **120行目**: `customer.webmasterEmail = Request.Form("webmasterEmail")`
- **122-126行目**: save()とキャッシュクリア

#### Step 4: データベース保存を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | customer.asp | `asp/includes/customer.asp` | save関数のSEO関連カラム更新 |

**主要処理フロー**:
- **364行目**: `rs("sDescription") = sDescription`
- **367行目**: `rs("copyRight") = copyRight`
- **371行目**: `rs("keywords") = keywords`
- **370行目**: `rs("webmaster") = webmaster`
- **368行目**: `rs("webmasterEmail") = webmasterEmail`
- **392行目**: `rs("sHeader") = sHeader`

### プログラム呼び出し階層図

```
bs_admin.asp
    │
    ├─ begin.asp（インクルード）
    │      └─ includes/customer.asp（cls_customerクラス）
    │
    ├─ bs_security.asp（認証・権限チェック）
    │      └─ secondAdmin.bSetupGeneral
    │
    ├─ bs_process.asp（処理分岐）
    │      │
    │      └─ btnaction = "saveAdmin"
    │             ├─ CSRF検証（checkCSRF）
    │             ├─ SEO設定値取得
    │             │    ├─ keywords
    │             │    ├─ sDescription
    │             │    ├─ copyRight
    │             │    ├─ webmaster
    │             │    ├─ webmasterEmail
    │             │    └─ sHeader
    │             ├─ customer.save()
    │             └─ clearMenuCache()
    │
    └─ フォーム表示（SEO設定入力欄）
```

### データフロー図

```
[入力]               [処理]                    [出力]

フォーム入力 ────▶ Request.Form取得
(SEO設定)               │
                        │
   keywords ────────────┼──▶ customer.keywords
   sDescription ────────┼──▶ customer.sDescription
   copyRight ───────────┼──▶ customer.copyRight
   webmaster ───────────┼──▶ customer.webmaster
   webmasterEmail ──────┼──▶ customer.webmasterEmail
   sHeader ─────────────┼──▶ customer.sHeader
                        │
                        ▼
                  customer.save()
                        │
                        ▼
                  tblCustomer
                  (UPDATE)
                        │
                        ▼
              HTMLヘッダーにMETAタグ出力
              <meta name="keywords" ... />
              <meta name="description" ... />
              <meta name="copyright" ... />
              <meta name="author" ... />
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_admin.asp | `asp/bs_admin.asp` | ソース | 基本設定画面メインファイル |
| bs_process.asp | `asp/bs_process.asp` | ソース | 処理分岐ロジック（saveAdmin） |
| customer.asp | `asp/includes/customer.asp` | ソース | cls_customerクラス定義 |
| bs_security.asp | `asp/bs_security.asp` | ソース | 認証・権限チェック |
| header.asp | `asp/includes/header.asp` | ソース | METAタグ出力処理 |
