# 機能設計書 61-ゲストブック一覧

## 概要

本ドキュメントは、QuickerSite CMSの管理画面におけるゲストブック一覧機能の設計を定義する。

### 本機能の処理概要

ゲストブック一覧機能は、サイト上に設置可能なゲストブック（掲示板形式のコメント機能）を一覧表示し、各ゲストブックの管理操作を提供する機能である。

**業務上の目的・背景**：ウェブサイトにおいてユーザーからのコメントやメッセージを収集するためのゲストブック機能を管理する必要がある。管理者は複数のゲストブックを作成し、それぞれ異なるページやセクションに配置することができる。本機能は、作成済みのゲストブックを一覧表示し、各種管理操作へのアクセスを提供することで、効率的なゲストブック管理を実現する。

**機能の利用シーン**：
- 新規ゲストブックを作成する際に一覧画面から作成画面へ遷移
- 既存ゲストブックの設定を編集する際の起点画面として使用
- ゲストブック投稿の管理画面への遷移
- 投稿データをExcel形式でエクスポートする際のアクセス
- ゲストブックのコピー（複製）操作

**主要な処理内容**：
1. 顧客IDに紐づくゲストブック一覧のデータベースからの取得
2. 各ゲストブックの名前、コード、IDの表示
3. ゲストブック複製機能（copyアクション）の実行
4. 編集画面、投稿管理画面、Excelエクスポートへのリンク生成
5. ページ埋め込み用コード（[QS_GUESTBOOK:コード名]）の表示

**関連システム・外部連携**：特になし（CMS内部機能）

**権限による制御**：セカンドアドミン権限のbGuestbookフラグによりアクセス制御される。bGuestbook権限がないセカンドアドミンはアクセス不可。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 59 | ゲストブック一覧 | 主画面 | 登録済みゲストブックの一覧表示 |
| 60 | ゲストブック編集 | 遷移先画面 | 新規ゲストブック作成画面への遷移 |
| 61 | エントリー管理 | 遷移先画面 | ゲストブック投稿の管理画面への遷移 |
| 62 | Excel出力 | 遷移先画面 | ゲストブックデータのExcel出力 |

## 機能種別

データ一覧表示 / ナビゲーション

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| iGBID | String (暗号化) | No | コピー対象ゲストブックID（クエリストリング） | decrypt後にisNumeriekでチェック |
| QS_secCode | String | No | CSRFトークン（コピー操作時） | セキュリティコードとして検証 |

### 入力データソース

- データベーステーブル: tblGuestbook
- セッション: 顧客ID（cId）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| sName | String | ゲストブック名 |
| sCode | String | 埋め込みコード |
| iId | Integer | ゲストブックID |
| 編集リンク | HTML | 編集画面へのリンク |
| 投稿管理リンク | HTML | 投稿一覧画面へのリンク |
| Excelエクスポートリンク | HTML | Excel出力画面へのリンク |
| 埋め込みコード | Text | [QS_GUESTBOOK:コード名]形式 |

### 出力先

HTML画面（管理画面内）

## 処理フロー

### 処理シーケンス

```
1. アクセス権限チェック
   └─ secondAdmin.bGuestbook権限の確認
2. コピーリクエストの処理
   └─ iGBIDパラメータがある場合、ゲストブックを複製
   └─ 複製成功時は新規ゲストブックの編集画面へリダイレクト
3. ゲストブック一覧の取得
   └─ customer.guestbooksプロパティでDictionary形式で取得
4. 一覧の表示
   └─ 各ゲストブックについてリンクとコードを生成
5. 画面レンダリング
   └─ ヘッダー、一覧テーブル、フッターの出力
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{bGuestbook権限あり?}
    B -->|No| C[アクセス拒否]
    B -->|Yes| D{iGBIDパラメータあり?}
    D -->|Yes| E[ゲストブックコピー処理]
    E --> F{コピー成功?}
    F -->|Yes| G[編集画面へリダイレクト]
    F -->|No| H[一覧取得処理]
    D -->|No| H
    H --> I{ゲストブックあり?}
    I -->|Yes| J[一覧テーブル表示]
    I -->|No| K[「ゲストブックがありません」表示]
    J --> L[終了]
    K --> L
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | 権限チェック | セカンドアドミンはbGuestbook権限が必要 | 全アクセス時 |
| BR-002 | コピー時コード生成 | コピー時は新しいユニークなコードを自動生成 | コピー操作時 |
| BR-003 | 顧客分離 | 自顧客のゲストブックのみ表示 | 一覧表示時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 一覧表示 | tblGuestbook | SELECT | 顧客IDでフィルタして取得 |
| コピー | tblGuestbook | INSERT | 新規レコード作成 |

### テーブル別操作詳細

#### tblGuestbook

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | iCustomerID = cId | 顧客IDでフィルタ、sCodeでソート |
| INSERT（コピー時） | 全項目 | 元レコードをコピー、sCodeは新規生成 | GeneratePassword関数でコード生成 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 権限エラー | bGuestbook権限なし | 管理者ホーム画面へリダイレクト |
| - | データなし | ゲストブック未登録 | 「ゲストブックがありません」メッセージ表示 |

### リトライ仕様

リトライ処理なし

## トランザクション仕様

コピー処理はADOのデフォルトトランザクション（自動コミット）を使用

## パフォーマンス要件

- 一覧表示: 1秒以内
- コピー処理: 2秒以内

## セキュリティ考慮事項

- セカンドアドミン権限によるアクセス制御
- CSRFトークン（QS_secCode）によるコピー操作の保護
- IDパラメータの暗号化（encrypt/decrypt関数）
- 出力値のサニタイズ（sanitize関数）
- JavaScript確認ダイアログによる誤操作防止

## 備考

- ゲストブックはページ内に[QS_GUESTBOOK:コード名]タグを記述することで埋め込み可能
- 埋め込みコードは入力フィールドとして表示され、クリックで選択可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、ゲストブックのデータモデルを理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | guestbook.asp | `asp/includes/guestbook.asp` | cls_guestbookクラスの構造、プロパティ定義（2-33行目） |

**読解のコツ**: VBScriptのクラス定義では、PublicプロパティとPrivate Subを確認する。Class_Initializeでデフォルト値と初期化処理を理解できる。

#### Step 2: エントリーポイントを理解する

処理の起点となるASPファイルを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_gbList.asp | `asp/bs_gbList.asp` | 一覧表示のメイン処理（1-11行目） |

**主要処理フロー**:
1. **4行目**: セキュリティチェック（logon.hasaccess secondAdmin.bGuestbook）
2. **5-7行目**: コピー処理（cls_guestbook.copy()メソッド呼び出し）
3. **8-9行目**: ゲストブック一覧取得（customer.guestbooksプロパティ）
4. **9-10行目**: 各ゲストブックのループ表示とリンク生成

#### Step 3: データアクセス層を理解する

データベースアクセスの詳細を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | customer.asp | `asp/includes/customer.asp` | guestbooksプロパティの実装（930-945行目） |
| 3-2 | guestbook.asp | `asp/includes/guestbook.asp` | Pickメソッド（45-70行目）、copyメソッド（152-158行目） |

**主要処理フロー**:
- **930-945行目（customer.asp）**: guestbooks関数でDictionary作成、tblGuestbookからSELECT
- **152-158行目（guestbook.asp）**: copyメソッドでiIdをnullにしてsaveを呼び出すことで複製を実現

### プログラム呼び出し階層図

```
bs_gbList.asp
    │
    ├─ bs_security.asp
    │      └─ logon.hasaccess (権限チェック)
    │
    ├─ cls_guestbook.copy()
    │      └─ GeneratePassword() (新規コード生成)
    │      └─ save() (データベース保存)
    │
    └─ customer.guestbooks
           └─ cls_guestbook.pick() (各レコード取得)
```

### データフロー図

```
[入力]               [処理]                    [出力]

クエリストリング ───▶ bs_gbList.asp ───▶ HTML一覧画面
(iGBID)                    │
                           ▼
セッション(cId) ───▶ customer.guestbooks ───▶ Dictionary
                           │
                           ▼
                    tblGuestbook ───▶ 各ゲストブック情報
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_gbList.asp | `asp/bs_gbList.asp` | ソース | ゲストブック一覧画面のメイン処理 |
| guestbook.asp | `asp/includes/guestbook.asp` | ソース | cls_guestbookクラス定義 |
| customer.asp | `asp/includes/customer.asp` | ソース | guestbooksプロパティ（顧客クラス） |
| bs_security.asp | `asp/bs_security.asp` | ソース | 権限チェック処理 |
| bs_header.asp | `asp/bs_header.asp` | テンプレート | 管理画面ヘッダー |
| bs_gbBack.asp | `asp/bs_gbBack.asp` | テンプレート | 戻るリンク表示 |
| header.asp | `asp/includes/header.asp` | テンプレート | HTMLヘッダー |
| footer.asp | `asp/includes/footer.asp` | テンプレート | HTMLフッター |
