# 機能設計書 62-ゲストブック作成・編集

## 概要

本ドキュメントは、QuickerSite CMSの管理画面におけるゲストブック作成・編集機能の設計を定義する。

### 本機能の処理概要

ゲストブック作成・編集機能は、サイト上に設置するゲストブック（コメント投稿機能）の新規作成および既存ゲストブックの設定変更を行う機能である。

**業務上の目的・背景**：ウェブサイト運営者がサイト訪問者からのコメントやメッセージを収集するためのゲストブックを作成・管理する必要がある。ゲストブックは表示テンプレート、投稿フォーム、承認ルール、通知設定など多くのカスタマイズ項目を持っており、サイトのデザインや運用ポリシーに合わせた柔軟な設定が求められる。本機能はこれらの設定を一元的に管理し、ゲストブックの作成から運用設定までをサポートする。

**機能の利用シーン**：
- 新規サイトにゲストブック機能を追加する際の初期設定
- 既存ゲストブックのテンプレートデザイン変更
- 投稿承認ルールや通知設定の変更
- スパム対策としてのIPブロック設定
- ゲストブックの公開期間設定
- 不要になったゲストブックの削除

**主要な処理内容**：
1. ゲストブックの基本情報（名前、コード、公開期間）の設定
2. 表示テンプレート（全体、フォーム、エラー、アイテム、返信）の編集
3. 投稿承認ルール（要承認/自動承認）の設定
4. メール通知設定
5. スパム対策（IPブロックリスト）の管理
6. データベースへの保存・更新処理
7. ゲストブックの削除処理
8. 使用箇所の検索表示

**関連システム・外部連携**：メール通知機能（投稿時の管理者通知）

**権限による制御**：セカンドアドミン権限のbGuestbookフラグによりアクセス制御される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 60 | ゲストブック編集 | 主画面 | ゲストブックの作成・設定 |
| 59 | ゲストブック一覧 | 参照画面 | 戻り先画面 |

## 機能種別

CRUD操作（Create/Read/Update/Delete）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| iGBID | String (暗号化) | No | ゲストブックID（編集時） | decrypt後にisNumeriek |
| sName | String | Yes | ゲストブック名 | 最大50文字 |
| sCode | String | Yes | 埋め込みコード | 最大50文字、空白除去、小文字変換 |
| dOnlinefrom | Date | No | 公開開始日 | 日付フォーマット検証 |
| dOnlineUntil | Date | No | 公開終了日 | 日付フォーマット検証 |
| sFullTemplate | Text | No | 全体テンプレートHTML | - |
| sTemplateForm | Text | No | フォームテンプレートHTML | - |
| sTemplateErr | Text | No | エラーテンプレートHTML | - |
| sTemplate | Text | No | アイテムテンプレートHTML | - |
| sTemplateReply | Text | No | 返信テンプレートHTML | - |
| sSortby | String | No | 表示順（recentfirst/空文字） | - |
| iPaging | Integer | No | ページあたり表示件数 | 5-500の範囲 |
| bRequireValidation | Boolean | No | 承認必要フラグ | true/false |
| sWarningApproval | String | No | 承認待ちメッセージ | 最大255文字 |
| sEmail | Email | No | 通知先メールアドレス | メール形式検証 |
| sBlockIP | Text | No | ブロックIPリスト（改行区切り） | - |
| btnaction | String | Yes | アクション（保存/削除） | l("save") または l("delete") |
| postBack | Boolean | - | ポストバックフラグ | - |

### 入力データソース

- 画面入力フォーム
- データベーステーブル: tblGuestbook（編集時の初期値）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 保存成功 | - | 一覧画面へリダイレクト |
| 削除成功 | - | 一覧画面へリダイレクト |
| バリデーションエラー | Message | エラーメッセージ表示 |
| 使用箇所一覧 | HTML | ゲストブック埋め込み箇所の検索結果 |

### 出力先

HTML画面（管理画面内）、データベース

## 処理フロー

### 処理シーケンス

```
1. アクセス権限チェック
   └─ secondAdmin.bGuestbook権限の確認
2. リクエストパラメータ取得
   └─ iGBIDによる既存データ読み込み（編集時）
3. ポストバック処理判定
   └─ postBackフラグの確認
4. アクション分岐
   ├─ 保存アクション
   │   └─ CSRFチェック
   │   └─ リクエスト値取得
   │   └─ バリデーション（sCode、sName必須チェック）
   │   └─ データベース保存
   │   └─ 成功時：一覧画面へリダイレクト
   └─ 削除アクション
       └─ CSRFチェック
       └─ 関連投稿データ削除
       └─ ゲストブック削除
       └─ 一覧画面へリダイレクト
5. 画面表示
   └─ フォーム表示
   └─ 使用箇所検索・表示（編集時のみ）
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{bGuestbook権限あり?}
    B -->|No| C[アクセス拒否]
    B -->|Yes| D[ゲストブックデータ読込]
    D --> E{postBack?}
    E -->|Yes| F{btnaction}
    F -->|保存| G[CSRFチェック]
    G --> H[リクエスト値取得]
    H --> I{バリデーションOK?}
    I -->|Yes| J[データベース保存]
    J --> K[一覧画面へリダイレクト]
    I -->|No| L[エラー表示]
    F -->|削除| M[CSRFチェック]
    M --> N[関連データ削除]
    N --> O[ゲストブック削除]
    O --> K
    E -->|No| L
    L --> P[フォーム表示]
    P --> Q{既存データあり?}
    Q -->|Yes| R[使用箇所検索表示]
    Q -->|No| S[終了]
    R --> S
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | 必須チェック | sCode、sNameは入力必須 | 保存時 |
| BR-002 | コード形式 | sCodeは空白除去・小文字変換して保存 | 保存時 |
| BR-003 | コード大文字保存 | データベースへはucase(sCode)で大文字保存 | 保存時 |
| BR-004 | 削除時連動削除 | ゲストブック削除時は関連投稿も削除 | 削除時 |
| BR-005 | デフォルト値 | 新規作成時はデフォルトテンプレートを設定 | 新規作成時 |
| BR-006 | 通知メール初期値 | 通知メールはcustomer.webmasterEmailを初期値 | 新規作成時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 新規作成 | tblGuestbook | INSERT | 新規ゲストブックレコード作成 |
| 編集 | tblGuestbook | UPDATE | 既存レコード更新 |
| 削除 | tblGuestbookItem | DELETE | 関連投稿全削除 |
| 削除 | tblGuestbook | DELETE | ゲストブック削除 |
| 読込 | tblGuestbook | SELECT | 編集用データ取得 |

### テーブル別操作詳細

#### tblGuestbook

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT/UPDATE | sCode | ucase(入力値) | 大文字で保存 |
| INSERT/UPDATE | sName | 入力値 | - |
| INSERT/UPDATE | dOnlineFrom | 入力日付 | DatePicker形式から変換 |
| INSERT/UPDATE | dOnlineUntil | 入力日付 | DatePicker形式から変換 |
| INSERT/UPDATE | sTemplate | 入力HTML | アイテムテンプレート |
| INSERT/UPDATE | sTemplateForm | 入力HTML | フォームテンプレート |
| INSERT/UPDATE | iCustomerID | cId | 顧客ID |
| INSERT/UPDATE | bRequireValidation | 入力Boolean | - |
| INSERT/UPDATE | sEmail | 入力値 | - |
| INSERT/UPDATE | sFullTemplate | 入力HTML | 全体テンプレート |
| INSERT/UPDATE | sWarningApproval | 入力値 | - |
| INSERT/UPDATE | sBlockIP | 入力値 | 改行区切り |
| INSERT/UPDATE | sTemplateReply | 入力HTML | 返信テンプレート |
| INSERT/UPDATE | sSortBy | 入力値 | - |
| INSERT/UPDATE | sTemplateErr | 入力HTML | エラーテンプレート |
| INSERT/UPDATE | iPaging | 入力数値 | - |
| DELETE | - | iId条件 | ゲストブック削除 |

#### tblGuestbookItem

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | - | iGuestbookID条件 | 関連投稿全削除 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| err_mandatory | 必須エラー | sCode未入力 | エラーメッセージ表示、再入力 |
| err_mandatory | 必須エラー | sName未入力 | エラーメッセージ表示、再入力 |
| - | 権限エラー | bGuestbook権限なし | アクセス拒否 |

### リトライ仕様

バリデーションエラー時は画面再表示、ユーザーによる再入力を促す

## トランザクション仕様

ADOのデフォルトトランザクション（自動コミット）を使用。削除時の関連データ削除とゲストブック削除は別クエリで実行。

## パフォーマンス要件

- 保存処理: 2秒以内
- 削除処理: 3秒以内
- 使用箇所検索: 5秒以内（サイト規模に依存）

## セキュリティ考慮事項

- セカンドアドミン権限によるアクセス制御
- CSRFトークン（checkCSRF()）による保存・削除操作の保護
- IDパラメータの暗号化（encrypt/decrypt関数）
- フォーム入力値のquotRep関数によるエスケープ
- HTML入力は許可（テンプレート編集のため）
- JavaScript確認ダイアログによる削除誤操作防止

## 備考

- テンプレートでは以下のプレースホルダーが使用可能:
  - {ITEMS}: 投稿一覧
  - {FORM}: 投稿フォーム
  - {PAGING}: ページネーション
  - {AUTHOR}: 投稿者名
  - {MESSAGE}: メッセージ本文
  - {TIMESTAMP}: 投稿日時
  - {REPLY}: 管理者返信
  - {SMILEYS}: スマイリー選択
  - {CAPTCHA}: CAPTCHA画像
  - {ERROR}: エラーメッセージ
  - {TEMPLATEERROR}: エラーテンプレート
  - {TEMPLATEREPLY}: 返信テンプレート
  - {WARNINGAPPROVAL}: 承認待ちメッセージ
- 使用箇所検索はcls_fullSearchクラスで正規表現検索を実行

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、ゲストブックのデータモデルとプロパティを理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | guestbook.asp | `asp/includes/guestbook.asp` | cls_guestbookクラスのプロパティ定義（2-18行目）とデフォルト値設定（19-33行目） |

**読解のコツ**: Class_Initializeサブルーチンでデフォルトテンプレートが設定されている。sTemplateForm、sTemplate、sTemplateReplyなどの複雑なHTML文字列を確認することで、プレースホルダーの仕様を理解できる。

#### Step 2: エントリーポイントを理解する

処理の起点となるASPファイルを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_gbEdit.asp | `asp/bs_gbEdit.asp` | メイン処理フロー（1-38行目） |

**主要処理フロー**:
1. **4行目**: セキュリティチェック（logon.hasaccess secondAdmin.bGuestbook）
2. **5-6行目**: cls_guestbookインスタンス生成、自動でpick処理実行
3. **7-10行目**: postBackフラグ確認とリクエスト値取得
4. **11-21行目**: btnactionによる分岐（保存/削除）
5. **13行目**: checkCSRF()によるCSRFチェック
6. **14-16行目**: 保存処理、成功時リダイレクト
7. **18-21行目**: 削除処理
8. **22-25行目**: フォームHTML生成
9. **26-36行目**: 使用箇所検索表示

#### Step 3: データ永続化層を理解する

保存・削除処理の詳細を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | guestbook.asp | `asp/includes/guestbook.asp` | check()メソッド（71-83行目）、save()メソッド（84-125行目） |
| 3-2 | guestbook.asp | `asp/includes/guestbook.asp` | getRequestValues()メソッド（126-142行目） |
| 3-3 | guestbook.asp | `asp/includes/guestbook.asp` | remove()メソッド（143-151行目） |

**主要処理フロー**:
- **71-83行目**: check()でsCode、sNameの必須チェック
- **84-125行目**: save()でINSERT/UPDATE分岐、ADO Recordsetで保存
- **101行目**: sCodeをucaseで大文字変換して保存
- **143-151行目**: remove()で関連投稿削除後にゲストブック削除

### プログラム呼び出し階層図

```
bs_gbEdit.asp
    │
    ├─ bs_security.asp
    │      └─ logon.hasaccess (権限チェック)
    │
    ├─ cls_guestbook (インスタンス生成)
    │      └─ Class_Initialize
    │             └─ pick() (iGBIDから既存データ読込)
    │
    ├─ guestbook.getRequestValues()
    │      └─ Request.Form値の取得・変換
    │
    ├─ guestbook.save()
    │      └─ check() (バリデーション)
    │      └─ db.GetDynamicRS (ADO Recordset)
    │      └─ rs.AddNew / rs.Update
    │
    ├─ guestbook.remove()
    │      └─ DELETE tblGuestbookItem
    │      └─ DELETE tblGuestbook
    │
    └─ cls_fullSearch.search()
           └─ 正規表現でサイト内検索
```

### データフロー図

```
[入力]               [処理]                    [出力]

フォームPOST ───▶ bs_gbEdit.asp ───▶ 一覧画面（成功時）
                       │
                       ▼
               getRequestValues() ───▶ cls_guestbookプロパティ
                       │
                       ▼
               check() + save() ───▶ tblGuestbook（INSERT/UPDATE）
                       │
                       ▼
               cls_fullSearch ───▶ 使用箇所一覧（画面表示）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_gbEdit.asp | `asp/bs_gbEdit.asp` | ソース | ゲストブック編集画面のメイン処理 |
| guestbook.asp | `asp/includes/guestbook.asp` | ソース | cls_guestbookクラス定義 |
| bs_security.asp | `asp/bs_security.asp` | ソース | 権限チェック処理 |
| bs_gbBack.asp | `asp/bs_gbBack.asp` | テンプレート | 戻るリンク表示 |
| urlenCodeJS.asp | `asp/includes/urlenCodeJS.asp` | ソース | URL/JavaScript文字列エンコード |
| header.asp | `asp/includes/header.asp` | テンプレート | HTMLヘッダー |
| footer.asp | `asp/includes/footer.asp` | テンプレート | HTMLフッター |
| fullSearch.asp | `asp/includes/fullSearch.asp` | ソース | サイト内検索クラス |
