# 機能設計書 64-ゲストブックExcel出力

## 概要

本ドキュメントは、QuickerSite CMSの管理画面におけるゲストブックExcel出力機能の設計を定義する。

### 本機能の処理概要

ゲストブックExcel出力機能は、指定されたゲストブックに投稿された全エントリをExcel形式（.xls）のファイルとしてエクスポートする機能である。

**業務上の目的・背景**：ゲストブックに蓄積された投稿データを、集計・分析・バックアップ・外部システムへの連携などの目的で活用するために、汎用的なスプレッドシート形式でのエクスポートが求められる。特にマーケティング分析、ユーザーフィードバックの集計、データ移行などの業務において、Excel形式でのデータ出力は不可欠である。

**機能の利用シーン**：
- ゲストブック投稿の定期的なバックアップ
- マーケティング部門へのユーザーフィードバック共有
- 投稿データの統計分析・レポート作成
- 他システムへのデータ移行
- 監査目的でのログ保存

**主要な処理内容**：
1. 指定ゲストブックIDに紐づく全投稿をデータベースから取得
2. HTMLテーブル形式でデータを構築
3. cls_excelfileクラスによるExcelファイル生成
4. 生成されたファイルへのリダイレクト（ダウンロード開始）

**関連システム・外部連携**：ファイルシステム（Excelファイルの一時保存）

**権限による制御**：セカンドアドミン権限（bs_security.asp）によるアクセス制御。具体的なbGuestbook権限チェックは省略されているが、bs_security.aspのincludeにより基本的な認証が適用される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 62 | Excel出力 | 主機能 | ゲストブック投稿のExcel形式エクスポート |
| 59 | ゲストブック一覧 | 参照画面 | Excelエクスポートへのリンク元 |

## 機能種別

帳票出力 / データエクスポート

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| iGBID | String (暗号化) | Yes | ゲストブックID（クエリストリング） | decrypt後にconvertGetalで数値変換 |

### 入力データソース

- クエリストリング: iGBID
- データベーステーブル: tblGuestbookItem

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| iId | Integer | 投稿ID（第1カラム） |
| iGuestbookID | Integer | ゲストブックID（第2カラム） |
| sValue | Text | 投稿メッセージ（第3カラム） |
| sMessageBy | String | 投稿者名（第4カラム） |
| sMessageByEmail | String | 投稿者メール（第5カラム） |
| dCreatedTS | DateTime | 作成日時（第6カラム） |

### 出力先

- ファイル: {userfiles}/IEExport_{ランダム文字列}.xls
- ブラウザ: ファイルダウンロードとしてリダイレクト

## 処理フロー

### 処理シーケンス

```
1. セキュリティチェック
   └─ bs_security.aspによる認証確認
2. クエリストリング取得
   └─ iGBIDをdecrypt→convertGetalで数値化
3. データベースクエリ実行
   └─ tblGuestbookItemからSELECT（iId昇順）
4. HTMLテーブル構築
   └─ レコードセットをループしてHTML生成
5. Excelファイル生成
   └─ cls_excelfile.export()メソッド呼び出し
6. リダイレクト
   └─ 生成ファイルへブラウザリダイレクト
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[セキュリティチェック]
    B --> C[iGBIDパラメータ取得・復号]
    C --> D[SQLクエリ構築]
    D --> E[データベースSELECT実行]
    E --> F{レコードあり?}
    F -->|Yes| G[HTMLテーブル構築ループ]
    G --> H{EOF?}
    H -->|No| I[行データ追加]
    I --> J[次レコードへ]
    J --> H
    H -->|Yes| K[cls_excelfileインスタンス生成]
    F -->|No| K
    K --> L[export実行]
    L --> M[redirectLink実行]
    M --> N[終了/ダウンロード開始]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | 全件出力 | ページングなしで全投稿を出力 | 常時 |
| BR-002 | 昇順ソート | iId昇順（作成順）で出力 | 常時 |
| BR-003 | 古いファイル削除 | 出力時に同一プレフィックスの古いファイルを削除 | export時 |
| BR-004 | ファイル名ランダム化 | セキュリティのためファイル名にランダム文字列使用 | export時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| エクスポート | tblGuestbookItem | SELECT | 全カラム取得、iGuestbookID条件、iId昇順 |

### テーブル別操作詳細

#### tblGuestbookItem

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | iGuestbookID = 指定ID、ORDER BY iId ASC | 全カラム取得 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 認証エラー | 未ログイン | ログイン画面へリダイレクト |
| - | データなし | 投稿が0件 | 空のExcelファイル生成 |
| - | ファイル書込エラー | ディスク容量不足等 | on error resume nextで継続 |

### リトライ仕様

リトライ処理なし

## トランザクション仕様

読み取り専用処理のためトランザクション管理不要

## パフォーマンス要件

- ファイル生成: 投稿数×0.01秒以内（目安）
- 1000件程度で10秒以内

## セキュリティ考慮事項

- bs_security.aspによる基本認証
- IDパラメータの暗号化（encrypt/decrypt関数）
- 生成ファイル名のランダム化によるURLの推測防止
- 古いエクスポートファイルの自動削除

## 備考

- 出力形式はHTML形式をXLS拡張子で保存（Excelで開ける形式）
- 文字コードはQS_CHARSETで指定（UTF-8またはiso-8859-1）
- 新しいウィンドウで開く設計（リンク元のJavaScript window.open使用）
- prepareForExport関数で特殊文字処理
- convertTo_iso_8859_1関数で文字コード変換

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Excel出力クラスの構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | excelfile.asp | `asp/includes/excelfile.asp` | cls_excelFileクラスの構造（2-54行目） |

**読解のコツ**: このクラスはHTMLテーブルをExcelで開けるXLS形式で出力する。export()メソッドがファイル生成、redirectLink()がダウンロード処理を担当。

#### Step 2: エントリーポイントを理解する

処理の起点となるASPファイルを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_gbExcel.asp | `asp/bs_gbExcel.asp` | メイン処理フロー（1-26行目） |

**主要処理フロー**:
1. **4行目**: bs_security.aspインクルードで認証チェック
2. **5行目**: SQLクエリ構築、decrypt()でiGBID復号、convertGetal()で数値化
3. **6-19行目**: レコードセットをループしてHTMLテーブル構築
4. **20行目**: Recordset解放
5. **21-22行目**: cls_excelfileインスタンス生成
6. **23行目**: export()メソッドでファイル生成
7. **24行目**: redirectLink()でブラウザリダイレクト

#### Step 3: Excel出力クラスを理解する

ファイル生成の詳細を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | excelfile.asp | `asp/includes/excelfile.asp` | export()メソッド（14-29行目） |
| 3-2 | excelfile.asp | `asp/includes/excelfile.asp` | redirectLink()メソッド（36-38行目） |
| 3-3 | excelfile.asp | `asp/includes/excelfile.asp` | deleteOthers()メソッド（39-53行目） |

**主要処理フロー**:
- **6-10行目**: Class_Initialize - ファイルプレフィックス（IEExport_）とパスワード生成
- **14-29行目**: export() - HTMLをXML名前空間付きでファイル出力
- **17行目**: deleteOthers()で古いファイル削除
- **19行目**: CreateTextFile()でファイル作成
- **36-38行目**: redirectLink() - Response.Redirectでファイルへ遷移

### プログラム呼び出し階層図

```
bs_gbExcel.asp
    │
    ├─ bs_security.asp (認証チェック)
    │
    ├─ db.execute() (SQLクエリ実行)
    │      └─ SELECT * FROM tblGuestbookItem
    │
    └─ cls_excelfile
           ├─ Class_Initialize
           │      └─ GeneratePassWord() (ファイル名生成)
           │      └─ FSO作成
           ├─ export()
           │      └─ deleteOthers() (古ファイル削除)
           │      └─ CreateTextFile() (ファイル書込)
           └─ redirectLink()
                  └─ Response.Redirect (ダウンロード)
```

### データフロー図

```
[入力]               [処理]                    [出力]

クエリストリング ───▶ bs_gbExcel.asp ───▶ Excelファイル
(iGBID)                   │                   (.xls)
                          ▼
                   tblGuestbookItem ───▶ HTMLテーブル文字列
                          │
                          ▼
                   cls_excelfile.export() ───▶ ファイルシステム
                          │
                          ▼
                   redirectLink() ───▶ ブラウザダウンロード
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_gbExcel.asp | `asp/bs_gbExcel.asp` | ソース | Excel出力画面のメイン処理 |
| excelfile.asp | `asp/includes/excelfile.asp` | ソース | cls_excelFileクラス定義 |
| bs_security.asp | `asp/bs_security.asp` | ソース | 認証チェック処理 |
| begin.asp | `asp/begin.asp` | ソース | 共通初期化処理（db接続含む） |
| QSconfig.asp | `asp/includes/QSconfig.asp` | 設定 | QS_CHARSET等の定数定義 |
