# 機能設計書 65-ポップアップ一覧

## 概要

本ドキュメントは、QuickerSite CMSの管理画面におけるポップアップ一覧機能の設計を定義する。

### 本機能の処理概要

ポップアップ一覧機能は、サイト上に表示可能なポップアップウィンドウを一覧表示し、各ポップアップの管理操作を提供する機能である。

**業務上の目的・背景**：ウェブサイトにおいて、重要なお知らせ、キャンペーン情報、注意事項などを訪問者に対してモーダルウィンドウ形式で表示する必要がある。ポップアップは表示頻度、表示期間、表示条件などを細かく制御できるため、マーケティングや運用面で重要な機能である。本機能は、作成済みのポップアップを一覧表示し、各種管理操作へのアクセスを提供することで、効率的なポップアップ管理を実現する。

**機能の利用シーン**：
- 新規ポップアップを作成する際に一覧画面から作成画面へ遷移
- 既存ポップアップの設定を編集する際の起点画面として使用
- ポップアップのプレビュー確認
- ポップアップの複製操作
- 表示回数カウンターのリセット
- ポップアップの有効/無効状態の確認

**主要な処理内容**：
1. 顧客IDに紐づくポップアップ一覧のデータベースからの取得
2. 各ポップアップの名前、表示回数、有効状態の表示
3. ポップアップ複製機能（copyアクション）の実行
4. 表示回数カウンターのリセット
5. 編集画面、プレビュー画面へのリンク生成

**関連システム・外部連携**：特になし（CMS内部機能）

**権限による制御**：セカンドアドミン権限のbPopupフラグによりアクセス制御される。bPopup権限がないセカンドアドミンはアクセス不可。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 65 | ポップアップ一覧 | 主画面 | 登録済みポップアップの一覧表示 |
| 66 | ポップアップ編集 | 遷移先画面 | 新規ポップアップ作成画面への遷移 |

## 機能種別

データ一覧表示 / ナビゲーション

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| ipopupID | String (暗号化) | No | コピー対象ポップアップID（クエリストリング） | decrypt後にisNumeriekでチェック |
| i | String (暗号化) | No | リセット対象ポップアップID | decrypt後にisNumeriekでチェック |
| QS_secCode | String | No | CSRFトークン（コピー操作時） | セキュリティコードとして検証 |

### 入力データソース

- データベーステーブル: tblPopup
- セッション: 顧客ID（cId）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| sName | String | ポップアップ名 |
| iShows | Integer | 表示回数 |
| bEnabled | Boolean | 有効/無効状態 |
| iId | Integer | ポップアップID |
| 編集リンク | HTML | 編集画面へのリンク |
| プレビューリンク | HTML | プレビュー画面へのリンク |
| コピーリンク | HTML | 複製操作へのリンク |
| リセットリンク | HTML | 表示回数リセットへのリンク |

### 出力先

HTML画面（管理画面内）

## 処理フロー

### 処理シーケンス

```
1. アクセス権限チェック
   └─ secondAdmin.bPopup権限の確認
2. コピーリクエストの処理
   └─ ipopupIDパラメータがある場合、ポップアップを複製
   └─ 複製成功時は新規ポップアップの編集画面へリダイレクト
3. リセットリクエストの処理
   └─ iパラメータがある場合、表示回数を0にリセット
4. ポップアップ一覧の取得
   └─ customer.popupsプロパティでDictionary形式で取得
5. 一覧の表示
   └─ 各ポップアップについてリンクと状態を生成
6. 画面レンダリング
   └─ ヘッダー、一覧テーブル、フッターの出力
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{bPopup権限あり?}
    B -->|No| C[アクセス拒否]
    B -->|Yes| D{ipopupIDパラメータあり?}
    D -->|Yes| E[ポップアップコピー処理]
    E --> F{コピー成功?}
    F -->|Yes| G[編集画面へリダイレクト]
    F -->|No| H{iパラメータあり?}
    D -->|No| H
    H -->|Yes| I[表示回数リセット処理]
    I --> J[一覧取得処理]
    H -->|No| J
    J --> K{ポップアップあり?}
    K -->|Yes| L[一覧テーブル表示]
    K -->|No| M[「ポップアップがありません」表示]
    L --> N[終了]
    M --> N
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | 権限チェック | セカンドアドミンはbPopup権限が必要 | 全アクセス時 |
| BR-002 | 顧客分離 | 自顧客のポップアップのみ表示 | 一覧表示時 |
| BR-003 | リセット処理 | iShows=0に更新して保存 | リセット操作時 |
| BR-004 | 状態表示 | Enabled時は太字、Disabled時はグレー | 一覧表示時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 一覧表示 | tblPopup | SELECT | 顧客IDでフィルタして取得 |
| コピー | tblPopup | INSERT | 新規レコード作成 |
| リセット | tblPopup | UPDATE | iShows=0に更新 |

### テーブル別操作詳細

#### tblPopup

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | iCustomerID = cId | 顧客IDでフィルタ、sNameでソート |
| INSERT（コピー時） | 全項目 | 元レコードをコピー、iIdはnull | copy()メソッド |
| UPDATE（リセット時） | iShows | 0 | pick後にsave() |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 権限エラー | bPopup権限なし | 管理者ホーム画面へリダイレクト |
| - | データなし | ポップアップ未登録 | 「No Popups available」メッセージ表示 |

### リトライ仕様

リトライ処理なし

## トランザクション仕様

コピー・リセット処理はADOのデフォルトトランザクション（自動コミット）を使用

## パフォーマンス要件

- 一覧表示: 1秒以内
- コピー処理: 2秒以内
- リセット処理: 1秒以内

## セキュリティ考慮事項

- セカンドアドミン権限によるアクセス制御
- CSRFトークン（QS_secCode）によるコピー操作の保護
- IDパラメータの暗号化（encrypt/decrypt関数）
- JavaScript確認ダイアログによる誤操作防止
- プレビューはwindow.openで新しいウィンドウに表示

## 備考

- ポップアップは表示モード（iMode）により表示頻度を制御可能
- 表示回数（iShows）は実際の表示をトラッキング
- プレビューはforcePPパラメータでホームページ上に強制表示

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、ポップアップのデータモデルを理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | popup.asp | `asp/includes/popup.asp` | cls_popupクラスの構造、プロパティ定義（2-21行目） |

**読解のコツ**: VBScriptのクラス定義では、Publicプロパティで多数の設定値を持つ。iModeは表示頻度制御、bEnabledは有効/無効フラグ。

#### Step 2: エントリーポイントを理解する

処理の起点となるASPファイルを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_popupList.asp | `asp/bs_popupList.asp` | 一覧表示のメイン処理（1-17行目） |

**主要処理フロー**:
1. **4行目**: セキュリティチェック（logon.hasaccess secondAdmin.bPopup）
2. **5-7行目**: コピー処理（cls_popup.copy()メソッド呼び出し）
3. **8-12行目**: リセット処理（iパラメータでiShows=0に設定）
4. **14-15行目**: ポップアップ一覧取得（customer.popupsプロパティ）
5. **15-16行目**: 各ポップアップのループ表示とリンク生成

#### Step 3: データアクセス層を理解する

データベースアクセスの詳細を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | customer.asp | `asp/includes/customer.asp` | popupsプロパティの実装（871-886行目） |
| 3-2 | popup.asp | `asp/includes/popup.asp` | Pickメソッド（108-132行目）、copyメソッド（187-192行目） |

**主要処理フロー**:
- **871-886行目（customer.asp）**: popups関数でDictionary作成、tblPopupからSELECT
- **187-192行目（popup.asp）**: copyメソッドでiIdをnullにしてsaveを呼び出すことで複製を実現

### プログラム呼び出し階層図

```
bs_popupList.asp
    │
    ├─ bs_security.asp
    │      └─ logon.hasaccess (権限チェック)
    │
    ├─ cls_popup.copy()
    │      └─ save() (データベース保存)
    │
    ├─ cls_popup.pick() + save() (リセット処理)
    │      └─ iShows = 0
    │
    └─ customer.popups
           └─ cls_popup.pick() (各レコード取得)
```

### データフロー図

```
[入力]               [処理]                    [出力]

クエリストリング ───▶ bs_popupList.asp ───▶ HTML一覧画面
(ipopupID/i)               │
                           ▼
セッション(cId) ───▶ customer.popups ───▶ Dictionary
                           │
                           ▼
                    tblPopup ───▶ 各ポップアップ情報
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_popupList.asp | `asp/bs_popupList.asp` | ソース | ポップアップ一覧画面のメイン処理 |
| popup.asp | `asp/includes/popup.asp` | ソース | cls_popupクラス定義 |
| customer.asp | `asp/includes/customer.asp` | ソース | popupsプロパティ（顧客クラス） |
| bs_security.asp | `asp/bs_security.asp` | ソース | 権限チェック処理 |
| header.asp | `asp/includes/header.asp` | テンプレート | HTMLヘッダー |
| footer.asp | `asp/includes/footer.asp` | テンプレート | HTMLフッター |
