# 機能設計書 66-ポップアップ作成・編集

## 概要

本ドキュメントは、QuickerSite CMSの管理画面におけるポップアップ作成・編集機能の設計を定義する。

### 本機能の処理概要

ポップアップ作成・編集機能は、サイト上に表示するポップアップウィンドウの新規作成および既存ポップアップの設定変更を行う機能である。

**業務上の目的・背景**：ウェブサイト運営者が訪問者に対してキャンペーン情報、重要なお知らせ、プロモーションなどをモーダルウィンドウ形式で表示するためのポップアップを作成・管理する必要がある。ポップアップはURL指定またはHTMLコンテンツ直接入力、表示サイズ、表示頻度、表示期間、自動閉じタイマーなど多くのカスタマイズ項目を持っており、マーケティング戦略に合わせた柔軟な設定が求められる。

**機能の利用シーン**：
- 新規キャンペーン告知用ポップアップの作成
- 既存ポップアップのコンテンツ更新
- 表示期間の設定変更
- 表示頻度（モード）の調整
- ポップアップの有効/無効切り替え
- 不要なポップアップの削除

**主要な処理内容**：
1. ポップアップの基本情報（名前、URL、テキスト）の設定
2. 表示設定（幅、高さ、モード、自動閉じ）の編集
3. 公開期間（開始日、終了日）の設定
4. 有効/無効の切り替え
5. データベースへの保存・更新処理
6. ポップアップの削除処理

**関連システム・外部連携**：WYSIWYGエディタ（FCKEditor/CKEditor相当）によるコンテンツ編集

**権限による制御**：セカンドアドミン権限のbPopupフラグによりアクセス制御される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 66 | ポップアップ編集 | 主画面 | ポップアップの作成・コンテンツ編集・表示条件設定 |
| 65 | ポップアップ一覧 | 参照画面 | 戻り先画面 |

## 機能種別

CRUD操作（Create/Read/Update/Delete）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| ipopupId | String (暗号化) | No | ポップアップID（編集時） | decrypt後にisNumeriek |
| sName | String | Yes | ポップアップ名 | 最大50文字 |
| sUrl | String | No* | 外部URL（URLまたはテキストが必須） | 最大255文字 |
| sValue | Text | No* | 表示テキストHTML（URLまたはテキストが必須） | WYSIWYGエディタ |
| bEnabled | Boolean | No | 有効フラグ | true/false |
| iMode | Integer | No | 表示モード | 0-10の範囲 |
| dOnlineFrom | Date | No | 公開開始日 | 日付フォーマット検証 |
| dOnlineUntil | Date | No | 公開終了日 | 日付フォーマット検証 |
| iWidth | Integer | No | 幅（px） | 10-1000の範囲 |
| iHeight | Integer | No | 高さ（px） | 10-1000の範囲 |
| iAutoclose | Integer | No | 自動閉じ秒数 | 0-120の範囲（0=無効） |
| btnaction | String | Yes | アクション（保存/削除） | l("save") または l("delete") |
| postBack | Boolean | - | ポストバックフラグ | - |

### 入力データソース

- 画面入力フォーム
- データベーステーブル: tblPopup（編集時の初期値）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 保存成功 | - | 一覧画面へリダイレクト |
| 削除成功 | - | 一覧画面へリダイレクト |
| バリデーションエラー | Message | エラーメッセージ表示 |

### 出力先

HTML画面（管理画面内）、データベース

## 処理フロー

### 処理シーケンス

```
1. アクセス権限チェック
   └─ secondAdmin.bPopup権限の確認
2. bNOPopupフラグ設定
   └─ 編集画面でのポップアップ表示抑制
3. リクエストパラメータ取得
   └─ ipopupIdによる既存データ読み込み（編集時）
4. 削除アクション処理
   └─ btnaction=deleteの場合、削除して一覧へリダイレクト
5. ポストバック処理
   └─ postBack=trueの場合
   └─ リクエスト値取得
   └─ CSRFチェック
   └─ バリデーション（sName必須、URLまたはテキスト必須）
   └─ データベース保存
   └─ 成功時：一覧画面へリダイレクト
6. 画面表示
   └─ フォーム表示（WYSIWYGエディタ含む）
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{bPopup権限あり?}
    B -->|No| C[アクセス拒否]
    B -->|Yes| D[bNOPopup=true設定]
    D --> E[ポップアップデータ読込]
    E --> F{btnaction=delete?}
    F -->|Yes| G[ポップアップ削除]
    G --> H[一覧画面へリダイレクト]
    F -->|No| I{postBack?}
    I -->|Yes| J[リクエスト値取得]
    J --> K[CSRFチェック]
    K --> L{バリデーションOK?}
    L -->|Yes| M[データベース保存]
    M --> H
    L -->|No| N[エラー表示]
    I -->|No| N
    N --> O[フォーム表示]
    O --> P[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | 必須チェック | sNameは入力必須 | 保存時 |
| BR-002 | URL/テキスト必須 | sUrlまたはsValueのいずれかは必須 | 保存時 |
| BR-003 | デフォルトサイズ | 新規時は400x300px | 新規作成時 |
| BR-004 | デフォルトURL | 新規時のURLは"http://" | 新規作成時 |
| BR-005 | 表示モード | iMode=0:毎回、1:Cookie、2-10:セッションN回目 | 表示時 |

### 計算ロジック

- 表示モード制御: iModeの値により表示タイミングを制御
  - 0: 毎回表示
  - 1: Cookieで1回のみ（365日間）
  - 2-10: セッションでN回目に表示

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 新規作成 | tblPopup | INSERT | 新規ポップアップレコード作成 |
| 編集 | tblPopup | UPDATE | 既存レコード更新 |
| 削除 | tblPopup | DELETE | ポップアップ削除 |
| 読込 | tblPopup | SELECT | 編集用データ取得 |

### テーブル別操作詳細

#### tblPopup

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT/UPDATE | sName | 入力値（最大50文字） | 必須 |
| INSERT/UPDATE | sUrl | 入力URL | - |
| INSERT/UPDATE | dOnlineFrom | 入力日付 | DatePicker形式から変換 |
| INSERT/UPDATE | dOnlineUntil | 入力日付 | DatePicker形式から変換 |
| INSERT/UPDATE | iHeight | 入力数値 | - |
| INSERT/UPDATE | iWidth | 入力数値 | - |
| INSERT/UPDATE | bEnabled | 入力Boolean | - |
| INSERT/UPDATE | iTemplateID | 入力数値 | - |
| INSERT/UPDATE | iCustomerID | cId | 顧客ID |
| INSERT/UPDATE | sValue | 入力HTML | removeEmptyP処理 |
| INSERT/UPDATE | iMode | 入力数値 | 表示モード |
| INSERT/UPDATE | iShows | 現在値維持 | 表示回数 |
| INSERT/UPDATE | sViewmode | 入力値 | - |
| INSERT/UPDATE | iAutoclose | 入力数値 | 自動閉じ秒数 |
| DELETE | - | iId条件 | ポップアップ削除 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| err_mandatory | 必須エラー | sName未入力 | エラーメッセージ表示、再入力 |
| err_mandatory | 必須エラー | sUrl、sValue両方未入力 | エラーメッセージ表示、再入力 |
| - | 権限エラー | bPopup権限なし | アクセス拒否 |

### リトライ仕様

バリデーションエラー時は画面再表示、ユーザーによる再入力を促す

## トランザクション仕様

ADOのデフォルトトランザクション（自動コミット）を使用

## パフォーマンス要件

- 保存処理: 2秒以内
- 削除処理: 1秒以内

## セキュリティ考慮事項

- セカンドアドミン権限によるアクセス制御
- CSRFトークン（checkCSRF()）による保存操作の保護
- IDパラメータの暗号化（encrypt/decrypt関数）
- フォーム入力値のquotRep関数によるエスケープ
- HTML入力は許可（WYSIWYGエディタ使用のため）
- JavaScript確認ダイアログによる削除誤操作防止
- bNOPopupフラグによる編集画面でのポップアップ表示抑制

## 備考

- 表示モード（iMode）の詳細:
  - 0: 常に表示
  - 1: Cookie制御（初回のみ、365日有効）
  - 2: セッション2回目のページ読込で表示
  - 3-10: セッションN回目のページ読込で表示
- 自動閉じ（iAutoclose）: 0の場合は自動閉じなし、1-120秒で設定可能
- WYSIWYGエディタ（FCKEditor）でリッチテキスト編集

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、ポップアップのデータモデルとプロパティを理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | popup.asp | `asp/includes/popup.asp` | cls_popupクラスのプロパティ定義（2-21行目）とデフォルト値設定 |
| 1-2 | popupModeList.asp | `asp/includes/popupModeList.asp` | 表示モードの選択肢定義 |

**読解のコツ**: Class_Initializeでデフォルト値が設定されている。iModeによる表示制御はbOnlineプロパティで実装されている（36-93行目）。

#### Step 2: エントリーポイントを理解する

処理の起点となるASPファイルを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_popupEdit.asp | `asp/bs_popupEdit.asp` | メイン処理フロー（1-22行目） |

**主要処理フロー**:
1. **4行目**: bNOPopup=true設定（ポップアップ表示抑制）
2. **4行目**: セキュリティチェック（logon.hasaccess secondAdmin.bpopup）
3. **5-6行目**: cls_popup、cls_popupModeListインスタンス生成
4. **8行目**: postBackフラグ確認
5. **9-12行目**: 削除アクション処理
6. **13-18行目**: 保存処理（getRequestValues、checkCSRF、save）
7. **19-21行目**: フォームHTML生成

#### Step 3: データ永続化層を理解する

保存・削除処理の詳細を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | popup.asp | `asp/includes/popup.asp` | check()メソッド（133-143行目）、save()メソッド（144-179行目） |
| 3-2 | popup.asp | `asp/includes/popup.asp` | getRequestValues()メソッド（94-107行目） |
| 3-3 | popup.asp | `asp/includes/popup.asp` | remove()メソッド（180-186行目） |

**主要処理フロー**:
- **133-143行目**: check()でsName必須、sUrl/sValueいずれか必須をチェック
- **144-179行目**: save()でINSERT/UPDATE分岐、ADO Recordsetで保存
- **180-186行目**: remove()でDELETE実行

### プログラム呼び出し階層図

```
bs_popupEdit.asp
    │
    ├─ bs_security.asp
    │      └─ logon.hasaccess (権限チェック)
    │
    ├─ cls_popup (インスタンス生成)
    │      └─ Class_Initialize
    │             └─ pick() (ipopupIdから既存データ読込)
    │
    ├─ cls_popupModeList (モード選択肢)
    │
    ├─ popup.getRequestValues()
    │      └─ Request.Form値の取得・変換
    │
    ├─ popup.save()
    │      └─ check() (バリデーション)
    │      └─ db.GetDynamicRS (ADO Recordset)
    │      └─ rs.AddNew / rs.Update
    │
    └─ popup.remove()
           └─ DELETE tblPopup
```

### データフロー図

```
[入力]               [処理]                    [出力]

フォームPOST ───▶ bs_popupEdit.asp ───▶ 一覧画面（成功時）
                       │
                       ▼
               getRequestValues() ───▶ cls_popupプロパティ
                       │
                       ▼
               check() + save() ───▶ tblPopup（INSERT/UPDATE）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_popupEdit.asp | `asp/bs_popupEdit.asp` | ソース | ポップアップ編集画面のメイン処理 |
| popup.asp | `asp/includes/popup.asp` | ソース | cls_popupクラス定義 |
| popupModeList.asp | `asp/includes/popupModeList.asp` | ソース | 表示モード選択肢 |
| bs_security.asp | `asp/bs_security.asp` | ソース | 権限チェック処理 |
| bs_popupBack.asp | `asp/bs_popupBack.asp` | テンプレート | 戻るリンク表示 |
| header.asp | `asp/includes/header.asp` | テンプレート | HTMLヘッダー |
| footer.asp | `asp/includes/footer.asp` | テンプレート | HTMLフッター |
