# 機能設計書 67-ニュースレター一覧

## 概要

本ドキュメントは、QuickerSite CMSの管理画面におけるニュースレター一覧機能の設計を定義する。

### 本機能の処理概要

ニュースレター一覧機能は、作成済みのニュースレターテンプレートを一覧表示し、各ニュースレターの管理操作へのナビゲーションを提供する機能である。

**業務上の目的・背景**：ウェブサイト運営者が購読者に対してメールマガジン形式でニュースレターを配信する際、複数のニュースレターテンプレートを管理する必要がある。本機能は、作成済みのニュースレターテンプレートを一覧表示し、各種管理機能（編集、コピー、購読者管理、配信履歴など）へのアクセスを提供することで、効率的なニュースレター運用を実現する。

**機能の利用シーン**：
- 新規ニュースレターテンプレートを作成する際の起点画面
- 既存ニュースレターの編集画面への遷移
- ニュースレターテンプレートの複製操作
- 購読者管理画面への遷移
- メーリング（一括配信）画面への遷移
- 配信履歴の確認

**主要な処理内容**：
1. 顧客IDに紐づくニュースレター一覧のデータベースからの取得
2. 各ニュースレターの名前、IDの表示
3. ニュースレター複製機能（copyアクション）の実行
4. 編集画面へのリンク生成
5. 購読者管理、メーリング関連画面へのナビゲーション

**関連システム・外部連携**：メール配信システム（SMTPサーバ）

**権限による制御**：セカンドアドミン権限のbNewsletterフラグによりアクセス制御される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 67 | ニュースレター一覧 | 主画面 | 登録済みニュースレターの一覧表示 |
| 68 | ニュースレター作成・編集 | 遷移先画面 | 新規作成・編集画面への遷移 |
| 69 | 購読者管理 | 遷移先画面 | 購読者一覧画面への遷移 |
| - | メーリング作成 | 遷移先画面 | 一括配信設定画面への遷移 |
| - | メーリング履歴 | 遷移先画面 | 配信履歴画面への遷移 |
| - | メールリスト一覧 | 遷移先画面 | カテゴリ一覧画面への遷移 |

## 機能種別

データ一覧表示 / ナビゲーション

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| iNewsletterID | String (暗号化) | No | コピー対象ニュースレターID（クエリストリング） | decrypt後にisNumeriekでチェック |
| QS_secCode | String | No | CSRFトークン（コピー操作時） | セキュリティコードとして検証 |

### 入力データソース

- データベーステーブル: tblNewsletter
- データベーステーブル: tblNewsletterCategory（ボタン表示条件用）
- セッション: 顧客ID（cId）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| sName | String | ニュースレター名 |
| iId | Integer | ニュースレターID |
| 編集リンク | HTML | 編集画面へのリンク |
| コピーリンク | HTML | 複製操作へのリンク |
| ナビゲーションボタン | HTML | 各種管理画面へのボタン |

### 出力先

HTML画面（管理画面内）

## 処理フロー

### 処理シーケンス

```
1. アクセス権限チェック
   └─ secondAdmin.bNewsletter権限の確認
2. コピーリクエストの処理
   └─ iNewsletterIDパラメータがある場合、ニュースレターを複製
   └─ 複製成功時は新規ニュースレターの編集画面へリダイレクト
3. カテゴリ一覧の取得
   └─ customer.NewsletterCategoriesプロパティで取得
4. ニュースレター一覧の取得
   └─ customer.Newslettersプロパティでdictionary形式で取得
5. ナビゲーションボタンの表示
   └─ bCanImportSubscribersでカテゴリ有無を確認
   └─ カテゴリがある場合のみ購読者関連ボタンを表示
6. 一覧の表示
   └─ 各ニュースレターについてリンクと操作アイコンを生成
7. 画面レンダリング
   └─ ヘッダー、ボタン、一覧テーブル、フッターの出力
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{bNewsletter権限あり?}
    B -->|No| C[アクセス拒否]
    B -->|Yes| D{iNewsletterIDパラメータあり?}
    D -->|Yes| E[ニュースレターコピー処理]
    E --> F{コピー成功?}
    F -->|Yes| G[編集画面へリダイレクト]
    F -->|No| H[一覧取得処理]
    D -->|No| H
    H --> I{カテゴリあり?}
    I -->|Yes| J[購読者関連ボタン表示]
    I -->|No| K[基本ボタンのみ表示]
    J --> L{ニュースレターあり?}
    K --> L
    L -->|Yes| M[一覧テーブル表示]
    L -->|No| N[「ニュースレターがありません」表示]
    M --> O[終了]
    N --> O
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | 権限チェック | セカンドアドミンはbNewsletter権限が必要 | 全アクセス時 |
| BR-002 | 顧客分離 | 自顧客のニュースレターのみ表示 | 一覧表示時 |
| BR-003 | 購読者ボタン条件 | カテゴリが1件以上存在する場合のみ購読者関連ボタンを表示 | 画面表示時 |
| BR-004 | コピー確認 | コピー操作時はJavaScript確認ダイアログ | コピー操作時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 一覧表示 | tblNewsletter | SELECT | 顧客IDでフィルタして取得 |
| カテゴリ取得 | tblNewsletterCategory | SELECT | 顧客IDでフィルタして取得 |
| コピー | tblNewsletter | INSERT | 新規レコード作成 |

### テーブル別操作詳細

#### tblNewsletter

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | iCustomerID = cId | 顧客IDでフィルタ、iId降順でソート |
| INSERT（コピー時） | 全項目 | 元レコードをコピー、iIdはnull | copy()メソッド |

#### tblNewsletterCategory

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | iId | iCustomerID = cId | カテゴリ有無確認用 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 権限エラー | bNewsletter権限なし | 管理者ホーム画面へリダイレクト |
| - | データなし | ニュースレター未登録 | 「No Newsletters available」メッセージ表示 |

### リトライ仕様

リトライ処理なし

## トランザクション仕様

コピー処理はADOのデフォルトトランザクション（自動コミット）を使用

## パフォーマンス要件

- 一覧表示: 1秒以内
- コピー処理: 2秒以内

## セキュリティ考慮事項

- セカンドアドミン権限によるアクセス制御
- CSRFトークン（QS_secCodeURL）によるコピー操作の保護
- IDパラメータの暗号化（encrypt/decrypt関数）
- JavaScript確認ダイアログによる誤操作防止

## 備考

- ニュースレターテンプレートはHTMLメール形式で管理
- プレースホルダ（[NL_NAME]、[NL_EMAIL]、[NL_UNSUBSCRIBELINK]）により動的コンテンツに対応
- 購読者管理ボタンはカテゴリが存在する場合のみ表示される

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、ニュースレターのデータモデルを理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | newsletter.asp | `asp/includes/newsletter.asp` | cls_newsletterクラスの構造、プロパティ定義（2-3行目） |
| 1-2 | newsletterCategory.asp | `asp/includes/newsletterCategory.asp` | cls_newsletterCategoryクラス、購読カテゴリの構造 |

**読解のコツ**: VBScriptのクラス定義では、Public宣言されたプロパティがデータモデルを表す。Class_Initialize（4-35行目）でデフォルト値が設定され、pick()で既存データが読み込まれる。

#### Step 2: エントリーポイントを理解する

処理の起点となるASPファイルを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_newsletterList.asp | `asp/bs_newsletterList.asp` | 一覧表示のメイン処理（1-14行目） |

**主要処理フロー**:
1. **4行目**: セキュリティチェック（logon.hasaccess secondAdmin.bNewsletter）
2. **5-7行目**: コピー処理（cls_Newsletter.copy()メソッド呼び出し）
3. **8-9行目**: カテゴリ一覧取得（customer.NewsletterCategories）
4. **10-11行目**: ニュースレター一覧取得（customer.Newsletters）
5. **12行目**: bCanImportSubscribersによるボタン表示制御
6. **13-14行目**: 各ニュースレターのループ表示とリンク生成

#### Step 3: データアクセス層を理解する

データベースアクセスの詳細を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | customer.asp | `asp/includes/customer.asp` | Newslettersプロパティの実装（888-904行目） |
| 3-2 | customer.asp | `asp/includes/customer.asp` | bCanImportSubscribersプロパティ（922-929行目） |
| 3-3 | newsletter.asp | `asp/includes/newsletter.asp` | Pickメソッド（58-77行目）、copyメソッド（132-137行目） |

**主要処理フロー**:
- **888-904行目（customer.asp）**: newsletters関数でDictionary作成、tblNewsletterからSELECT
- **922-929行目（customer.asp）**: bCanImportSubscribersでtblNewsletterCategoryのカウント確認
- **132-137行目（newsletter.asp）**: copyメソッドでiIdをnullにしてsaveを呼び出すことで複製を実現

### プログラム呼び出し階層図

```
bs_newsletterList.asp
    │
    ├─ bs_security.asp
    │      └─ logon.hasaccess (権限チェック)
    │
    ├─ cls_newsletter.copy()
    │      └─ iId = null
    │      └─ save() (データベース保存)
    │
    ├─ customer.NewsletterCategories
    │      └─ cls_newsletterCategory.pick() (各カテゴリ取得)
    │
    ├─ customer.Newsletters
    │      └─ cls_newsletter.pick() (各レコード取得)
    │
    └─ customer.bCanImportSubscribers
           └─ tblNewsletterCategory COUNT確認
```

### データフロー図

```
[入力]               [処理]                    [出力]

クエリストリング ───▶ bs_newsletterList.asp ───▶ HTML一覧画面
(iNewsletterID)            │
                           ▼
セッション(cId) ───▶ customer.Newsletters ───▶ Dictionary
                           │
                           ▼
                    tblNewsletter ───▶ 各ニュースレター情報
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_newsletterList.asp | `asp/bs_newsletterList.asp` | ソース | ニュースレター一覧画面のメイン処理 |
| newsletter.asp | `asp/includes/newsletter.asp` | ソース | cls_newsletterクラス定義 |
| newsletterCategory.asp | `asp/includes/newsletterCategory.asp` | ソース | cls_newsletterCategoryクラス定義 |
| customer.asp | `asp/includes/customer.asp` | ソース | Newsletters、NewsletterCategoriesプロパティ |
| bs_security.asp | `asp/bs_security.asp` | ソース | 権限チェック処理 |
| bs_NewsletterEdit.asp | `asp/bs_NewsletterEdit.asp` | ソース | ニュースレター編集画面（遷移先） |
| bs_NewsletterMailingEdit.asp | `asp/bs_NewsletterMailingEdit.asp` | ソース | メーリング作成画面（遷移先） |
| bs_NewsletterMailingHistory.asp | `asp/bs_NewsletterMailingHistory.asp` | ソース | メーリング履歴画面（遷移先） |
| bs_NewsletterSubscribers.asp | `asp/bs_NewsletterSubscribers.asp` | ソース | 購読者一覧画面（遷移先） |
| bs_NewsletterCategoryList.asp | `asp/bs_NewsletterCategoryList.asp` | ソース | メールリスト一覧画面（遷移先） |
| header.asp | `asp/includes/header.asp` | テンプレート | HTMLヘッダー |
| footer.asp | `asp/includes/footer.asp` | テンプレート | HTMLフッター |
