# 機能設計書 68-ニュースレター作成・編集

## 概要

本ドキュメントは、QuickerSite CMSの管理画面におけるニュースレター作成・編集機能の設計を定義する。

### 本機能の処理概要

ニュースレター作成・編集機能は、メール配信用のニュースレターテンプレートの新規作成および既存テンプレートの設定変更を行う機能である。

**業務上の目的・背景**：ウェブサイト運営者が購読者に対してメールマガジン形式でニュースレターを配信する際、HTMLメール形式のテンプレートを作成・管理する必要がある。ニュースレターには送信者情報、件名、本文、配信解除リンクなど多くの設定項目があり、これらを統一的に管理するためのインターフェースが必要である。また、テスト配信機能により本番配信前の内容確認を可能にする。

**機能の利用シーン**：
- 新規ニュースレターテンプレートの作成
- 既存テンプレートの内容更新
- 送信者情報（名前、メールアドレス）の設定
- 件名の編集
- HTMLメール本文の編集（WYSIWYGエディタ）
- 配信解除リンクテキストのカスタマイズ
- テスト配信（プレビュー送信）
- デフォルトテンプレートとして保存
- 不要なテンプレートの削除

**主要な処理内容**：
1. ニュースレターの基本情報（名前、件名、送信者）の設定
2. HTMLメール本文の編集（WYSIWYGエディタ使用）
3. 配信解除関連設定の編集
4. データベースへの保存・更新処理
5. テスト配信機能による確認メール送信
6. デフォルトテンプレート保存機能
7. ニュースレターの削除処理

**関連システム・外部連携**：
- WYSIWYGエディタ（FCKEditor/CKEditor相当）によるコンテンツ編集
- メール配信システム（SMTPサーバ）によるテスト配信

**権限による制御**：セカンドアドミン権限のbNewsletterフラグによりアクセス制御される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 68 | ニュースレター編集 | 主画面 | ニュースレターの作成・編集・削除 |
| 67 | ニュースレター一覧 | 参照画面 | 戻り先画面 |

## 機能種別

CRUD操作（Create/Read/Update/Delete）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| iNewsletterID | String (暗号化) | No | ニュースレターID（編集時） | decrypt後にisNumeriek |
| sName | String | Yes | ニュースレター名 | 最大150文字 |
| sSubject | String | Yes | メール件名 | 最大150文字 |
| sFromEmail | String | Yes | 送信者メールアドレス | メール形式検証、最大50文字 |
| sFromName | String | No | 送信者名 | 最大50文字 |
| sValue | Text | No | HTMLメール本文 | WYSIWYGエディタ |
| sBodyBGColor | String | No | 背景色 | 最大50文字 |
| sUnsubscribeText | String | Yes | 配信解除リンクテキスト | 最大50文字 |
| sStyleLink | String | No | 配信解除リンクのCSS | 最大255文字 |
| bSaveAsTemplate | Boolean | No | デフォルトテンプレート保存フラグ | true/false |
| previewName | String | No | テスト送信先名前 | - |
| previewEmail | String | No | テスト送信先メールアドレス | - |
| btnaction | String | Yes | アクション（保存/送信/削除） | l("save")、l("send")、l("delete") |
| postBack | Boolean | - | ポストバックフラグ | - |

### 入力データソース

- 画面入力フォーム
- データベーステーブル: tblNewsletter（編集時の初期値）
- customerテーブル: sNLTemplate（デフォルトテンプレート）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 保存成功 | Message | fb_saveOKメッセージ表示 |
| 送信成功 | HTML | 「Preview was sent!」表示 |
| 削除成功 | - | 一覧画面へリダイレクト |
| バリデーションエラー | Message | エラーメッセージ表示 |

### 出力先

HTML画面（管理画面内）、データベース、メール送信

## 処理フロー

### 処理シーケンス

```
1. アクセス権限チェック
   └─ secondAdmin.bNewsletter権限の確認
2. リクエストパラメータ取得
   └─ iNewsletterIDによる既存データ読み込み（編集時）
3. 削除アクション処理
   └─ btnaction=deleteの場合、削除して一覧へリダイレクト
4. ポストバック処理
   └─ postBack=trueの場合
   └─ リクエスト値取得（getRequestValues）
   └─ CSRFチェック
   └─ バリデーション（sName必須、sUnsubscribeText必須、メール形式検証）
   └─ bSaveAsTemplateの場合、顧客テンプレートに保存
   └─ データベース保存
   └─ btnaction=sendの場合、テスト配信実行
5. 画面表示
   └─ フォーム表示（WYSIWYGエディタ含む）
   └─ 保存済みの場合、テスト送信セクション表示
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{bNewsletter権限あり?}
    B -->|No| C[アクセス拒否]
    B -->|Yes| D[ニュースレターデータ読込]
    D --> E{btnaction=delete?}
    E -->|Yes| F[ニュースレター削除]
    F --> G[一覧画面へリダイレクト]
    E -->|No| H{postBack?}
    H -->|Yes| I[リクエスト値取得]
    I --> J[CSRFチェック]
    J --> K{バリデーションOK?}
    K -->|Yes| L{bSaveAsTemplate?}
    L -->|Yes| M[顧客テンプレート保存]
    L -->|No| N[データベース保存]
    M --> N
    N --> O{btnaction=send?}
    O -->|Yes| P[テスト配信実行]
    P --> Q[フォーム表示]
    O -->|No| R[成功メッセージ表示]
    R --> Q
    K -->|No| S[エラー表示]
    H -->|No| Q
    S --> Q
    Q --> T[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | 必須チェック | sNameは入力必須 | 保存時 |
| BR-002 | 必須チェック | sUnsubscribeTextは入力必須 | 保存時 |
| BR-003 | メール形式 | sFromEmailは正しいメール形式 | 保存時 |
| BR-004 | テスト送信条件 | テスト送信は保存済み（iIDあり）の場合のみ可能 | 画面表示時 |
| BR-005 | プレースホルダ | [NL_NAME]、[NL_EMAIL]、[NL_UNSUBSCRIBELINK]使用可能 | 配信時 |

### 計算ロジック

- テスト配信時、プレースホルダを入力値（previewName、previewEmail）で置換
- [NL_UNSUBSCRIBELINK]は配信解除リンクHTMLに置換（テスト時は空文字列）

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 新規作成 | tblNewsletter | INSERT | 新規ニュースレターレコード作成 |
| 編集 | tblNewsletter | UPDATE | 既存レコード更新 |
| 削除 | tblNewsletter | DELETE | ニュースレター削除 |
| 読込 | tblNewsletter | SELECT | 編集用データ取得 |
| テンプレート保存 | tblCustomer | UPDATE | sNLTemplateカラム更新 |

### テーブル別操作詳細

#### tblNewsletter

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT/UPDATE | sName | 入力値（最大150文字） | 必須 |
| INSERT/UPDATE | sSubject | 入力値（最大150文字） | - |
| INSERT/UPDATE | sFromEmail | 入力メールアドレス | 形式検証 |
| INSERT/UPDATE | sFromName | 入力値（最大50文字） | - |
| INSERT/UPDATE | sValue | 入力HTML | removeEmptyP処理 |
| INSERT/UPDATE | sBodyBGColor | 入力値（最大50文字） | カラーピッカー |
| INSERT/UPDATE | sUnsubscribeText | 入力値（最大50文字） | 必須 |
| INSERT/UPDATE | sStyleLink | 入力値（最大255文字） | CSS |
| INSERT/UPDATE | bOnline | 入力Boolean | - |
| INSERT/UPDATE | iCustomerID | cId | 顧客ID |
| DELETE | - | iId条件 | ニュースレター削除 |

#### tblCustomer

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | sNLTemplate | 区切り文字で連結した全設定値 | デフォルトテンプレート |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| err_mandatory | 必須エラー | sName未入力 | エラーメッセージ表示、再入力 |
| err_mandatory | 必須エラー | sUnsubscribeText未入力 | エラーメッセージ表示、再入力 |
| err_email | メール形式エラー | sFromEmailが不正 | エラーメッセージ表示、再入力 |
| - | 権限エラー | bNewsletter権限なし | アクセス拒否 |

### リトライ仕様

バリデーションエラー時は画面再表示、ユーザーによる再入力を促す

## トランザクション仕様

ADOのデフォルトトランザクション（自動コミット）を使用

## パフォーマンス要件

- 保存処理: 2秒以内
- 削除処理: 1秒以内
- テスト送信: 5秒以内（SMTPサーバ依存）

## セキュリティ考慮事項

- セカンドアドミン権限によるアクセス制御
- CSRFトークン（checkCSRF()）による保存操作の保護
- IDパラメータの暗号化（encrypt/decrypt関数）
- フォーム入力値のquotRep関数によるエスケープ
- HTML入力は許可（WYSIWYGエディタ使用のため）
- JavaScript確認ダイアログによる削除誤操作防止

## 備考

- プレースホルダ一覧:
  - [NL_NAME]: 購読者名に置換
  - [NL_EMAIL]: 購読者メールアドレスに置換
  - [NL_UNSUBSCRIBELINK]: 配信解除リンクに置換
- デフォルトテンプレート保存機能により、新規作成時の初期値を設定可能
- テスト送信機能はiIDが設定された（保存済み）場合のみ表示
- 背景色はJQColorPickerを使用したカラーピッカーで選択可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、ニュースレターのデータモデルとプロパティを理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | newsletter.asp | `asp/includes/newsletter.asp` | cls_newsletterクラスのプロパティ定義（2-3行目）とデフォルト値設定（4-35行目） |

**読解のコツ**: Class_Initializeでデフォルト値が設定されている。sNLTemplate（16-33行目）による顧客カスタムテンプレートの読み込みも行われる。

#### Step 2: エントリーポイントを理解する

処理の起点となるASPファイルを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_newsletterEdit.asp | `asp/bs_newsletterEdit.asp` | メイン処理フロー（1-30行目） |

**主要処理フロー**:
1. **4行目**: セキュリティチェック（logon.hasaccess secondAdmin.bNewsletter）
2. **5行目**: cls_Newsletterインスタンス生成
3. **7行目**: postBackフラグ確認
4. **8-11行目**: 削除アクション処理
5. **13-25行目**: 保存処理（getRequestValues、checkCSRF、save）
6. **19-23行目**: テスト送信処理（btnaction=send時）
7. **29-30行目**: フォームHTML生成

#### Step 3: データ永続化層を理解する

保存・削除処理の詳細を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | newsletter.asp | `asp/includes/newsletter.asp` | check()メソッド（78-92行目）、save()メソッド（93-124行目） |
| 3-2 | newsletter.asp | `asp/includes/newsletter.asp` | getRequestValues()メソッド（43-57行目） |
| 3-3 | newsletter.asp | `asp/includes/newsletter.asp` | remove()メソッド（125-131行目） |
| 3-4 | newsletter.asp | `asp/includes/newsletter.asp` | send()メソッド（139-170行目） |

**主要処理フロー**:
- **78-92行目**: check()でsName必須、sUnsubscribeText必須、メール形式をチェック
- **93-124行目**: save()でINSERT/UPDATE分岐、ADO Recordsetで保存
- **125-131行目**: remove()でDELETE実行
- **139-170行目**: send()でメール送信、プレースホルダ置換処理

### プログラム呼び出し階層図

```
bs_newsletterEdit.asp
    │
    ├─ bs_security.asp
    │      └─ logon.hasaccess (権限チェック)
    │
    ├─ cls_newsletter (インスタンス生成)
    │      └─ Class_Initialize
    │             └─ pick() (iNewsletterIDから既存データ読込)
    │             └─ customer.sNLTemplate (デフォルトテンプレート)
    │
    ├─ newsletter.getRequestValues()
    │      └─ Request.Form値の取得・変換
    │      └─ bSaveAsTemplateの場合
    │             └─ customer.sNLTemplate 更新
    │             └─ customer.save()
    │
    ├─ newsletter.save()
    │      └─ check() (バリデーション)
    │      └─ db.GetDynamicRS (ADO Recordset)
    │      └─ rs.AddNew / rs.Update
    │
    ├─ newsletter.send()
    │      └─ treatConstants() (プレースホルダ処理)
    │      └─ cls_mail_message (メール送信)
    │
    └─ newsletter.remove()
           └─ DELETE tblNewsletter
```

### データフロー図

```
[入力]               [処理]                    [出力]

フォームPOST ───▶ bs_newsletterEdit.asp ───▶ 一覧画面（削除時）
                       │
                       ▼
               getRequestValues() ───▶ cls_newsletterプロパティ
                       │
                       ├─ bSaveAsTemplate ───▶ customer.sNLTemplate
                       │
                       ▼
               check() + save() ───▶ tblNewsletter（INSERT/UPDATE）
                       │
                       ▼
               send() ───▶ SMTPサーバ（テスト配信）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_newsletterEdit.asp | `asp/bs_newsletterEdit.asp` | ソース | ニュースレター編集画面のメイン処理 |
| newsletter.asp | `asp/includes/newsletter.asp` | ソース | cls_newsletterクラス定義 |
| bs_security.asp | `asp/bs_security.asp` | ソース | 権限チェック処理 |
| mail.asp | `asp/includes/mail.asp` | ソース | cls_mail_messageクラス（メール送信） |
| customer.asp | `asp/includes/customer.asp` | ソース | sNLTemplateプロパティ |
| urlenCodeJS.asp | `asp/includes/urlenCodeJS.asp` | ソース | URLエンコード用JavaScript |
| header.asp | `asp/includes/header.asp` | テンプレート | HTMLヘッダー |
| footer.asp | `asp/includes/footer.asp` | テンプレート | HTMLフッター |
