# 機能設計書 71-メーリング作成・送信

## 概要

本ドキュメントは、QuickerSite CMSにおけるニュースレターのメーリング作成・一斉送信機能の設計内容を記述する。

### 本機能の処理概要

ニュースレターの購読者リストに対して、作成したニュースレターコンテンツを一斉配信する機能を提供する。

**業務上の目的・背景**：ウェブサイト運営者がニュースレター購読者に対して、最新情報やプロモーション情報を効率的に一斉配信するために必要な機能である。手動で個別にメールを送信する手間を省き、大量の購読者に対して自動的にメール配信を行うことで、マーケティング活動の効率化を実現する。

**機能の利用シーン**：管理者がニュースレター一覧画面から新規メーリングを作成し、送信対象となるメールリスト（購読者カテゴリ）を選択してニュースレターを一斉配信する場面で使用される。また、送信前にプレビューとしてテスト送信を行い、コンテンツの確認を行うこともできる。

**主要な処理内容**：
1. ニュースレターとメールリスト（カテゴリ）の選択
2. メーリング設定（ログ記録の有無）の設定
3. プレビュー送信（テスト送信）の実行
4. 購読者への一斉配信処理（バッチ処理方式）
5. 配信ログの記録と進捗表示

**関連システム・外部連携**：システム内蔵のメール送信機能（cls_mail_message）を使用してSMTP経由でメール送信を行う。

**権限による制御**：secondAdmin.bNewsletter権限を持つ管理者のみがこの機能にアクセス可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 49 | 配信編集 | 主画面 | 配信メールの作成・編集 |
| 50 | 配信送信 | 主画面 | ニュースレターの一斉配信実行 |
| 42 | ニュースレター一覧 | 遷移元 | 配信メール作成画面への遷移 |

## 機能種別

データ作成 / バッチ処理（メール一斉送信）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| iNewsletterID | Integer | Yes | 送信するニュースレターのID | 数値チェック、存在確認 |
| sCategory | String | Yes | 送信対象カテゴリID（カンマ区切りで複数可） | 数値チェック |
| bLog | Boolean | No | 配信ログを記録するかどうか | ブール値変換 |
| previewName | String | No | プレビュー送信先の名前 | 文字列 |
| previewEmail | String | No | プレビュー送信先のメールアドレス | メールアドレス形式 |
| iInterval | Integer | No | 一度に送信するメッセージ数（デフォルト10） | 1-100の範囲 |
| iForceReload | Integer | No | リロード間隔（秒、デフォルト15） | 3-600の範囲 |

### 入力データソース

- 画面入力（フォーム）
- tblNewsletterテーブル（ニュースレターコンテンツ）
- tblNewsletterCategoryテーブル（メールリスト定義）
- tblNewsletterCategorySubscriberテーブル（購読者リスト）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| iId | Integer | メーリングID |
| dSentDate | DateTime | 送信日時 |
| 配信進捗 | Integer | 送信済みメッセージ数 |
| 開封追跡画像URL | String | 開封追跡用の画像URL |

### 出力先

- tblNewsletterMailingテーブル（メーリング記録）
- tblNewsletterLogテーブル（配信ログ・開封追跡）
- メール（SMTP経由で購読者に送信）

## 処理フロー

### 処理シーケンス

```
1. メーリング編集画面表示
   └─ 既存メーリングの場合はデータ読み込み
2. ニュースレター・カテゴリ選択
   └─ 必須項目のバリデーション
3. プレビュー送信（オプション）
   └─ 指定されたメールアドレスにテスト送信
4. 送信実行開始
   └─ メーリングデータ保存、送信画面へ遷移
5. バッチ送信処理
   ├─ 指定間隔で指定件数ずつ送信
   ├─ 重複送信防止チェック
   ├─ ログ記録有効時は追跡用レコード作成
   └─ 進捗表示のための自動リロード
6. 送信完了
   └─ 完了時刻記録、履歴画面へのリンク表示
```

### フローチャート

```mermaid
flowchart TD
    A[メーリング編集画面] --> B{プレビュー送信?}
    B -->|Yes| C[テストメール送信]
    C --> A
    B -->|No| D{送信実行?}
    D -->|No| A
    D -->|Yes| E[メーリング保存]
    E --> F[送信処理画面]
    F --> G{全件送信完了?}
    G -->|No| H[n件送信]
    H --> I[追跡ログ記録]
    I --> J[進捗表示]
    J --> K[自動リロード]
    K --> G
    G -->|Yes| L[完了時刻記録]
    L --> M[完了画面表示]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-71-1 | 重複送信防止 | 同一メールアドレスへの重複送信を防止する | 送信処理中 |
| BR-71-2 | 段階的送信 | 指定された間隔・件数で段階的に送信する | 一斉送信時 |
| BR-71-3 | 開封追跡 | ログ記録有効時のみ開封追跡用画像URLを埋め込む | bLog=true |
| BR-71-4 | アクティブ購読者のみ | bActive=trueの購読者のみに送信する | 送信対象選択時 |

### 計算ロジック

開封追跡URL生成: `customer.sQSUrl & "/default.asp?pageAction=rlog&k=" & sKey & "&i=" & iId`

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| メーリング保存 | tblNewsletterMailing | INSERT/UPDATE | メーリング設定の保存 |
| 配信ログ記録 | tblNewsletterLog | INSERT | 各購読者への送信記録 |
| 購読者取得 | tblNewsletterCategorySubscriber | SELECT | 送信対象購読者の取得 |

### テーブル別操作詳細

#### tblNewsletterMailing

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT/UPDATE | iNewsletterID | 選択されたニュースレターID | |
| INSERT/UPDATE | sCategory | 選択されたカテゴリID（カンマ区切り） | |
| INSERT/UPDATE | bLog | ログ記録フラグ | |
| UPDATE | dSentDate | 送信完了日時 | 送信完了時のみ |

#### tblNewsletterLog

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | iSubscriberID | 購読者ID | |
| INSERT | iMailingID | メーリングID | |
| INSERT | bRead | false（初期値） | 開封時にtrueに更新 |
| INSERT | sKey | ランダム生成キー | 開封追跡用 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| err_mandatory | 入力エラー | 必須項目未入力 | エラーメッセージ表示 |
| - | 認証エラー | CSRF検証失敗 | 処理中断 |

### リトライ仕様

送信処理は自動リロードにより継続される。ページを閉じた場合は送信が中断される。

## トランザクション仕様

各メール送信は個別トランザクションで処理される。ページリロードにより送信位置を維持し、中断位置から再開可能。

## パフォーマンス要件

- 一度に送信するメッセージ数: 1-100件（設定可能）
- リロード間隔: 3-600秒（設定可能）
- デフォルト: 10件/15秒

## セキュリティ考慮事項

- secondAdmin.bNewsletter権限によるアクセス制御
- CSRF対策（checkCSRF関数）
- IDパラメータの暗号化（encrypt/decrypt関数）
- セッションベースの認証確認

## 備考

- 送信中はブラウザウィンドウを閉じないよう警告表示される
- bLog=falseの場合、送信完了後にメーリングレコードは削除される

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | newsletterMailing.asp | `asp/includes/newsletterMailing.asp` | cls_newsletterMailingクラスの構造、プロパティ（iId, iNewsletterID, sCategory, bLog, dSentDate）を理解 |

**読解のコツ**: VBScriptのクラス構文を理解すること。`Public`で定義されたプロパティがデータ構造を表す。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_newsletterMailingEdit.asp | `asp/bs_newsletterMailingEdit.asp` | メーリング編集画面のエントリーポイント、フォーム処理 |

**主要処理フロー**:
1. **6-9行目**: 削除処理の判定と実行
2. **12-24行目**: POSTバック時のデータ保存とプレビュー/送信処理
3. **28-44行目**: カテゴリ選択のラジオボタン生成

#### Step 3: 送信処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_newsletterMailingSend.asp | `asp/bs_newsletterMailingSend.asp` | バッチ送信処理のメインロジック |

**主要処理フロー**:
- **25-75行目**: 送信ループ処理（購読者ごとにメール送信）
- **36-64行目**: 各購読者への送信処理と重複チェック
- **40-56行目**: ログ記録有効時の追跡レコード作成
- **65-71行目**: 送信完了時の処理（日時記録、リダイレクト）

### プログラム呼び出し階層図

```
bs_newsletterMailingEdit.asp（編集画面）
    │
    ├─ includes/newsletterMailing.asp（データクラス）
    │      ├─ cls_newsletterMailing.getRequestValues()
    │      ├─ cls_newsletterMailing.save()
    │      └─ cls_newsletterMailing.Newsletter（ニュースレター取得）
    │
    └─ bs_newsletterMailingSend.asp（送信画面）
           ├─ cls_newsletterMailing.pick()
           ├─ cls_newsletter.send()（メール送信）
           └─ tblNewsletterLog INSERT（追跡ログ）
```

### データフロー図

```
[入力]                    [処理]                         [出力]

フォーム入力          bs_newsletterMailingEdit.asp
  │                          │
  │  iNewsletterID           ▼
  │  sCategory         メーリング保存
  │  bLog             ─────────────────────▶ tblNewsletterMailing
  │                          │
  └──────────────────▶ bs_newsletterMailingSend.asp
                             │
tblNewsletterCategory        ▼
Subscriber ──────────▶ 購読者ループ処理
                             │
                             ├─────────────────────▶ メール送信（SMTP）
                             │
                             └─────────────────────▶ tblNewsletterLog
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_newsletterMailingEdit.asp | `asp/bs_newsletterMailingEdit.asp` | ソース | メーリング編集画面 |
| bs_newsletterMailingSend.asp | `asp/bs_newsletterMailingSend.asp` | ソース | 送信処理画面 |
| newsletterMailing.asp | `asp/includes/newsletterMailing.asp` | インクルード | メーリングデータクラス |
| newsletter.asp | `asp/includes/newsletter.asp` | インクルード | ニュースレターデータクラス |
| bs_security.asp | `asp/bs_security.asp` | インクルード | 認証・権限チェック |
