# 機能設計書 72-メーリング履歴

## 概要

本ドキュメントは、QuickerSite CMSにおけるニュースレターのメーリング履歴表示機能の設計内容を記述する。

### 本機能の処理概要

過去に送信したニュースレターメーリングの履歴を一覧表示し、配信結果（総送信数、開封数、未開封数）を確認する機能を提供する。

**業務上の目的・背景**：ニュースレターマーケティングにおいて、配信効果を測定・分析することは非常に重要である。本機能により、管理者は過去の配信履歴を確認し、開封率などの指標を把握することで、今後のマーケティング戦略の改善に活用できる。これにより、効果的なニュースレター運用のPDCAサイクルを回すことが可能となる。

**機能の利用シーン**：管理者がニュースレター管理画面からメーリング履歴を確認し、各配信の効果を分析する場面で使用される。また、古い履歴データを削除してストレージを整理する場面でも使用される。

**主要な処理内容**：
1. メーリング履歴の一覧表示（送信日時順）
2. 各メーリングの統計情報表示（総数、開封数、未開封数）
3. 開封率のパーセンテージ計算と表示
4. 各カテゴリ（全体/開封/未開封）の購読者リスト表示
5. メーリング履歴の削除

**関連システム・外部連携**：なし（システム内部での履歴管理）

**権限による制御**：secondAdmin.bNewsletter権限を持つ管理者のみがこの機能にアクセス可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 51 | 配信履歴 | 主画面 | 過去の配信履歴の確認 |
| 42 | ニュースレター一覧 | 遷移元 | 配信履歴画面への遷移 |

## 機能種別

データ参照 / データ削除

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| iNewsletterMailingID | String | No | 表示/削除対象のメーリングID（暗号化） | decrypt後の数値チェック |
| delete | String | No | 削除フラグ（"1"で削除実行） | 値チェック |
| showRead | String | No | 詳細表示対象のメーリングID（暗号化） | decrypt後の数値チェック |
| t | String | No | 表示タイプ（0:全体, 1:開封, 2:未開封） | 0/1/2のいずれか |

### 入力データソース

- リクエストパラメータ（QueryString）
- tblNewsletterMailingテーブル（メーリング履歴）
- tblNewsletterLogテーブル（配信ログ・開封追跡）
- tblNewsletterCategorySubscriberテーブル（購読者情報）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| dSentDate | DateTime | 送信日時 |
| sName | String | ニュースレター名 |
| sCategory | String | メールリスト名 |
| nmbrReceivers(0) | Integer | 総送信数 |
| nmbrReceivers(1) | Integer | 開封数 |
| nmbrReceivers(2) | Integer | 未開封数 |
| percRead | Integer | 開封率（%） |
| percNotRead | Integer | 未開封率（%） |

### 出力先

画面表示（HTML）

## 処理フロー

### 処理シーケンス

```
1. 権限チェック
   └─ secondAdmin.bNewsletter権限確認
2. 削除リクエスト処理
   └─ delete=1の場合、対象メーリングを削除
3. メーリング履歴取得
   └─ iCustomerID条件で送信日時降順取得
4. 各メーリングの統計情報計算
   ├─ 総送信数取得
   ├─ 開封数取得
   ├─ 未開封数取得
   └─ 開封率・未開封率計算
5. 詳細表示リクエスト処理
   └─ showRead指定時、該当カテゴリの購読者リスト表示
6. 画面レンダリング
   └─ テーブル形式で履歴一覧を表示
```

### フローチャート

```mermaid
flowchart TD
    A[履歴画面アクセス] --> B{権限チェック}
    B -->|NG| C[アクセス拒否]
    B -->|OK| D{削除リクエスト?}
    D -->|Yes| E[メーリング削除]
    E --> F[履歴取得]
    D -->|No| F
    F --> G[各メーリングの統計計算]
    G --> H{詳細表示要求?}
    H -->|Yes| I[購読者リスト表示]
    H -->|No| J[一覧表示]
    I --> J
    J --> K[画面出力]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-72-1 | 開封率計算 | 開封数/総数×100で計算（四捨五入） | 総数が0でない場合 |
| BR-72-2 | カスケード削除 | メーリング削除時に関連ログも削除 | 削除実行時 |
| BR-72-3 | 降順表示 | 送信日時の降順で表示 | 一覧表示時 |

### 計算ロジック

開封率計算:
```
percRead = round((nmbrReceivers(1) / nmbrReceivers(0)) * 100, 0)
percNotRead = round((nmbrReceivers(2) / nmbrReceivers(0)) * 100, 0)
```

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 履歴取得 | tblNewsletterMailing | SELECT | メーリング履歴の取得 |
| 統計取得 | tblNewsletterLog | SELECT | 送信・開封数のカウント |
| 購読者取得 | tblNewsletterCategorySubscriber | SELECT | 購読者詳細の取得 |
| 履歴削除 | tblNewsletterMailing | DELETE | メーリングレコードの削除 |
| ログ削除 | tblNewsletterLog | DELETE | 配信ログの削除 |

### テーブル別操作詳細

#### tblNewsletterMailing

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | iId, iNewsletterID, sCategory, dSentDate | iCustomerID=cId | 降順ソート |
| DELETE | - | iId=指定ID AND iCustomerID=cId | 削除時 |

#### tblNewsletterLog

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT COUNT | - | iMailingID=指定ID | 総数カウント |
| SELECT COUNT | - | bRead=true AND iMailingID=指定ID | 開封数カウント |
| SELECT COUNT | - | bRead=false AND iMailingID=指定ID | 未開封数カウント |
| DELETE | - | iMailingID=指定ID | 履歴削除時 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 認証エラー | 権限なしアクセス | アクセス拒否 |
| - | データなし | 履歴が存在しない | "No mailings.."メッセージ表示 |

### リトライ仕様

なし（参照系処理のためリトライ不要）

## トランザクション仕様

削除処理時のみトランザクション管理が必要。tblNewsletterLogの削除後にtblNewsletterMailingを削除する。

## パフォーマンス要件

履歴件数が多い場合でもレスポンスを維持するため、インデックスの適切な設定が必要。

## セキュリティ考慮事項

- secondAdmin.bNewsletter権限によるアクセス制御
- IDパラメータの暗号化（encrypt/decrypt関数）
- 削除時の確認ダイアログ表示

## 備考

- 開封追跡はメール内の画像読み込みにより検出されるため、画像表示を無効にしているメールクライアントでは開封として記録されない

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | newsletterMailing.asp | `asp/includes/newsletterMailing.asp` | cls_newsletterMailingクラス、特にnmbrReceiversプロパティとshowReadサブルーチン |

**読解のコツ**: nmbrReceiversプロパティ（85-101行目）は引数tで取得対象を切り替える。0=全体、1=開封、2=未開封。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_newsletterMailingHistory.asp | `asp/bs_newsletterMailingHistory.asp` | 履歴一覧画面のメインロジック |

**主要処理フロー**:
1. **4行目**: 権限チェック（secondAdmin.bNewsletter）
2. **6-8行目**: 削除リクエストの処理
3. **10行目**: メーリング履歴の取得（降順）
4. **12-21行目**: 各メーリングの統計情報表示ループ
5. **16-18行目**: 開封率・未開封率の計算

### プログラム呼び出し階層図

```
bs_newsletterMailingHistory.asp
    │
    ├─ includes/newsletterMailing.asp
    │      ├─ cls_newsletterMailing.pick()
    │      ├─ cls_newsletterMailing.nmbrReceivers(t)
    │      ├─ cls_newsletterMailing.showRead(t)
    │      ├─ cls_newsletterMailing.newsletter
    │      ├─ cls_newsletterMailing.category
    │      └─ cls_newsletterMailing.remove()
    │
    └─ includes/newsletter.asp
           └─ cls_newsletter.sName
```

### データフロー図

```
[入力]                    [処理]                           [出力]

QueryString           bs_newsletterMailingHistory.asp
  │                          │
  │  delete                  ▼
  │  showRead          削除処理（条件付き）
  │  t                ───────────────────────▶ tblNewsletterLog DELETE
  │                                             tblNewsletterMailing DELETE
  │                          │
  │                          ▼
tblNewsletterMailing  履歴取得・統計計算
  │                          │
  └──────────────────▶  nmbrReceivers
                             │
tblNewsletterLog            ▼
  │                    開封率計算
  └──────────────────▶  percRead/percNotRead
                             │
                             ▼
                        HTML出力 ──────────────▶ 画面表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_newsletterMailingHistory.asp | `asp/bs_newsletterMailingHistory.asp` | ソース | メーリング履歴画面 |
| newsletterMailing.asp | `asp/includes/newsletterMailing.asp` | インクルード | メーリングデータクラス |
| newsletter.asp | `asp/includes/newsletter.asp` | インクルード | ニュースレターデータクラス |
| newsletterCategory.asp | `asp/includes/newsletterCategory.asp` | インクルード | カテゴリデータクラス |
| bs_security.asp | `asp/bs_security.asp` | インクルード | 認証・権限チェック |
