# 機能設計書 73-メールリスト管理

## 概要

本ドキュメントは、QuickerSite CMSにおけるニュースレター購読者をグループ分けするカテゴリ（メールリスト）の管理機能の設計内容を記述する。

### 本機能の処理概要

ニュースレター購読者を分類・管理するためのメールリスト（カテゴリ）の作成、編集、削除を行う機能を提供する。

**業務上の目的・背景**：ニュースレターマーケティングにおいて、購読者をセグメント化して異なるコンテンツを配信することは効果的な手法である。本機能により、管理者は購読者を複数のメールリストに分類し、ターゲットを絞ったマーケティングコミュニケーションを実現できる。例えば、「新規顧客リスト」「既存顧客リスト」「プレミアム会員リスト」など、目的に応じたリストを作成できる。

**機能の利用シーン**：管理者がニュースレター管理画面からメールリストの一覧を確認し、新規リストを作成したり、既存リストの設定（登録フォーム、ウェルカムメッセージ、解除フィードバック等）を編集する場面で使用される。

**主要な処理内容**：
1. メールリスト（カテゴリ）の一覧表示
2. 新規メールリストの作成
3. メールリストの設定編集（名前、登録フォーム、メッセージ等）
4. メールリストの削除（関連購読者も削除）
5. 埋め込み用フォームコードの表示

**関連システム・外部連携**：新規購読者登録時に管理者へ通知メールを送信する機能あり。

**権限による制御**：secondAdmin.bNewsletter権限を持つ管理者のみがこの機能にアクセス可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 47 | カテゴリ一覧 | 主画面 | 購読者グループ分けカテゴリの一覧表示 |
| 48 | カテゴリ編集 | 主画面 | 購読者カテゴリの詳細設定 |
| 42 | ニュースレター一覧 | 遷移元 | メールリスト管理画面への遷移 |

## 機能種別

CRUD操作（作成・読取・更新・削除）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| iNewsletterCategoryID | String | No | カテゴリID（暗号化） | decrypt後の数値チェック |
| sName | String | Yes | リスト名（最大50文字） | 必須、50文字以内 |
| sSignupForm | String | Yes | 登録フォームHTML | 必須 |
| sWelcomeMessage | String | Yes | 登録完了メッセージ | 必須 |
| sUnsubscribeFB | String | Yes | 解除時フィードバック | 必須 |
| sUnsubscribeFBTitle | String | Yes | 解除時ページタイトル（最大50文字） | 必須、50文字以内 |
| bRequireBoth | Boolean | No | 名前とメール両方必須か | ブール値 |
| sErrorMessage | String | No | エラーメッセージ（最大255文字） | 255文字以内 |
| sNotifEmail | String | No | 新規登録通知メール宛先（最大50文字） | 50文字以内 |

### 入力データソース

- 画面入力（フォーム）
- tblNewsletterCategoryテーブル（既存データ）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| iId | Integer | カテゴリID |
| sName | String | リスト名 |
| nmbrSubscribers | Integer | 購読者数 |
| 埋め込みコード | String | ウェブサイト埋め込み用のコード |

### 出力先

- tblNewsletterCategoryテーブル（データ保存）
- 画面表示（HTML）

## 処理フロー

### 処理シーケンス

```
1. 一覧画面表示
   └─ 全カテゴリと購読者数を表示
2. 編集画面表示
   ├─ 新規の場合はデフォルト値を設定
   └─ 既存の場合はデータを読み込み
3. 保存処理
   ├─ バリデーション実行
   └─ データベースへ保存
4. 削除処理
   ├─ 関連購読者の削除
   └─ カテゴリの削除
```

### フローチャート

```mermaid
flowchart TD
    A[一覧画面] --> B{操作選択}
    B -->|新規作成| C[編集画面（新規）]
    B -->|編集| D[編集画面（既存）]
    C --> E[デフォルト値設定]
    D --> F[データ読み込み]
    E --> G[フォーム表示]
    F --> G
    G --> H{保存/削除?}
    H -->|保存| I[バリデーション]
    I -->|OK| J[データ保存]
    I -->|NG| G
    J --> K[成功メッセージ]
    H -->|削除| L[確認ダイアログ]
    L -->|Yes| M[購読者削除]
    M --> N[カテゴリ削除]
    N --> A
    K --> G
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-73-1 | デフォルトフォーム | 新規作成時は標準的な登録フォームをデフォルト設定 | 新規作成時 |
| BR-73-2 | カスケード削除 | カテゴリ削除時は関連購読者も削除 | 削除実行時 |
| BR-73-3 | 購読者数カウント | アクティブな購読者のみをカウント | 一覧表示時 |
| BR-73-4 | 両方必須オプション | bRequireBoth=trueの場合、名前とメール両方必須 | 購読者登録時 |

### 計算ロジック

購読者数カウント:
```sql
SELECT COUNT(*) FROM tblNewsletterCategorySubscriber
WHERE bActive=true AND iCategoryID=指定ID
```

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 一覧取得 | tblNewsletterCategory | SELECT | カテゴリ一覧の取得 |
| 詳細取得 | tblNewsletterCategory | SELECT | カテゴリ詳細の取得 |
| 保存 | tblNewsletterCategory | INSERT/UPDATE | カテゴリ情報の保存 |
| 削除 | tblNewsletterCategorySubscriber | DELETE | 購読者の削除 |
| 削除 | tblNewsletterCategory | DELETE | カテゴリの削除 |

### テーブル別操作詳細

#### tblNewsletterCategory

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | iCustomerID=cId AND iId=指定ID | 詳細取得 |
| INSERT/UPDATE | sName | リスト名 | 最大50文字 |
| INSERT/UPDATE | sSignupForm | 登録フォームHTML | |
| INSERT/UPDATE | sWelcomeMessage | 登録完了メッセージ | |
| INSERT/UPDATE | sUnsubscribeFB | 解除時フィードバック | |
| INSERT/UPDATE | sUnsubscribeFBTitle | 解除時タイトル | 最大50文字 |
| INSERT/UPDATE | bRequireBoth | 両方必須フラグ | |
| INSERT/UPDATE | sErrorMessage | エラーメッセージ | 最大255文字 |
| INSERT/UPDATE | sNotifEmail | 通知メール宛先 | 最大50文字 |
| DELETE | - | iId=指定ID | 削除時 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| err_mandatory | 入力エラー | sNameが空 | エラーメッセージ表示 |
| err_mandatory | 入力エラー | sUnsubscribeFBが空 | エラーメッセージ表示 |
| err_mandatory | 入力エラー | sUnsubscribeFBTitleが空 | エラーメッセージ表示 |
| - | CSRF検証エラー | CSRFトークン不正 | 処理中断 |

### リトライ仕様

なし

## トランザクション仕様

削除処理時はtblNewsletterCategorySubscriberの削除後にtblNewsletterCategoryを削除する。

## パフォーマンス要件

特になし（管理画面のため即座のレスポンスは必須ではない）

## セキュリティ考慮事項

- secondAdmin.bNewsletter権限によるアクセス制御
- CSRF対策（checkCSRF関数、QS_secCodeHidden）
- IDパラメータの暗号化（encrypt/decrypt関数）
- 削除時の確認ダイアログ表示
- WYSIWYGエディタ（FCKEditor）でのコンテンツ編集

## 備考

- 登録フォームにはプレースホルダー（{ID}, {N}, {E}, {AJAX}等）を使用
- 埋め込みコード[QS_NLCAT_ID]をテンプレートに記述することで、フロントエンドに登録フォームを表示可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | newsletterCategory.asp | `asp/includes/newsletterCategory.asp` | cls_newsletterCategoryクラスの全体構造、プロパティ、メソッド |

**読解のコツ**: Class_Initializeサブルーチン（4-14行目）でデフォルト値の設定を理解する。build関数（106-126行目）でフォームの動的生成を理解する。

#### Step 2: 一覧画面を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_newsletterCategoryList.asp | `asp/bs_newsletterCategoryList.asp` | カテゴリ一覧の表示ロジック |

**主要処理フロー**:
1. **4-5行目**: customer.NewsletterCategoriesで全カテゴリ取得
2. **5-6行目**: ループで各カテゴリと購読者数を表示
3. **6行目**: 埋め込みコード[QS_NLCAT_ID]の表示

#### Step 3: 編集画面を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_newsletterCategoryEdit.asp | `asp/bs_newsletterCategoryEdit.asp` | カテゴリ編集のメインロジック |

**主要処理フロー**:
- **8-10行目**: 削除処理
- **12-17行目**: 保存処理
- **18-19行目**: フォーム表示（WYSIWYGエディタ使用）

### プログラム呼び出し階層図

```
bs_newsletterCategoryList.asp（一覧画面）
    │
    └─ customer.NewsletterCategories
           └─ cls_newsletterCategory（各カテゴリ）
                  └─ nmbrSubscribers（購読者数）

bs_newsletterCategoryEdit.asp（編集画面）
    │
    ├─ includes/newsletterCategory.asp
    │      ├─ cls_newsletterCategory.pick()
    │      ├─ cls_newsletterCategory.getRequestValues()
    │      ├─ cls_newsletterCategory.save()
    │      └─ cls_newsletterCategory.remove()
    │
    └─ FCKEditor（WYSIWYGエディタ）
           └─ createFCKInstance()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

フォーム入力          bs_newsletterCategoryEdit.asp
  │                          │
  │  sName                   ▼
  │  sSignupForm        バリデーション
  │  sWelcomeMessage         │
  │  sUnsubscribeFB          │
  │                          ▼
  └──────────────────▶ データ保存
                             │
                             └─────────────────────▶ tblNewsletterCategory

削除リクエスト              │
  │                         ▼
  └──────────────────▶ 購読者削除
                             │
                             └─────────────────────▶ tblNewsletterCategorySubscriber DELETE
                             │
                             └─────────────────────▶ tblNewsletterCategory DELETE
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_newsletterCategoryList.asp | `asp/bs_newsletterCategoryList.asp` | ソース | カテゴリ一覧画面 |
| bs_newsletterCategoryEdit.asp | `asp/bs_newsletterCategoryEdit.asp` | ソース | カテゴリ編集画面 |
| newsletterCategory.asp | `asp/includes/newsletterCategory.asp` | インクルード | カテゴリデータクラス |
| bs_security.asp | `asp/bs_security.asp` | インクルード | 認証・権限チェック |
