# 機能設計書 74-予約カレンダー

## 概要

本ドキュメントは、QuickerSite CMSにおける予約カレンダー（Availability Calendar）の管理機能の設計内容を記述する。

### 本機能の処理概要

宿泊施設やレンタルサービス等の空き状況を表示するための予約カレンダーの作成・管理機能を提供する。

**業務上の目的・背景**：ホテル、民泊、レンタカー、会議室などの予約可能なリソースを管理するサイトでは、空き状況を視覚的に表示することが重要である。本機能により、管理者は複数のカレンダーを作成し、各リソースの空き状況を管理できる。訪問者はカレンダーを見て空き状況を確認し、予約可否を判断できる。

**機能の利用シーン**：管理者が予約カレンダー管理画面から新規カレンダーを作成したり、既存カレンダーの名前を変更したり、不要になったカレンダーを削除する場面で使用される。また、作成したカレンダーの一覧を確認する場面でも使用される。

**主要な処理内容**：
1. 予約カレンダーの一覧表示
2. 新規カレンダーの作成
3. カレンダー名の編集
4. カレンダーの削除（関連予約も削除）
5. カレンダービューの表示

**関連システム・外部連携**：なし（システム内部での管理）

**権限による制御**：secondAdmin.bAvailabilityCal権限を持つ管理者のみがこの機能にアクセス可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 105 | カレンダー管理 | 主画面 | 予約カレンダーの管理画面 |
| 108 | カレンダー表示 | 表示画面 | カレンダー表示画面 |
| 109 | カレンダービュー | 表示画面 | カレンダービュー表示 |
| 110 | マイカレンダー | 一覧画面 | 個人カレンダーの一覧表示 |
| 112 | カレンダーメニュー | メニュー画面 | カレンダーメニューの表示 |

## 機能種別

CRUD操作（作成・読取・更新・削除）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| iCalID | Integer | No | カレンダーID | 数値チェック |
| sName | String | Yes | カレンダー名（最大50文字） | 必須、50文字以内 |
| calAction | String | No | アクション種別（createcal/editcal/embedcode/booking/bookings） | 固定値 |
| postback | Boolean | No | POSTバックフラグ | ブール値 |
| btnName | String | No | ボタン名（Save/Delete） | 固定値 |

### 入力データソース

- 画面入力（フォーム）
- tblCalendarテーブル（既存データ）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| iId | Integer | カレンダーID |
| sName | String | カレンダー名 |
| dCreatedTS | DateTime | 作成日時 |
| カレンダービュー | HTML | 月別カレンダー表示 |

### 出力先

- tblCalendarテーブル（データ保存）
- 画面表示（HTML）

## 処理フロー

### 処理シーケンス

```
1. メイン画面表示（bs_ac.asp）
   └─ calActionパラメータで分岐
2. アクション分岐
   ├─ createcal/editcal: カレンダー編集画面
   ├─ embedcode: 埋め込みコード生成画面
   ├─ booking: 予約編集画面
   ├─ bookings: 予約一覧画面
   └─ その他: マイカレンダー一覧
3. カレンダー編集処理
   ├─ 保存: バリデーション → 保存 → 一覧へ
   └─ 削除: 確認 → 予約削除 → カレンダー削除 → 一覧へ
```

### フローチャート

```mermaid
flowchart TD
    A[bs_ac.asp] --> B{calAction}
    B -->|createcal/editcal| C[bs_ac_calendar.asp]
    B -->|embedcode| D[bs_ac_embed.asp]
    B -->|booking| E[bs_ac_booking.asp]
    B -->|bookings| F[bs_ac_bookings.asp]
    B -->|その他| G[bs_ac_mycals.asp]
    C --> H{POSTバック?}
    H -->|Yes| I{ボタン}
    I -->|Save| J[バリデーション]
    J -->|OK| K[保存]
    K --> L[一覧へリダイレクト]
    J -->|NG| C
    I -->|Delete| M[予約削除]
    M --> N[カレンダー削除]
    N --> L
    H -->|No| C
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-74-1 | カスケード削除 | カレンダー削除時は関連予約も削除 | 削除実行時 |
| BR-74-2 | 必須項目 | カレンダー名は必須 | 保存時 |
| BR-74-3 | 顧客分離 | 顧客IDでカレンダーを分離 | 全操作 |

### 計算ロジック

なし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 一覧取得 | tblCalendar | SELECT | カレンダー一覧の取得 |
| 詳細取得 | tblCalendar | SELECT | カレンダー詳細の取得 |
| 保存 | tblCalendar | INSERT/UPDATE | カレンダー情報の保存 |
| 削除 | tblCalendarBooking | DELETE | 予約の削除 |
| 削除 | tblCalendar | DELETE | カレンダーの削除 |

### テーブル別操作詳細

#### tblCalendar

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | iCustomerID=cId | 一覧取得 |
| SELECT | * | iId=指定ID AND iCustomerID=cId | 詳細取得 |
| INSERT | sName, iCustomerID, dCreatedTS | 入力値, cId, now() | 新規作成 |
| UPDATE | sName | 入力値 | 更新 |
| DELETE | - | iId=指定ID | 削除 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| err_mandatory | 入力エラー | sNameが空 | エラーメッセージ表示 |
| - | 認証エラー | 権限なしアクセス | アクセス拒否 |

### リトライ仕様

なし

## トランザクション仕様

削除処理時はtblCalendarBookingの削除後にtblCalendarを削除する。

## パフォーマンス要件

特になし

## セキュリティ考慮事項

- secondAdmin.bAvailabilityCal権限によるアクセス制御
- 顧客ID（iCustomerID）によるデータ分離
- 削除時の確認ダイアログ表示

## 備考

- カレンダーはプロパティ名（物件名等）として使用されることが多い
- 複数のカレンダーを作成して複数リソースを管理可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ac_calendar.asp | `asp/includes/ac_calendar.asp` | cls_Calendarクラスの構造、プロパティ（iId, sName, iCustomerID等） |

**読解のコツ**: このファイルは1行に圧縮されているため、適宜整形して読むことを推奨。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_ac.asp | `asp/bs_ac.asp` | カレンダー管理のメインエントリーポイント、calActionによる分岐 |

**主要処理フロー**:
1. **4行目**: 権限チェック（secondAdmin.bAvailabilityCal）
2. **4-5行目**: 各種インクルードファイルの読み込み
3. **8-9行目**: calActionによる画面分岐

#### Step 3: カレンダー編集を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_ac_calendar.asp | `asp/bs_ac_calendar.asp` | カレンダー編集のメインロジック |

**主要処理フロー**:
- **2-3行目**: カレンダーオブジェクトの取得
- **4-14行目**: POSTバック時の保存/削除処理
- **15行目**: フォーム表示

### プログラム呼び出し階層図

```
bs_ac.asp（メイン画面）
    │
    ├─ includes/ac_calendar.asp（カレンダークラス）
    ├─ includes/ac_calendarview.asp（ビュー表示）
    ├─ includes/ac_calendarbooking.asp（予約クラス）
    ├─ includes/ac_statuslist.asp（ステータス一覧）
    │
    ├─ bs_ac_calendar.asp（編集画面）
    │      ├─ cls_calendar.pick()
    │      ├─ cls_calendar.save()
    │      └─ cls_calendar.delete()
    │
    ├─ bs_ac_mycals.asp（一覧画面）
    │      └─ cls_calendar.mycals()
    │
    └─ bs_ac_view.asp（ビュー生成）
```

### データフロー図

```
[入力]                    [処理]                         [出力]

リクエスト              bs_ac.asp
  │                          │
  │  calAction               ▼
  │  iCalID             アクション分岐
  │                          │
  │                          ├─────────────▶ bs_ac_calendar.asp
  │                          │                    │
フォーム入力                 │                    ▼
  │                          │              カレンダー保存
  │  sName                   │                    │
  └──────────────────────────┤                    └────▶ tblCalendar
                             │
                             ├─────────────▶ bs_ac_mycals.asp
                             │                    │
                             │                    ▼
                             │              一覧表示 ───▶ 画面出力
                             │
                             └─────────────▶ bs_ac_view.asp
                                                  │
                                                  ▼
                                            カレンダービュー ───▶ 画面出力
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_ac.asp | `asp/bs_ac.asp` | ソース | カレンダー管理メイン画面 |
| bs_ac_calendar.asp | `asp/bs_ac_calendar.asp` | インクルード | カレンダー編集 |
| bs_ac_mycals.asp | `asp/bs_ac_mycals.asp` | インクルード | カレンダー一覧 |
| bs_ac_view.asp | `asp/bs_ac_view.asp` | ソース | カレンダービュー生成 |
| bs_ac_menu.asp | `asp/bs_ac_menu.asp` | インクルード | カレンダーメニュー |
| ac_calendar.asp | `asp/includes/ac_calendar.asp` | インクルード | カレンダーデータクラス |
| ac_calendarview.asp | `asp/includes/ac_calendarview.asp` | インクルード | ビュー表示クラス |
