# 機能設計書 75-カレンダー予約管理

## 概要

本ドキュメントは、QuickerSite CMSにおける予約カレンダーの予約登録・編集・削除機能の設計内容を記述する。

### 本機能の処理概要

予約カレンダーに対する個別の予約（ブッキング）の登録、編集、削除を行う機能を提供する。

**業務上の目的・背景**：宿泊施設やレンタルサービスの運営において、予約を正確に管理することは業務の根幹である。本機能により、管理者は予約の登録・変更・削除を行い、空き状況をリアルタイムで反映できる。重複予約を防止するバリデーション機能により、ダブルブッキングのミスを防ぐことができる。

**機能の利用シーン**：管理者がカレンダー管理画面から新規予約を登録したり、既存予約の日程や顧客情報を変更したり、キャンセルされた予約を削除する場面で使用される。また、予約一覧から各予約の詳細を確認・編集する場面でも使用される。

**主要な処理内容**：
1. 予約一覧の表示（カレンダー選択可能）
2. 新規予約の登録
3. 予約情報の編集（ステータス、日程、顧客情報、メモ）
4. 予約の削除
5. 重複予約チェック（ダブルブッキング防止）

**関連システム・外部連携**：なし（システム内部での管理）

**権限による制御**：secondAdmin.bAvailabilityCal権限を持つ管理者のみがこの機能にアクセス可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 106 | 予約一覧 | 主画面 | 予約の一覧表示・管理 |
| 107 | 予約編集 | 主画面 | 予約の詳細編集 |

## 機能種別

CRUD操作（作成・読取・更新・削除）/ バリデーション

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| iBookingID | Integer | No | 予約ID | 数値チェック |
| iCalID | Integer | Yes | カレンダーID | 数値チェック |
| iStatus | Integer | No | ステータス | 数値チェック |
| dStartDate | Date | Yes | 開始日 | 日付形式、終了日以前 |
| dEndDate | Date | Yes | 終了日 | 日付形式、開始日以降 |
| bSOnlyAfternoon | Boolean | No | 開始日午後のみフラグ | ブール値 |
| bEOnlyMorning | Boolean | No | 終了日午前のみフラグ | ブール値 |
| sName | String | Yes | 予約者名（最大50文字） | 必須、50文字以内 |
| sEmail | String | No | メールアドレス（最大50文字） | 50文字以内 |
| sPhone | String | No | 電話番号（最大50文字） | 50文字以内 |
| sNotes | String | No | メモ | リッチテキスト |

### 入力データソース

- 画面入力（フォーム）
- tblCalendarBookingテーブル（既存データ）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| iId | Integer | 予約ID |
| iStatus | Integer | ステータス |
| dStartDate | Date | 開始日 |
| dEndDate | Date | 終了日 |
| sName | String | 予約者名 |
| sEmail | String | メールアドレス |
| sPhone | String | 電話番号 |
| sNotes | String | メモ |

### 出力先

- tblCalendarBookingテーブル（データ保存）
- 画面表示（HTML）

## 処理フロー

### 処理シーケンス

```
1. 予約一覧画面表示（bs_ac_bookings.asp）
   ├─ カレンダー選択ドロップダウン
   └─ 選択カレンダーの予約一覧表示
2. 予約編集画面表示（bs_ac_booking.asp）
   ├─ 新規の場合は空フォーム
   └─ 既存の場合はデータ読み込み
3. 保存処理
   ├─ 必須項目バリデーション
   ├─ 日付整合性チェック（終了日>=開始日）
   ├─ 重複予約チェック（ダブルブッキング防止）
   └─ データベースへ保存
4. 削除処理
   └─ 確認後に予約削除
```

### フローチャート

```mermaid
flowchart TD
    A[予約一覧画面] --> B{操作選択}
    B -->|新規追加| C[予約編集画面（新規）]
    B -->|編集| D[予約編集画面（既存）]
    C --> E[フォーム表示]
    D --> F[データ読み込み]
    F --> E
    E --> G{保存/削除?}
    G -->|保存| H[必須チェック]
    H -->|OK| I[日付整合性チェック]
    I -->|OK| J[重複予約チェック]
    J -->|OK| K[データ保存]
    K --> L[一覧へリダイレクト]
    H -->|NG| E
    I -->|NG| M[エラー表示]
    M --> E
    J -->|NG| N[重複エラー表示]
    N --> E
    G -->|削除| O[確認ダイアログ]
    O -->|Yes| P[予約削除]
    P --> L
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-75-1 | 必須項目 | 予約者名、開始日、終了日は必須 | 保存時 |
| BR-75-2 | 日付整合性 | 終了日は開始日以降でなければならない | 保存時 |
| BR-75-3 | 重複禁止 | 同一カレンダー内で日程が重複する予約は登録不可 | 保存時 |
| BR-75-4 | 半日対応 | 開始日午後のみ/終了日午前のみの設定により、同日チェックイン・チェックアウト可能 | 重複チェック時 |

### 計算ロジック

重複チェックロジック:
```
// 既存予約との重複をチェック
if dStartDate < 既存.dEndDate AND dEndDate > 既存.dEndDate then 重複
if dStartDate > 既存.dStartDate AND dStartDate < 既存.dEndDate then 重複
if dEndDate > 既存.dStartDate AND dEndDate < 既存.dEndDate then 重複

// 同日の場合の半日チェック
if dEndDate = 既存.dStartDate then
  if NOT (bEOnlyMorning AND 既存.bSOnlyAfternoon) then 重複
if dStartDate = 既存.dEndDate then
  if NOT (bSOnlyAfternoon AND 既存.bEOnlyMorning) then 重複
```

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 一覧取得 | tblCalendarBooking | SELECT | 予約一覧の取得 |
| 詳細取得 | tblCalendarBooking | SELECT | 予約詳細の取得 |
| 保存 | tblCalendarBooking | INSERT/UPDATE | 予約情報の保存 |
| 削除 | tblCalendarBooking | DELETE | 予約の削除 |

### テーブル別操作詳細

#### tblCalendarBooking

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | iCalendarID=指定ID ORDER BY dStartdate desc | 一覧取得 |
| SELECT | * | iId=指定ID | 詳細取得 |
| INSERT | iStatus, dStartDate, dEndDate, bSOnlyAfternoon, bEOnlyMorning, sName, sEmail, sPhone, sNotes, iCalendarID, dCreatedTS | 入力値, now() | 新規作成 |
| UPDATE | iStatus, dStartDate, dEndDate, bSOnlyAfternoon, bEOnlyMorning, sName, sEmail, sPhone, sNotes, dUpdatedTS | 入力値, now() | 更新 |
| DELETE | - | iId=指定ID | 削除 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| err_mandatory | 入力エラー | sName, dStartDate, dEndDateが空 | エラーメッセージ表示 |
| - | 日付エラー | 終了日が開始日より前 | カスタムエラーメッセージ表示 |
| - | 重複エラー | 日程が既存予約と重複 | カスタムエラーメッセージ表示 |

### リトライ仕様

なし

## トランザクション仕様

単一レコードの操作のため、個別のトランザクションで処理。

## パフォーマンス要件

特になし

## セキュリティ考慮事項

- secondAdmin.bAvailabilityCal権限によるアクセス制御
- 削除時の確認ダイアログ表示
- WYSIWYGエディタ（FCKEditor）でのメモ編集

## 備考

- ステータスは別途定義されたステータスリスト（cls_statusList）から選択
- jQueryのDatePickerを使用した日付入力
- カレンダービューと連動してリアルタイムで空き状況が更新される

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ac_calendarbooking.asp | `asp/includes/ac_calendarbooking.asp` | cls_calendarbookingクラスの構造、プロパティ、check関数の重複チェックロジック |

**読解のコツ**: check関数（43-96行目）は複雑な重複チェックロジックを含む。特に61-95行目の日程重複判定を注意深く読むこと。

#### Step 2: 予約一覧画面を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_ac_bookings.asp | `asp/bs_ac_bookings.asp` | 予約一覧の表示ロジック、ソート機能 |

**主要処理フロー**:
1. **2-5行目**: カレンダー・予約オブジェクトの取得
2. **6行目**: 予約一覧のテーブル表示

#### Step 3: 予約編集画面を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_ac_booking.asp | `asp/bs_ac_booking.asp` | 予約編集のメインロジック |

**主要処理フロー**:
- **2-6行目**: カレンダー・予約オブジェクトの取得
- **7-11行目**: メモ表示用のAJAXレスポンス
- **12-23行目**: POSTバック時の保存/削除処理
- **24-26行目**: フォーム表示（DatePicker、FCKEditor使用）

### プログラム呼び出し階層図

```
bs_ac.asp（メイン画面）
    │
    ├─ bs_ac_bookings.asp（予約一覧）
    │      ├─ cls_calendar.pick()
    │      ├─ cls_calendar.bookings()
    │      └─ cls_statusList（ステータス表示）
    │
    └─ bs_ac_booking.asp（予約編集）
           ├─ cls_calendar.pick()
           ├─ cls_calendarbooking.pick()
           ├─ cls_calendarbooking.getRequestValues()
           ├─ cls_calendarbooking.check()
           │      └─ 重複チェックロジック
           ├─ cls_calendarbooking.save()
           ├─ cls_calendarbooking.delete()
           └─ cls_statusList（ステータス選択）
```

### データフロー図

```
[入力]                    [処理]                         [出力]

フォーム入力          bs_ac_booking.asp
  │                          │
  │  dStartDate              ▼
  │  dEndDate           必須チェック
  │  sName                   │
  │  sEmail                  ▼
  │  sPhone             日付整合性チェック
  │  sNotes                  │
  │                          ▼
  │                    重複予約チェック
  │                          │
  └──────────────────▶ データ保存
                             │
                             └─────────────────────▶ tblCalendarBooking

カレンダー選択        bs_ac_bookings.asp
  │                          │
  │  iCalID                  ▼
  └──────────────────▶ 予約一覧取得
                             │
                             └─────────────────────▶ 画面表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_ac_booking.asp | `asp/bs_ac_booking.asp` | インクルード | 予約編集画面 |
| bs_ac_bookings.asp | `asp/bs_ac_bookings.asp` | インクルード | 予約一覧画面 |
| ac_calendarbooking.asp | `asp/includes/ac_calendarbooking.asp` | インクルード | 予約データクラス |
| ac_statuslist.asp | `asp/includes/ac_statuslist.asp` | インクルード | ステータスリストクラス |
| sorttable.js | `js/sorttable.js` | JavaScript | テーブルソート機能 |
