# 機能設計書 76-カレンダー埋め込みコード

## 概要

本ドキュメントは、QuickerSite CMSにおける予約カレンダーの外部サイト埋め込み用コード生成機能の設計内容を記述する。

### 本機能の処理概要

作成した予約カレンダーを外部ウェブサイトに埋め込むためのHTMLコード（JavaScript、iframe、リンク）を生成する機能を提供する。

**業務上の目的・背景**：宿泊施設やレンタルサービスの運営者は、自社サイトだけでなく、外部のポータルサイトや予約サイトにも空き状況を表示したい場合がある。本機能により、管理者は簡単に埋め込み用のコードを取得し、任意のウェブサイトにカレンダーを組み込むことができる。これにより、複数のチャネルで一貫した空き状況情報を提供できる。

**機能の利用シーン**：管理者がカレンダー管理画面から埋め込みコードを生成し、そのコードをコピーして外部サイトや自社サイトのHTMLに貼り付ける場面で使用される。また、表示月数や凡例表示の有無などをカスタマイズする場面でも使用される。

**主要な処理内容**：
1. 表示設定の選択（期間、月数、凡例表示）
2. JavaScript埋め込みコードの生成
3. iframe埋め込みコードの生成
4. リンク用URLの生成

**関連システム・外部連携**：外部ウェブサイトへのカレンダー埋め込み

**権限による制御**：secondAdmin.bAvailabilityCal権限を持つ管理者のみがこの機能にアクセス可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 111 | 埋め込みコード | 主画面 | 外部サイトへの埋め込み用コード生成 |

## 機能種別

コード生成 / データ参照

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| iCalID | Integer | Yes | カレンダーID | 数値チェック |
| time | String | No | 表示期間タイプ（0:月数指定, 1:今年, 2:来年） | 0/1/2のいずれか |
| months | String | No | 表示月数（1-24、デフォルト12） | 数値チェック |
| iLegend | Boolean | No | 凡例表示フラグ | ブール値 |
| postback | Boolean | No | POSTバックフラグ | ブール値 |

### 入力データソース

- 画面入力（フォーム）
- tblCalendarテーブル（カレンダー情報）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| embedJSCode | String | JavaScript埋め込みコード |
| embedIFcode | String | iframe埋め込みコード |
| embedHTMLcode | String | リンク用URL |

### 出力先

画面表示（textarea形式でコピー可能）

## 処理フロー

### 処理シーケンス

```
1. 埋め込み設定画面表示
   └─ デフォルト設定（凡例表示有効）
2. 表示設定の選択
   ├─ 期間タイプ選択（月数指定/今年/来年）
   ├─ 月数選択（月数指定の場合）
   └─ 凡例表示有無
3. コード生成
   ├─ JavaScript埋め込みコード生成
   ├─ iframe埋め込みコード生成
   └─ リンクURL生成
4. コード表示
   └─ textareaで表示（クリックで全選択）
```

### フローチャート

```mermaid
flowchart TD
    A[埋め込みコード画面] --> B{期間タイプ選択}
    B -->|月数指定| C[月数選択]
    B -->|今年/来年| D[凡例設定]
    C --> D
    D --> E[フォーム送信]
    E --> F[コード生成]
    F --> G[JavaScript埋め込みコード]
    F --> H[iframe埋め込みコード]
    F --> I[リンクURL]
    G --> J[表示]
    H --> J
    I --> J
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-76-1 | デフォルト月数 | 月数未指定時は12ヶ月表示 | 月数指定モード |
| BR-76-2 | 凡例デフォルト | 凡例表示はデフォルトで有効 | 初期表示時 |
| BR-76-3 | 最大月数 | 最大36ヶ月まで表示可能 | 月数指定時 |

### 計算ロジック

JavaScript埋め込みコード生成:
```
embedJSCode = "<script type=""text/javascript"" src=""" &
              C_DIRECTORY_QUICKERSITE & "/asp/bs_ac_view.asp?" &
              timeParam & "&" & legend & "months=" & nm &
              "&mode=js&iCalID=" & cal.iId & """></script>"
```

iframe埋め込みコード生成:
```
embedIFcode = "<iframe frameborder=""0"" style=""width:100%;height:850px"" src=""" &
              customer.sQSUrl & "/asp/bs_ac_view.asp?" & timeParam &
              "&months=" & nm & "&" & legend & "mode=if&iCalID=" & cal.iId & """ />"
```

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| カレンダー取得 | tblCalendar | SELECT | カレンダー情報の取得 |

### テーブル別操作詳細

#### tblCalendar

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | sName, iId | iId=指定ID | カレンダー名取得 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 認証エラー | 権限なしアクセス | アクセス拒否 |
| - | パラメータエラー | カレンダーIDなし | 画面表示なし |

### リトライ仕様

なし（参照系処理のためリトライ不要）

## トランザクション仕様

なし（参照のみ）

## パフォーマンス要件

特になし

## セキュリティ考慮事項

- secondAdmin.bAvailabilityCal権限によるアクセス制御
- 埋め込みコードはカレンダーIDを含むが、表示は読み取り専用
- 外部サイトからのアクセスは表示のみ許可

## 備考

- 推奨はJavaScript埋め込み方式（ページ内に直接表示）
- iframeは他ドメインへの埋め込み用
- リンクURLはカレンダー単体ページへのリンク用
- 月数パラメータで表示範囲をカスタマイズ可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | bs_ac_embed.asp | `asp/bs_ac_embed.asp` | 埋め込みコード生成のメインロジック |

**読解のコツ**: このファイルは比較的短いが、3種類の埋め込みコード生成を理解することが重要。

**主要処理フロー**:
1. **2-3行目**: カレンダーオブジェクトの取得
2. **4-13行目**: 凡例フラグの処理
3. **14-19行目**: 月数設定の処理
4. **20-29行目**: 各パラメータの組み立て
5. **30-32行目**: 3種類の埋め込みコード生成
6. **33-38行目**: フォームとコード表示

#### Step 2: カレンダービュー生成を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_ac_view.asp | `asp/bs_ac_view.asp` | 実際のカレンダービュー生成処理 |

**読解のコツ**: modeパラメータ（js/if/html）によって出力形式が変わる。

### プログラム呼び出し階層図

```
bs_ac.asp（メイン画面）
    │
    └─ bs_ac_embed.asp（埋め込みコード画面）
           ├─ cls_calendar.pick()
           ├─ JavaScript埋め込みコード生成
           ├─ iframe埋め込みコード生成
           └─ リンクURL生成
                  │
                  └─ bs_ac_view.asp（ビュー生成）
                         ├─ mode=js: JavaScript出力
                         ├─ mode=if: iframe用HTML出力
                         └─ mode=html: 通常HTML出力
```

### データフロー図

```
[入力]                    [処理]                         [出力]

設定選択              bs_ac_embed.asp
  │                          │
  │  time                    ▼
  │  months             パラメータ組み立て
  │  iLegend                 │
  │                          ▼
  └──────────────────▶ コード生成
                             │
                             ├─────────────────────▶ JavaScript埋め込みコード
                             │                          （textarea表示）
                             │
                             ├─────────────────────▶ iframe埋め込みコード
                             │                          （textarea表示）
                             │
                             └─────────────────────▶ リンクURL
                                                        （textarea表示）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_ac_embed.asp | `asp/bs_ac_embed.asp` | インクルード | 埋め込みコード生成画面 |
| bs_ac_view.asp | `asp/bs_ac_view.asp` | ソース | カレンダービュー生成（埋め込み先で実行） |
| ac_calendar.asp | `asp/includes/ac_calendar.asp` | インクルード | カレンダーデータクラス |
| ac_calendarview.asp | `asp/includes/ac_calendarview.asp` | インクルード | カレンダービュー表示クラス |
