# 機能設計書 77-ショッピングカート管理

## 概要

本ドキュメントは、QuickerSite CMSにおけるECサイト機能の商品・カテゴリ管理のダッシュボード機能の設計内容を記述する。

### 本機能の処理概要

ECサイト（ショッピングカート）機能の統合管理画面として、商品カテゴリ、メーカー、商品の一覧表示とそれぞれの編集画面への遷移を提供する。

**業務上の目的・背景**：ECサイトを運営するためには、商品情報、カテゴリ、メーカー情報を統合的に管理する必要がある。本機能により、管理者はEC機能全体の概要を把握し、各管理画面へ素早くアクセスできる。これにより、商品管理の効率化と運用コストの削減を実現する。

**機能の利用シーン**：管理者がショッピングカート管理画面にアクセスし、現在登録されているカテゴリ、メーカー、商品を確認する場面で使用される。また、各項目の編集画面へ遷移したり、新規登録を行ったりする際の起点としても使用される。

**主要な処理内容**：
1. 商品カテゴリ一覧の表示（階層構造）
2. メーカー一覧の表示
3. 商品一覧の表示
4. 各編集画面への遷移リンク提供
5. オンライン/オフライン状態の表示

**関連システム・外部連携**：なし（システム内部での管理）

**権限による制御**：secondAdmin.bShoppingCart権限を持つ管理者のみがこの機能にアクセス可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 98 | ショッピングカート管理 | 主画面 | ECサイト機能の商品・カテゴリ管理 |
| 99 | カテゴリ管理 | 遷移先 | 商品カテゴリの階層管理 |
| 100 | メーカー管理 | 遷移先 | 商品メーカー・ブランドの管理 |
| 101 | 商品管理 | 遷移先 | 商品の追加・編集・削除 |
| 102 | 商品カテゴリ | 遷移先 | 商品のカテゴリ割り当て |
| 103 | 商品画像 | 遷移先 | 商品画像のアップロード・管理 |

## 機能種別

ダッシュボード / データ参照

## 入力仕様

### 入力パラメータ

なし（一覧表示のみ）

### 入力データソース

- tblQShopCategoryテーブル（カテゴリ情報）
- tblQShopProductテーブル（商品情報）
- tblQShopMakeテーブル（メーカー情報）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| カテゴリ一覧 | List | 階層構造のカテゴリリスト |
| メーカー一覧 | List | メーカーリスト |
| 商品一覧 | List | 商品リスト（名前、メーカー付き） |
| オンライン状態 | Boolean | 各項目の公開状態 |

### 出力先

画面表示（HTML）

## 処理フロー

### 処理シーケンス

```
1. 権限チェック
   └─ secondAdmin.bShoppingCart権限確認
2. データ取得
   ├─ カテゴリ一覧取得（親子階層付き）
   ├─ メーカー一覧取得
   └─ 商品一覧取得
3. 画面レンダリング
   ├─ カテゴリセクション表示
   ├─ メーカーセクション表示
   └─ 商品セクション表示
4. 各項目の操作リンク生成
   ├─ 編集リンク
   ├─ カテゴリ設定リンク（商品のみ）
   └─ 画像管理リンク（商品のみ）
```

### フローチャート

```mermaid
flowchart TD
    A[ショッピングカート管理画面] --> B[データ取得]
    B --> C[カテゴリ一覧取得]
    B --> D[メーカー一覧取得]
    B --> E[商品一覧取得]
    C --> F[カテゴリセクション表示]
    D --> G[メーカーセクション表示]
    E --> H[商品セクション表示]
    F --> I{操作選択}
    G --> I
    H --> I
    I -->|カテゴリ編集| J[bs_shopAdCat.asp]
    I -->|メーカー編集| K[bs_shopMake.asp]
    I -->|商品編集| L[bs_shopProduct.asp]
    I -->|カテゴリ設定| M[bs_shopProductCat.asp]
    I -->|画像管理| N[bs_shopProductImg.asp]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-77-1 | 階層表示 | カテゴリは親子階層で表示 | カテゴリ一覧 |
| BR-77-2 | オフライン表示 | オフライン項目は色分けして表示 | 全一覧 |
| BR-77-3 | 名前順ソート | 各一覧は名前順でソート | 全一覧 |

### 計算ロジック

なし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| カテゴリ取得 | tblQShopCategory | SELECT | カテゴリ一覧取得 |
| メーカー取得 | tblQShopMake | SELECT | メーカー一覧取得 |
| 商品取得 | tblQShopProduct | SELECT | 商品一覧取得 |

### テーブル別操作詳細

#### tblQShopCategory

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | iId, sName, bOnline, iParentCatID | iCustomerID=cId AND iParentCatID IS NULL | 親カテゴリ取得 |
| SELECT | iId, sName, bOnline | iCustomerID=cId AND iParentCatID=親ID | 子カテゴリ取得 |

#### tblQShopProduct

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | iId, sName, iMakeID | iCustomerID=cId ORDER BY sName | 商品一覧 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 認証エラー | 権限なしアクセス | アクセス拒否 |

### リトライ仕様

なし（参照系処理のためリトライ不要）

## トランザクション仕様

なし（参照のみ）

## パフォーマンス要件

特になし

## セキュリティ考慮事項

- secondAdmin.bShoppingCart権限によるアクセス制御
- IDパラメータの暗号化（encrypt関数）

## 備考

- 商品一覧にはメーカー名も表示される
- 各項目のオンライン/オフライン状態を色分けで表示
- 新規登録ボタンは各セクションに配置

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | shopCategory.asp | `asp/includes/shopCategory.asp` | cls_shopCategoryクラス、list関数、subcategories関数 |
| 1-2 | shopProduct.asp | `asp/includes/shopProduct.asp` | cls_shopProductクラス、allproductsプロパティ |
| 1-3 | shopMake.asp | `asp/includes/shopMake.asp` | cls_shopMakeクラス |

**読解のコツ**: list関数は親カテゴリのみを取得し、subcategoriesで子カテゴリを取得する階層構造を理解すること。

#### Step 2: メイン画面を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_shoppingcart.asp | `asp/bs_shoppingcart.asp` | ショッピングカート管理のメイン画面 |

**主要処理フロー**:
1. **4行目**: 権限チェック（secondAdmin.bShoppingCart）
2. **4-8行目**: カテゴリ、メーカー一覧の取得
3. **8-20行目**: カテゴリ一覧表示（親子階層）
4. **21-25行目**: メーカー一覧表示
5. **30-44行目**: 商品一覧表示

### プログラム呼び出し階層図

```
bs_shoppingcart.asp（管理画面）
    │
    ├─ includes/shopCategory.asp
    │      ├─ cls_shopCategory.list()
    │      └─ cls_shopCategory.subcategories()
    │
    ├─ includes/shopMake.asp
    │      └─ cls_shopMake.list()
    │
    ├─ includes/shopProduct.asp
    │      └─ cls_shopProduct.allproducts
    │
    ├─ bs_shoppingcartmenu.asp（メニュー）
    │
    └─ 遷移先
           ├─ bs_shopAdCat.asp（カテゴリ編集）
           ├─ bs_shopMake.asp（メーカー編集）
           ├─ bs_shopProduct.asp（商品編集）
           ├─ bs_shopProductCat.asp（商品カテゴリ）
           └─ bs_shopProductImg.asp（商品画像）
```

### データフロー図

```
[入力]                    [処理]                         [出力]

なし                  bs_shoppingcart.asp
                             │
                             ▼
tblQShopCategory ──────▶ カテゴリ一覧取得 ──────▶ カテゴリセクション
                             │
tblQShopMake ──────────▶ メーカー一覧取得 ──────▶ メーカーセクション
                             │
tblQShopProduct ───────▶ 商品一覧取得 ─────────▶ 商品セクション
                                                       │
                                                       ▼
                                                  画面表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_shoppingcart.asp | `asp/bs_shoppingcart.asp` | ソース | ショッピングカート管理メイン画面 |
| bs_shoppingcartmenu.asp | `asp/bs_shoppingcartmenu.asp` | インクルード | ショッピングカートメニュー |
| shopCategory.asp | `asp/includes/shopCategory.asp` | インクルード | カテゴリデータクラス |
| shopProduct.asp | `asp/includes/shopProduct.asp` | インクルード | 商品データクラス |
| shopMake.asp | `asp/includes/shopMake.asp` | インクルード | メーカーデータクラス |
