# 機能設計書 78-商品管理

## 概要

本ドキュメントは、QuickerSite CMSにおけるECサイト機能の商品の追加・編集・削除機能の設計内容を記述する。

### 本機能の処理概要

ECサイトで販売する商品情報（商品名、説明、在庫数、メーカー等）の登録、編集、削除を行う機能を提供する。

**業務上の目的・背景**：ECサイトを運営するためには、販売する商品の情報を正確に管理する必要がある。本機能により、管理者は商品情報を登録・更新し、在庫状況を管理できる。これにより、顧客に正確な商品情報を提供し、在庫切れによる機会損失を防ぐことができる。

**機能の利用シーン**：管理者が新商品を追加したり、既存商品の価格や説明を変更したり、販売終了した商品を削除する場面で使用される。また、在庫数の更新や公開/非公開の切り替えにも使用される。

**主要な処理内容**：
1. 商品情報の新規登録
2. 商品情報の編集（名前、説明、在庫、メーカー、オンライン状態）
3. 商品の削除（関連画像フォルダも削除）
4. WYSIWYGエディタによる詳細説明の編集

**関連システム・外部連携**：なし（システム内部での管理）

**権限による制御**：secondAdmin.bShoppingCart権限を持つ管理者のみがこの機能にアクセス可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 101 | 商品管理 | 主画面 | 商品の追加・編集・削除 |
| 98 | ショッピングカート管理 | 遷移元 | 商品管理画面への遷移 |

## 機能種別

CRUD操作（作成・読取・更新・削除）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| iShopProductID | String | No | 商品ID（暗号化） | decrypt後の数値チェック |
| sName | String | Yes | 商品名（最大255文字） | 必須、255文字以内 |
| sShortDesc | String | No | 短い説明 | 文字列 |
| sLongDesc | String | No | 詳細説明（リッチテキスト） | HTML |
| iStock | Integer | No | 在庫数 | 数値チェック |
| iMakeID | Integer | No | メーカーID | 数値チェック |
| bOnline | Boolean | No | オンライン公開フラグ | ブール値 |

### 入力データソース

- 画面入力（フォーム）
- tblQShopProductテーブル（既存データ）
- tblQShopMakeテーブル（メーカー選択）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| iId | Integer | 商品ID |
| sName | String | 商品名 |
| sShortDesc | String | 短い説明 |
| sLongDesc | String | 詳細説明 |
| iStock | Integer | 在庫数 |
| iMakeID | Integer | メーカーID |
| bOnline | Boolean | オンライン公開フラグ |
| dCreatedTS | DateTime | 作成日時 |
| dUpdatedTS | DateTime | 更新日時 |

### 出力先

- tblQShopProductテーブル（データ保存）
- 画面表示（HTML）

## 処理フロー

### 処理シーケンス

```
1. 商品編集画面表示
   ├─ 新規の場合は空フォーム
   └─ 既存の場合はデータ読み込み
2. メーカー選択リスト生成
   └─ tblQShopMakeからメーカー一覧取得
3. 保存処理
   ├─ 必須項目バリデーション（商品名）
   ├─ 在庫数の数値チェック
   └─ データベースへ保存
4. 削除処理
   ├─ 確認ダイアログ表示
   ├─ 商品画像フォルダ削除
   └─ 商品レコード削除
```

### フローチャート

```mermaid
flowchart TD
    A[商品管理画面] --> B{新規/既存}
    B -->|新規| C[空フォーム表示]
    B -->|既存| D[データ読み込み]
    D --> E[フォーム表示]
    C --> E
    E --> F{保存/削除?}
    F -->|保存| G[バリデーション]
    G -->|OK| H[データ保存]
    H --> I[一覧へリダイレクト]
    G -->|NG| E
    F -->|削除| J[確認ダイアログ]
    J -->|Yes| K[画像フォルダ削除]
    K --> L[商品削除]
    L --> I
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-78-1 | 必須項目 | 商品名は必須 | 保存時 |
| BR-78-2 | 在庫数は数値 | 在庫数が指定される場合は数値でなければならない | 保存時 |
| BR-78-3 | カスケード削除 | 商品削除時は関連画像フォルダも削除 | 削除時 |
| BR-78-4 | タイムスタンプ | 作成時・更新時に日時を記録 | 保存時 |

### 計算ロジック

なし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 商品取得 | tblQShopProduct | SELECT | 商品詳細の取得 |
| 保存 | tblQShopProduct | INSERT/UPDATE | 商品情報の保存 |
| 削除 | tblQShopProduct | DELETE | 商品の削除 |

### テーブル別操作詳細

#### tblQShopProduct

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | iId=指定ID | 詳細取得 |
| INSERT | sName, sShortDesc, sLongDesc, iStock, iMakeID, bOnline, iCustomerID, dCreatedTS, dUpdatedTS | 入力値, cId, now() | 新規作成 |
| UPDATE | sName, sShortDesc, sLongDesc, iStock, iMakeID, bOnline, dUpdatedTS | 入力値, now() | 更新 |
| DELETE | - | iId=指定ID | 削除 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| err_mandatory | 入力エラー | sNameが空 | エラーメッセージ表示 |
| err_mandatory | 入力エラー | iStockが数値でない | エラーメッセージ表示 |

### リトライ仕様

なし

## トランザクション仕様

単一レコードの操作のため、個別のトランザクションで処理。削除時はファイルシステムの削除も含む。

## パフォーマンス要件

特になし

## セキュリティ考慮事項

- secondAdmin.bShoppingCart権限によるアクセス制御
- CSRF対策（QS_secCodeHidden）
- IDパラメータの暗号化（encrypt/decrypt関数）
- 削除時の確認ダイアログ表示
- 入力値のサニタイズ（sanitize関数）

## 備考

- 詳細説明はWYSIWYGエディタ（FCKEditor）で編集可能
- 在庫数は空欄でも登録可能
- 商品画像は別画面（bs_shopProductImg.asp）で管理

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | shopProduct.asp | `asp/includes/shopProduct.asp` | cls_shopProductクラスの構造、プロパティ、check関数、save関数、delete関数 |

**読解のコツ**: check関数（35-49行目）でバリデーションロジックを、delete関数（83-90行目）でファイルシステム操作を理解すること。

#### Step 2: 編集画面を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_shopProduct.asp | `asp/bs_shopProduct.asp` | 商品編集のメインロジック |

**主要処理フロー**:
1. **4-6行目**: 商品オブジェクトの取得
2. **7-9行目**: メーカーオブジェクトの取得
3. **11-24行目**: POSTバック時の保存/削除処理
4. **25行目**: フォーム表示（WYSIWYGエディタ使用）

### プログラム呼び出し階層図

```
bs_shopProduct.asp（商品編集画面）
    │
    ├─ includes/shopProduct.asp
    │      ├─ cls_shopProduct.pick()
    │      ├─ cls_shopProduct.check()
    │      ├─ cls_shopProduct.save()
    │      └─ cls_shopProduct.delete()
    │             └─ FileSystemObject（画像フォルダ削除）
    │
    ├─ includes/shopMake.asp
    │      └─ cls_shopMake.showMake()
    │
    └─ FCKEditor（WYSIWYGエディタ）
           └─ createFCKInstance()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

フォーム入力          bs_shopProduct.asp
  │                          │
  │  sName                   ▼
  │  sShortDesc         商品オブジェクト取得
  │  sLongDesc               │
  │  iStock                  ▼
  │  iMakeID            バリデーション
  │  bOnline                 │
  │                          ▼
  └──────────────────▶ データ保存
                             │
                             └─────────────────────▶ tblQShopProduct

削除リクエスト              │
  │                         ▼
  └──────────────────▶ 画像フォルダ削除
                             │
                             └─────────────────────▶ ファイルシステム
                             │
                             └─────────────────────▶ tblQShopProduct DELETE
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_shopProduct.asp | `asp/bs_shopProduct.asp` | ソース | 商品編集画面 |
| shopProduct.asp | `asp/includes/shopProduct.asp` | インクルード | 商品データクラス |
| shopMake.asp | `asp/includes/shopMake.asp` | インクルード | メーカーデータクラス |
| bs_shoppingcartmenu.asp | `asp/bs_shoppingcartmenu.asp` | インクルード | ショッピングカートメニュー |
