# 機能設計書 79-商品カテゴリ管理

## 概要

本ドキュメントは、QuickerSite CMSにおけるECサイト機能の商品カテゴリの階層管理機能の設計内容を記述する。

### 本機能の処理概要

商品を分類するためのカテゴリの作成、編集、削除、および商品へのカテゴリ割り当てを行う機能を提供する。

**業務上の目的・背景**：ECサイトで多数の商品を扱う場合、商品をカテゴリ別に整理することで顧客が目的の商品を見つけやすくなる。本機能により、管理者は商品カテゴリを階層構造（親カテゴリ・子カテゴリ）で管理し、商品を適切に分類できる。これにより、顧客のショッピング体験を向上させ、売上向上に貢献する。

**機能の利用シーン**：管理者が新しい商品カテゴリを追加したり、既存カテゴリの名前を変更したり、不要なカテゴリを削除する場面で使用される。また、商品を特定のカテゴリに割り当てたり、割り当てを変更したりする場面でも使用される。

**主要な処理内容**：
1. 商品カテゴリの新規作成
2. カテゴリ情報の編集（名前、親カテゴリ、オンライン状態）
3. カテゴリの削除
4. 商品へのカテゴリ割り当て（複数選択可能）
5. 親子階層構造の管理

**関連システム・外部連携**：なし（システム内部での管理）

**権限による制御**：secondAdmin.bShoppingCart権限を持つ管理者のみがこの機能にアクセス可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 99 | カテゴリ管理 | 主画面 | 商品カテゴリの階層管理 |
| 102 | 商品カテゴリ | 主画面 | 商品のカテゴリ割り当て |
| 98 | ショッピングカート管理 | 遷移元 | カテゴリ管理画面への遷移 |

## 機能種別

CRUD操作（作成・読取・更新・削除）

## 入力仕様

### 入力パラメータ（カテゴリ編集画面）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| iShopCatID | String | No | カテゴリID（暗号化） | decrypt後の数値チェック |
| sName | String | Yes | カテゴリ名（最大255文字） | 必須、255文字以内 |
| iParentCatID | Integer | No | 親カテゴリID | 数値チェック |
| bOnline | Boolean | No | オンライン公開フラグ | ブール値 |

### 入力パラメータ（商品カテゴリ割り当て画面）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| iShopProductID | String | Yes | 商品ID（暗号化） | decrypt後の数値チェック |
| cat | Array | No | 選択されたカテゴリIDリスト（暗号化） | 各値のdecrypt後数値チェック |

### 入力データソース

- 画面入力（フォーム）
- tblQShopCategoryテーブル（既存データ）
- tblQShopProdCatテーブル（商品-カテゴリ関連）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| iId | Integer | カテゴリID |
| sName | String | カテゴリ名 |
| iParentCatID | Integer | 親カテゴリID |
| bOnline | Boolean | オンライン公開フラグ |
| dCreatedTS | DateTime | 作成日時 |
| dUpdatedTS | DateTime | 更新日時 |

### 出力先

- tblQShopCategoryテーブル（カテゴリ保存）
- tblQShopProdCatテーブル（商品-カテゴリ関連保存）
- 画面表示（HTML）

## 処理フロー

### 処理シーケンス（カテゴリ編集）

```
1. カテゴリ編集画面表示
   ├─ 新規の場合は空フォーム
   └─ 既存の場合はデータ読み込み
2. 親カテゴリ選択リスト生成
   └─ 子カテゴリを持つ場合は親選択不可
3. 保存処理
   ├─ 必須項目バリデーション（カテゴリ名）
   └─ データベースへ保存
4. 削除処理
   ├─ 確認ダイアログ表示
   ├─ 子カテゴリの親参照解除
   ├─ 商品-カテゴリ関連削除
   └─ カテゴリレコード削除
```

### 処理シーケンス（商品カテゴリ割り当て）

```
1. 商品カテゴリ割り当て画面表示
   ├─ 商品情報取得
   ├─ 全カテゴリ一覧取得
   └─ 現在の割り当て状態取得
2. 保存処理
   ├─ 既存の関連を全削除
   └─ 選択されたカテゴリを新規登録
```

### フローチャート

```mermaid
flowchart TD
    A[カテゴリ編集画面] --> B{新規/既存}
    B -->|新規| C[空フォーム表示]
    B -->|既存| D[データ読み込み]
    C --> E[フォーム表示]
    D --> E
    E --> F{保存/削除?}
    F -->|保存| G[バリデーション]
    G -->|OK| H[データ保存]
    H --> I[オフライン連動]
    I --> J[一覧へリダイレクト]
    G -->|NG| E
    F -->|削除| K[確認ダイアログ]
    K -->|Yes| L[子の親参照解除]
    L --> M[商品関連削除]
    M --> N[カテゴリ削除]
    N --> J
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-79-1 | 必須項目 | カテゴリ名は必須 | 保存時 |
| BR-79-2 | 階層制限 | 子カテゴリを持つカテゴリは親を持てない（2階層まで） | 編集時 |
| BR-79-3 | オフライン連動 | 親カテゴリをオフラインにすると子もオフライン | 保存時 |
| BR-79-4 | 削除時の関連解除 | 削除時は子カテゴリの親参照を解除 | 削除時 |
| BR-79-5 | 複数カテゴリ | 1商品を複数カテゴリに割り当て可能 | 割り当て時 |

### 計算ロジック

なし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| カテゴリ取得 | tblQShopCategory | SELECT | カテゴリ詳細の取得 |
| カテゴリ保存 | tblQShopCategory | INSERT/UPDATE | カテゴリ情報の保存 |
| カテゴリ削除 | tblQShopCategory | UPDATE/DELETE | 親参照解除、カテゴリ削除 |
| 関連取得 | tblQShopProdCat | SELECT | 商品-カテゴリ関連取得 |
| 関連保存 | tblQShopProdCat | DELETE/INSERT | 関連の全削除後、新規登録 |

### テーブル別操作詳細

#### tblQShopCategory

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | iId=指定ID | 詳細取得 |
| INSERT | sName, iParentCatID, bOnline, iCustomerID, dCreatedTS, dUpdatedTS | 入力値, cId, now() | 新規作成 |
| UPDATE | sName, iParentCatID, bOnline, dUpdatedTS | 入力値, now() | 更新 |
| UPDATE | iParentCatID | null | 子の親参照解除 |
| UPDATE | bOnline | false | 親がオフライン時に子も連動 |
| DELETE | - | iId=指定ID | 削除 |

#### tblQShopProdCat

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | iCategoryID | iProductID=指定ID | 割り当て取得 |
| DELETE | - | iProductID=指定ID | 全関連削除 |
| DELETE | - | iCategoryID=指定ID | カテゴリ削除時 |
| INSERT | iProductID, iCategoryID | 商品ID, カテゴリID | 新規関連登録 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| err_mandatory | 入力エラー | sNameが空 | エラーメッセージ表示 |

### リトライ仕様

なし

## トランザクション仕様

商品カテゴリ割り当て時は、全削除後に新規登録するため、トランザクション管理が必要。

## パフォーマンス要件

特になし

## セキュリティ考慮事項

- secondAdmin.bShoppingCart権限によるアクセス制御
- CSRF対策（QS_secCodeHidden）
- IDパラメータの暗号化（encrypt/decrypt関数）
- 削除時の確認ダイアログ表示
- 入力値のサニタイズ（sanitize関数）

## 備考

- 階層は2階層まで（親カテゴリと子カテゴリ）
- 商品は複数のカテゴリに属することが可能
- 親カテゴリのオフライン化は子カテゴリに連動

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | shopCategory.asp | `asp/includes/shopCategory.asp` | cls_shopCategoryクラス、subcategories関数、bShowParentCatDropDown、delete関数 |

**読解のコツ**: bShowParentCatDropDownプロパティ（96-105行目）で親選択可否の判定ロジックを理解すること。

#### Step 2: カテゴリ編集画面を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_shopAdCat.asp | `asp/bs_shopAdCat.asp` | カテゴリ編集のメインロジック |

**主要処理フロー**:
1. **4-6行目**: カテゴリオブジェクトの取得
2. **9-18行目**: POSTバック時の保存/削除処理
3. **20-21行目**: 親カテゴリ選択可否の条件分岐

#### Step 3: 商品カテゴリ割り当てを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_shopProductCat.asp | `asp/bs_shopProductCat.asp` | 商品へのカテゴリ割り当て |

**主要処理フロー**:
- **10-12行目**: 保存処理（saveCats呼び出し）
- **15-32行目**: カテゴリチェックボックス表示

### プログラム呼び出し階層図

```
bs_shopAdCat.asp（カテゴリ編集画面）
    │
    ├─ includes/shopCategory.asp
    │      ├─ cls_shopCategory.pick()
    │      ├─ cls_shopCategory.check()
    │      ├─ cls_shopCategory.save()
    │      ├─ cls_shopCategory.delete()
    │      ├─ cls_shopCategory.bShowParentCatDropDown
    │      ├─ cls_shopCategory.bShowOnlineCB
    │      └─ cls_shopCategory.showParentCat()
    │
    └─ bs_shoppingcartmenu.asp

bs_shopProductCat.asp（商品カテゴリ割り当て画面）
    │
    ├─ includes/shopProduct.asp
    │      ├─ cls_shopProduct.pick()
    │      ├─ cls_shopProduct.categories()
    │      └─ cls_shopProduct.saveCats()
    │
    └─ includes/shopCategory.asp
           ├─ cls_shopCategory.list()
           └─ cls_shopCategory.subcategories()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

フォーム入力          bs_shopAdCat.asp
  │                          │
  │  sName                   ▼
  │  iParentCatID       バリデーション
  │  bOnline                 │
  │                          ▼
  └──────────────────▶ データ保存
                             │
                             ├─────────────────────▶ tblQShopCategory
                             │
                             └─────────────────────▶ 子カテゴリオフライン連動

チェックボックス       bs_shopProductCat.asp
  │                          │
  │  cat[]                   ▼
  └──────────────────▶ 関連全削除
                             │
                             ├─────────────────────▶ tblQShopProdCat DELETE
                             │
                             └─────────────────────▶ tblQShopProdCat INSERT
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_shopAdCat.asp | `asp/bs_shopAdCat.asp` | ソース | カテゴリ編集画面 |
| bs_shopProductCat.asp | `asp/bs_shopProductCat.asp` | ソース | 商品カテゴリ割り当て画面 |
| shopCategory.asp | `asp/includes/shopCategory.asp` | インクルード | カテゴリデータクラス |
| shopProduct.asp | `asp/includes/shopProduct.asp` | インクルード | 商品データクラス（saveCats） |
