# 機能設計書 8-ページ一覧

## 概要

本ドキュメントは、QuickerSite CMSのページ一覧機能について記述する。

### 本機能の処理概要

本機能は、サイト内のページを階層構造で表示し、各ページに対する操作（編集、コピー、移動、パスワード設定等）へのアクセスを提供する。管理者はこの画面を通じてサイト全体のページ構造を把握し、各種ページ管理操作を実行できる。

**業務上の目的・背景**：CMSにおいてページの管理は最も基本的かつ重要な機能である。サイトの階層構造を視覚的に把握し、効率的にページを管理するためにページ一覧機能が必要となる。

**機能の利用シーン**：
- サイト構造の確認・把握
- 特定ページへのアクセス（編集画面への遷移）
- ページのコピー・移動操作
- ページのパスワード保護設定
- ページの表示順序変更
- フリーページの管理

**主要な処理内容**：
1. ページ階層構造の表示（ツリー形式）
2. ページ種別アイコンの表示（ホームページ、コンテナ、リスト等）
3. 各種操作リンクの提供
4. フリーページ一覧の表示
5. メニューキャッシュの利用

**関連システム・外部連携**：なし

**権限による制御**：
- 基本表示は認証済み管理者全員
- ページ追加: secondAdmin.bPagesAdd
- ページ移動: secondAdmin.bPagesMove
- パスワード管理: secondAdmin.bPagesPW
- 表示順変更: secondAdmin.bPageOrder

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 10 | 管理画面トップ | 主画面 | ページ一覧の表示 |
| 11 | メニュー | 部品画面 | ページ階層の表示 |
| 12 | ページ選択 | 遷移先画面 | ページ移動先の選択 |
| 13 | ページ編集 | 遷移先画面 | ページ内容の編集 |
| 14 | パスワード適用 | 遷移先画面 | ページのパスワード設定 |

## 機能種別

一覧表示 / ナビゲーション

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| btnaction | String | No | 実行アクション | MoveUp / MoveDown / Copy / Move |
| iId | String(暗号化) | No | 対象ページID | 復号化後に数値チェック |

### 入力データソース

- URLパラメータ
- データベース（tblPage）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| ページ階層ツリー | HTML | 階層構造のリスト表示 |
| ページタイトル | String | 各ページのタイトル |
| ページ種別アイコン | Image | ホームページ、コンテナ、リスト等 |
| 操作リンク | HTML | 編集、コピー、移動等のリンク |
| フリーページ一覧 | HTML | 独立ページのリスト |

### 出力先

- 画面表示（bs_default.asp）
- アプリケーションキャッシュ（メニューキャッシュ）

## 処理フロー

### 処理シーケンス

```
1. ページ一覧画面アクセス
   └─ 認証チェック（bs_security.asp）

2. アクション処理（btnactionがある場合）
   └─ MoveUp: ページを上に移動
   └─ MoveDown: ページを下に移動
   └─ Copy: ページをコピー
   └─ Move: ページ移動先選択画面へ遷移

3. メニュー表示
   └─ キャッシュ確認
   └─ キャッシュがなければ生成
   └─ getBOMenu()でページ階層を取得
   └─ 権限に応じた操作アイコンを表示

4. フリーページ表示
   └─ lossePaginas()でフリーページ取得
   └─ フリーページ一覧を表示
```

### フローチャート

```mermaid
flowchart TD
    A[ページ一覧画面] --> B[認証チェック]
    B --> C{btnactionあり?}
    C -->|Yes| D{アクション種別}
    D -->|MoveUp| E[CSRF検証]
    E --> F[page.moveUp]
    F --> G[リダイレクト]
    D -->|MoveDown| H[CSRF検証]
    H --> I[page.moveDown]
    I --> G
    D -->|Copy| J[CSRF検証]
    J --> K[page.copy]
    K --> G
    D -->|Move| L[ページ選択画面へ]
    C -->|No| M[メニュー表示処理]
    M --> N{キャッシュあり?}
    N -->|Yes| O[キャッシュから表示]
    N -->|No| P[getBOMenu生成]
    P --> Q[キャッシュ保存]
    Q --> O
    O --> R[フリーページ取得]
    R --> S[フリーページ表示]
    S --> T[画面表示完了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 階層表示 | ページは階層構造（ツリー）で表示される | 常時 |
| BR-02 | キャッシュ利用 | メニュー表示はキャッシュを利用して高速化 | 常時 |
| BR-03 | 権限別アイコン | 操作アイコンは権限に応じて表示/非表示 | 常時 |
| BR-04 | 削除済み非表示 | bDeleted=trueのページは表示されない | 常時 |
| BR-05 | オンライン判定 | ページのオンライン/オフライン状態を表示 | 常時 |
| BR-06 | フリーページ分離 | 階層に属さないフリーページは別セクションで表示 | 常時 |

### 計算ロジック

- 表示順序: iRang カラムの昇順
- 階層判定: iParentID による親子関係

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ページ一覧取得 | tblPage | SELECT | 階層構造でページ取得 |
| 表示順上げ | tblPage | UPDATE | iRangを減少 |
| 表示順下げ | tblPage | UPDATE | iRangを増加 |
| ページコピー | tblPage | INSERT | 新規ページ作成 |

### テーブル別操作詳細

#### tblPage

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | iId, sTitle, bOnline等 | iCustomerID=cId, bDeleted=false, bLossePagina=false | メニュー用ページ取得 |
| SELECT | iId, sTitle等 | iCustomerID=cId, bDeleted=false, bLossePagina=true | フリーページ取得 |
| UPDATE | iRang | 現在値-1 | 表示順上げ |
| UPDATE | iRang | 現在値+1 | 表示順下げ |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| （なし） | - | ページ一覧表示は読み取り専用のためエラーは発生しにくい | - |

### リトライ仕様

- 表示エラー時はページリロードで再取得

## トランザクション仕様

- ページ移動・コピー時: 単一トランザクションで完結

## パフォーマンス要件

- ページ一覧表示: キャッシュ利用により高速化
- キャッシュ更新: ページ変更時に自動クリア

## セキュリティ考慮事項

- 認証チェック（bs_security.asp）
- 各操作に対するCSRF対策トークン検証
- 権限に応じた操作アイコンの表示制御
- ページIDの暗号化（EnCrypt/DeCrypt）

## 備考

- メニューキャッシュはアプリケーションレベルで管理される
- イントラネットページは別画面（bs_intranet.asp）で管理
- ページ編集時にキャッシュがクリアされる

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ページのデータ構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | page.asp | `asp/includes/page.asp` | cls_pageクラスのプロパティ定義（4-11行目） |

**読解のコツ**: cls_pageクラスで以下のプロパティが一覧表示に関連する。
- `iId`: ページID
- `iParentID`: 親ページID（階層構造）
- `sTitle`: ページタイトル
- `iRang`: 表示順序
- `bOnline`: オンライン状態
- `bDeleted`: 削除フラグ
- `bLossePagina`: フリーページフラグ
- `bContainerPage`: コンテナページフラグ
- `bHomepage`: ホームページフラグ

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_default.asp | `asp/bs_default.asp` | ページ一覧画面のメインファイル（16行） |

**主要処理フロー**:
1. **1-3行目**: begin.asp、bs_security.aspインクルード
2. **4行目**: ナビゲーションリンク表示（新規ページ、定数、検索等）
3. **4行目**: bs_menu.aspインクルード（メニュー表示）

**ナビゲーションリンク**:
- `bs_default.asp`: ページ一覧
- `bs_setupPage.asp`: 新規ページ（bPagesAdd権限が必要）
- `bs_constantlist.asp`: 定数（bHomeConstants権限が必要）
- `bs_search.asp`: 検索

#### Step 3: メニュー表示処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_menu.asp | `asp/bs_menu.asp` | メニュー表示処理（27行） |

**主要処理フロー**:
- **2-3行目**: cls_menuオブジェクト生成
- **4-6行目**: キャッシュ確認・生成
- **7行目**: メニュー出力
- **8-24行目**: フリーページ一覧表示

**キャッシュ処理**:
```vbscript
if isEmpty(application(QS_CMS_cacheBOMenu & logon.currentPW)) then
  application(QS_CMS_cacheBOMenu & logon.currentPW)=menu.getBOMenu(null,false)
end if
```

#### Step 4: メニュー生成ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | menu.asp | `asp/includes/menu.asp` | cls_menuクラスのgetBOMenu関数 |

**主要処理フロー**:
- **150-200行目**: getBOMenu関数
- **155-163行目**: ページ取得SQL
- **166-200行目**: ページループ処理、アイコン生成

**権限別アイコン表示**:
- `secondAdmin.bPagesAdd`: 新規追加、コピーアイコン
- `secondAdmin.bPagesMove` + `bPageOrder`: 上下移動アイコン
- `secondAdmin.bPagesPW`: パスワード管理アイコン

#### Step 5: アクション処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | bs_process.asp | `asp/bs_process.asp` | ページ操作処理 |

**主要処理フロー**:
- **20-27行目**: MoveUp処理
- **28-35行目**: MoveDown処理
- **65-73行目**: Copy処理
- **36-40行目**: Move処理（ページ選択画面へ遷移）

### プログラム呼び出し階層図

```
bs_default.asp
    │
    ├─ begin.asp（インクルード）
    │      └─ includes/page.asp（cls_pageクラス）
    │
    ├─ bs_security.asp（認証チェック）
    │
    ├─ bs_process.asp（アクション処理）
    │      ├─ MoveUp
    │      │      └─ page.moveUp()
    │      ├─ MoveDown
    │      │      └─ page.moveDown()
    │      ├─ Copy
    │      │      └─ page.copy()
    │      └─ Move
    │             └─ bs_selectPage.aspへ遷移
    │
    ├─ bs_menu.asp（メニュー表示）
    │      ├─ キャッシュ確認
    │      │      └─ application(QS_CMS_cacheBOMenu)
    │      ├─ menu.getBOMenu()
    │      │      └─ ページ階層取得・HTML生成
    │      └─ menu.lossePaginas()
    │             └─ フリーページ取得
    │
    └─ 画面表示
           ├─ ページ階層ツリー
           └─ フリーページ一覧
```

### データフロー図

```
[入力]               [処理]                    [出力]

URLアクセス ─────▶ bs_default.asp
                        │
                        ▼
                  bs_security.asp
                  (認証チェック)
                        │
                        ▼
              ┌─────────┴─────────┐
              ▼                   ▼
      btnactionあり          btnactionなし
              │                   │
              ▼                   │
      bs_process.asp             │
      (MoveUp/Down/Copy)         │
              │                   │
              └─────────┬─────────┘
                        ▼
                  bs_menu.asp
                        │
              ┌─────────┴─────────┐
              ▼                   ▼
      キャッシュあり         キャッシュなし
              │                   │
              │                   ▼
              │           menu.getBOMenu()
              │                   │
              │                   ▼
              │           tblPage SELECT
              │           (階層構造取得)
              │                   │
              │                   ▼
              │           キャッシュ保存
              │                   │
              └─────────┬─────────┘
                        ▼
                  HTML出力
                  (ページツリー)
                        │
                        ▼
                  lossePaginas()
                  (フリーページ)
                        │
                        ▼
                  画面表示完了
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_default.asp | `asp/bs_default.asp` | ソース | ページ一覧画面メインファイル |
| bs_menu.asp | `asp/bs_menu.asp` | ソース | メニュー表示処理 |
| bs_process.asp | `asp/bs_process.asp` | ソース | アクション処理（移動・コピー） |
| menu.asp | `asp/includes/menu.asp` | ソース | cls_menuクラス定義 |
| page.asp | `asp/includes/page.asp` | ソース | cls_pageクラス定義 |
| bs_security.asp | `asp/bs_security.asp` | ソース | 認証チェック |
| secondAdmin.asp | `asp/includes/secondAdmin.asp` | ソース | 権限チェック |
| bs_selectPage.asp | `asp/bs_selectPage.asp` | ソース | ページ移動先選択画面 |
