# 機能設計書 80-商品画像管理

## 概要

本ドキュメントは、QuickerSite CMSにおけるECサイト機能の商品画像のアップロード・管理機能の設計内容を記述する。

### 本機能の処理概要

商品に紐づく画像のアップロード、表示、削除、およびデフォルト画像の設定を行う機能を提供する。

**業務上の目的・背景**：ECサイトにおいて、商品画像は購買意欲に大きく影響する重要な要素である。本機能により、管理者は商品ごとに複数の画像をアップロードし、サムネイル表示で管理できる。また、デフォルト画像を設定することで、一覧ページやカート画面で表示される代表画像を指定できる。

**機能の利用シーン**：管理者が新商品に画像を追加したり、既存商品の画像を入れ替えたり、不要な画像を削除する場面で使用される。また、複数の画像の中からデフォルト画像を設定する場面でも使用される。

**主要な処理内容**：
1. 商品画像の一覧表示（サムネイル形式）
2. 画像のアップロード（JPGファイルのみ）
3. 画像の削除
4. デフォルト画像の設定
5. 画像のプレビュー（Lightbox形式）

**関連システム・外部連携**：サムネイル生成機能（showThumb.aspx）と連携

**権限による制御**：secondAdmin.bShoppingCart権限を持つ管理者のみがこの機能にアクセス可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 103 | 商品画像 | 主画面 | 商品画像のアップロード・管理 |
| 104 | 商品画像アップロード | 処理画面 | 商品画像のアップロード処理 |
| 98 | ショッピングカート管理 | 遷移元 | 商品画像管理への遷移 |

## 機能種別

ファイル管理（アップロード・削除）/ データ更新

## 入力仕様

### 入力パラメータ（画像管理画面）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| iShopProductID | String | Yes | 商品ID（暗号化） | decrypt後の数値チェック |
| delete | String | No | 削除対象の画像ファイル名 | ファイル存在チェック |
| default | String | No | デフォルト設定対象の画像ファイル名 | ファイル存在チェック |

### 入力パラメータ（アップロード処理）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| iShopProductID | String | Yes | 商品ID（暗号化） | decrypt後の数値チェック |
| image1 | File | Yes | 画像ファイル | JPGファイルのみ許可 |

### 入力データソース

- 画面入力（フォーム、ファイルアップロード）
- ファイルシステム（既存画像）
- tblQShopProductテーブル（デフォルト画像情報）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 画像一覧 | List | 商品に紐づく画像リスト |
| サムネイル | Image | 画像のサムネイル表示 |
| sDefaultImage | String | デフォルト画像ファイル名 |

### 出力先

- ファイルシステム（画像ファイル保存）
- tblQShopProductテーブル（sDefaultImage更新）
- 画面表示（HTML）

## 処理フロー

### 処理シーケンス

```
1. 商品画像管理画面表示
   ├─ 商品情報取得
   └─ 既存画像一覧取得（ファイルシステムから）
2. 削除リクエスト処理
   ├─ ファイル削除
   └─ デフォルト画像の場合はsDefaultImageクリア
3. デフォルト設定リクエスト処理
   └─ sDefaultImage更新
4. アップロード処理
   ├─ フォルダ存在確認・作成
   ├─ ファイルアップロード
   ├─ 拡張子チェック（JPGのみ）
   └─ 不正ファイルの場合は削除
```

### フローチャート

```mermaid
flowchart TD
    A[商品画像管理画面] --> B{リクエスト種別}
    B -->|表示のみ| C[画像一覧取得]
    B -->|削除| D[ファイル削除]
    B -->|デフォルト設定| E[sDefaultImage更新]
    B -->|アップロード| F[アップロード処理画面]
    C --> G[サムネイル表示]
    D --> H{デフォルト画像?}
    H -->|Yes| I[sDefaultImageクリア]
    H -->|No| G
    I --> G
    E --> G
    F --> J[フォルダ確認・作成]
    J --> K[ファイル保存]
    K --> L{JPGファイル?}
    L -->|Yes| M[アップロード完了]
    L -->|No| N[ファイル削除]
    N --> O[エラーメッセージ]
    M --> G
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-80-1 | JPGのみ | アップロード可能なファイル形式はJPGのみ | アップロード時 |
| BR-80-2 | フォルダ自動作成 | 商品用フォルダが存在しない場合は自動作成 | アップロード時 |
| BR-80-3 | デフォルト画像削除 | デフォルト画像削除時はsDefaultImageをクリア | 削除時 |
| BR-80-4 | 複数画像 | 1商品に複数画像をアップロード可能 | アップロード時 |

### 計算ロジック

画像保存パス: `C_VIRT_DIR & Application("QS_CMS_userfiles") & qsscart & "/" & 商品ID & "/" & ファイル名`

サムネイルURL: `C_DIRECTORY_QUICKERSITE & "/showthumb.aspx?img=" & 画像パス & "&maxsize=150&FSR=1`

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 商品取得 | tblQShopProduct | SELECT | 商品詳細の取得 |
| デフォルト設定 | tblQShopProduct | UPDATE | sDefaultImage更新 |
| デフォルトクリア | tblQShopProduct | UPDATE | sDefaultImage=""に更新 |

### テーブル別操作詳細

#### tblQShopProduct

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | sDefaultImage | iId=指定ID | デフォルト画像取得 |
| UPDATE | sDefaultImage | 指定ファイル名 | デフォルト設定 |
| UPDATE | sDefaultImage | "" | デフォルトクリア |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| err_fileType | ファイルエラー | JPG以外のファイルアップロード | エラーメッセージ表示、ファイル削除 |
| err_newFile | ファイルエラー | ファイルが選択されていない | エラーメッセージ表示 |

### リトライ仕様

なし

## トランザクション仕様

ファイルシステム操作とデータベース操作が混在するため、適切な順序で処理する。

## パフォーマンス要件

- サムネイル生成は動的に行われる（showThumb.aspx）
- 大量画像の場合、一覧表示に時間がかかる可能性あり

## セキュリティ考慮事項

- secondAdmin.bShoppingCart権限によるアクセス制御
- CSRF対策（QS_secCodeHidden、checkCSRF_Upload）
- IDパラメータの暗号化（encrypt/decrypt関数）
- ファイル拡張子チェック（JPGのみ許可）
- 削除時の確認ダイアログ表示

## 備考

- 画像ファイルは商品IDごとのフォルダに保存
- Lightbox形式で大きな画像をプレビュー可能（QSPPIMG class）
- サムネイル生成はshowThumb.aspxで動的に実行

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | shopProduct.asp | `asp/includes/shopProduct.asp` | images関数、deleteImage関数、setAsDefaultImage関数 |

**読解のコツ**: images関数（103-116行目）でファイルシステムから画像リストを取得するロジックを理解する。

#### Step 2: 画像管理画面を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_shopProductImg.asp | `asp/bs_shopProductImg.asp` | 画像一覧表示、削除、デフォルト設定のロジック |

**主要処理フロー**:
1. **4-6行目**: 商品オブジェクトの取得
2. **8-9行目**: 削除リクエスト処理
3. **10-12行目**: デフォルト設定リクエスト処理
4. **14行目以降**: サムネイル一覧表示

#### Step 3: アップロード処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_shopProductImgUpload.asp | `asp/bs_shopProductImgUpload.asp` | ファイルアップロードのメインロジック |

**主要処理フロー**:
- **4-6行目**: 商品オブジェクトの取得
- **9-14行目**: フォルダ存在確認・作成
- **17-21行目**: ファイルアップロード処理
- **22-35行目**: 拡張子チェックと不正ファイル削除

### プログラム呼び出し階層図

```
bs_shopProductImg.asp（画像管理画面）
    │
    ├─ includes/shopProduct.asp
    │      ├─ cls_shopProduct.pick()
    │      ├─ cls_shopProduct.images()
    │      │      └─ FileSystemObject.getFolder()
    │      ├─ cls_shopProduct.deleteImage()
    │      │      └─ FileSystemObject.deletefile()
    │      └─ cls_shopProduct.setAsDefaultImage()
    │             └─ cls_shopProduct.save()
    │
    └─ showThumb.aspx（サムネイル生成）

bs_shopProductImgUpload.asp（アップロード処理）
    │
    ├─ includes/shopProduct.asp
    │      └─ cls_shopProduct.pick()
    │
    ├─ FileSystemObject
    │      ├─ folderexists()
    │      └─ createFolder()
    │
    └─ FreeASPUpload（アップロードライブラリ）
           ├─ Save()
           └─ UploadedFiles()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ファイル選択          bs_shopProductImgUpload.asp
  │                          │
  │  image1                  ▼
  └──────────────────▶ フォルダ確認・作成
                             │
                             └─────────────────────▶ ファイルシステム
                             │
                             ▼
                        拡張子チェック
                             │
                        ┌────┴────┐
                        │        │
                       OK       NG
                        │        │
                        ▼        ▼
                      保存    ファイル削除
                        │        │
                        └────────┴─────────────────▶ エラーメッセージ
                                                      または
                                                      一覧へリダイレクト

削除/デフォルト      bs_shopProductImg.asp
リクエスト                   │
  │                         ▼
  │  delete            ファイル削除
  │  default                │
  └──────────────────▶ sDefaultImage更新
                             │
                             └─────────────────────▶ tblQShopProduct
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_shopProductImg.asp | `asp/bs_shopProductImg.asp` | ソース | 商品画像管理画面 |
| bs_shopProductImgUpload.asp | `asp/bs_shopProductImgUpload.asp` | ソース | 画像アップロード処理 |
| shopProduct.asp | `asp/includes/shopProduct.asp` | インクルード | 商品データクラス（images, deleteImage, setAsDefaultImage） |
| showThumb.aspx | `showThumb.aspx` | ASPX | サムネイル動的生成 |
| freeASPUpload.asp | `asp/includes/freeASPUpload.asp` | インクルード | ファイルアップロードライブラリ |
