# 機能設計書 81-メーカー管理

## 概要

本ドキュメントは、QuickerSite CMSにおけるショッピングカート機能の「メーカー管理」機能について、その設計仕様を詳細に記述したものである。

### 本機能の処理概要

メーカー管理機能は、ECサイトで取り扱う商品のメーカー（ブランド）情報を登録・編集・削除するための管理機能である。

**業務上の目的・背景**：ECサイトにおいて、商品を製造元やブランドで分類・検索できるようにすることで、ユーザーの商品選択を支援する。また、メーカーごとのロゴ表示により、ブランド認知度の向上やユーザーの信頼性向上に寄与する。管理者は複数のメーカー情報を一元管理することで、商品カタログの整合性を保つことができる。

**機能の利用シーン**：新規メーカーの取り扱いを開始する際、またはメーカー情報（名称、ロゴ、公開状態）を変更する際に管理者が使用する。商品登録時にメーカーを選択するためのマスタデータとしても機能する。

**主要な処理内容**：
1. メーカー一覧からの選択・編集画面への遷移
2. メーカー名とロゴURLの入力・検証
3. 公開/非公開状態の設定
4. データベースへの保存（新規登録/更新）
5. メーカーの削除

**関連システム・外部連携**：本機能は単体で完結し、外部システムとの連携は行わない。商品管理機能からメーカー情報を参照する。

**権限による制御**：ショッピングカート管理権限（secondAdmin.bShoppingCart）を持つ管理者のみがアクセス可能である。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 100 | メーカー管理 | 主画面 | 商品メーカー・ブランドの管理 |
| 98 | ショッピングカート管理 | 参照画面 | ECサイト機能の商品・カテゴリ管理からの遷移元 |

## 機能種別

CRUD操作（Create: メーカー新規登録、Read: メーカー情報取得、Update: メーカー情報更新、Delete: メーカー削除）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| iShopMakeID | String(暗号化) | No | メーカーID（編集時） | 復号後に数値チェック |
| sName | String | Yes | メーカー名 | 最大250文字、空白チェック |
| sLogo | String | No | メーカーロゴURL | 最大250文字 |
| bOnline | Boolean | No | 公開状態 | 1=公開、未指定=非公開 |
| btnaction | String | Yes | 実行アクション | "save"または"delete" |
| postback | Boolean | Yes | POSTフラグ | true/false |

### 入力データソース

- 画面フォーム入力（メーカー名、ロゴURL、公開状態）
- URLパラメータ（暗号化されたメーカーID）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| iId | Integer | メーカーID（自動採番） |
| sName | String | メーカー名 |
| sLogo | String | ロゴURL |
| bOnline | Boolean | 公開状態 |
| dCreatedTS | DateTime | 作成日時 |
| dUpdatedTS | DateTime | 更新日時 |

### 出力先

- データベーステーブル（tblQShopMake）
- 画面リダイレクト（bs_shoppingcart.asp）

## 処理フロー

### 処理シーケンス

```
1. 認証・権限チェック
   └─ ショッピングカート管理権限の確認
2. メーカー情報の取得
   └─ iShopMakeIDが指定されている場合、既存データをDBから取得
3. POSTデータの処理（postback=trueの場合）
   └─ btnactionに応じて保存または削除を実行
4. 保存処理（btnaction="save"）
   └─ バリデーション → DB更新 → リダイレクト
5. 削除処理（btnaction="delete"）
   └─ DBからレコード削除 → リダイレクト
6. 画面表示
   └─ 編集フォームの出力
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{認証チェック}
    B -->|失敗| C[アクセス拒否]
    B -->|成功| D[メーカーID取得]
    D --> E{既存データ?}
    E -->|Yes| F[DBからデータ取得]
    E -->|No| G[新規インスタンス作成]
    F --> H{POSTリクエスト?}
    G --> H
    H -->|No| I[編集フォーム表示]
    H -->|Yes| J{アクション判定}
    J -->|save| K[入力値を設定]
    K --> L[バリデーション]
    L -->|OK| M[DB保存]
    M --> N[一覧へリダイレクト]
    L -->|NG| I
    J -->|delete| O[DB削除]
    O --> N
    I --> P[終了]
    N --> P
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-81-01 | メーカー名必須 | メーカー名は必須入力である | 保存時 |
| BR-81-02 | 文字数制限 | メーカー名・ロゴURLは最大255文字 | 保存時 |
| BR-81-03 | 顧客ID紐付け | メーカーは作成した顧客（サイト）に紐付く | 保存時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| メーカー取得 | tblQShopMake | SELECT | IDによるメーカー情報取得 |
| メーカー一覧取得 | tblQShopMake | SELECT | 顧客IDに紐づくメーカー一覧取得 |
| メーカー新規登録 | tblQShopMake | INSERT | 新規メーカーレコード作成 |
| メーカー更新 | tblQShopMake | UPDATE | 既存メーカー情報の更新 |
| メーカー削除 | tblQShopMake | DELETE | メーカーレコードの削除 |

### テーブル別操作詳細

#### tblQShopMake

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | iId = パラメータ値 | 単一レコード取得 |
| SELECT | iId | iCustomerID = cId ORDER BY sName | 一覧取得用 |
| INSERT | sName | 入力値（最大255文字） | 必須 |
| INSERT | sLogo | 入力値（最大255文字） | 任意 |
| INSERT | bOnline | 入力値（Boolean変換） | デフォルトtrue |
| INSERT | dCreatedTS | now() | 作成時のみ |
| INSERT | dUpdatedTS | now() | 毎回更新 |
| INSERT | iCustomerID | cId（セッション） | 顧客ID |
| UPDATE | sName, sLogo, bOnline, dUpdatedTS | 同上 | iIdで特定 |
| DELETE | - | iId = パラメータ値 | 物理削除 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| err_mandatory | 入力エラー | メーカー名が空の場合 | エラーメッセージ表示、再入力要求 |

### リトライ仕様

リトライ処理は実装されていない。エラー発生時は画面に戻り再入力を促す。

## トランザクション仕様

ADO Recordsetを使用した自動コミット方式。明示的なトランザクション制御は行わない。

## パフォーマンス要件

特に明示的な要件なし。通常のCRUD操作であり、数百件程度のメーカーデータを想定。

## セキュリティ考慮事項

- 認証必須：`logon.hasaccess secondAdmin.bShoppingCart`による権限チェック
- 入力サニタイズ：`sanitize()`関数による出力エスケープ
- ID暗号化：`encrypt()`/`decrypt()`関数によるメーカーIDの暗号化
- CSRF対策：`QS_secCodeHidden`によるトークン検証

## 備考

- メーカーロゴURLは外部URLを想定しており、ファイルアップロード機能は含まない
- メーカー削除時に関連する商品データへの影響は本機能では考慮されていない

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

メーカークラス（cls_shopMake）の構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | shopMake.asp | `asp/includes/shopMake.asp` | cls_shopMakeクラスの定義、プロパティ、メソッドの理解 |

**読解のコツ**: Classic ASPのクラス定義では、`Class_Initialize`がコンストラクタ、`Public`で宣言されたものがプロパティ・メソッドとなる。

#### Step 2: エントリーポイントを理解する

管理画面のメインファイルから処理の流れを追う。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_shopMake.asp | `asp/bs_shopMake.asp` | 画面表示とPOST処理のフロー |

**主要処理フロー**:
1. **4行目**: インクルードファイルと権限チェック（`logon.hasaccess secondAdmin.bShoppingCart`）
2. **5-6行目**: cls_shopMakeインスタンス作成とデータ取得（`shopMake.pick`）
3. **9-19行目**: POSTリクエスト処理（保存・削除の分岐）
4. **20行目**: HTMLフォーム出力

#### Step 3: クラスメソッドの詳細を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | shopMake.asp | `asp/includes/shopMake.asp` | Pick、Check、Save、deleteの各メソッド |

**主要処理フロー**:
- **23-38行目**: `Pick`関数 - IDからDBデータを取得
- **39-46行目**: `Check`関数 - バリデーション（メーカー名の空チェック）
- **47-72行目**: `Save`関数 - 新規/更新の判定とDB保存
- **73-76行目**: `delete`関数 - レコード削除

### プログラム呼び出し階層図

```
bs_shopMake.asp（エントリーポイント）
    │
    ├─ begin.asp（共通初期化）
    │
    ├─ bs_security.asp（認証チェック）
    │      └─ logon.hasaccess（権限検証）
    │
    ├─ cls_shopMake（メーカークラス）
    │      ├─ pick(id)（データ取得）
    │      ├─ check()（バリデーション）
    │      ├─ save()（保存処理）
    │      └─ delete()（削除処理）
    │
    └─ HTMLフォーム出力
```

### データフロー図

```
[入力]               [処理]                    [出力]

URLパラメータ ───▶ decrypt() ───▶ メーカーID
     │
     ▼
フォーム入力 ───▶ cls_shopMake ───▶ tblQShopMake
(sName,sLogo,        │                    │
 bOnline)            │                    ▼
                     ▼               データベース
              Check() → Save()
                     │
                     ▼
              bs_shoppingcart.asp（リダイレクト）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_shopMake.asp | `asp/bs_shopMake.asp` | ソース | メーカー編集画面のエントリーポイント |
| shopMake.asp | `asp/includes/shopMake.asp` | ソース | cls_shopMakeクラス定義（ビジネスロジック） |
| begin.asp | `asp/begin.asp` | ソース | 共通初期化処理 |
| bs_security.asp | `asp/bs_security.asp` | ソース | 認証・権限チェック |
| bs_shoppingcart.asp | `asp/bs_shoppingcart.asp` | ソース | ショッピングカート管理メイン画面 |
