# 機能設計書 82-イントラネット管理

## 概要

本ドキュメントは、QuickerSite CMSにおける「イントラネット管理」機能について、その設計仕様を詳細に記述したものである。

### 本機能の処理概要

イントラネット管理機能は、会員限定エリア（イントラネット）の設定・管理を行う管理機能である。会員制サイト運営に必要な各種設定を一元的に管理できる。

**業務上の目的・背景**：Webサイトに会員専用エリアを設けることで、登録会員のみがアクセスできるコンテンツを提供する。これにより、有料会員サービス、社内イントラネット、会員向け情報配信など、閉じられたコミュニティを構築できる。管理者は会員登録の可否、デフォルト権限、通知メール設定などを柔軟に設定できる。

**機能の利用シーン**：サイト構築初期のイントラネット機能の有効化設定、会員登録ポリシーの変更、会員向け自動メール設定の調整、アバター機能の有効化など、サイト運営方針に合わせた設定変更時に使用する。

**主要な処理内容**：
1. イントラネット機能の有効/無効切り替え
2. 会員ログインモード（メールアドレス/ニックネーム）の設定
3. 公開プロフィール機能の設定
4. アバター機能の設定（サイズ、ボーダー色）
5. 新規会員登録の許可/禁止設定
6. デフォルト会員ステータスの設定
7. 新規会員登録時の管理者通知メール設定
8. ページ更新通知メールアドレスの設定

**関連システム・外部連携**：本機能は設定管理のみであり、外部システムとの直接連携はない。設定内容はコンタクト管理、テーマ/フォーラム機能に影響を与える。

**権限による制御**：イントラネットセットアップ権限（secondAdmin.bIntranetSetup）を持つ管理者のみがアクセス可能である。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 117 | イントラネット管理 | 主画面 | 会員限定エリアの設定・管理 |
| 118 | イントラネット管理者 | 主画面 | イントラネットの管理者設定 |
| 119 | イントラネットメニュー | 主画面 | イントラネットメニューの表示 |

## 機能種別

設定管理（Update: 各種イントラネット設定の更新）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| intranetUse | Boolean | No | イントラネット機能の有効/無効 | 1=有効 |
| intranetName | String | Conditional | イントラネット名 | 最大49文字、機能有効時必須 |
| sLabelEditSite | String | Conditional | サイト編集ラベル | 最大50文字、機能有効時必須 |
| iLoginMode | Integer | Conditional | ログインモード | 0=メール、1=ニックネーム |
| intranetLogOff | String | Conditional | ログオフラベル | 最大49文字、機能有効時必須 |
| intranetUseMyProfile | Boolean | No | 公開プロフィール機能 | 1=有効 |
| intranetMyProfile | String | Conditional | マイプロフィールラベル | 最大49文字、プロフィール有効時必須 |
| bUseAvatars | Boolean | No | アバター機能 | 1=有効 |
| iAvatarSize | Integer | Conditional | アバターサイズ | 32-150px |
| sAvatarBorderColor | String | No | アバターボーダー色 | 空白でボーダーなし |
| bAllowNewRegistrations | Boolean | No | 新規登録許可 | 1=許可 |
| iDefaultStatus | Integer | Conditional | デフォルト会員ステータス | 登録許可時必須 |
| sLabelRegister | String | Conditional | 登録ラベル | 最大100文字 |
| bSendMailUponNewMember | Boolean | No | 新規会員通知 | 1=有効 |
| sEmailNewRegistrations | Email | Conditional | 通知先メールアドレス | 通知有効時必須 |
| sNotifValidate | String | No | ページ更新通知メール | 最大100文字 |
| postback | Boolean | Yes | POSTフラグ | true/false |
| saveAdminIntranet | String | Yes | 保存アクション | "save" |

### 入力データソース

- 画面フォーム入力（各種設定値）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| intranetUse | Boolean | イントラネット有効状態 |
| intranetName | String | イントラネット名 |
| sLabelEditSite | String | サイト編集ラベル |
| iLoginMode | Integer | ログインモード |
| intranetLogOff | String | ログオフラベル |
| intranetUseMyProfile | Boolean | プロフィール機能状態 |
| intranetMyProfile | String | マイプロフィールラベル |
| bUseAvatars | Boolean | アバター機能状態 |
| iAvatarSize | Integer | アバターサイズ |
| sAvatarBorderColor | String | アバターボーダー色 |
| bAllowNewRegistrations | Boolean | 新規登録許可状態 |
| iDefaultStatus | Integer | デフォルトステータス |
| sLabelRegister | String | 登録ラベル |
| bSendMailUponNewMember | Boolean | 新規会員通知状態 |
| sEmailNewRegistrations | String | 通知メールアドレス |
| sNotifValidate | String | 更新通知メール |

### 出力先

- データベーステーブル（tblCustomer - customerオブジェクト経由）
- 画面表示（設定完了メッセージ）

## 処理フロー

### 処理シーケンス

```
1. 認証・権限チェック
   └─ イントラネットセットアップ権限の確認
2. 会員ステータスリストの初期化
   └─ サイレントステータスを除外
3. POSTデータの処理（postback=trueの場合）
   └─ getIntranetAdminRequestValues()で値を取得
4. 保存処理（saveAdminIntranet="save"）
   └─ CSRF検証 → customer.save() → 成功メッセージ
5. 画面表示
   └─ 現在の設定値を反映したフォーム出力
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{認証チェック}
    B -->|失敗| C[アクセス拒否]
    B -->|成功| D[ステータスリスト初期化]
    D --> E{POSTリクエスト?}
    E -->|No| F[設定フォーム表示]
    E -->|Yes| G[リクエスト値取得]
    G --> H{保存アクション?}
    H -->|No| F
    H -->|Yes| I[CSRF検証]
    I --> J[customer.save]
    J -->|成功| K[成功メッセージ表示]
    J -->|失敗| L[エラーメッセージ表示]
    K --> F
    L --> F
    F --> M[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-82-01 | イントラネット名必須 | イントラネット有効時、名前は必須 | intranetUse=true |
| BR-82-02 | プロフィールラベル必須 | プロフィール有効時、ラベルは必須 | intranetUseMyProfile=true |
| BR-82-03 | アバターサイズデフォルト | アバター有効時、デフォルトは80px | bUseAvatars=true, iAvatarSize=0 |
| BR-82-04 | 通知メール必須 | 新規会員通知有効時、メールアドレスは必須 | bSendMailUponNewMember=true |
| BR-82-05 | デフォルトステータス | 新規登録会員に付与されるステータス | bAllowNewRegistrations=true |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 設定保存 | tblCustomer | UPDATE | イントラネット関連設定の更新 |

### テーブル別操作詳細

#### tblCustomer（customerオブジェクト経由）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | intranetUse | Boolean | イントラネット有効/無効 |
| UPDATE | intranetName | String(49) | イントラネット名 |
| UPDATE | sLabelEditSite | String(50) | サイト編集ラベル |
| UPDATE | iLoginMode | Integer | ログインモード |
| UPDATE | intranetLogOff | String(49) | ログオフラベル |
| UPDATE | intranetUseMyProfile | Boolean | プロフィール機能 |
| UPDATE | intranetMyProfile | String(49) | マイプロフィールラベル |
| UPDATE | bUseAvatars | Boolean | アバター機能 |
| UPDATE | iAvatarSize | Integer | アバターサイズ |
| UPDATE | sAvatarBorderColor | String | ボーダー色 |
| UPDATE | bAllowNewRegistrations | Boolean | 新規登録許可 |
| UPDATE | iDefaultStatus | Integer | デフォルトステータス |
| UPDATE | sLabelRegister | String(100) | 登録ラベル |
| UPDATE | bSendMailUponNewMember | Boolean | 新規会員通知 |
| UPDATE | sEmailNewRegistrations | String(50) | 通知メール |
| UPDATE | sNotifValidate | String(100) | 更新通知メール |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| err_mandatory | 入力エラー | 必須項目が未入力の場合 | エラーメッセージ表示、再入力要求 |

### リトライ仕様

リトライ処理は実装されていない。エラー発生時は画面に戻り再入力を促す。

## トランザクション仕様

customerオブジェクトのsave()メソッドを使用。ADO Recordsetによる自動コミット方式。

## パフォーマンス要件

特に明示的な要件なし。設定保存は単一レコードの更新処理。

## セキュリティ考慮事項

- 認証必須：`logon.hasaccess secondAdmin.bIntranetSetup`による権限チェック
- CSRF対策：`checkCSRF()`による検証、`QS_secCodeHidden`トークン
- 入力サニタイズ：`quotRep()`関数による出力エスケープ
- 確認ダイアログ：保存前のconfirm()による誤操作防止

## 備考

- イントラネット機能の有効/無効を切り替えると、画面が動的に再表示される（JavaScript: submit()）
- オンスクリーンメッセージと自動メール設定は別画面（bs_adminIntranetOSM.asp、bs_adminIntranetEM.asp）で管理される

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

customerオブジェクトのイントラネット関連プロパティを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | customer.asp | `asp/includes/customer.asp` | customerクラスのイントラネット関連プロパティ |

**読解のコツ**: customerオブジェクトはサイト全体の設定を保持するオブジェクトで、イントラネット設定もその一部として管理される。

#### Step 2: エントリーポイントを理解する

管理画面のメインファイルから処理の流れを追う。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_adminIntranet.asp | `asp/bs_adminIntranet.asp` | 画面表示とPOST処理のフロー |

**主要処理フロー**:
1. **4行目**: 権限チェック（`logon.hasaccess secondAdmin.bIntranetSetup`）とステータスリスト初期化
2. **5-8行目**: POSTリクエスト処理（値の取得）
3. **10-15行目**: 保存処理（CSRF検証、customer.save()）
4. **16-18行目**: 条件付き設定項目の表示（アバター、新規登録など）

#### Step 3: イントラネット一覧画面を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_intranet.asp | `asp/bs_intranet.asp` | イントラネットページ一覧表示 |

**主要処理フロー**:
- **4行目**: 権限チェック（`secondAdmin.bIntranet`）
- **4行目**: 新規ページ作成リンク（`bIntranet=true`フラグ付き）
- **4行目**: イントラネットメニュー表示（bs_menuIntranet.asp）

### プログラム呼び出し階層図

```
bs_adminIntranet.asp（設定画面エントリーポイント）
    │
    ├─ begin.asp（共通初期化）
    │
    ├─ bs_security.asp（認証チェック）
    │      └─ logon.hasaccess（権限検証）
    │
    ├─ cslist（会員ステータスリスト）
    │      └─ remove(cs_silent)（サイレント除外）
    │
    ├─ customer（顧客/サイト設定オブジェクト）
    │      ├─ getIntranetAdminRequestValues()（値取得）
    │      └─ save()（設定保存）
    │
    └─ HTMLフォーム出力（動的表示制御）

bs_intranet.asp（ページ一覧画面）
    │
    ├─ bs_menuIntranet.asp（イントラネットメニュー）
    │
    └─ ページ階層表示
```

### データフロー図

```
[入力]               [処理]                    [出力]

フォーム入力 ───▶ customer.get...() ───▶ プロパティ設定
(各種設定)            │
                      ▼
                 customer.save()
                      │
                      ▼
                 tblCustomer ───▶ 設定反映
                      │
                      ▼
              成功メッセージ表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_adminIntranet.asp | `asp/bs_adminIntranet.asp` | ソース | イントラネット設定画面 |
| bs_intranet.asp | `asp/bs_intranet.asp` | ソース | イントラネットページ一覧画面 |
| bs_adminIntranetOSM.asp | `asp/bs_adminIntranetOSM.asp` | ソース | オンスクリーンメッセージ設定 |
| bs_adminIntranetEM.asp | `asp/bs_adminIntranetEM.asp` | ソース | 自動メール設定 |
| bs_menuIntranet.asp | `asp/bs_menuIntranet.asp` | ソース | イントラネットメニュー表示 |
| customer.asp | `asp/includes/customer.asp` | ソース | 顧客/サイト設定クラス |
| begin.asp | `asp/begin.asp` | ソース | 共通初期化処理 |
| bs_security.asp | `asp/bs_security.asp` | ソース | 認証・権限チェック |
