# 機能設計書 84-コンタクト作成・編集

## 概要

本ドキュメントは、QuickerSite CMSにおける「コンタクト作成・編集」機能について、その設計仕様を詳細に記述したものである。

### 本機能の処理概要

コンタクト作成・編集機能は、会員（コンタクト）情報の新規登録・編集・削除を行う管理機能である。基本情報とカスタムフィールドを統合して管理できる。

**業務上の目的・背景**：会員制サイトの運営において、会員情報の正確な管理は必須である。本機能により、管理者は会員のログイン情報、プロフィール情報、会員ステータスなどを一元的に管理できる。また、パスワードリセットとその通知メール送信機能も提供し、会員サポート業務を効率化する。

**機能の利用シーン**：新規会員の手動登録、会員情報の修正（メールアドレス変更、ステータス変更等）、退会処理（削除）、パスワード再発行依頼への対応時に使用する。

**主要な処理内容**：
1. 会員基本情報（メール、パスワード、ニックネーム）の入力
2. カスタムフィールドの入力・編集
3. 会員ステータスの設定
4. プライベートメッセージ受信許可の設定
5. パスワードリセットと通知メール送信
6. 会員情報の保存（新規/更新）
7. 会員の削除

**関連システム・外部連携**：メール送信機能との連携（ステータス変更通知、パスワードリセット通知）。

**権限による制御**：イントラネットコンタクト管理権限（secondAdmin.bIntranetContacts）を持つ管理者のみがアクセス可能である。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 52 | 連絡先ホーム | 参照画面 | 会員一覧画面からの遷移元 |
| 53 | 連絡先編集 | 主画面 | 会員情報の登録・編集 |

## 機能種別

CRUD操作（Create: 会員新規登録、Read: 会員情報取得、Update: 会員情報更新、Delete: 会員削除）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| iContactID | String(暗号化) | No | 会員ID（編集時） | 復号後に数値チェック |
| sEmail | Email | Yes | メールアドレス | 必須、形式チェック、重複チェック |
| sPw | String | Yes | パスワード | 必須、最大20文字 |
| sNickname | String | Yes | ニックネーム | 必須、最大30文字、重複チェック |
| bGetEmailsFromSite | Boolean | No | プライベートメッセージ許可 | true/false |
| iStatus | Integer | Yes | 会員ステータス | ステータスリストの値 |
| (カスタムフィールド) | 動的 | 動的 | カスタムフィールドの値 | bMandatory設定に依存 |
| btnaction | String | Yes | 実行アクション | "save"/"delete"/"savAndResetPw" |
| postback | Boolean | Yes | POSTフラグ | true/false |

### 入力データソース

- 画面フォーム入力（会員情報、カスタムフィールド値）
- URLパラメータ（暗号化された会員ID）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| iId | Integer | 会員ID（自動採番） |
| sEmail | String | メールアドレス |
| sNickname | String | ニックネーム |
| sPw | String | パスワード |
| iStatus | Integer | 会員ステータス |
| bGetEmailsFromSite | Boolean | プライベートメッセージ許可 |
| fields | Dictionary | カスタムフィールド値 |
| dCreatedTS | DateTime | 登録日時 |
| dUpdatedTS | DateTime | 更新日時 |
| dLastLoginTS | DateTime | 最終ログイン日時 |

### 出力先

- データベーステーブル（tblContact, tblContactValues）
- 画面表示（保存完了/エラーメッセージ）
- メール送信（ステータス変更通知、パスワードリセット通知）

## 処理フロー

### 処理シーケンス

```
1. 認証・権限チェック
   └─ イントラネットコンタクト管理権限の確認
2. 会員情報の取得
   └─ iContactIDが指定されている場合、既存データをDBから取得
3. カスタムフィールド定義の取得
   └─ customer.contactFields()でフィールド定義を取得
4. POSTデータの処理
   └─ getRequestValues()で入力値を取得
5. アクション別処理
   ├─ save: バリデーション → DB保存 → 完了メッセージ
   ├─ delete: DB削除 → ポップアップクローズ
   └─ savAndResetPw: 保存 → パスワードリセット → メール送信
6. 画面表示
   └─ 編集フォームの出力
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{認証チェック}
    B -->|失敗| C[アクセス拒否]
    B -->|成功| D[会員情報取得]
    D --> E[カスタムフィールド取得]
    E --> F{POSTリクエスト?}
    F -->|No| G[編集フォーム表示]
    F -->|Yes| H{アクション判定}
    H -->|save| I[バリデーション]
    I -->|OK| J[DB保存]
    J --> K[成功メッセージ]
    I -->|NG| G
    H -->|delete| L[DB削除]
    L --> M[ポップアップクローズ]
    H -->|savAndResetPw| N[保存+パスワードリセット]
    N --> O[メール送信]
    O --> K
    K --> G
    G --> P[終了]
    M --> P
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-84-01 | メールアドレス必須 | メールアドレスは必須かつ形式チェック | 保存時 |
| BR-84-02 | メール重複チェック | 同一サイト内でメールアドレスの重複不可 | 保存時 |
| BR-84-03 | ニックネーム重複チェック | 同一サイト内でニックネームの重複不可 | 保存時 |
| BR-84-04 | 必須フィールドチェック | bMandatory=trueのカスタムフィールドは必須 | 保存時 |
| BR-84-05 | ステータス変更通知 | ステータス変更時にcs_silent以外なら通知メール送信 | 保存時 |
| BR-84-06 | パスワードリセット通知 | パスワードリセット時に新パスワードをメール送信 | savAndResetPw時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 会員取得 | tblContact | SELECT | IDによる会員情報取得 |
| フィールド値取得 | tblContactValues | SELECT | 会員IDに紐づくフィールド値取得 |
| 会員新規登録 | tblContact | INSERT | 新規会員レコード作成 |
| 会員更新 | tblContact | UPDATE | 既存会員情報の更新 |
| フィールド値削除 | tblContactValues | DELETE | 会員のフィールド値全削除 |
| フィールド値登録 | tblContactValues | INSERT | 会員のフィールド値一括登録 |
| 重複メールチェック | tblContact | SELECT | 同一メールの存在確認 |
| 重複ニックネームチェック | tblContact | SELECT | 同一ニックネームの存在確認 |
| 会員削除 | tblContact | DELETE | 会員レコード削除 |
| 関連データ削除 | 複数テーブル | DELETE | フィールド値、投稿、購読等の削除 |

### テーブル別操作詳細

#### tblContact

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT/UPDATE | sEmail | 入力値（小文字変換） | 必須 |
| INSERT/UPDATE | sNickName | 入力値 | 必須 |
| INSERT/UPDATE | sPw | 入力値/生成パスワード | 必須 |
| INSERT/UPDATE | iStatus | 入力値 | 必須 |
| INSERT/UPDATE | bGetEmailsFromSite | 入力値 | Boolean |
| INSERT | dCreatedTS | now() | 新規登録時のみ |
| UPDATE | dUpdatedTS | now() | 毎回更新 |
| INSERT/UPDATE | iCustomerID | cId | 顧客ID |

#### tblContactValues

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | - | iContactID = 会員ID | 一括削除 |
| INSERT | iContactID | 会員ID | フィールドごとに挿入 |
| INSERT | iFieldID | フィールドID | |
| INSERT | sValue | 入力値 | |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| err_mandatory | 入力エラー | 必須項目が未入力 | エラーメッセージ表示 |
| err_email | 形式エラー | メールアドレス形式不正 | エラーメッセージ表示 |
| err_doubleemail | 重複エラー | メールアドレス重複 | エラーメッセージ表示 |
| err_doublenickname | 重複エラー | ニックネーム重複 | エラーメッセージ表示 |

### リトライ仕様

リトライ処理は実装されていない。エラー発生時は画面に戻り再入力を促す。

## トランザクション仕様

ADO Recordsetを使用した自動コミット方式。フィールド値の保存は一度削除してから挿入するため、エラー時のロールバックは不完全。

## パフォーマンス要件

特に明示的な要件なし。単一会員の操作であり、通常のCRUD処理。

## セキュリティ考慮事項

- 認証必須：`logon.hasaccess secondAdmin.bIntranetContacts`による権限チェック
- CSRF対策：`checkCSRF()`による検証、`QS_secCodeHidden`トークン
- 入力サニタイズ：`quotRep()`関数による出力エスケープ
- ID暗号化：`encrypt()`/`decrypt()`関数による会員IDの暗号化
- パスワード：平文保存（セキュリティ上の懸念あり）
- 削除確認：confirm()ダイアログによる誤操作防止

## 備考

- パスワードは平文でDBに保存されており、セキュリティ観点では要改善
- ステータス変更時の通知メール内容はcls_customerImessで管理される
- ポップアップ画面として表示され、保存/削除後はcPopup.close()で親画面に戻る

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

会員（コンタクト）クラスの構造を詳細に理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | contact.asp | `asp/includes/contact.asp` | cls_contactクラスの全体構造 |

**読解のコツ**: fieldsプロパティはDictionary型で、iFieldIDをキー、sValueをバリューとして保持。Check関数でバリデーション、Save関数で保存処理を行う。

#### Step 2: エントリーポイントを理解する

管理画面のメインファイルから処理の流れを追う。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_contactEdit.asp | `asp/bs_contactEdit.asp` | 画面表示とPOST処理のフロー |

**主要処理フロー**:
1. **4行目**: 権限チェック（`secondAdmin.bIntranetContacts`）
2. **5行目**: cls_contactインスタンス作成（自動でrequest("iContactID")をpick）
3. **14-18行目**: POST時の値取得、ステータス設定
4. **19-40行目**: アクション別処理（save/delete/savAndResetPw）
5. **42-47行目**: フィールドタイプごとのフォーム要素生成

#### Step 3: 会員クラスのCRUD処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | contact.asp | `asp/includes/contact.asp` | Check, Save, delete, resetPWメソッド |

**主要処理フロー**:
- **80-128行目**: `Check`関数 - 必須チェック、メール形式、重複チェック
- **153-225行目**: `Save`関数 - 会員情報保存、フィールド値保存、ステータス変更通知
- **247-271行目**: `delete`関数 - 関連データ含む会員削除
- **288-306行目**: `resetPW`関数 - パスワード生成、DB更新、メール送信

### プログラム呼び出し階層図

```
bs_contactEdit.asp（エントリーポイント）
    │
    ├─ begin.asp（共通初期化）
    │
    ├─ bs_security.asp（認証チェック）
    │      └─ logon.hasaccess（権限検証）
    │
    ├─ cls_contact（会員クラス）
    │      ├─ pick(id)（データ取得）
    │      ├─ getRequestValues()（値取得）
    │      ├─ check()（バリデーション）
    │      ├─ save()（保存処理）
    │      │     └─ cls_mail_message（ステータス変更通知）
    │      ├─ delete()（削除処理）
    │      └─ resetPW()（パスワードリセット）
    │            └─ cls_mail_message（パスワード通知）
    │
    └─ cPopup.close()（ポップアップクローズ）
```

### データフロー図

```
[入力]               [処理]                    [出力]

フォーム入力 ───▶ cls_contact ───▶ check()
(基本情報,            │                 │
カスタムフィールド)    │                 ▼
                      │           バリデーション
                      │                 │
                      ▼                 ▼
              getRequestValues() ───▶ save()
                                       │
                    ┌──────────────────┴──────────────────┐
                    ▼                                      ▼
              tblContact                           tblContactValues
              (基本情報保存)                        (フィールド値保存)
                    │
                    ▼
              ステータス変更通知メール（変更時のみ）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_contactEdit.asp | `asp/bs_contactEdit.asp` | ソース | 会員編集画面のエントリーポイント |
| contact.asp | `asp/includes/contact.asp` | ソース | cls_contactクラス定義 |
| contactField.asp | `asp/includes/contactField.asp` | ソース | cls_contactFieldクラス定義 |
| contactStatusList.asp | `asp/includes/contactStatusList.asp` | ソース | 会員ステータスリスト |
| mail.asp | `asp/includes/mail.asp` | ソース | メール送信クラス |
| begin.asp | `asp/begin.asp` | ソース | 共通初期化処理 |
| bs_security.asp | `asp/bs_security.asp` | ソース | 認証・権限チェック |
