# 機能設計書 85-コンタクトフィールド管理

## 概要

本ドキュメントは、QuickerSite CMSにおける「コンタクトフィールド管理」機能について、その設計仕様を詳細に記述したものである。

### 本機能の処理概要

コンタクトフィールド管理機能は、会員（コンタクト）情報のカスタムフィールドを定義・管理する機能である。サイトの要件に合わせて柔軟なプロフィール項目を設定できる。

**業務上の目的・背景**：会員制サイトにおいて必要な会員情報は業種や目的によって異なる。本機能により、管理者は標準項目（メール、ニックネーム、パスワード）に加えて、氏名、住所、電話番号、生年月日など任意のカスタムフィールドを定義できる。これにより、各サイトの要件に合った会員情報の収集・管理が可能になる。

**機能の利用シーン**：サイト構築初期の会員情報項目の設計、新たな情報収集が必要になった際のフィールド追加、不要になったフィールドの削除、表示順序の調整時に使用する。

**主要な処理内容**：
1. カスタムフィールドの一覧表示
2. フィールドの新規作成（タイプ、名前、選択肢の設定）
3. フィールドの編集（属性変更）
4. フィールドの削除
5. 表示順序の変更（上下移動）
6. 必須/検索対象/プロフィール表示の設定

**関連システム・外部連携**：定義されたフィールドはコンタクト一覧（No.83）、コンタクト作成・編集（No.84）、会員登録（No.105）、会員プロフィール編集（No.107）で使用される。

**権限による制御**：イントラネットコンタクト管理権限（secondAdmin.bIntranetContacts）を持つ管理者のみがアクセス可能である。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 54 | 連絡先フィールド一覧 | 主画面 | 会員情報カスタムフィールドの一覧表示 |
| 55 | 連絡先フィールド編集 | 主画面 | 会員情報フィールドの詳細設定 |

## 機能種別

CRUD操作（Create: フィールド新規作成、Read: フィールド一覧/詳細取得、Update: フィールド編集、Delete: フィールド削除）/ 並び替え

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| iFieldID | String(暗号化) | No | フィールドID（編集時） | 復号後に数値チェック |
| sFieldName | String | Yes | フィールド名 | 必須 |
| sType | String | Yes | フィールドタイプ | 必須、定義済みタイプ |
| sValues | String | Conditional | 選択肢（select時） | select時必須、改行区切り |
| bMandatory | Boolean | No | 必須項目フラグ | 1=必須 |
| bSearchField | Boolean | No | 検索対象フラグ | 1=検索対象 |
| bProfile | Boolean | No | プロフィール表示フラグ | 1=表示 |
| btnaction | String | Yes | 実行アクション | "save"/"delete"/"MoveUP"/"MoveDOWN" |
| postback | Boolean | Yes | POSTフラグ | true/false |

### 入力データソース

- 画面フォーム入力（フィールド定義）
- URLパラメータ（暗号化されたフィールドID、移動アクション）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| iId | Integer | フィールドID（自動採番） |
| sFieldName | String | フィールド名 |
| sType | String | フィールドタイプ |
| sValues | String | 選択肢（改行区切り） |
| iRang | Integer | 表示順序 |
| bMandatory | Boolean | 必須フラグ |
| bSearchField | Boolean | 検索対象フラグ |
| bProfile | Boolean | プロフィール表示フラグ |

### 出力先

- データベーステーブル（tblContactField, tblContactValues）
- 画面リダイレクト（bs_contactFields.asp）

## 処理フロー

### 処理シーケンス

```
1. 認証・権限チェック
   └─ イントラネットコンタクト管理権限の確認
2. フィールド情報の取得（編集/移動時）
   └─ iFieldIDが指定されている場合、既存データをDBから取得
3. アクション処理
   ├─ MoveUP/MoveDOWN: 表示順序の変更
   ├─ save: バリデーション → DB保存 → リダイレクト
   └─ delete: DB削除 → リダイレクト
4. 画面表示
   └─ 一覧画面または編集フォームの出力
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{認証チェック}
    B -->|失敗| C[アクセス拒否]
    B -->|成功| D{アクション判定}
    D -->|MoveUP| E[表示順序-1]
    D -->|MoveDOWN| F[表示順序+1]
    D -->|save| G[バリデーション]
    G -->|OK| H[DB保存]
    G -->|NG| I[エラー表示]
    D -->|delete| J[フィールド値削除]
    J --> K[フィールド削除]
    H --> L[一覧へリダイレクト]
    K --> L
    E --> M[画面再表示]
    F --> M
    I --> N[編集フォーム表示]
    D -->|none| O{一覧or編集?}
    O -->|一覧| M
    O -->|編集| N
    M --> P[終了]
    N --> P
    L --> P
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-85-01 | フィールド名必須 | フィールド名は必須入力 | 保存時 |
| BR-85-02 | タイプ必須 | フィールドタイプは必須選択 | 保存時 |
| BR-85-03 | 選択肢必須 | selectタイプの場合、選択肢は必須 | sType=sb_select時 |
| BR-85-04 | 必須かつプロフィール | bMandatory=trueの場合、bProfile=trueも必須 | 保存時 |
| BR-85-05 | 新規フィールド順序 | 新規作成時、順序は既存フィールド数+1 | 新規作成時 |
| BR-85-06 | 既存会員への適用 | 新規フィールド作成時、既存会員全員に空値レコード作成 | 新規作成時 |

### 計算ロジック

- 表示順序上移動: iRang = iRang - 1（対象）、iRang + 1（入れ替え対象）
- 表示順序下移動: iRang = iRang + 1（対象）、iRang - 1（入れ替え対象）

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| フィールド取得 | tblContactField | SELECT | IDによるフィールド定義取得 |
| フィールド一覧取得 | tblContactField | SELECT | 顧客IDに紐づくフィールド一覧 |
| フィールド新規作成 | tblContactField | INSERT | 新規フィールドレコード作成 |
| フィールド更新 | tblContactField | UPDATE | 既存フィールド定義の更新 |
| フィールド削除 | tblContactField | DELETE | フィールドレコード削除 |
| 順序変更 | tblContactField | UPDATE | iRangの更新 |
| 既存会員へ値追加 | tblContactValues | INSERT | 新規フィールド用の空値レコード作成 |
| フィールド値削除 | tblContactValues | DELETE | フィールド削除時の値レコード削除 |

### テーブル別操作詳細

#### tblContactField

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | iId = パラメータ値 | 単一レコード取得 |
| SELECT | * | iCustomerID = cId ORDER BY iRang | 一覧取得 |
| INSERT | sFieldName | 入力値 | 必須 |
| INSERT | sType | 入力値 | 必須 |
| INSERT | sValues | 入力値 | select時のみ |
| INSERT | iRang | COUNT(*) + 1 | 自動採番 |
| INSERT | bMandatory | 入力値 | Boolean |
| INSERT | bSearchField | 入力値 | Boolean |
| INSERT | bProfile | 入力値 | Boolean |
| INSERT | iCustomerID | cId | 顧客ID |
| UPDATE | iRang | iRang +/- 1 | 順序変更 |
| DELETE | - | iId = パラメータ値 | 物理削除 |

#### tblContactValues

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | iContactID | 既存会員ID | 新規フィールド作成時 |
| INSERT | iFieldID | 新規フィールドID | |
| INSERT | sValue | "" | 空文字 |
| DELETE | - | iFieldId = フィールドID | フィールド削除時 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| err_mandatory | 入力エラー | フィールド名/タイプが未入力 | エラーメッセージ表示 |
| err_mandatory | 入力エラー | select時に選択肢が未入力 | エラーメッセージ表示 |
| err_mandatoryprofile | 設定エラー | 必須かつ非プロフィール設定 | エラーメッセージ表示 |

### リトライ仕様

リトライ処理は実装されていない。エラー発生時は画面に戻り再入力を促す。

## トランザクション仕様

ADO Recordsetを使用した自動コミット方式。明示的なトランザクション制御は行わない。

## パフォーマンス要件

特に明示的な要件なし。フィールド数は通常数十件程度を想定。

## セキュリティ考慮事項

- 認証必須：`logon.hasaccess secondAdmin.bIntranetContacts`による権限チェック
- CSRF対策：`checkCSRF()`による検証（移動、保存、削除時）
- 入力サニタイズ：`quotRep()`関数による出力エスケープ
- ID暗号化：`encrypt()`/`decrypt()`関数によるフィールドIDの暗号化
- 削除確認：confirm()ダイアログによる誤操作防止

## 備考

- フィールドタイプ：text, textarea, url, email, richtext, checkbox, select, date, comment
- commentタイプはユーザー入力なしの説明文表示用
- richTextタイプではFCKeditorを使用
- フィールド削除時は関連するフィールド値も全削除される

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

カスタムフィールドクラスの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | contactField.asp | `asp/includes/contactField.asp` | cls_contactFieldクラスの全体構造 |

**読解のコツ**: sValuesは改行（vbcrlf）区切りで選択肢を保持。showSelected関数でセレクトボックスのオプションを生成する。

#### Step 2: エントリーポイントを理解する（一覧画面）

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_contactFields.asp | `asp/bs_contactFields.asp` | フィールド一覧画面と移動処理 |

**主要処理フロー**:
1. **4行目**: 権限チェック
2. **5-13行目**: 移動アクション処理（MoveUP/MoveDOWN）
3. **17行目**: フィールド一覧テーブル生成

#### Step 3: 編集画面を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_contactFieldEdit.asp | `asp/bs_contactFieldEdit.asp` | フィールド編集画面 |

**主要処理フロー**:
1. **11-22行目**: 保存/削除アクション処理
2. **24-25行目**: フィールドタイプごとのフォーム表示切り替え

#### Step 4: クラスのCRUD処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | contactField.asp | `asp/includes/contactField.asp` | Check, Save, remove, moveUp, moveDownメソッド |

**主要処理フロー**:
- **40-58行目**: `Check`関数 - 必須チェック、必須+プロフィールチェック
- **59-106行目**: `Save`関数 - フィールド保存、既存会員への空値レコード作成
- **137-156行目**: `moveUp`/`moveDown`関数 - 順序変更
- **157-167行目**: `remove`関数 - 順序調整、値削除、フィールド削除

### プログラム呼び出し階層図

```
bs_contactFields.asp（一覧画面）
    │
    ├─ begin.asp（共通初期化）
    │
    ├─ bs_security.asp（認証チェック）
    │      └─ logon.hasaccess（権限検証）
    │
    ├─ cls_contactField（フィールドクラス）
    │      ├─ moveUp()（上移動）
    │      └─ moveDown()（下移動）
    │
    └─ customer.contactFields()（フィールド一覧取得）

bs_contactFieldEdit.asp（編集画面）
    │
    ├─ cls_contactField（フィールドクラス）
    │      ├─ getRequestValues()（値取得）
    │      ├─ check()（バリデーション）
    │      ├─ save()（保存処理）
    │      └─ remove()（削除処理）
    │
    └─ HTMLフォーム出力
```

### データフロー図

```
[入力]               [処理]                    [出力]

フォーム入力 ───▶ cls_contactField ───▶ check()
(フィールド定義)       │                    │
                      │                    ▼
                      │             バリデーション
                      │                    │
                      ▼                    ▼
              getRequestValues() ───▶ save()
                                        │
                    ┌───────────────────┴───────────────────┐
                    ▼                                        ▼
           tblContactField                           tblContactValues
           (フィールド定義保存)                      (既存会員に空値作成)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_contactFields.asp | `asp/bs_contactFields.asp` | ソース | フィールド一覧画面 |
| bs_contactFieldEdit.asp | `asp/bs_contactFieldEdit.asp` | ソース | フィールド編集画面 |
| contactField.asp | `asp/includes/contactField.asp` | ソース | cls_contactFieldクラス定義 |
| contactFieldTypeList.asp | `asp/includes/contactFieldTypeList.asp` | ソース | フィールドタイプ一覧 |
| begin.asp | `asp/begin.asp` | ソース | 共通初期化処理 |
| bs_security.asp | `asp/bs_security.asp` | ソース | 認証・権限チェック |
