# 機能設計書 86-一括メール送信

## 概要

本ドキュメントは、QuickerSite CMSにおける「一括メール送信」機能について、その設計仕様を詳細に記述したものである。

### 本機能の処理概要

一括メール送信機能は、選択した会員に対してメールを一斉配信する機能である。カスタムフィールドの値を差し込み可能なパーソナライズメールの送信をサポートする。

**業務上の目的・背景**：会員制サイトの運営において、会員への情報発信は重要なコミュニケーション手段である。本機能により、特定条件で抽出した会員グループに対して一斉にメールを送信できる。また、メール本文に会員固有の情報（名前、メールアドレス等）を差し込むことで、パーソナライズされたメール配信が可能となる。

**機能の利用シーン**：重要なお知らせの配信、特定会員グループへのキャンペーン案内、会員ステータス変更の通知、パスワード情報を含む個別連絡など、会員向けメール送信が必要な際に使用する。

**主要な処理内容**：
1. 送信対象会員の選択（コンタクト一覧からの引き継ぎ）
2. 件名・本文の入力（HTMLメール対応）
3. 差し込みフィールドの置換処理
4. 過去のメールテンプレートの再利用
5. CCメールアドレスへの同時送信
6. 送信履歴の記録
7. メール送信処理の実行

**関連システム・外部連携**：SMTPサーバーを使用したメール送信。コンタクト一覧機能（No.83）から送信対象を受け取る。メール送信履歴機能（No.87）に送信ログを保存する。

**権限による制御**：イントラネットコンタクト管理権限（secondAdmin.bIntranetContacts）およびイントラネットメール権限（secondAdmin.bIntranetMail）を持つ管理者のみがアクセス可能である。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 57 | 一括操作 | 主画面 | 選択した連絡先への一括操作・メール送信 |
| 123 | 一斉メール送信 | 主画面 | 会員への一斉メール送信 |

## 機能種別

メール送信処理 / バッチ処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| iContactIDM | Array(String) | Yes | 送信対象会員ID（暗号化、カンマ区切り） | 復号後に数値チェック |
| sSubject | String | Yes | メール件名 | 必須 |
| sBody | String | Yes | メール本文（HTML） | 必須（HTMLタグ除去後空でないこと） |
| sBodyBGColor | String | Yes | 本文背景色 | デフォルト#FFFFFF |
| ccEmails | String | No | CCメールアドレス（カンマ区切り） | メール形式チェック |
| resendMailID | Integer | No | 再送信用メールテンプレートID | 存在チェック |
| postBack | Boolean | Yes | POSTフラグ | true |
| sendBack | Boolean | Yes | 送信実行フラグ | true |

### 入力データソース

- 画面フォーム入力（件名、本文、CC）
- セッション/フォーム（送信対象会員ID）
- 過去メールテンプレート（resendMailID指定時）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| iMailID | Integer | 送信メールID |
| sSubject | String | メール件名 |
| sBody | String | メール本文 |
| sBodyBGColor | String | 背景色 |
| dDateSent | DateTime | 送信日時 |
| 受信者リスト | Array | 送信先メールアドレス一覧 |

### 出力先

- SMTPサーバー経由でメール送信
- データベーステーブル（tblMail, tblMailContact）
- 完了画面リダイレクト（bs_massMailingFB.asp）

## 処理フロー

### 処理シーケンス

```
1. 認証・権限チェック
   └─ イントラネットコンタクト管理権限＋メール権限の確認
2. 送信対象会員IDの取得
   └─ フォームから暗号化IDリストを取得
3. メール内容の入力/テンプレート読み込み
   └─ 件名・本文・背景色の設定
4. バリデーション
   └─ 件名・本文の必須チェック
5. 送信処理（サーバータイムアウト延長: 10000秒）
   ├─ 会員ごとにループ
   │   ├─ 差し込みフィールド置換
   │   ├─ メール送信
   │   └─ 重複チェック（同一メールへの二重送信防止）
   └─ CC宛先への送信
6. 履歴保存
   └─ tblMail, tblMailContactへの記録
7. 完了画面へリダイレクト
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{認証チェック}
    B -->|失敗| C[アクセス拒否]
    B -->|成功| D[対象会員ID取得]
    D --> E{テンプレート選択?}
    E -->|Yes| F[テンプレート読み込み]
    E -->|No| G[メール内容入力]
    F --> G
    G --> H{送信実行?}
    H -->|No| I[編集画面表示]
    H -->|Yes| J[バリデーション]
    J -->|NG| I
    J -->|OK| K[タイムアウト延長]
    K --> L[会員ループ開始]
    L --> M{重複メール?}
    M -->|Yes| N[スキップ]
    M -->|No| O[差し込み置換]
    O --> P[メール送信]
    P --> Q[CC送信]
    Q --> R[送信記録追加]
    N --> S{次の会員?}
    R --> S
    S -->|Yes| L
    S -->|No| T[履歴保存]
    T --> U[完了画面へ]
    I --> V[終了]
    U --> V
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-86-01 | 件名必須 | メール件名は必須入力 | 送信実行時 |
| BR-86-02 | 本文必須 | メール本文は必須入力（HTMLタグ除去後） | 送信実行時 |
| BR-86-03 | 重複送信防止 | 同一メールアドレスへの二重送信防止 | 送信ループ内 |
| BR-86-04 | CC形式チェック | CCメールアドレスは形式チェック実施 | CC送信時 |
| BR-86-05 | 差し込み置換 | [フィールド名]形式で会員情報を置換 | メール生成時 |
| BR-86-06 | 履歴保存 | 送信メールと受信者を履歴として保存 | 送信完了時 |

### 計算ロジック

- 差し込みフィールド置換：`replace(body, "[フィールド名]", 会員の値)`
- 特殊差し込み：`[Email]` → sEmail、`[sPw]` → sPw

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 会員情報取得 | tblContact | SELECT | 送信対象会員のデータ取得 |
| フィールド値取得 | tblContactValues | SELECT | 差し込み用フィールド値取得 |
| メール履歴保存 | tblMail | INSERT | 送信メールの記録 |
| 受信者保存 | tblMailContact | INSERT | 送信先メールアドレスの記録 |
| テンプレート取得 | tblMail | SELECT | 過去メールの再利用 |

### テーブル別操作詳細

#### tblMail

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | sSubject | 件名 | |
| INSERT | sBody | 本文 | |
| INSERT | sBodyBGColor | 背景色 | |
| INSERT | dDateSent | now() | 送信日時 |
| INSERT | iCustomerID | cId | 顧客ID |

#### tblMailContact

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | iMailID | メールID | 外部キー |
| INSERT | sEmail | 送信先メールアドレス | |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| err_mandatory | 入力エラー | 件名が未入力 | エラーメッセージ表示 |
| err_mandatory | 入力エラー | 本文が未入力（HTMLタグ除去後） | エラーメッセージ表示 |
| - | 送信エラー | 個別メール送信失敗 | ErrorReport記録、次の会員へ継続 |

### リトライ仕様

個別メール送信エラー時はエラーをログ記録し、次の会員への送信を継続する（On Error Resume Next）。

## トランザクション仕様

明示的なトランザクション制御なし。メール送信と履歴保存は個別に実行される。送信途中でエラーが発生した場合、既に送信されたメールは取り消されない。

## パフォーマンス要件

- サーバースクリプトタイムアウト：10000秒に延長
- 大量送信対応：会員ごとのループ処理

## セキュリティ考慮事項

- 認証必須：`logon.hasaccess secondAdmin.bIntranetContacts`および`secondAdmin.bIntranetMail`による権限チェック
- CSRF対策：`QS_secCodeHidden`トークン
- 送信前確認：confirm()ダイアログによる誤操作防止
- 入力サニタイズ：`quotRep()`関数による出力エスケープ
- ID暗号化：`decrypt()`関数による会員IDの復号

## 備考

- HTMLメールに対応（FCKeditorで作成）
- 本文背景色をカスタマイズ可能
- 過去の送信メールをテンプレートとして再利用可能
- 送信完了後、送信件数を含む完了画面にリダイレクト

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

メール関連クラスの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | mail.asp | `asp/includes/mail.asp` | cls_mail, cls_mail_messageクラスの構造 |

**読解のコツ**: cls_mailは送信履歴管理、cls_mail_messageは実際のメール送信を担当する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_contactSelectionActions.asp | `asp/bs_contactSelectionActions.asp` | メール送信画面のメインファイル |

**主要処理フロー**:
1. **4行目**: 権限チェック（`secondAdmin.bIntranetContacts`）
2. **8-23行目**: テンプレート読み込み処理
3. **24-32行目**: バリデーションと送信処理呼び出し
4. **34-49行目**: フォーム表示と差し込みフィールド一覧

#### Step 3: 送信処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_massMailing2.asp | `asp/bs_massMailing2.asp` | 実際のメール送信処理 |

**主要処理フロー**:
- **6行目**: タイムアウト延長（10000秒）
- **20-64行目**: 会員ループでのメール送信
- **25-41行目**: 差し込みフィールドの置換処理
- **66-80行目**: 履歴保存とリダイレクト

### プログラム呼び出し階層図

```
bs_contactSelectionActions.asp（入力画面）
    │
    ├─ begin.asp（共通初期化）
    │
    ├─ bs_security.asp（認証チェック）
    │      └─ logon.hasaccess（権限検証）
    │
    ├─ cls_mail（テンプレート取得）
    │      └─ pick()（過去メール読み込み）
    │
    └─ bs_massMailing2.asp（送信処理）
           │
           ├─ cls_contact（会員情報取得）
           │      └─ pick()（差し込み用データ取得）
           │
           ├─ cls_mail_message（メール送信）
           │      └─ send()（SMTP送信）
           │
           └─ cls_mail（履歴保存）
                  └─ save()（tblMail保存）
```

### データフロー図

```
[入力]               [処理]                    [出力]

コンタクト一覧 ───▶ iContactIDM（会員ID配列）
     │
     ▼
フォーム入力 ───▶ 件名・本文・CC
(sSubject,sBody)       │
                       ▼
              差し込み置換処理
                       │
            ┌──────────┴──────────┐
            ▼                      ▼
     SMTPメール送信          履歴保存
     (cls_mail_message)    (tblMail,tblMailContact)
            │
            ▼
     完了画面（送信件数表示）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_contactSelectionActions.asp | `asp/bs_contactSelectionActions.asp` | ソース | メール送信入力画面 |
| bs_massMailing2.asp | `asp/bs_massMailing2.asp` | ソース | メール送信処理 |
| bs_massMailingFB.asp | `asp/bs_massMailingFB.asp` | ソース | 送信完了画面 |
| mail.asp | `asp/includes/mail.asp` | ソース | メール関連クラス |
| contact.asp | `asp/includes/contact.asp` | ソース | 会員クラス |
| begin.asp | `asp/begin.asp` | ソース | 共通初期化処理 |
| bs_security.asp | `asp/bs_security.asp` | ソース | 認証・権限チェック |
