# 機能設計書 87-メール送信履歴

## 概要

本ドキュメントは、QuickerSite CMSにおける「メール送信履歴」機能について、その設計仕様を詳細に記述したものである。

### 本機能の処理概要

メール送信履歴機能は、会員へ送信したメールの履歴を確認・管理する機能である。過去の配信内容の確認や受信者リストの参照、不要な履歴の削除が可能である。

**業務上の目的・背景**：会員向けメール配信の運用において、過去の配信履歴を確認できることは重要である。本機能により、管理者は過去に送信したメールの内容確認、受信者リストの確認、配信結果の分析などを行うことができる。また、履歴データの整理（削除）も可能である。

**機能の利用シーン**：過去の配信内容を確認する際、クレーム対応で配信履歴を調べる際、古い履歴データを整理・削除する際、配信実績の確認・報告時に使用する。

**主要な処理内容**：
1. 送信済みメールの一覧表示（件名、送信日、受信者数）
2. メール本文の詳細表示（ポップアップ）
3. 受信者リストの表示（ポップアップ）
4. 履歴の削除

**関連システム・外部連携**：一括メール送信機能（No.86）で送信されたメールが履歴として記録される。

**権限による制御**：イントラネットメール権限（secondAdmin.bIntranetMail）を持つ管理者のみがアクセス可能である。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 120 | メール履歴 | 主画面 | 送信メール履歴の一覧表示 |
| 121 | メール詳細 | 主画面 | 送信メールの詳細内容確認 |
| 122 | メール受信者 | 主画面 | メール受信者の一覧表示 |

## 機能種別

参照・削除（Read: 送信履歴の取得、Delete: 履歴の削除）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| iMail_ID | String(暗号化) | No | メールID（削除/詳細表示時） | 復号後に数値チェック |

### 入力データソース

- URLパラメータ（暗号化されたメールID）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| iId | Integer | メールID |
| sSubject | String | メール件名 |
| sBody | String | メール本文 |
| dDateSent | DateTime | 送信日時 |
| iNumberRec | Integer | 受信者数 |
| 受信者一覧 | Array | 受信者メールアドレスリスト |

### 出力先

- 画面表示（履歴一覧テーブル、詳細ポップアップ、受信者リストポップアップ）

## 処理フロー

### 処理シーケンス

```
1. 認証・権限チェック
   └─ イントラネットメール権限の確認
2. 削除リクエストの処理（iMail_ID指定時）
   └─ CSRF検証 → 履歴削除
3. 履歴一覧の取得
   └─ customer.mailsで送信済みメール取得
4. 画面表示
   └─ 一覧テーブル出力（件名リンク、日付、受信者数、削除ボタン）
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{認証チェック}
    B -->|失敗| C[アクセス拒否]
    B -->|成功| D{削除リクエスト?}
    D -->|Yes| E[CSRF検証]
    E --> F[履歴削除]
    F --> G[履歴取得]
    D -->|No| G
    G --> H{履歴あり?}
    H -->|Yes| I[一覧テーブル表示]
    H -->|No| J[履歴なしメッセージ]
    I --> K[終了]
    J --> K
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-87-01 | CSRF検証 | 削除時はCSRFトークン検証必須 | 削除処理時 |
| BR-87-02 | 確認ダイアログ | 削除前に確認ダイアログ表示 | 削除ボタンクリック時 |
| BR-87-03 | 顧客ID絞り込み | 履歴は現在のサイト（顧客ID）に限定 | 履歴取得時 |

### 計算ロジック

- 受信者数：tblMailContactのiMailIDでCOUNT

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 履歴一覧取得 | tblMail | SELECT | 顧客IDに紐づくメール履歴取得 |
| 履歴詳細取得 | tblMail | SELECT | IDによるメール詳細取得 |
| 受信者取得 | tblMailContact | SELECT | メールIDに紐づく受信者一覧取得 |
| 履歴削除 | tblMail | DELETE | メールレコード削除 |
| 受信者削除 | tblMailContact | DELETE | 関連する受信者レコード削除 |

### テーブル別操作詳細

#### tblMail

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | iCustomerID = cId ORDER BY dDateSent DESC | 一覧取得 |
| SELECT | * | iId = パラメータ値 | 詳細取得 |
| DELETE | - | iId = パラメータ値 | 物理削除 |

#### tblMailContact

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | sEmail | iMailID = メールID | 受信者一覧取得 |
| SELECT | COUNT(*) | iMailID = メールID | 受信者数取得 |
| DELETE | - | iMailID = メールID | 関連レコード削除 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | CSRF検証失敗 | トークン不一致 | 処理中断 |

### リトライ仕様

リトライ処理は実装されていない。

## トランザクション仕様

削除処理時、tblMailとtblMailContactの削除は個別に実行される（明示的なトランザクション制御なし）。

## パフォーマンス要件

特に明示的な要件なし。履歴一覧はsortableテーブルとして表示。

## セキュリティ考慮事項

- 認証必須：`logon.hasaccess secondAdmin.bIntranetMail`による権限チェック
- CSRF対策：`checkCSRF()`による検証（削除時）、`QS_secCodeURL`トークン
- 削除確認：confirm()ダイアログによる誤操作防止
- ID暗号化：`encrypt()`/`decrypt()`関数によるメールIDの暗号化

## 備考

- 詳細表示と受信者リストはポップアップウィンドウで開く（openPopUpWindow関数）
- 一覧テーブルはsortableクラスでソート可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

メールクラスの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | mail.asp | `asp/includes/mail.asp` | cls_mailクラスの構造、プロパティ |

**読解のコツ**: cls_mailはメール履歴の管理、cls_mail_messageはメール送信を担当する。履歴機能ではcls_mailを使用。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_mailHistory.asp | `asp/bs_mailHistory.asp` | 履歴一覧画面と削除処理 |

**主要処理フロー**:
1. **4行目**: 権限チェック（`secondAdmin.bIntranetMail`）
2. **6-9行目**: 削除処理（CSRF検証、theMail.delete()）
3. **11-12行目**: 履歴一覧取得（customer.mails）
4. **12行目**: 一覧テーブル生成（ループ処理）

### プログラム呼び出し階層図

```
bs_mailHistory.asp（エントリーポイント）
    │
    ├─ begin.asp（共通初期化）
    │
    ├─ bs_security.asp（認証チェック）
    │      └─ logon.hasaccess（権限検証）
    │
    ├─ cls_mail（メール履歴クラス）
    │      ├─ pick()（詳細取得）
    │      └─ delete()（履歴削除）
    │
    ├─ customer.mails（履歴一覧取得）
    │
    └─ HTMLテーブル出力
           │
           ├─ bs_mailDetail.asp（詳細ポップアップ）
           │
           └─ bs_mailReceivers.asp（受信者リストポップアップ）
```

### データフロー図

```
[入力]               [処理]                    [出力]

URLパラメータ ───▶ decrypt() ───▶ メールID
(削除時)                │
                        ▼
                  checkCSRF()
                        │
                        ▼
                  cls_mail.delete()
                        │
                        ▼
                  tblMail削除
                  tblMailContact削除

一覧表示 ───────▶ customer.mails ───▶ 履歴一覧
                        │
                        ▼
                  HTMLテーブル生成
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_mailHistory.asp | `asp/bs_mailHistory.asp` | ソース | 履歴一覧画面 |
| bs_mailDetail.asp | `asp/bs_mailDetail.asp` | ソース | メール詳細ポップアップ |
| bs_mailReceivers.asp | `asp/bs_mailReceivers.asp` | ソース | 受信者リストポップアップ |
| mail.asp | `asp/includes/mail.asp` | ソース | メール関連クラス |
| begin.asp | `asp/begin.asp` | ソース | 共通初期化処理 |
| bs_security.asp | `asp/bs_security.asp` | ソース | 認証・権限チェック |
