# 機能設計書 88-アクティベーション管理

## 概要

本ドキュメントは、QuickerSite CMSにおける「アクティベーション管理」機能について、その設計仕様を詳細に記述したものである。

### 本機能の処理概要

アクティベーション管理機能は、会員登録のアクティベーション待ち状態を管理する機能である。メール認証待ちの会員登録申請を一覧表示し、再送信や削除を行うことができる。

**業務上の目的・背景**：会員制サイトにおいて、スパム登録を防止しつつ正規の会員登録を支援するため、メールによるアクティベーション認証が必要となる。本機能により、管理者はアクティベーション待ちの申請を確認し、必要に応じてアクティベーションメールの再送信や、不正な申請の削除を行うことができる。

**機能の利用シーン**：会員から「登録メールが届かない」という問い合わせがあった際のアクティベーションメール再送信、明らかにスパムと判断される申請の削除、長期間未認証の申請の整理時に使用する。

**主要な処理内容**：
1. アクティベーション待ち申請の一覧表示
2. 申請詳細の表示（登録日時、メールアドレス、訪問者情報）
3. アクティベーションメールの再送信
4. 申請の削除（一括削除対応）

**関連システム・外部連携**：会員登録機能（No.105）で申請されたアクティベーション情報を管理。SMTPサーバーを使用したアクティベーションメール送信。

**権限による制御**：イントラネットコンタクト管理権限（secondAdmin.bIntranetContacts）を持つ管理者のみがアクセス可能である。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 58 | チケット管理 | 主画面 | 会員登録のアクティベーション待ち一覧管理 |

## 機能種別

一覧・削除・再送信（Read: アクティベーション待ち一覧取得、Delete: 申請削除、Send: メール再送信）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| iTicketID | Array(String) | No | チケットID（暗号化、削除時複数選択可） | 復号後に数値チェック |
| pageAction | String | No | 実行アクション | "remove"または"resend" |

### 入力データソース

- フォーム入力（削除対象チェックボックス）
- URLパラメータ（再送信対象チケットID）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| iId | Integer | チケットID |
| sEmail | String | 申請メールアドレス |
| sTicket | String | アクティベーションコード |
| dCreatedTS | DateTime | 申請日時 |
| sVisitorDetails | String | 訪問者詳細情報 |

### 出力先

- 画面表示（アクティベーション待ち一覧テーブル）
- メール送信（アクティベーションメール再送信時）

## 処理フロー

### 処理シーケンス

```
1. 認証・権限チェック
   └─ イントラネットコンタクト管理権限の確認
2. 削除処理（pageAction="remove"）
   └─ CSRF検証 → 選択されたチケットを削除
3. 再送信処理（pageAction="resend"）
   └─ CSRF検証 → アクティベーションメール再送信 → リダイレクト
4. 一覧取得
   └─ customer.ticketsでアクティベーション待ち一覧取得
5. 画面表示
   └─ 一覧テーブル出力（日時、メール、詳細、削除チェック、再送信リンク）
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{認証チェック}
    B -->|失敗| C[アクセス拒否]
    B -->|成功| D{pageAction?}
    D -->|remove| E[CSRF検証]
    E --> F[選択チケット削除ループ]
    F --> G[一覧取得]
    D -->|resend| H[CSRF検証]
    H --> I[メール再送信]
    I --> J[リダイレクト]
    D -->|none| G
    G --> K{データあり?}
    K -->|Yes| L[一覧テーブル表示]
    K -->|No| M[結果なしメッセージ]
    L --> N[終了]
    M --> N
    J --> N
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-88-01 | CSRF検証 | 削除・再送信時はCSRFトークン検証必須 | アクション実行時 |
| BR-88-02 | 確認ダイアログ | 削除・再送信前に確認ダイアログ表示 | アクション実行時 |
| BR-88-03 | 一括削除 | 複数チケットの一括削除が可能 | 削除処理時 |
| BR-88-04 | 訪問者情報表示 | 登録時の訪問者詳細情報を表示（35文字で折り返し） | 一覧表示時 |
| BR-88-05 | 再送信フィードバック | 再送信成功時にメッセージ表示 | 再送信完了時 |

### 計算ロジック

- 訪問者情報表示：`splitby(sVisitorDetails, 35)` で35文字ごとに改行

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 一覧取得 | tblContactRegistration | SELECT | 顧客IDに紐づくアクティベーション待ち取得 |
| チケット取得 | tblContactRegistration | SELECT | IDによるチケット詳細取得 |
| チケット削除 | tblContactRegistration | DELETE | チケットレコード削除 |

### テーブル別操作詳細

#### tblContactRegistration

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | iCustomerID = cId | 一覧取得 |
| SELECT | * | iId = パラメータ値 AND iCustomerID = cId | 単一取得 |
| DELETE | - | iId = パラメータ値 AND iCustomerID = cId | 物理削除 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | CSRF検証失敗 | トークン不一致 | 処理中断 |
| - | メール送信失敗 | SMTP接続エラー | エラーログ記録 |

### リトライ仕様

リトライ処理は実装されていない。

## トランザクション仕様

削除処理時は各チケットを個別に削除（明示的なトランザクション制御なし）。

## パフォーマンス要件

特に明示的な要件なし。アクティベーション待ち件数は通常少数を想定。

## セキュリティ考慮事項

- 認証必須：`logon.hasaccess secondAdmin.bIntranetContacts`による権限チェック
- CSRF対策：`checkCSRF()`による検証（削除・再送信時）、`QS_secCodeHidden`トークン
- 確認ダイアログ：confirm()による誤操作防止
- ID暗号化：`encrypt()`/`decrypt()`関数によるチケットIDの暗号化
- 訪問者情報：不正登録の検出に使用（IPアドレス等を含む可能性）

## 備考

- アクティベーションリンクはcustomer.sQSUrl + "/default.asp?pageAction=profile&ac=" + sTicket形式
- 訪問者詳細情報には登録時のユーザーエージェント、IPアドレス等が記録される
- コンタクト一覧画面（bs_contactHome.asp）からもリンクあり

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

チケットクラスの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ticket.asp | `asp/includes/ticket.asp` | cls_ticketクラスの構造、プロパティ |

**読解のコツ**: sTicketがアクティベーションコード、sVisitorDetailsが登録時の訪問者情報を保持。activationlinkプロパティでリンクを生成。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_tickets.asp | `asp/bs_tickets.asp` | 一覧画面と削除・再送信処理 |

**主要処理フロー**:
1. **4行目**: 権限チェック（`secondAdmin.bIntranetContacts`）
2. **4-13行目**: 削除処理（pageAction="remove"、ループで複数削除）
3. **14-21行目**: 再送信処理（pageAction="resend"、sendTicket()呼び出し）
4. **22-24行目**: 一覧取得と表示

#### Step 3: チケットクラスの詳細を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ticket.asp | `asp/includes/ticket.asp` | Pick, SaveAndSend, remove, sendTicketメソッド |

**主要処理フロー**:
- **20-34行目**: `Pick`関数 - IDからチケットデータ取得
- **72-99行目**: `SaveAndSend`関数 - チケット作成とメール送信
- **100-106行目**: `remove`関数 - チケット削除
- **107-115行目**: `sendTicket`関数 - アクティベーションメール送信
- **116-118行目**: `activationlink`プロパティ - リンク生成

### プログラム呼び出し階層図

```
bs_tickets.asp（エントリーポイント）
    │
    ├─ begin.asp（共通初期化）
    │
    ├─ bs_security.asp（認証チェック）
    │      └─ logon.hasaccess（権限検証）
    │
    ├─ cls_ticket（チケットクラス）
    │      ├─ pick()（データ取得）
    │      ├─ remove()（削除処理）
    │      └─ sendTicket()（メール再送信）
    │             └─ cls_mail_message（メール送信）
    │
    └─ customer.tickets（一覧取得）
```

### データフロー図

```
[入力]               [処理]                    [出力]

フォーム入力 ───▶ pageAction判定
(チェックボックス)      │
                       ├─── remove ───▶ cls_ticket.remove()
                       │                      │
                       │                      ▼
                       │              tblContactRegistration削除
                       │
                       └─── resend ───▶ cls_ticket.sendTicket()
                                              │
                                              ▼
                                       SMTPメール送信

一覧表示 ───────▶ customer.tickets ───▶ 一覧テーブル
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_tickets.asp | `asp/bs_tickets.asp` | ソース | アクティベーション管理画面 |
| ticket.asp | `asp/includes/ticket.asp` | ソース | cls_ticketクラス定義 |
| mail.asp | `asp/includes/mail.asp` | ソース | メール送信クラス |
| bs_contactHome.asp | `asp/bs_contactHome.asp` | ソース | コンタクト一覧（リンク元） |
| begin.asp | `asp/begin.asp` | ソース | 共通初期化処理 |
| bs_security.asp | `asp/bs_security.asp` | ソース | 認証・権限チェック |
