# 機能設計書 89-テーマ/フォーラム一覧

## 概要

本ドキュメントは、QuickerSite CMSにおける「テーマ/フォーラム一覧」機能について、その設計仕様を詳細に記述したものである。

### 本機能の処理概要

テーマ/フォーラム一覧機能は、掲示板・フォーラム・ブログのテーマを一覧表示し、管理する機能である。各テーマへの編集画面への遷移や、テーマのコピー機能を提供する。

**業務上の目的・背景**：会員制サイトやコミュニティサイトにおいて、ユーザー同士の情報交換を促進するための掲示板・フォーラム・ブログ機能が必要となる。本機能により、管理者は作成されたテーマの一覧を確認し、既存テーマのコピーによる新規テーマ作成を効率的に行うことができる。

**機能の利用シーン**：新しいフォーラムを作成する際、既存フォーラムの設定を確認する際、フォーラムの埋め込みコードを取得する際に使用する。

**主要な処理内容**：
1. テーマ一覧の表示（名前、埋め込みコード、ID）
2. テーマ編集画面への遷移
3. テーマのコピー（複製）機能

**関連システム・外部連携**：テーマ/フォーラム作成・編集機能（No.90）と連携。テーマはページに埋め込まれて公開される。

**権限による制御**：テーマ管理権限（secondAdmin.bTheme）を持つ管理者のみがアクセス可能である。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 77 | テーマ一覧 | 主画面 | テーマ・フォーラムの一覧表示 |
| 78 | テーマ編集 | 遷移先 | テーマの新規作成・編集 |

## 機能種別

一覧・コピー（Read: テーマ一覧取得、Copy: テーマ複製）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| ithemeID | String(暗号化) | No | コピー対象テーマID | 復号後に数値チェック |

### 入力データソース

- URLパラメータ（暗号化されたテーマID、コピー時）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| iId | Integer | テーマID |
| sName | String | テーマ名 |
| sCode | String | 埋め込みコード |

### 出力先

- 画面表示（テーマ一覧テーブル）

## 処理フロー

### 処理シーケンス

```
1. 認証・権限チェック
   └─ テーマ管理権限の確認
2. コピー処理（ithemeID指定時）
   └─ CSRF検証 → テーマコピー → 編集画面へリダイレクト
3. テーマ一覧取得
   └─ customer.themesで全テーマ取得
4. 画面表示
   └─ テーマ名リンク、コピーアイコン、埋め込みコード、ID表示
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{認証チェック}
    B -->|失敗| C[アクセス拒否]
    B -->|成功| D{コピーリクエスト?}
    D -->|Yes| E[テーマコピー実行]
    E --> F{コピー成功?}
    F -->|Yes| G[編集画面へリダイレクト]
    F -->|No| H[一覧取得]
    D -->|No| H
    H --> I{テーマあり?}
    I -->|Yes| J[一覧テーブル表示]
    I -->|No| K[テーマなしメッセージ]
    J --> L[終了]
    K --> L
    G --> L
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-89-01 | コピー確認 | コピー実行前に確認ダイアログ表示 | コピーアイコンクリック時 |
| BR-89-02 | コピー名称 | コピーしたテーマ名は「Copy of 元テーマ名」 | コピー処理時 |
| BR-89-03 | コピー時コード初期化 | コピー時に埋め込みコードは空にする | コピー処理時 |
| BR-89-04 | 新規作成リンク | 一覧上部に新規作成リンクを表示 | 常時 |
| BR-89-05 | CSRF検証 | コピー時はCSRFトークン検証必須 | コピー処理時 |

### 計算ロジック

- 特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 一覧取得 | tblTheme | SELECT | 顧客IDに紐づくテーマ一覧取得 |
| コピー | tblTheme | INSERT | テーマの複製レコード作成 |

### テーブル別操作詳細

#### tblTheme

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | iCustomerID = cId | 一覧取得 |
| INSERT | * | 元テーマからコピー、sName="Copy of "+元名, sCode="" | コピー時 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 権限エラー | テーマ管理権限なし | アクセス拒否 |

### リトライ仕様

リトライ処理は実装されていない。

## トランザクション仕様

コピー処理時の明示的なトランザクション制御なし。

## パフォーマンス要件

特に明示的な要件なし。テーマ数は通常少数を想定。

## セキュリティ考慮事項

- 認証必須：`logon.hasaccess secondAdmin.bTheme`による権限チェック
- CSRF対策：`QS_secCodeURL`トークンによるコピー操作の保護
- 確認ダイアログ：confirm()による誤操作防止
- ID暗号化：`encrypt()`/`decrypt()`関数によるテーマIDの暗号化
- XSS対策：`sanitize()`による埋め込みコード表示のエスケープ

## 備考

- 埋め込みコードは`[QS_theme:CODE]`形式でページに挿入する
- テーマはフォーラム（discussion）、パーソナルブログ、タスクシステムの3種類に対応
- イントラネットメニューからアクセス

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

テーマクラスの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | theme.asp | `asp/includes/theme.asp` | cls_themeクラスの構造、プロパティ |

**読解のコツ**: sNameがテーマ名、sCodeが埋め込み用コード、iTypeがテーマ種別（フォーラム/ブログ/タスク）。copyメソッドで複製処理。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_themesList.asp | `asp/bs_themesList.asp` | 一覧画面とコピー処理 |

**主要処理フロー**:
1. **4行目**: 権限チェック（`secondAdmin.bTheme`）
2. **5-7行目**: コピー処理（copy()呼び出し、成功時リダイレクト）
3. **8-9行目**: 一覧取得（customer.themes）
4. **9-10行目**: 一覧テーブル生成（ループ処理）

#### Step 3: コピー処理の詳細を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | theme.asp | `asp/includes/theme.asp` | copyメソッドの実装 |

**主要処理フロー**:
- **825-832行目**: `copy`関数 - テーマの複製処理
  - iIdをnullに設定して新規レコードとして保存
  - sNameに"Copy of "プレフィックスを追加
  - sCodeを空文字列に初期化

### プログラム呼び出し階層図

```
bs_themesList.asp（エントリーポイント）
    │
    ├─ begin.asp（共通初期化）
    │
    ├─ bs_security.asp（認証チェック）
    │      └─ logon.hasaccess（権限検証）
    │
    ├─ cls_theme.copy()（コピー処理）
    │      └─ cls_theme.save()（保存処理）
    │             └─ tblTheme INSERT
    │
    └─ customer.themes（一覧取得）
           └─ tblTheme SELECT
```

### データフロー図

```
[入力]               [処理]                    [出力]

URLパラメータ ───▶ decrypt() ───▶ テーマID
(コピー時)               │
                         ▼
                   cls_theme.pick()
                         │
                         ▼
                   cls_theme.copy()
                         │
                         ├─ sName = "Copy of " + 元名
                         ├─ sCode = ""
                         └─ save()
                               │
                               ▼
                         tblTheme INSERT
                               │
                               ▼
                         編集画面リダイレクト

一覧表示 ───────▶ customer.themes ───▶ 一覧テーブル
                         │
                         ▼
                   HTMLテーブル生成
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_themesList.asp | `asp/bs_themesList.asp` | ソース | テーマ一覧画面 |
| bs_themeEdit.asp | `asp/bs_themeEdit.asp` | ソース | テーマ編集画面 |
| theme.asp | `asp/includes/theme.asp` | ソース | cls_themeクラス定義 |
| begin.asp | `asp/begin.asp` | ソース | 共通初期化処理 |
| bs_security.asp | `asp/bs_security.asp` | ソース | 認証・権限チェック |
