# 機能設計書 91-アクセス統計表示

## 概要

本ドキュメントは、QuickerSite CMSの管理画面におけるアクセス統計表示機能の設計を記述する。サイト内の各ページのヒット数・訪問者数を一覧表示し、サイトのパフォーマンス分析を支援する機能である。

### 本機能の処理概要

アクセス統計表示機能は、サイト管理者がWebサイトの各ページへのアクセス状況を把握するための機能である。

**業務上の目的・背景**：Webサイト運営において、どのページがユーザーに閲覧されているかを把握することは、コンテンツ戦略の立案やサイト改善に不可欠である。本機能により、管理者は人気のあるコンテンツや改善が必要なページを特定できる。また、日次平均値を算出することで、時系列でのトレンド分析も可能となる。

**機能の利用シーン**：サイト運営者が定期的なアクセスレポート確認時、マーケティング担当者がキャンペーン効果測定時、コンテンツ制作者が人気コンテンツ分析時に利用される。

**主要な処理内容**：
1. 全ページのアクセス統計情報（ヒット数、訪問者数）をデータベースから取得
2. ヒット数降順でソートした一覧をテーブル形式で表示
3. 日次平均値（ヒット数/日、訪問者数/日）を算出・表示
4. RSSからのアクセス数を別途オレンジ色で表示
5. 統計リセット日時の表示と参照元サイト一覧へのリンク提供

**関連システム・外部連携**：外部システムとの連携はないが、RSSフィードからのアクセスを個別にトラッキングしている。

**権限による制御**：セカンドアドミンの`bStats`権限を持つユーザーのみアクセス可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 95 | 統計画面 | 主画面 | ページ別のヒット数・訪問者数の確認 |
| 6 | 管理者ダッシュボード | 参照画面 | サイトアクセス統計の概要表示 |
| 96 | リファラー一覧 | 遷移先画面 | 参照元サイト一覧への遷移 |

## 機能種別

データ参照・集計表示

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| btnaction | String | No | アクション種別（ResetStatsの場合は統計リセット処理へ） | 固定値チェック |

### 入力データソース

- セッション情報（認証状態）
- tblPageテーブル（ページ統計情報）
- tblCustomerテーブル（統計リセット日時、日数）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| sTitle | String | ページタイトル |
| iHits | Integer | 総ヒット数 |
| iHitsRSS | Integer | RSSからのヒット数 |
| iHits/day | Decimal | 日次平均ヒット数 |
| iHitsRSS/day | Decimal | RSSからの日次平均ヒット数 |
| iVisitors | Integer | 総訪問者数 |
| iVisitors/day | Decimal | 日次平均訪問者数 |

### 出力先

管理画面（bs_stats.asp）のHTMLテーブルとして表示

## 処理フロー

### 処理シーケンス

```
1. セキュリティチェック
   └─ セカンドアドミンのbStats権限を確認
2. 検索条件の設定
   └─ cls_searchクラスを初期化し、ヒット数降順でソート設定
3. 統計データ取得
   └─ パスワード保護・イントラネットページを含む全ページの統計を取得
4. 日数計算
   └─ 統計リセット日からの経過日数（aantalDagen）を取得
5. 一覧表示
   └─ 各ページのタイトル、ヒット数、日次平均を表示
6. フッター情報表示
   └─ 統計リセット日時、リセットリンク、参照元サイトリンクを表示
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{bStats権限チェック}
    B -->|No| C[アクセス拒否]
    B -->|Yes| D[cls_search初期化]
    D --> E[検索条件設定]
    E --> F[ページ統計取得]
    F --> G[経過日数取得]
    G --> H[統計テーブル生成]
    H --> I{RSSヒット > 0?}
    I -->|Yes| J[RSS統計表示]
    I -->|No| K[通常統計のみ表示]
    J --> L[フッター情報表示]
    K --> L
    L --> M[終了]
    C --> M
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-91-1 | 権限チェック | bStats権限を持つセカンドアドミンのみアクセス可能 | 常時 |
| BR-91-2 | ソート順序 | ヒット数の多い順（降順）で表示 | 常時 |
| BR-91-3 | 日次平均計算 | ヒット数・訪問者数を統計リセットからの日数で除算 | 常時 |
| BR-91-4 | RSS統計分離 | RSSからのアクセスは別途オレンジ色で表示 | RSSヒット数 > 0の場合 |

### 計算ロジック

- 日次平均ヒット数 = 総ヒット数 / 統計リセットからの経過日数
- 日次平均訪問者数 = 総訪問者数 / 統計リセットからの経過日数
- 日次平均RSSヒット数 = RSSヒット数 / 統計リセットからの経過日数

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 統計取得 | tblPage | SELECT | ページ統計情報の取得 |
| 設定取得 | tblCustomer | SELECT | 統計リセット日時・日数の取得 |

### テーブル別操作詳細

#### tblPage

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | iId, sTitle, iHits, iHitsRSS, iVisitors | iCustomerID = cId | cls_searchクラス経由で取得 |

#### tblCustomer

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | dResetStats, aantalDagen, bScanreferer | iId = cId | 統計関連設定の取得 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | アクセス拒否 | bStats権限なし | ログインページへリダイレクト |

### リトライ仕様

特になし

## トランザクション仕様

読み取り専用の処理のため、トランザクション管理は不要

## パフォーマンス要件

- 250ページ以下のサイトで1秒以内のレスポンス
- sortableテーブルによりクライアントサイドでのソートが可能

## セキュリティ考慮事項

- セカンドアドミン権限（bStats）による認証・認可
- セッションベースの認証チェック
- 出力時のサニタイズ処理（quotRep関数）

## 備考

- 統計はリセット可能で、リセット日時が記録される
- 参照元サイトのスキャン機能（bScanreferer）が有効な場合、参照元サイト一覧へのリンクが表示される

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

統計情報はcls_searchクラスを通じて取得されるため、まずこのクラスの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | search.asp | `asp/includes/search.asp` | cls_searchクラスの定義、resultsプロパティの実装 |

**読解のコツ**: cls_searchクラスはページ検索用の汎用クラスで、統計表示時はorderbyプロパティを"iHits desc"に設定して使用する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_stats.asp | `asp/bs_stats.asp` | 統計画面のメインファイル |

**主要処理フロー**:
1. **1行目**: インクルードファイルの読み込み
2. **4行目**: セキュリティチェック（`logon.hasaccess secondAdmin.bStats`）
3. **5-12行目**: cls_searchの初期化と設定
4. **14-16行目**: テーブルヘッダーの出力
5. **15-17行目**: 各ページの統計データをループで表示

#### Step 3: セキュリティ層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_security.asp | `asp/bs_security.asp` | 権限チェックの実装 |

**主要処理フロー**:
- **hasaccessメソッド**: 指定された権限フラグをチェックし、権限がない場合はリダイレクト

### プログラム呼び出し階層図

```
bs_stats.asp
    │
    ├─ bs_security.asp
    │      └─ logon.hasaccess(secondAdmin.bStats)
    │
    ├─ includes/search.asp
    │      └─ cls_search.results()
    │             └─ tblPage SELECT
    │
    └─ tblCustomer参照
           └─ customer.aantalDagen
           └─ customer.dResetStats
           └─ customer.bScanreferer
```

### データフロー図

```
[入力]               [処理]                    [出力]

セッション情報 ───▶ bs_security.asp ───▶ 権限チェック結果
                        │
                        ▼
tblPage ─────────▶ cls_search ─────────▶ 統計データ配列
                        │
                        ▼
tblCustomer ─────▶ 日数計算 ──────────▶ HTMLテーブル
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_stats.asp | `asp/bs_stats.asp` | ソース | 統計表示のメインページ |
| bs_security.asp | `asp/bs_security.asp` | ソース | セキュリティチェック |
| search.asp | `asp/includes/search.asp` | ソース | cls_searchクラス定義 |
| header.asp | `asp/includes/header.asp` | テンプレート | HTMLヘッダー |
| bs_header.asp | `asp/bs_header.asp` | テンプレート | 管理画面ヘッダー |
| bs_endBack.asp | `asp/bs_endBack.asp` | テンプレート | 管理画面フッター |
